/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.recovery.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.recovery.process.DrmExecuteScriptProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.provider.BaseRecoveryProcessProvider;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class HostRecoveryProcessProvider
extends BaseRecoveryProcessProvider {
    private static Log logger = LogFactory.getInstance(HostRecoveryProcessProvider.class);

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, Class<? extends RecoveryProcessor> afterProcCls, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        RecoveryProcessor customProcessor = this.getCustomRecoveryProcessor(params);
        customProcessor.setProcessId(rpDefinition.getProcessId());
        customProcessor.setPlanId(rpDefinition.getPlanId());
        this.insertRecoveryProcessors(rpDefinition, afterProcCls, customProcessor, isEnable, isNeedUpdateDb);
        return customProcessor.getProcId();
    }

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, RecoveryProcessor afterProcessor, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        RecoveryProcessor customProcessor = this.getCustomRecoveryProcessor(params);
        customProcessor.setProcessId(rpDefinition.getProcessId());
        customProcessor.setPlanId(rpDefinition.getPlanId());
        this.insertRecoveryProcessors(rpDefinition, afterProcessor, customProcessor, isEnable, isNeedUpdateDb);
        return customProcessor.getProcId();
    }

    public void modifyCustomRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDefinition, String procId, Map<String, Object> params) {
        IRecoveryProcessService recoveryProcessService;
        boolean result;
        if (null == recoveryProcessDefinition || VerifyUtil.isEmpty((String)procId) || VerifyUtil.isEmpty(params)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessor customProcessor = null;
        for (RecoveryProcessor processor : recoveryProcessDefinition.getRecoveryProcessors()) {
            if (!processor.getProcId().equals(procId)) continue;
            customProcessor = processor;
            break;
        }
        if (null == customProcessor || !(customProcessor instanceof DrmExecuteScriptProcessor)) {
            throw new LegoCheckedException(1073947394L);
        }
        if (!customProcessor.getIsEditable().booleanValue()) {
            throw new LegoCheckedException(1073948732L);
        }
        DrmExecuteScriptProcessor executeScriptProcessor = (DrmExecuteScriptProcessor)customProcessor;
        executeScriptProcessor.setProcName(String.valueOf(params.get("CUSTOM_PROCESSOR_NAME")));
        Object script = params.get("EXECUTE_SCRIPT_NAME");
        if (script != null) {
            logger.info((Object)("user modify script to scheme: " + script));
            executeScriptProcessor.setScriptName(String.valueOf(script));
        }
        executeScriptProcessor.getProps().put("EXECUTE_POLICY", String.valueOf(params.get("EXECUTE_POLICY")));
        executeScriptProcessor.getProps().put("isUserDefined", String.valueOf(params.get("isUserDefined")));
        executeScriptProcessor.getProps().put("STEP_PARAMS", JSONObject.fromObject((Object)params.get("STEP_PARAMS")).toString());
        if (params.containsKey("recoveryScriptSchemeId")) {
            String schemeId = String.valueOf(params.get("recoveryScriptSchemeId"));
            logger.info((Object)("user modify script to scheme, id: " + schemeId));
            if (!VerifyUtil.isEmpty((String)schemeId)) {
                executeScriptProcessor.getProps().put("recoveryScriptSchemeId", schemeId);
            }
        }
        if (!(result = (recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)executeScriptProcessor))) {
            throw new LegoCheckedException(-1L);
        }
    }

    public Map<String, Object> getCustomRecoveryProcessorInfos(RecoveryProcessDefinition rpDef, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        if (null == rpDef || VerifyUtil.isEmpty((String)procId) || null == procType) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessor customProcessor = null;
        for (RecoveryProcessor processor : rpDef.getRecoveryProcessors()) {
            if (!processor.getProcId().equals(procId)) continue;
            customProcessor = processor;
            break;
        }
        if (null == customProcessor || !(customProcessor instanceof DrmExecuteScriptProcessor)) {
            throw new LegoCheckedException(1073947394L);
        }
        DrmExecuteScriptProcessor executeScriptProcessor = (DrmExecuteScriptProcessor)customProcessor;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("CUSTOM_PROCESSOR_NAME", executeScriptProcessor.getProcName());
        params.put("EXECUTE_SCRIPT_NAME", executeScriptProcessor.getScriptName());
        String execPolicy = (String)executeScriptProcessor.getProps().get("EXECUTE_POLICY");
        params.put("EXECUTE_POLICY", execPolicy);
        return params;
    }

    public Class<? extends RecoveryProcessor> getCustomRecoveryProcessorClass() {
        return DrmExecuteScriptProcessor.class;
    }

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator) {
        if (VerifyUtil.isEmpty((String)planId) || null == procType || VerifyUtil.isEmpty(recoveryContext)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK) {
            HashMap<String, Object> settings = new HashMap<String, Object>();
            Set<Map.Entry<String, String>> entrySet = recoveryContext.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                settings.put(entry.getKey(), entry.getValue());
            }
            this.checkCloneVolumeReplica(recoveryContext);
            return settings;
        }
        if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING) {
            this.checkCloneVolumeReplica(recoveryContext);
        }
        if (null == recoveryContext.get("disasterHostSn")) {
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.queryRecoveryPlan(planId, false);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        Map<String, Object> settings = this.getRecvSetting(recoveryContext, operator, recoveryPlan);
        return settings;
    }

    private void checkCloneVolumeReplica(Map<String, String> recoveryContext) {
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        Set<Map.Entry<String, String>> entrySet = recoveryContext.entrySet();
        String replicaId = "";
        for (Map.Entry<String, String> entry : entrySet) {
            if (!"REPLICA_ID".equals(entry.getKey())) continue;
            replicaId = entry.getValue();
        }
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (!VerifyUtil.isEmpty((Object)replica) && replica.getType() == 9) {
            logger.error((Object)"not support operate!");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Map<String, Object> getRecvSetting(Map<String, String> recoveryContext, User operator, RecoveryPlan recoveryPlan) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource resource = resourceService.getDrResourceBySn(recoveryContext.get("disasterHostSn"));
        if (VerifyUtil.isEmpty((Object)resource)) {
            return new HashMap<String, Object>();
        }
        IBizScopeManager scopeManager = (IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class);
        scopeManager.checkUserGrantedObject(operator.getUserId(), resource.getSiteId());
        String siteId = this.getDisterSiteId(resource.getSiteId(), (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups()));
        if (resource instanceof DrHostGroup) {
            Set<String> recoverySites = this.getRecoverySitesByProtectGroupReplica(recoveryPlan);
            for (DrResource drHost : resource.getChildResources()) {
                if (!recoverySites.contains(drHost.getSiteId())) continue;
                siteId = this.getDisterSiteId(drHost.getSiteId(), (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups()));
                scopeManager.checkUserGrantedMOObject(operator.getUserId(), drHost.getDeviceSn());
                break;
            }
        } else {
            scopeManager.checkUserGrantedMOObject(operator.getUserId(), resource.getDeviceSn());
        }
        HashMap<String, String> hostSettings = new HashMap<String, String>();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            hostSettings.put(protectGroup.getUuid(), resource.getDeviceSn());
        }
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("DISASTER_SITE_ID", siteId);
        settings.put("PG_DISASTER_HOST", hostSettings);
        return settings;
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan plan = recoveryPlanService.queryRecoveryPlan(planId, false);
        return this.getRecoverySiteId(plan, procType, recoveryContext);
    }

    public String getRecoverySiteId(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        if (recoveryContext.containsKey("siteId") && !recoveryContext.containsKey("disasterHostSn")) {
            return recoveryContext.get("siteId");
        }
        String disasterSiteId = "";
        if (!recoveryContext.containsKey("disasterHostSn")) {
            return disasterSiteId;
        }
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource resource = resourceService.getDrResourceBySn(recoveryContext.get("disasterHostSn"));
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(201L);
        }
        disasterSiteId = resource.getSiteId();
        if (!VerifyUtil.isEmpty((Collection)resource.getChildResources())) {
            if (plan == null) {
                throw new LegoCheckedException(201L);
            }
            Set<String> recoverySites = this.getRecoverySitesByProtectGroupReplica(plan);
            for (DrResource childResource : resource.getChildResources()) {
                String hostSiteId = childResource.getSiteId();
                if (!recoverySites.contains(hostSiteId)) continue;
                disasterSiteId = hostSiteId;
                break;
            }
        }
        return disasterSiteId;
    }

    protected Set<String> getRecoverySitesByProtectGroupReplica(RecoveryPlan plan) {
        HashSet<String> recoverySites = new HashSet<String>();
        Set protectGroups = plan.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            Set gpReplicas = protectGroup.getReplicaList();
            for (ProtectGroupReplica gpReplica : gpReplicas) {
                recoverySites.add(gpReplica.getRecoverySite());
            }
        }
        return recoverySites;
    }

    protected RecoveryProcessor getCustomRecoveryProcessor(Map<String, Object> params) {
        DrmExecuteScriptProcessor executeScriptProcessor = new DrmExecuteScriptProcessor();
        executeScriptProcessor.setProcName(String.valueOf(params.get("CUSTOM_PROCESSOR_NAME")));
        executeScriptProcessor.setScriptName(String.valueOf(params.get("EXECUTE_SCRIPT_NAME")));
        executeScriptProcessor.setProcId(String.valueOf(params.get("CustomProcId")));
        Map props = executeScriptProcessor.getProps();
        executeScriptProcessor.getProps().put("EXECUTE_POLICY", String.valueOf(params.get("EXECUTE_POLICY")));
        executeScriptProcessor.getProps().put("STEP_PARAMS", JSONObject.fromObject((Object)params.get("STEP_PARAMS")).toString());
        Object isUserDefined = params.get("isUserDefined");
        if (isUserDefined instanceof String) {
            isUserDefined = "true".equals(isUserDefined);
        } else if (!(isUserDefined instanceof Boolean)) {
            isUserDefined = true;
        }
        props.put("isUserDefined", String.valueOf(isUserDefined));
        if (!Boolean.TRUE.equals(isUserDefined)) {
            props.put("recoveryScriptSchemeId", params.get("recoveryScriptSchemeId").toString());
        }
        executeScriptProcessor.getProps().put("position", (String)params.get("position"));
        return executeScriptProcessor;
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
        if (VerifyUtil.isEmpty(recoverySettingList)) {
            return;
        }
        for (RecoverySetting rs : recoverySettingList) {
            int startOrder;
            String name = rs.getName();
            String value = rs.getValue();
            if ("isStart".equals(name) && !"true".equals(value) && !"false".equals(value)) {
                logger.error((Object)("invalid parameter!name:" + name + ", value:" + value));
                throw new LegoCheckedException(1073947393L);
            }
            if (!"startOrder".equals(name) || (startOrder = NumberUtil.convertToInteger((Object)value, (LegoCheckedException)new LegoCheckedException(1073947393L)).intValue()) >= 1 && startOrder <= 32) continue;
            logger.error((Object)("invalid parameter!name:" + name + ", value:" + value));
            throw new LegoCheckedException(1073947393L);
        }
    }
}

