/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.NeMgrProtocolExtendServiceUtil;
import com.huawei.ism.drm.host.agent.action.HostAction;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.host.util.HostDataCollectUtil;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.util.List;

public class HostDataCollectBackTask
extends AbstractBackTask {
    private static Log logger = LogFactory.getInstance(HostDataCollectBackTask.class);
    private static final long FILE_SIZE_MAX = 0x1400000L;
    private static final long DIR_SIZE_MAX = 0x40000000L;
    private Host host;

    public HostDataCollectBackTask(String taskId, BackTask backTask, boolean isNeedUpdateDb, Host host) {
        super(taskId, backTask, isNeedUpdateDb);
        this.host = host;
    }

    public HostDataCollectBackTask(String taskId, BackTask backTask, int timeout, boolean isNeedUpdateDb, Host host) {
        super(taskId, backTask, timeout, isNeedUpdateDb);
        this.host = host;
    }

    protected void doWork() {
        try {
            HostAction exportAction;
            boolean downloadResult;
            long freeFileSpace = this.freeDirSpace();
            if (freeFileSpace < 0x1400000L) {
                logger.error((Object)("free dir space:" + freeFileSpace), 90160758786816L);
                throw new LegoCheckedException(-1L);
            }
            NeMgrProtocolExtend extend = NeMgrProtocolExtendServiceUtil.getNeMgrExtendService().findByMoId(this.host.getMoId());
            if (null == extend) {
                logger.error((Object)("host data collect failed,NeMgrProtocolExtend is null,moId=" + this.host.getMoId() + ",sn=" + this.host.getSn()), 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            String macAddress = (String)extend.getExtendParams().get("mac_address");
            HostAction action = new HostAction(extend, macAddress);
            String logFileName = action.dataCollect();
            if (VerifyUtil.isEmpty((String)logFileName)) {
                logger.error((Object)"logFileName is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            this.updateDownloadableFlag(this.host.getSn(), false);
            for (int index = 1; index <= 60 && !(downloadResult = (exportAction = new HostAction(extend, null)).exportDataCollect(logFileName, this.host.getSn())); ++index) {
                this.checkTimout(this.host, index);
            }
            this.updateDownloadableFlag(this.host.getSn(), true);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"host data collect failed.", (Throwable)le, le.getErrorCode());
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"host data collect failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    private void checkTimout(Host hostObj, int index) {
        if (180 == index) {
            logger.error((Object)"dataCollect host failed, time out", 90160758784001L);
            throw new LegoCheckedException(1073947433L);
        }
        logger.error((Object)("dataCollect host failed, times=" + index + ",ip:" + hostObj.getIpAddress()), 90160758784001L);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            logger.error((Object)"thread sleep InterruptedException");
        }
    }

    private long freeDirSpace() {
        List<File> files = HostDataCollectUtil.getFiles(HostDataCollectUtil.getHostDataCollectLogFilePath());
        long dirSize = HostDataCollectUtil.getDirSize(files);
        long freeDirSize = 0x40000000L - dirSize;
        logger.debug((Object)("init freeFileSize:" + freeDirSize), 90160758786816L);
        if (freeDirSize > 0x1400000L) {
            logger.debug((Object)("freeFileSize:" + freeDirSize), 90160758786816L);
            return freeDirSize;
        }
        HostDataCollectUtil.getFileSort(files);
        for (File file : files) {
            long fileSize = file.length();
            if (this.deleteFile(file)) {
                freeDirSize += fileSize;
            }
            logger.debug((Object)("after del file,freeFileSize:" + freeDirSize), 90160758786816L);
            if (freeDirSize <= 0x1400000L) continue;
            logger.debug((Object)("freeFileSize:" + freeDirSize), 90160758786816L);
            break;
        }
        logger.info((Object)("free file space size:" + freeDirSize), 90160758786816L);
        return freeDirSize;
    }

    private boolean deleteFile(File file) {
        try {
            int dotIndex = file.getName().indexOf(".");
            if (dotIndex < 0) {
                logger.error((Object)("invalid file\uff1a" + file.getName()), 90160758787071L);
                return false;
            }
            String hostSn = file.getName().substring(0, dotIndex);
            this.updateDownloadableFlag(hostSn, false);
            long fileSize = file.length();
            boolean result = file.delete();
            logger.info((Object)("delete file:" + file.getName() + ",fileSize:" + fileSize + ",result:" + result), 90160758786816L);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("delete file fail,fileName:" + file.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return false;
        }
    }

    private void updateDownloadableFlag(String hostSn, boolean downloadable) {
        List<DrHost> drHosts = DrHostUtil.getDrHostBySNs(new String[]{hostSn});
        if (null == drHosts) {
            logger.error((Object)("host is not exist,hostSn=" + hostSn), 90160758784001L);
            return;
        }
        for (DrHost drHost : drHosts) {
            drHost.setDownloadable(Boolean.valueOf(downloadable));
            CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)drHost);
        }
    }
}

