/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmConstant;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostGroupService;
import com.huawei.ism.drm.host.service.impl.HostServiceImpl;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(name="com.huawei.ism.drm.host.sdk.service.IHostGroupService", desc="", interfaceClass=IHostGroupService.class)
public class HostGroupServiceImpl
extends BaseService
implements IHostGroupService {
    private static Object resourceLock = new Object();
    private static final long MAX_HOSTNUM_IN_GROUP = LegoConfig.getInstance().getNumber("hostgroup.max.num", 9L);
    private static Log logger = LogFactory.getInstance(HostGroupServiceImpl.class);
    private ISiteService siteService;
    private IManagementServerService managementServerService;

    public void setSiteService(ISiteService siteService) {
        this.siteService = siteService;
    }

    public void setManagementServerService(IManagementServerService managementServerService) {
        this.managementServerService = managementServerService;
    }

    public void createHostGroup(DrHostGroup drHostGroup) {
        String siteId = drHostGroup.getSiteId();
        String hostGroupName = drHostGroup.getName();
        if (!this.checkHostGroupName(hostGroupName) || null == siteId) {
            throw new LegoCheckedException(1073947393L);
        }
        this.createLocalHostGroup(drHostGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLocalHostGroup(DrHostGroup drHostGroup) {
        String[] hostSns = null;
        String siteId = drHostGroup.getSiteId();
        String hostGroupName = drHostGroup.getName();
        Set chilDrResources = drHostGroup.getChildResources();
        if (!VerifyUtil.isEmpty((Collection)chilDrResources)) {
            hostSns = new String[chilDrResources.size()];
            int i = 0;
            for (DrResource chilDrResource : chilDrResources) {
                if (DrHostUtil.checkHostGroupUsed(chilDrResource.getDeviceSn())) {
                    throw new LegoCheckedException(1073947657L);
                }
                hostSns[i++] = chilDrResource.getDeviceSn();
            }
        }
        if (null == hostSns) {
            throw new LegoCheckedException(1073947686L);
        }
        Object object = resourceLock;
        synchronized (object) {
            DrHostGroup dbHostGroup = this.getHostGroupInManageServerByName(siteId, hostGroupName);
            if (null != dbHostGroup) {
                throw new LegoCheckedException(1073947392L);
            }
            DrHostGroup newHostGroup = new DrHostGroup();
            newHostGroup.setDbId(UUIDGenerator.getUUID());
            newHostGroup.setDeviceSn(newHostGroup.getDbId());
            if ((long)hostSns.length > MAX_HOSTNUM_IN_GROUP) {
                throw new LegoCheckedException(1073947684L);
            }
            String duplicateGroupName = this.checkReduplicateHosts(hostSns);
            if (!VerifyUtil.isEmpty((String)duplicateGroupName)) {
                throw new LegoCheckedException(1073947688L, new String[]{duplicateGroupName});
            }
            this.addHostIntoHostGroup(drHostGroup.getOsType(), hostSns, siteId, newHostGroup);
            if (VerifyUtil.isEmpty((Collection)newHostGroup.getChildResources())) {
                throw new LegoCheckedException(1073947393L);
            }
            newHostGroup.setClusterType(drHostGroup.getClusterType());
            newHostGroup.setName(hostGroupName);
            newHostGroup.setSiteId(siteId);
            newHostGroup.setOsType(drHostGroup.getOsType());
            this.saveHostGroupIntoDB(siteId, newHostGroup);
        }
    }

    private void addHostIntoHostGroup(String osType, String[] hostSns, String siteId, DrHostGroup hostGroup) {
        List<DrHost> drHosts = this.getCurrentManagementHostBySiteId(siteId, hostSns);
        boolean isExistHostInCurrentSite = false;
        for (DrHost host : drHosts) {
            if (!host.getSiteId().equals(siteId)) continue;
            isExistHostInCurrentSite = true;
            break;
        }
        if (!isExistHostInCurrentSite) {
            throw new LegoCheckedException(1073947700L);
        }
        for (DrHost host : drHosts) {
            if (!osType.equals(host.getOsType())) continue;
            hostGroup.addChildResource((DrResource)host);
            host.setParentDrResource((DrResource)hostGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHostGroupIntoDB(String siteId, DrHostGroup hostGroup) {
        Session session = null;
        Transaction t = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            t = session.beginTransaction();
            session.save((Object)hostGroup);
            Set drHosts = hostGroup.getChildResources();
            for (DrResource drHost : drHosts) {
                session.merge((Object)drHost);
            }
            t.commit();
        }
        catch (Exception ex) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                String errorMsg = "unable to delete DrHost by siteId:" + siteId;
                ExceptionUtil.rethrowException((Throwable)ex, (String)errorMsg, (long)1073947673L, null, (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHostGroupIntoDB(String siteId, DrHostGroup hostGroup, List<DrResource> hostNeedRemove) {
        Session session = null;
        Transaction t = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            t = session.beginTransaction();
            session.saveOrUpdate((Object)hostGroup);
            Set dhs = hostGroup.getChildResources();
            for (DrResource drHost : dhs) {
                session.merge((Object)drHost);
            }
            if (!hostNeedRemove.isEmpty()) {
                for (DrResource drHost : hostNeedRemove) {
                    drHost.setParentDrResource(null);
                    session.merge((Object)drHost);
                }
            }
            t.commit();
        }
        catch (Exception ex) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                String errorMsg = "unable to create DrHostGroup by siteId:" + siteId;
                ExceptionUtil.rethrowException((Throwable)ex, (String)errorMsg, (long)1073947673L, null, (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyHostGroup(String hostGroupId, String hostGroupName, String[] hostSns) {
        if (VerifyUtil.isEmpty((String)hostGroupId) || !this.checkHostGroupName(hostGroupName)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (DrHostUtil.checkHostGroupUsed(hostGroupId)) {
            throw new LegoCheckedException(1073947685L);
        }
        ArrayList<String> snNew = new ArrayList<String>();
        ArrayList<DrResource> hostNeedRemove = new ArrayList<DrResource>();
        Object object = resourceLock;
        synchronized (object) {
            DrHostGroup group = DrHostUtil.getDrHostGroupByGroupID(hostGroupId);
            if (VerifyUtil.isEmpty((Object)group)) {
                logger.error((Object)("unable to get DrHostGroup by id:" + hostGroupId), 90160758786873L);
                throw new LegoCheckedException(1073947394L);
            }
            String siteId = group.getSiteId();
            String groupName = group.getName();
            if (!groupName.equals(hostGroupName)) {
                if (!this.checkGroupName(group, hostGroupName)) {
                    logger.error((Object)("the DrHostGroup name reduplicate:" + hostGroupName), 90160758786880L);
                    throw new LegoCheckedException(1073947392L);
                }
                group.setName(hostGroupName);
            }
            if (!VerifyUtil.isEmpty((Object[])hostSns)) {
                int childExidtNum = this.generateGroupModifyInfo(group, hostSns, snNew, hostNeedRemove);
                if (!snNew.isEmpty()) {
                    if ((long)(childExidtNum + snNew.size()) > MAX_HOSTNUM_IN_GROUP) {
                        throw new LegoCheckedException(1073947684L);
                    }
                    List<DrHost> drHostsNew = this.getCurrentManagementHostBySiteId(siteId, this.toArrayFromList(snNew));
                    for (DrHost host : drHostsNew) {
                        group.addChildResource((DrResource)host);
                        host.setParentDrResource((DrResource)group);
                    }
                }
            }
            this.updateHostGroupIntoDB(siteId, group, hostNeedRemove);
        }
    }

    private int generateGroupModifyInfo(DrHostGroup group, String[] hostSns, List<String> snNew, List<DrResource> hostNeedRemove) {
        if (!VerifyUtil.isEmpty((Object[])hostSns)) {
            for (String str : hostSns) {
                if (str.isEmpty()) continue;
                snNew.add(str);
            }
        }
        int childExidtNum = 0;
        Set childExist = group.getChildResources();
        if (!VerifyUtil.isEmpty((Collection)childExist)) {
            childExidtNum = childExist.size();
        }
        Iterator it = childExist.iterator();
        while (it.hasNext()) {
            DrResource drTmp = (DrResource)it.next();
            String dSN = drTmp.getDeviceSn();
            if (snNew.contains(dSN)) {
                snNew.remove(dSN);
                continue;
            }
            hostNeedRemove.add(drTmp);
            it.remove();
        }
        return childExidtNum;
    }

    private String[] toArrayFromList(List<String> listIN) {
        String[] rs = new String[listIN.size()];
        listIN.toArray(rs);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHost2HostGroup(String hostGroupId, String[] hostSns) {
        if (VerifyUtil.isEmpty((String)hostGroupId) || VerifyUtil.isEmpty((Object[])hostSns)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (DrHostUtil.checkHostGroupUsed(hostGroupId)) {
            throw new LegoCheckedException(1073947685L);
        }
        Object object = resourceLock;
        synchronized (object) {
            DrHostGroup group = DrHostUtil.getDrHostGroupByGroupID(hostGroupId);
            if (null == group) {
                logger.error((Object)("unable to get DrHostGroup by id:" + hostGroupId), 90160758786873L);
                throw new LegoCheckedException(1073947394L);
            }
            String osType = group.getOsType();
            String siteId = group.getSiteId();
            List<DrHost> drHosts = this.getCurrentManagementHostBySiteId(siteId, hostSns);
            for (DrHost host : drHosts) {
                if (DrHostUtil.checkHostGroupUsed(host.getDeviceSn())) {
                    throw new LegoCheckedException(1073947657L);
                }
                if (!host.getOsType().equals(osType)) {
                    logger.error((Object)("unable to create DrHostGroup by siteId:" + siteId), 90160758787071L);
                    throw new LegoCheckedException(1073947683L);
                }
                group.addChildResource((DrResource)host);
                host.setParentDrResource((DrResource)group);
            }
            this.updateHostGroupIntoDB(siteId, group, new ArrayList<DrResource>());
        }
    }

    public List<DrHostGroup> getHostGroupList(String siteId, long userID) {
        ArrayList<DrHostGroup> groups = new ArrayList<DrHostGroup>();
        Site site = SiteResourceManagerUtil.isSiteExisted((String)siteId);
        if (null == site) {
            logger.error((Object)("site is empty. siteId:" + siteId));
            return groups;
        }
        HostServiceImpl hostService = new HostServiceImpl();
        List drHosts = hostService.getHostListBySiteId(siteId, userID);
        if (VerifyUtil.isEmpty((Collection)drHosts)) {
            return groups;
        }
        HashSet<String> hostGroupIdSet = new HashSet<String>();
        for (DrHost drHost : drHosts) {
            DrHostGroup drHostGroup = (DrHostGroup)drHost.getParentDrResource();
            if (null == drHostGroup || hostGroupIdSet.contains(drHostGroup.getDeviceSn())) continue;
            groups.add(drHostGroup);
            hostGroupIdSet.add(drHostGroup.getDeviceSn());
        }
        if (VerifyUtil.isEmpty(groups)) {
            return groups;
        }
        if (userID != DrmConstant.DEFAULT_USER_ID) {
            this.filterHostGroup(groups, drHosts);
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHostGroup(String hostGroupId) {
        if (VerifyUtil.isEmpty((String)hostGroupId)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrHostGroup group = DrHostUtil.getDrHostGroupByGroupID(hostGroupId);
        if (VerifyUtil.isEmpty((Object)group)) {
            logger.error((Object)("unable to get DrHostGroup by id:" + hostGroupId), 90160758786873L);
            throw new LegoCheckedException(1073947394L);
        }
        if (DrHostUtil.checkHostGroupUsed(hostGroupId)) {
            logger.error((Object)("unable to delete DrHostGroup by id:" + hostGroupId), 90160758786872L);
            throw new LegoCheckedException(1073947685L);
        }
        String siteId = group.getSiteId();
        Set childExist = group.getChildResources();
        Object object = resourceLock;
        synchronized (object) {
            ArrayList<DrResource> hostNeedRemove = new ArrayList<DrResource>();
            for (DrResource drTmp : childExist) {
                hostNeedRemove.add(drTmp);
            }
            group.clearChildResource();
            this.updateHostGroupIntoDB(siteId, group, hostNeedRemove);
            if (VerifyUtil.isEmpty((Collection)childExist)) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)group);
            }
        }
    }

    private boolean checkGroupName(DrHostGroup hostGroup, String groupName) {
        DrHostGroup dbHostGroup;
        boolean result = true;
        String siteId = hostGroup.getSiteId();
        Iterator childResourcesIter = hostGroup.getChildResources().iterator();
        if (childResourcesIter.hasNext()) {
            DrResource drResource = (DrResource)childResourcesIter.next();
            siteId = drResource.getSiteId();
        }
        if (null == (dbHostGroup = this.getHostGroupInManageServerByName(siteId, groupName))) {
            return result;
        }
        if (!hostGroup.getDbId().equals(dbHostGroup.getDbId()) && dbHostGroup.getName().equals(groupName)) {
            result = false;
        }
        return result;
    }

    public List<DrHostGroup> getHostGroupListByDeviceSN(String deviceSN) {
        if (null == deviceSN) {
            logger.error((Object)"deviceSN is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List groupsQuery = null;
        try {
            groupsQuery = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrHostGroup where deviceSn =?", new Object[]{deviceSN});
        }
        catch (Exception ex) {
            String errorMsg = "failed to get DrHostGroup of name:" + deviceSN;
            ExceptionUtil.rethrowException((Throwable)ex, (String)errorMsg, (long)-1L, null, (Log)logger);
        }
        return groupsQuery;
    }

    private String checkReduplicateHosts(String[] hostSns) {
        String result = "";
        List<DrHost> drHosts = DrHostUtil.getDrHostBySNs(hostSns);
        if (!VerifyUtil.isEmpty(drHosts)) {
            for (DrHost host : drHosts) {
                if (null == host.getParentDrResource()) continue;
                result = host.getParentDrResource().getName();
                break;
            }
        }
        return result;
    }

    private void filterHostGroup(List<DrHostGroup> groupSrc, List<DrHost> hostfilered) {
        for (DrHostGroup tmp : groupSrc) {
            Set children = tmp.getChildResources();
            Iterator itChild = children.iterator();
            DrResource child = null;
            while (itChild.hasNext()) {
                child = (DrResource)itChild.next();
                String deviceSN = child.getDeviceSn();
                if (VerifyUtil.isEmpty((String)deviceSN) || this.checkRightHostInGroup(deviceSN, hostfilered)) continue;
                itChild.remove();
            }
        }
    }

    private boolean checkRightHostInGroup(String deviceSN, List<DrHost> hostfilered) {
        boolean result = false;
        for (DrHost host : hostfilered) {
            String strDeviceSN = host.getDeviceSn();
            if (VerifyUtil.isEmpty((String)strDeviceSN) || !deviceSN.equals(strDeviceSN)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean checkHostGroupName(String groupName) {
        if (VerifyUtil.isEmpty((String)groupName) || "null".equals(groupName)) {
            return false;
        }
        return CommUtil.checkDrmNameParam((String)groupName);
    }

    public DrHostGroup getHostGroupById(String hostGroupId) {
        return DrHostUtil.getDrHostGroupByGroupID(hostGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHostFromHostGroup(String hostGroupId, String[] hostSns) {
        if (VerifyUtil.isEmpty((String)hostGroupId) || VerifyUtil.isEmpty((Object[])hostSns)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (DrHostUtil.checkHostGroupUsed(hostGroupId)) {
            throw new LegoCheckedException(1073947685L);
        }
        Object object = resourceLock;
        synchronized (object) {
            DrHostGroup group = DrHostUtil.getDrHostGroupByGroupID(hostGroupId);
            if (VerifyUtil.isEmpty((Object)group)) {
                logger.error((Object)("unable to get DrHostGroup by id:" + hostGroupId), 90160758786873L);
                throw new LegoCheckedException(1073947394L);
            }
            Set drHosts = group.getChildResources();
            ArrayList<DrResource> needRemoveHosts = new ArrayList<DrResource>();
            List<String> hostSnList = Arrays.asList(hostSns);
            for (DrResource host : drHosts) {
                if (!hostSnList.contains(host.getDeviceSn())) continue;
                needRemoveHosts.add(host);
            }
            if (VerifyUtil.isEmpty(needRemoveHosts)) {
                logger.error((Object)"needRemoveHosts is empty.", 90160758786873L);
                throw new LegoCheckedException(1073947394L);
            }
            for (DrResource needRemoveHost : needRemoveHosts) {
                drHosts.remove(needRemoveHost);
            }
            if (VerifyUtil.isEmpty((Collection)drHosts)) {
                logger.error((Object)"Cannot remove the latest drhost.", 90160758786873L);
                throw new LegoCheckedException(1073947696L);
            }
            this.updateHostGroupIntoDB(group.getSiteId(), group, needRemoveHosts);
        }
    }

    public List<DrHostGroup> getHostGroupListByManageServerId(String manageServerId, Long userId) {
        List sites = this.siteService.getSites(manageServerId);
        if (VerifyUtil.isEmpty((Collection)sites)) {
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("from DrHost where siteId in(");
        ArrayList<String> siteIds = new ArrayList<String>();
        for (Site site : sites) {
            sb.append("?,");
            siteIds.add(site.getSiteId());
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        List drHosts = template.find(sb.toString(), siteIds.toArray());
        if (VerifyUtil.isEmpty((Collection)drHosts)) {
            return Collections.emptyList();
        }
        ArrayList<DrHostGroup> hostGroups = new ArrayList<DrHostGroup>();
        HashSet<String> hostGroupIds = new HashSet<String>();
        for (DrHost drHost : drHosts) {
            DrHostGroup hostGroup = (DrHostGroup)drHost.getParentDrResource();
            if (null == hostGroup || hostGroupIds.contains(hostGroup.getDbId())) continue;
            hostGroups.add(hostGroup);
            hostGroupIds.add(hostGroup.getDbId());
        }
        return hostGroups;
    }

    private DrHostGroup getHostGroupInManageServerByName(String siteId, String hostGroupName) {
        Site site = this.siteService.getSiteById(siteId);
        if (null == site) {
            return null;
        }
        List<DrHostGroup> hostGroups = this.getHostGroupListByManageServerId(site.getServerUuid(), 0L);
        for (DrHostGroup hostGroup : hostGroups) {
            if (!hostGroup.getName().equals(hostGroupName)) continue;
            return hostGroup;
        }
        return null;
    }

    private List<DrHost> getCurrentManagementHostBySiteId(String siteId, String[] hostSns) {
        Site site = this.siteService.getSiteById(siteId);
        if (null == site) {
            throw new LegoCheckedException(1073947393L);
        }
        List manageServerSites = this.siteService.getSites(site.getServerUuid());
        ArrayList<String> siteIds = new ArrayList<String>();
        for (Site manageServerSite : manageServerSites) {
            siteIds.add(manageServerSite.getSiteId());
        }
        List<DrHost> drHosts = DrHostUtil.getDrHostsRegisteredBySn(siteIds, hostSns);
        return drHosts;
    }
}

