/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.service.impl;

import com.huawei.ism.drm.common.sdk.model.ScriptSchemeDefTemplate;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeStep;
import com.huawei.ism.drm.host.service.impl.HostServiceImpl;
import com.huawei.ism.drm.host.template.ScriptSchemeTemplateParser;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(name="com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService", desc="", interfaceClass=IHostScriptSchemeService.class)
public class HostScriptSchemeServiceImpl
extends BaseService
implements IHostScriptSchemeService {
    private static Log logger = LogFactory.getInstance(HostServiceImpl.class);

    public List<ScriptSchemeDefTemplate> queryDefaultThirdScripts() {
        logger.info((Object)"Start to loading script scheme template configuration.");
        ScriptSchemeTemplateParser parser = new ScriptSchemeTemplateParser();
        List urls = AdapterUtils.getAllClassPathEntries((String)"conf/scriptScheme.xml");
        for (URL url : urls) {
            parser.readTemplateFile(url);
        }
        try {
            List<ScriptSchemeDefTemplate> scriptSchemeInfo = parser.parseTemplateFile();
            return scriptSchemeInfo;
        }
        catch (Exception e) {
            logger.error((Object)("Parsing script scheme template failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return null;
        }
    }

    public ScriptSchemeDefTemplate queryScriptSchemeById(String schemeId) {
        if (VerifyUtil.isEmpty((String)schemeId)) {
            return null;
        }
        List<ScriptSchemeDefTemplate> scriptSchemeInfo = this.queryDefaultThirdScripts();
        for (ScriptSchemeDefTemplate scriptSchemeDefTemplate : scriptSchemeInfo) {
            if (!schemeId.equals(scriptSchemeDefTemplate.getId())) continue;
            return scriptSchemeDefTemplate;
        }
        return null;
    }

    public ScriptSchemeStep queryScriptSchemeStep(String schemeId, String position) {
        if (schemeId == null || position == null) {
            return null;
        }
        ScriptSchemeDefTemplate scheme = this.queryScriptSchemeById(schemeId);
        if (scheme == null) {
            return null;
        }
        return scheme.getSteps().stream().filter(s -> position.equals(s.getPosition())).findFirst().orElse(null);
    }

    public Map<String, String[]> getParamValidation(String schemeId) {
        ScriptSchemeDefTemplate scriptSchemeDefTemplate = this.queryScriptSchemeById(schemeId);
        HashMap<String, String[]> validations = new HashMap<String, String[]>();
        if (null == scriptSchemeDefTemplate) {
            return validations;
        }
        validations.putAll(this.transform(scriptSchemeDefTemplate.getPublicParams()));
        List steps = scriptSchemeDefTemplate.getSteps();
        for (ScriptSchemeStep scriptSchemeStep : steps) {
            validations.putAll(this.transform(scriptSchemeStep.getParams()));
        }
        return validations;
    }

    private Map<String, String[]> transform(List<Map<String, Object>> validations) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (Map<String, Object> rule : validations) {
            String key = String.valueOf(rule.get("name"));
            String optional = String.valueOf(rule.get("optional"));
            String length = String.valueOf(rule.get("length"));
            String expr = String.valueOf(rule.get("expr"));
            String sensitive = String.valueOf(rule.get("sensitive"));
            result.put(key, new String[]{optional, length, expr, sensitive});
        }
        return result;
    }
}

