/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.topology;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.host.util.ProtectObjectAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.topo.sdk.poll.ITopoPoller;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashMap;
import java.util.List;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoPollerManager", properties="type:topoPoller-host")
public class TopoHostPoller
implements ITopoPoller {
    private static final Log LOGGER = LogFactory.getInstance(TopoHostPoller.class);
    private static final String DB_ON_LINE = "0";
    private static final String DB_OFF_LINE = "1";
    private String sourceSn;

    public void pollResource(String paramSourceSn) {
        this.sourceSn = paramSourceSn;
        DrHost drResource = (DrHost)TopoServiceUtil.getDrResource((String)paramSourceSn);
        if (drResource == null) {
            LOGGER.error((Object)("updateResourceStatus, drResource==null, devSn:" + paramSourceSn), 90160758786988L);
            return;
        }
        try {
            String providerSn = drResource.getDeviceSn();
            DrHostGroup hostGroup = (DrHostGroup)drResource.getParentDrResource();
            if (null != hostGroup) {
                providerSn = hostGroup.getDeviceSn();
            }
            this.updateDatabaseStatus(drResource, providerSn);
        }
        catch (Exception e) {
            LOGGER.error((Object)("update databases status error in " + drResource.getIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        this.updateActiveHostDatabaseStatus(drResource);
    }

    private void updateActiveHostDatabaseStatus(DrHost drResource) {
        DrHostGroup hostGroup = (DrHostGroup)drResource.getParentDrResource();
        if (null == hostGroup) {
            return;
        }
        int clusterType = hostGroup.getClusterType();
        if (DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue() == clusterType) {
            return;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topMoUuid", drResource.getDeviceSn());
        List dbInstances = moDao.findMoBy(DatabaseInstance.class, "instanceName", true, props);
        for (DatabaseInstance dbInstance : dbInstances) {
            String resouceGroupName = dbInstance.getResourceGroupName();
            if (VerifyUtil.isEmpty((String)resouceGroupName)) {
                LOGGER.error((Object)("get active node error in " + drResource.getIpAddress() + ",resouceGroupName is empty"), 90160758786989L);
                continue;
            }
            try {
                IHostRetrieveProxy hostProxy = (IHostRetrieveProxy)ServiceLocator.getInstance().getService(IHostRetrieveProxy.class);
                DrHost drHost = hostProxy.queryActiveNodeInHostGroup(hostGroup, String.valueOf(clusterType), resouceGroupName);
                if (null == drHost || !drResource.getDeviceSn().equals(drHost.getDeviceSn())) continue;
                LOGGER.debug((Object)("get active node success, dbInstance=" + dbInstance.getName() + "resource group: " + resouceGroupName + ", node ip:" + drHost.getIpAddress()), 90160758786988L);
                this.updateDatabasInstanceStatus(dbInstance, true);
            }
            catch (Exception e) {
                this.updateDatabasInstanceStatus(dbInstance, false);
                LOGGER.error((Object)("get active node error in " + drResource.getIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    private void updateDatabaseStatus(DrHost drResource, String providerSn) {
        List<ProtectObject> poList = ProtectObjectAppUtil.getProtectObjectByHostSn(providerSn);
        if (VerifyUtil.isEmpty(poList)) {
            LOGGER.debug((Object)("po is null,drResource.getDeviceSn()\uff1a" + drResource.getDeviceSn() + ",providerSn:" + providerSn + ",ip:" + drResource.getIpAddress()), 90160758786989L);
            return;
        }
        IProtectObjectProviderDelegate providerDelegate = (IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class);
        for (ProtectObject protectObject : poList) {
            String instanceName;
            try {
                ProtectObject po = (ProtectObject)protectObject.clone();
                po.setProviderSN(drResource.getDeviceSn());
                po.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
                instanceName = this.getInstanceName(po, drResource);
                po.getProps().put("INSTANCENAME", instanceName);
                boolean checkResult = providerDelegate.testProtectObject(po.getPoType(), po);
                this.updateDatabaseStatus(drResource, instanceName, checkResult);
            }
            catch (LegoCheckedException e) {
                instanceName = (String)protectObject.getProps().get("INSTANCENAME");
                LOGGER.error((Object)("test po exception,poName:" + protectObject.getName() + ",ip:" + drResource.getIpAddress()), (Throwable)e, 90160758786989L);
                if (e.getErrorCode() != 1073948956L) continue;
                this.updateDatabaseStatus(drResource, instanceName, false);
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error((Object)("clone po exception,poName:" + protectObject.getName() + ",ip:" + drResource.getIpAddress()), (Throwable)e, 90160758786989L);
            }
            catch (Exception e) {
                LOGGER.error((Object)("test po fail,poName:" + protectObject.getName() + ",ip:" + drResource.getIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    private String getInstanceName(ProtectObject po, DrHost drResource) {
        String instanceName = (String)po.getProps().get("INSTANCENAME");
        DrHostGroup hostGroup = (DrHostGroup)drResource.getParentDrResource();
        if (null == hostGroup) {
            return instanceName;
        }
        int clusterType = hostGroup.getClusterType();
        try {
            JSONArray jsonArray = JSONArray.fromObject((Object)instanceName);
            for (Object object : jsonArray) {
                JSONObject jsonObject = JSONObject.fromObject(object);
                String name = JsonUtil.getString((JSONObject)jsonObject, (String)"INSTANCENAME", (String[])new String[]{""});
                String ip = JsonUtil.getString((JSONObject)jsonObject, (String)"ip", (String[])new String[]{""});
                if (VerifyUtil.isEmpty((String)name) || DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue() == clusterType && !ip.equals(drResource.getDeviceSn())) continue;
                return name;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("parse Instance fail,poName:" + po.getName() + ",providerSn:" + po.getProviderSN() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return instanceName;
    }

    private void updateDatabaseStatus(DrHost drResource, String instanceName, boolean onLine) {
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topMoUuid", drResource.getDeviceSn());
        List databases = moDao.findMoBy(Database.class, "name", true, props);
        for (Database database : databases) {
            DatabaseInstance dbInstance;
            if (!(database.getParentMo() instanceof DatabaseInstance) || !(dbInstance = (DatabaseInstance)database.getParentMo()).getInstanceName().equals(instanceName) || !dbInstance.getHostSN().equals(drResource.getDeviceSn())) continue;
            database.setDbStatus(onLine ? DB_ON_LINE : DB_OFF_LINE);
            moDao.getHibernateTemplate().update((Object)database);
            break;
        }
    }

    private void updateDatabasInstanceStatus(DatabaseInstance dbInstance, boolean isActiveHost) {
        dbInstance.setInstanceStatus(isActiveHost ? 1 : 0);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        moDao.getHibernateTemplate().update((Object)dbInstance);
    }

    public void pollResource(String ipAddress, String port) {
    }

    public String getResourceType() {
        return "host";
    }

    public String getResourceSN() {
        return this.sourceSn;
    }
}

