/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.topology.element;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.skin.HostNodeSkin;
import com.huawei.ism.drm.topo.twaver.TopoElement;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.twaver.Node;

public class HostElement
extends TopoElement {
    public HostElement() {
    }

    public HostElement(DrHost host) {
        super((Object)host.getDeviceSn(), host.getName());
        this.setToolTip(HostElement.createHostToolTip(host));
        this.setImage("/theme/recoverydirector/images/topo/hostIcon.png");
        this.use(new Skin[]{new HostNodeSkin()});
        this.setIconByStatus((Node)this, host.getStatus());
        this.setStyle("icons.yoffset", 6);
        this.setStyle("label.yoffset", -6);
    }

    public static String createHostToolTip(DrHost host) {
        return HostElement.createHostTooltip(host.getIpAddress(), host.getName(), host.getOsType(), host.getStatus());
    }

    public static void setImageByStatus(Node hostNode, String status) {
        int hostStatus = NumberUtil.parseInteger((Object)status);
        if (hostStatus == 1) {
            hostNode.setImage("/theme/recoverydirector/images/topo/host.png");
        } else if (hostStatus == 2) {
            hostNode.setImage("/theme/recoverydirector/images/topo/host_offline.png");
            hostNode.setStyle("label.color", 0x999999);
        } else {
            hostNode.setImage("/theme/recoverydirector/images/topo/host_unknown.png");
            hostNode.setStyle("label.color", 0x999999);
        }
    }

    public static String createHostTooltip(String ip, String name, String os, String status) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        os = resourceManager.containText(os = "ism.drm.topo.host.os." + os) ? resourceManager.getText(os) : null;
        StringBuilder tooltipBuilder = new StringBuilder();
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.host.ip", (String)ip);
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.host.name", (String)StringEscapeUtil.escape((String)name));
        TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)"ism.drm.topo.host.os", (String)os);
        int hostStatus = NumberUtil.parseInteger((Object)status);
        if (hostStatus == 1) {
            tooltipBuilder.append(resourceManager.getText("ism.drm.topo.storage.status") + " " + resourceManager.getText("ism.drm.host.online") + "\n");
        } else if (hostStatus == 2) {
            tooltipBuilder.append(resourceManager.getText("ism.drm.topo.storage.status") + " " + resourceManager.getText("ism.drm.host.offline") + "\n");
        } else {
            tooltipBuilder.append(resourceManager.getText("ism.drm.topo.storage.status") + " " + "--" + "\n");
        }
        return tooltipBuilder.toString();
    }

    private void setIconByStatus(Node hostNode, String status) {
        int hostStatus = NumberUtil.parseInteger((Object)status);
        if (hostStatus == 1) {
            hostNode.setIcon("/theme/recoverydirector/images/topo/hostIcon.png");
            hostNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/hostIcon.png");
        } else if (hostStatus == 2) {
            hostNode.setIcon("/theme/recoverydirector/images/topo/hostIcon_offline.png");
            hostNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/hostIcon_offline.png");
        } else {
            hostNode.setIcon("/theme/recoverydirector/images/topo/hostIcon_unknown.png");
            hostNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/hostIcon_unknown.png");
        }
    }
}

