/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.host.util;

import com.huawei.ism.base.sdk.model.Disk;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.host.sdk.service.IHostRetrieveProxy;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public final class DrHostDeviceUtil {
    private static Log logger = LogFactory.getInstance(DrHostDeviceUtil.class);

    private DrHostDeviceUtil() {
    }

    public static boolean isNeedUpdateDeviceName(String deviceName, int subType, String udevRules) {
        return !VerifyUtil.isEmpty((String)deviceName) && subType == 0 && VerifyUtil.isEmpty((String)udevRules);
    }

    public static List<Disk> getDiskByStorageInfo(HostDeviceStorageInfo hostDeviceStorageInfo, Map<String, List<Disk>> diskMap) {
        String key;
        List<Disk> disks;
        String mountDiskNum = hostDeviceStorageInfo.getSnapshotId();
        if (VerifyUtil.isEmpty((String)mountDiskNum) || "null".equals(mountDiskNum)) {
            mountDiskNum = hostDeviceStorageInfo.getLunId();
        }
        if (null == (disks = diskMap.get(key = hostDeviceStorageInfo.getDeviceId() + "_" + mountDiskNum)) && !VerifyUtil.isEmpty((String)hostDeviceStorageInfo.getWwn())) {
            disks = diskMap.get(hostDeviceStorageInfo.getWwn());
        }
        if (VerifyUtil.isEmpty(disks)) {
            logger.error((Object)("Cannot find the disk(key:" + key + ", wwn:" + hostDeviceStorageInfo.getWwn() + ")"), 90160758786989L);
        }
        return disks;
    }

    public static List<Disk> getDiskByPoStorageInfo(ProtectObjectStorageInfo poStorageInfo, Map<String, List<Disk>> diskMap) {
        String lunId = poStorageInfo.getResourceId();
        String key = poStorageInfo.getResourceProviderSN() + "_" + lunId;
        List<Disk> disks = diskMap.get(key);
        if (null == disks && !VerifyUtil.isEmpty((String)poStorageInfo.getLunWWN())) {
            disks = diskMap.get(poStorageInfo.getLunWWN());
        }
        if (VerifyUtil.isEmpty(disks)) {
            logger.error((Object)("Cannot find the disk(key:" + key + ", wwn:" + poStorageInfo.getLunWWN() + ")"), 90160758786989L);
        }
        return disks;
    }

    public static String getPartitionNumber(String deviceName) {
        String partitionNumber = "";
        if (null == deviceName) {
            return partitionNumber;
        }
        for (int i = 0; i < deviceName.length(); ++i) {
            char index = deviceName.charAt(i);
            if (!Character.isDigit(index)) continue;
            partitionNumber = deviceName.substring(i);
            break;
        }
        return partitionNumber;
    }

    public static Map<String, List<Disk>> buildDiskInfoMap(List<Disk> disks) {
        HashMap<String, List<Disk>> diskMap = new HashMap<String, List<Disk>>();
        for (Disk disk : disks) {
            String key = disk.getArraySN() + "_" + disk.getDiskNum();
            List<Disk> tmpDisks = (ArrayList<Disk>)diskMap.get(key);
            if (null == tmpDisks) {
                tmpDisks = new ArrayList<Disk>();
            }
            tmpDisks.add(disk);
            diskMap.put(key, tmpDisks);
            if (VerifyUtil.isEmpty((String)disk.getDiskSN())) continue;
            tmpDisks = (List)diskMap.get(disk.getDiskSN());
            if (null == tmpDisks) {
                tmpDisks = new ArrayList();
            }
            tmpDisks.add(disk);
            diskMap.put(disk.getDiskSN(), tmpDisks);
        }
        return diskMap;
    }

    public static void parseAndUpdateStorageErrorCodeInfo(LegoCheckedException legoEx, String keyName, Map<String, List<HostDeviceStorageInfo>> storageInfoMap) {
        String errorMessage = legoEx.getMessage();
        if (VerifyUtil.isEmpty((String)errorMessage) || "null".equals(errorMessage.trim()) || errorMessage.startsWith("Code:")) {
            throw legoEx;
        }
        JSONArray jsonArrayError = JSONArray.fromObject((Object)errorMessage);
        for (Object error : jsonArrayError) {
            JSONObject jsonObject = JSONObject.fromObject(error);
            String keyValue = JsonUtil.getString((JSONObject)jsonObject, (String)keyName, (String[])new String[0]);
            if (VerifyUtil.isEmpty((String)keyValue) || !storageInfoMap.containsKey(keyValue)) continue;
            List<Object> storageInfos = storageInfoMap.get(keyValue);
            storageInfos = storageInfos.stream().filter(Objects::nonNull).collect(Collectors.toList());
            storageInfos.forEach(storageInfo -> {
                storageInfo.setErrorCode(JsonUtil.getLong((JSONObject)jsonObject, (String)"errorCode", (Long[])new Long[]{0L}).longValue());
                storageInfo.setErrorParams(new String[]{keyValue});
            });
        }
    }

    public static Map<String, List<HostDeviceStorageInfo>> buildStorageInfoMapByDeviceName(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashMap<String, List<HostDeviceStorageInfo>> storageInfoMap = new HashMap<String, List<HostDeviceStorageInfo>>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String deviceName = hostDeviceStorageInfo.getDeviceName();
            ArrayList<HostDeviceStorageInfo> storageInfoList = (ArrayList<HostDeviceStorageInfo>)storageInfoMap.get(deviceName);
            if (null == storageInfoList) {
                storageInfoList = new ArrayList<HostDeviceStorageInfo>();
                storageInfoMap.put(deviceName, storageInfoList);
            }
            storageInfoList.add(hostDeviceStorageInfo);
        }
        return storageInfoMap;
    }

    public static Map<String, List<HostDeviceStorageInfo>> buildStorageInfoMapByWwn(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashMap<String, List<HostDeviceStorageInfo>> storageInfoMap = new HashMap<String, List<HostDeviceStorageInfo>>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String wwn = hostDeviceStorageInfo.getWwn();
            ArrayList<HostDeviceStorageInfo> storageInfoList = (ArrayList<HostDeviceStorageInfo>)storageInfoMap.get(wwn);
            if (null == storageInfoList) {
                storageInfoList = new ArrayList<HostDeviceStorageInfo>();
                storageInfoMap.put(wwn, storageInfoList);
            }
            storageInfoList.add(hostDeviceStorageInfo);
        }
        return storageInfoMap;
    }

    public static Map<String, List<HostDeviceStorageInfo>> buildStorageInfoMapByVgName(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        HashMap<String, List<HostDeviceStorageInfo>> storageInfoMap = new HashMap<String, List<HostDeviceStorageInfo>>();
        for (HostDeviceStorageInfo hostDeviceStorageInfo : hostDeviceStorageInfos) {
            String vgName = hostDeviceStorageInfo.getVgName();
            if (VerifyUtil.isEmpty((String)vgName)) continue;
            ArrayList<HostDeviceStorageInfo> storageInfoList = (ArrayList<HostDeviceStorageInfo>)storageInfoMap.get(vgName);
            if (null == storageInfoList) {
                storageInfoList = new ArrayList<HostDeviceStorageInfo>();
                storageInfoMap.put(vgName, storageInfoList);
            }
            storageInfoList.add(hostDeviceStorageInfo);
        }
        return storageInfoMap;
    }

    public static List<HostDeviceStorageInfo> buildActiveVgHostDeviceStorageInfos(ProtectObject po) {
        ArrayList<HostDeviceStorageInfo> hostDeviceStorageInfoList = new ArrayList<HostDeviceStorageInfo>();
        for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
            int storageSubType = poStorageInfo.getStorageSubType();
            if (storageSubType != 4) continue;
            HostDeviceStorageInfo hostDeviceStorageInfo = new HostDeviceStorageInfo();
            hostDeviceStorageInfo.setStorageSubType(poStorageInfo.getStorageSubType());
            hostDeviceStorageInfo.setStorageType(poStorageInfo.getStorageType());
            hostDeviceStorageInfo.setVgName(poStorageInfo.getVolumeGroupName());
            hostDeviceStorageInfo.setDeviceName(poStorageInfo.getDeviceName());
            hostDeviceStorageInfo.setMountPoint(poStorageInfo.getMountPoint());
            hostDeviceStorageInfoList.add(hostDeviceStorageInfo);
        }
        return hostDeviceStorageInfoList;
    }

    public static void parseAndThrowErrorInfo(List<HostDeviceStorageInfo> hostDeviceStorageInfos) {
        for (HostDeviceStorageInfo hostStorageInfo : hostDeviceStorageInfos) {
            if (hostStorageInfo.getErrorCode() == 0L) continue;
            throw new LegoCheckedException(hostStorageInfo.getErrorCode(), hostStorageInfo.getErrorParams());
        }
    }

    public static void hostDiskScan(String hostOrGroupId) {
        DrResource dr = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostOrGroupId);
        if (null == dr) {
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList<DrResource> resources = new ArrayList<DrResource>();
        if (VerifyUtil.isEmpty((Collection)dr.getChildResources())) {
            resources.add(dr);
        } else {
            resources.addAll(dr.getChildResources());
        }
        for (DrResource resource : resources) {
            try {
                ScanDiskTask scanDiskTask = new ScanDiskTask(resource);
                ExecutionService.submit((Callable)scanDiskTask);
            }
            catch (Exception e) {
                logger.error((Object)("Fail to scanDisk" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    private static <T> T getServiceByType(Class<T> type) {
        Object object = ServiceContext.getInstance().lookup(type);
        if (object == null) {
            throw new LegoCheckedException(-1L);
        }
        return type.cast(object);
    }

    private static final class ScanDiskTask
    implements Callable<OperationResult> {
        private final DrResource resource;

        public ScanDiskTask(DrResource resource) {
            this.resource = resource;
        }

        @Override
        public OperationResult call() {
            INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend(neMgr, this.resource.getDeviceSn());
            IHostRetrieveProxy hostRetrieveProxy = (IHostRetrieveProxy)DrHostDeviceUtil.getServiceByType(IHostRetrieveProxy.class);
            hostRetrieveProxy.scanDisk(extend);
            return null;
        }
    }
}

