/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.kube.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.ResourceSetInfo;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.rest.service.framework.kube.model.CheckKubeConfigResult;
import com.huawei.ism.drm.rest.service.framework.kube.model.KubeConfig;
import com.huawei.ism.drm.rest.service.framework.kube.model.KubeConfigCluster;
import com.huawei.ism.drm.rest.service.framework.kube.model.KubeConfigContext;
import com.huawei.ism.drm.rest.service.framework.kube.model.KubeConfigContextUser;
import com.huawei.ism.drm.rest.service.framework.kube.util.AttachmentUtils;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class KubeCheckUtil {
    private static final Log LOGGER = LogFactory.getInstance(KubeCheckUtil.class);
    private static final int CONFIG_FILE_MAX_SIZE = 30720;

    public static CheckKubeConfigResult checkKubeConfig(Attachment file, String currentConfigString) {
        KubeConfig currentConfig;
        boolean isServerSame;
        if (ObjectUtils.isEmpty((Object)file) || ObjectUtils.isEmpty((Object)file.getDataHandler())) {
            throw new LegoCheckedException(1073947732L);
        }
        boolean isFileTypeCorrect = AttachmentUtils.checkFileType(file, "yaml", "yml");
        if (!isFileTypeCorrect) {
            throw new LegoCheckedException(1073947733L);
        }
        CheckKubeConfigResult importConfigResult = KubeCheckUtil.parseKubeConfigData(file);
        boolean isConfigContentCorrect = KubeCheckUtil.checkKubernetesConfigContent(importConfigResult.getConfigData());
        if (!isConfigContentCorrect) {
            throw new LegoCheckedException(1073947735L);
        }
        if (StringUtils.isNotEmpty((CharSequence)currentConfigString) && !(isServerSame = KubeCheckUtil.compareConfigServer(currentConfig = KubeCheckUtil.parseKubeConfigData(currentConfigString), importConfigResult.getConfigData()))) {
            throw new LegoCheckedException(1073947736L);
        }
        return importConfigResult;
    }

    public static Kubernetes checkKubeExist(String sn) {
        if (VerifyUtil.isEmpty((String)sn)) {
            LOGGER.error((Object)"The resource id is empty");
            throw new LegoCheckedException(1073947393L);
        }
        IKubeService iKubeService = (IKubeService)ServiceLocator.getBundleService((String)"DRM_Kubernetes_Manager", (String)IKubeService.class.getName(), IKubeService.class);
        return iKubeService.getKubeById(sn);
    }

    public static void checkKubeRepeat(String serverIp) {
        IKubeService iKubeService = (IKubeService)ServiceLocator.getBundleService((String)"DRM_Kubernetes_Manager", (String)IKubeService.class.getName(), IKubeService.class);
        List result = iKubeService.getKubeByIp(serverIp);
        if (!VerifyUtil.isEmpty((Collection)result)) {
            throw new LegoCheckedException(132432L);
        }
    }

    private static boolean compareConfigServer(KubeConfig leftConfig, KubeConfig rightConfig) {
        KubeConfigCluster leftCluster = KubeCheckUtil.checkAndGetConfigCluster(leftConfig);
        KubeConfigCluster rightCluster = KubeCheckUtil.checkAndGetConfigCluster(rightConfig);
        return StringUtils.equals((CharSequence)leftCluster.getCluster().getServer(), (CharSequence)rightCluster.getCluster().getServer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CheckKubeConfigResult parseKubeConfigData(Attachment file) {
        CheckKubeConfigResult result = new CheckKubeConfigResult();
        DataHandler handler = file.getDataHandler();
        InputStream inputStream = null;
        try {
            inputStream = handler.getInputStream();
            if (inputStream == null) {
                LOGGER.warn((Object)"[kubernetes]Parse attachment canceled, cause target attachment is empty");
                CheckKubeConfigResult checkKubeConfigResult = result;
                return checkKubeConfigResult;
            }
            if (inputStream.available() > 30720) {
                LOGGER.error((Object)"[kubernetes]Target kubernetes config file is too large");
                throw new LegoCheckedException(1073947734L);
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
            String configText = writer.toString();
            if (VerifyUtil.isEmpty((String)configText)) {
                LOGGER.error((Object)"[kubernetes]Parse kubernetes config attachment error, parse result is empty");
                throw new LegoCheckedException(1073947393L);
            }
            result.setConfigText(configText);
            result.setConfigData(KubeCheckUtil.parseKubeConfigData(configText));
        }
        catch (IOException e) {
            LOGGER.error((Object)"[kubernetes]Parse kubernetes config attachment error.");
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KubeConfig parseKubeConfigData(String configString) {
        ByteArrayInputStream inputStream;
        KubeConfig result;
        block4: {
            result = null;
            inputStream = null;
            try {
                inputStream = new ByteArrayInputStream(configString.getBytes(StandardCharsets.UTF_8));
                Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
                Object dataObj = yaml.load((InputStream)inputStream);
                if (!ObjectUtils.isNotEmpty((Object)dataObj)) break block4;
                ObjectMapper objectMapper = new ObjectMapper();
                String configJsonString = objectMapper.writeValueAsString(dataObj);
                result = (KubeConfig)objectMapper.readValue(configJsonString, KubeConfig.class);
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)"[kubernetes]Parse kubernetes config attachment error.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    public static boolean checkKubernetesConfigContent(KubeConfig config) {
        if (config == null) {
            LOGGER.error((Object)"[kubernetes]Kubernetes config content is not correct( config is empty )");
            return false;
        }
        String currentContextName = config.getCurrentContext();
        if (StringUtils.isEmpty((CharSequence)currentContextName)) {
            LOGGER.error((Object)"[kubernetes]Kubernetes config content is not correct( current context is empty )");
            return false;
        }
        KubeConfigCluster currentCluster = KubeCheckUtil.checkAndGetConfigCluster(config);
        if (currentCluster.isEmpty()) {
            LOGGER.error((Object)"[kubernetes]Kubernetes config content is not correct( cluster info not correct )");
            return false;
        }
        KubeConfigContextUser currentUser = KubeCheckUtil.checkAndGetConfigUser(config);
        if (currentUser.isEmpty()) {
            LOGGER.error((Object)"[kubernetes]Kubernetes config content is not correct( user info not correct )");
            return false;
        }
        return true;
    }

    public static KubeConfigContext checkAndGetConfigContext(KubeConfig config) {
        KubeConfigContext currentContext = new KubeConfigContext();
        List<KubeConfigContext> contexts = config.getContexts();
        if (CollectionUtils.isEmpty(contexts)) {
            return currentContext;
        }
        String currentContextName = config.getCurrentContext();
        for (KubeConfigContext context : contexts) {
            if (context == null) {
                return currentContext;
            }
            if (StringUtils.isEmpty((CharSequence)context.getName())) {
                return currentContext;
            }
            if (context.getContext() == null) {
                return currentContext;
            }
            if (StringUtils.isEmpty((CharSequence)context.getContext().getUser())) {
                return currentContext;
            }
            if (StringUtils.isEmpty((CharSequence)context.getContext().getCluster())) {
                return currentContext;
            }
            if (!StringUtils.equals((CharSequence)context.getName(), (CharSequence)currentContextName)) continue;
            currentContext = context;
        }
        return currentContext;
    }

    public static KubeConfigCluster checkAndGetConfigCluster(KubeConfig config) {
        KubeConfigCluster currentCluster = new KubeConfigCluster();
        KubeConfigContext currentContext = KubeCheckUtil.checkAndGetConfigContext(config);
        if (currentContext.isEmpty()) {
            LOGGER.error((Object)"[kubernetes]Kubernetes config content is not correct( context info not correct )");
            return currentCluster;
        }
        List<KubeConfigCluster> clusters = config.getClusters();
        if (CollectionUtils.isEmpty(clusters)) {
            return currentCluster;
        }
        for (KubeConfigCluster cluster : clusters) {
            if (StringUtils.isEmpty((CharSequence)cluster.getName()) || cluster.getCluster() == null || StringUtils.isEmpty((CharSequence)cluster.getCluster().getServer()) || StringUtils.isEmpty((CharSequence)cluster.getCluster().getCertificateAuthorityData())) {
                return currentCluster;
            }
            if (!StringUtils.equals((CharSequence)cluster.getName(), (CharSequence)currentContext.getContext().getCluster())) continue;
            currentCluster = cluster;
        }
        return currentCluster;
    }

    public static KubeConfigContextUser checkAndGetConfigUser(KubeConfig config) {
        KubeConfigContextUser currentUser = new KubeConfigContextUser();
        KubeConfigContext currentContext = KubeCheckUtil.checkAndGetConfigContext(config);
        if (currentContext.isEmpty()) {
            LOGGER.error((Object)"[kubernetes]Kubernetes config content is not correct( context info not correct )");
            return currentUser;
        }
        List<KubeConfigContextUser> users = config.getUsers();
        if (CollectionUtils.isEmpty(users)) {
            return currentUser;
        }
        for (KubeConfigContextUser user : users) {
            if (StringUtils.isEmpty((CharSequence)user.getName())) {
                return currentUser;
            }
            if (user.getUser() == null) {
                return currentUser;
            }
            if (StringUtils.isEmpty((CharSequence)user.getUser().getClientCertificateData())) {
                return currentUser;
            }
            if (StringUtils.isEmpty((CharSequence)user.getUser().getClientKeyData())) {
                return currentUser;
            }
            if (!StringUtils.equals((CharSequence)user.getName(), (CharSequence)currentContext.getContext().getUser())) continue;
            currentUser = user;
        }
        return currentUser;
    }

    public static boolean checkResourceSetInfo(ResourceSetInfo resourceSetInfo) {
        if (VerifyUtil.isEmpty((String)resourceSetInfo.getName())) {
            LOGGER.error((Object)"The resource name is empty.");
            return false;
        }
        if (VerifyUtil.isEmpty((String)resourceSetInfo.getNamespace())) {
            LOGGER.error((Object)"The resourceSet namespace is empty.");
            return false;
        }
        return true;
    }

    public static void isKubeResourceSetUsed(String kubeId, String resourceSetId) {
        IKubeService kubeService = (IKubeService)ServiceLocator.getBundleService((String)"DRM_Kubernetes_Manager", (String)IKubeService.class.getName(), IKubeService.class);
        Set usedResourceSetIds = kubeService.getUsedResourceSetIds();
        if (usedResourceSetIds.contains(resourceSetId)) {
            throw new LegoCheckedException(1073947761L);
        }
        LOGGER.info((Object)"Kube resourceSet is not used.");
    }

    public static Site checkSiteId(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            LOGGER.error((Object)"[kubernetes]Register kubernetes error, cause site id is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        ISiteService siteSvc = (ISiteService)ServiceLocator.getBundleService((String)"DRM_Base", (String)ISiteService.class.getName(), ISiteService.class);
        Site site = siteSvc.getSiteById(siteId);
        if (site == null) {
            LOGGER.error((Object)"[kubernetes]Register kubernetes error, cause target site is not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        return site;
    }
}

