/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.notifyrule.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmVO;
import com.huawei.ism.drm.rest.service.framework.email.model.EmailVo;
import com.huawei.ism.drm.rest.service.framework.notifyrule.model.PhoneVo;
import com.huawei.ism.drm.rest.service.framework.notifyrule.model.RemoteNotifyRuleVo;
import com.huawei.ism.drm.rest.service.framework.notifyrule.service.INotifyRuleRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.DeviceVo;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.service.permission.PermissionService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.huawei.lego.nem.fault.sdk.model.NotifyResItem;
import com.huawei.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.huawei.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

public class NotifyRuleRestServiceImpl
extends AbstractRestService
implements INotifyRuleRestService {
    private static final Log LOG = FELogFactory.getInstance((String)"ui");
    private static final String END_TIME = "9999-12-31 23:59:59";
    private static final long END_TIME_LONG = 253402271999000L;
    private static final Map<String, String> SENDCONTENTMAP = new HashMap<String, String>();
    private static final long MANAGEMENT_SYSTEM_ID = 1L;
    @Autowired
    private PermissionService permissionService;

    @Override
    @Permission(name={"lego.event.notify.scan"})
    public String getRemoteNotifyRuleList(String resName, String ruleName, String orderBy, String orderType, int startPage, int pageSize) {
        Paging paging;
        if (startPage < 0 || pageSize < 0) {
            throw new LegoCheckedException(250L);
        }
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Validator.canOrderBy((String)orderBy);
        boolean orderByAscend = orderType != null && orderType.equalsIgnoreCase("asc");
        RemoteNotifyRule queryParam = new RemoteNotifyRule();
        queryParam.setCreateUserId(this.getCurrentUserId().longValue());
        if (this.checkRuleName(resName, ruleName)) {
            ruleName = HtmlStringConverter.decode((String)ruleName);
            queryParam.setRuleName(ruleName);
            paging = service.getRuleAndCountByName(queryParam, startPage * pageSize, pageSize, orderBy, orderByAscend);
        } else {
            resName = HtmlStringConverter.decode((String)resName);
            queryParam.setRuleName(resName);
            paging = service.getRuleAndCountByResName(queryParam, startPage * pageSize, pageSize, orderBy, orderByAscend);
        }
        int total = paging.getiCount();
        List remoteNotifyRuleList = paging.getData();
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"totalCount", (Object)total);
        JSONArray jsonArray = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)remoteNotifyRuleList)) {
            for (RemoteNotifyRule rule : remoteNotifyRuleList) {
                jsonArray.add(this.remoteNotifyRuleToJsonStr(rule));
            }
        }
        resultObject.put((Object)"records", (Object)jsonArray);
        return resultObject.toString();
    }

    private boolean checkRuleName(String resName, String ruleName) {
        return !VerifyUtil.isEmpty((String)ruleName) || VerifyUtil.isEmpty((String)ruleName) && VerifyUtil.isEmpty((String)resName);
    }

    private Object remoteNotifyRuleToJsonStr(RemoteNotifyRule rule) {
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)rule)) {
            return jsonObject;
        }
        jsonObject.put((Object)"id", (Object)rule.getId());
        jsonObject.put((Object)"ruleName", (Object)rule.getRuleName());
        try {
            long startTime = rule.getStartTime();
            jsonObject.put((Object)"startTime", (Object)CommUtils.formatDate((Date)new Date(startTime)));
        }
        catch (Exception e) {
            LOG.debug((Object)"param startTime is not a number Character string");
            jsonObject.put((Object)"startTime", (Object)"--");
        }
        long endTime = rule.getEndTime();
        String endTimeStr = "--";
        if (endTime != 253402271999000L) {
            endTimeStr = CommUtils.formatDate((Date)new Date(endTime));
        }
        jsonObject.put((Object)"endTime", (Object)endTimeStr);
        jsonObject.put((Object)"isUseEnable", (Object)rule.isUseEnable());
        jsonObject.put((Object)"description", (Object)rule.getDescription());
        jsonObject.put((Object)"emailTo", (Object)rule.getEmailTo());
        jsonObject.put((Object)"expiredStatus", (Object)rule.isExpiredStatus());
        jsonObject.put((Object)"isClearEnable", (Object)rule.isClearEnable());
        jsonObject.put((Object)"isCriticalEnable", (Object)rule.isCriticalEnable());
        jsonObject.put((Object)"isInfoEnable", (Object)rule.isInfoEnable());
        jsonObject.put((Object)"isMajorEnable", (Object)rule.isMajorEnable());
        jsonObject.put((Object)"isWarningEnable", (Object)rule.isWarningEnable());
        jsonObject.put((Object)"moMainType", (Object)rule.getMoMainType());
        jsonObject.put((Object)"moSubType", (Object)rule.getMoSubType());
        jsonObject.put((Object)"sendContent", (Object)rule.getSendContent());
        jsonObject.put((Object)"smsMode", (Object)rule.getSmsMode());
        jsonObject.put((Object)"language", (Object)rule.getLanguage());
        jsonObject.put((Object)"smsPhone", (Object)rule.getSmsPhone());
        jsonObject.put((Object)"validStatus", (Object)rule.isValidStatus());
        Set notifyAlarmItems = rule.getNotifyAlarmItems();
        Set notifyResItems = rule.getNotifyResItems();
        jsonObject.put((Object)"notifyAlarmItems", (Object)CommUtils.responseJsonArrayResult((Collection)notifyAlarmItems, (String[])new String[]{"remoteNotifyRule"}));
        jsonObject.put((Object)"notifyResItems", (Object)CommUtils.responseJsonArrayResult((Collection)notifyResItems, (String[])new String[]{"remoteNotifyRule"}));
        return jsonObject;
    }

    @Override
    @Permission(name={"lego.event.notify.add"})
    @Logging(name="notificationServer_createNotificationRule_operateName", object="$1?.ruleName")
    public Response createRemoteNotifyRule(RemoteNotifyRuleVo vo) {
        this.checkParam(vo);
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        RemoteNotifyRule remoteNotifyRule = this.voToBean(vo);
        remoteNotifyRule.setCreateUserId(this.getCurrentUserId().longValue());
        Object[] phoneList = this.checkPhone(vo);
        Object[] emailList = this.checkEmail(vo);
        if (VerifyUtil.isEmpty((Object[])phoneList) && VerifyUtil.isEmpty((Object[])emailList)) {
            throw new LegoCheckedException(250L);
        }
        String[] deviceStrArray = this.deviceSetToStrArray(vo.getDeviceSet());
        String[] alarmTypeList = this.alarmTypeSetToStrArray(vo.getAlarmTypeSet());
        service.addRule(remoteNotifyRule, (String[])emailList, (String[])phoneList, this.convertSelectiveFields(vo.getSelectiveFields()), deviceStrArray, alarmTypeList);
        return Response.ok().build();
    }

    private String[] convertSelectiveFields(String[] selectiveFields) {
        if (selectiveFields == null || selectiveFields.length == 0) {
            return selectiveFields;
        }
        int size = selectiveFields.length;
        for (int i = 0; i < size; ++i) {
            selectiveFields[i] = this.getSelectiveFields(selectiveFields[i]);
        }
        return selectiveFields;
    }

    private RemoteNotifyRule voToBean(RemoteNotifyRuleVo vo) {
        String ruleName = vo.getRuleName();
        Long startTime = vo.getStartTime();
        Long endTime = vo.getEndTime();
        String description = vo.getDescription();
        Integer language = vo.getLanguage();
        boolean useEnable = vo.isUseEnable();
        RemoteNotifyRule remoteNotifyRule = new RemoteNotifyRule();
        remoteNotifyRule.setLanguage(language.intValue());
        remoteNotifyRule.setRuleName(ruleName);
        remoteNotifyRule.setClearEnable(true);
        remoteNotifyRule.setUseEnable(useEnable);
        remoteNotifyRule.setStartTimeStr(CommUtils.formatDate((Date)new Date(startTime)));
        String endTimeStr = endTime == null || endTime <= 0L ? END_TIME : CommUtils.formatDate((Date)new Date(endTime));
        remoteNotifyRule.setEndTimeStr(endTimeStr);
        int smsMode = 2;
        remoteNotifyRule.setSmsMode(2);
        remoteNotifyRule.setDescription(description);
        return remoteNotifyRule;
    }

    private String[] alarmTypeSetToStrArray(Set<AlarmVO> alarmTypeSet) {
        Iterator<AlarmVO> iterator = alarmTypeSet.iterator();
        ArrayList<String> alarmList = new ArrayList<String>();
        while (iterator.hasNext()) {
            AlarmVO alarmVo = iterator.next();
            String severity = alarmVo.getSeverity();
            String alarmId = alarmVo.getAlarmId();
            String alarmName = alarmVo.getAlarmName();
            String alarmType = alarmVo.getAlarmType();
            CommUtils.checkParamEmpty((Object[])new Object[]{severity, alarmId, alarmName, alarmType});
            String alarmStr = severity + "\t" + alarmId + "\t" + alarmName + "\t" + alarmType;
            alarmList.add(alarmStr);
        }
        String[] alarmArray = new String[alarmList.size()];
        for (int i = 0; i < alarmList.size(); ++i) {
            alarmArray[i] = (String)alarmList.get(i);
        }
        return alarmArray;
    }

    private boolean checkselectiveFields(String[] selectiveFields) {
        if (VerifyUtil.isEmpty((Object[])selectiveFields)) {
            return false;
        }
        List<String> dbFields = Arrays.asList("severity", "alarmName", "alarmType", "source", "createTime", "clearStatus", "alarmDesc", "location");
        for (String fieldName : selectiveFields) {
            if (!VerifyUtil.isEmpty((String)fieldName) && dbFields.contains(fieldName)) continue;
            throw new LegoCheckedException(250L);
        }
        return true;
    }

    private String[] deviceSetToStrArray(Set<DeviceVo> deviceSet) {
        Iterator<DeviceVo> iterator = deviceSet.iterator();
        ArrayList<String> deviceList = new ArrayList<String>();
        while (iterator.hasNext()) {
            DeviceVo deviceVo = iterator.next();
            Long moid = deviceVo.getMoId();
            String name = deviceVo.getName();
            String mainType = deviceVo.getMainType();
            String subType = deviceVo.getSubType();
            String ipAddress = deviceVo.getIpAddress();
            CommUtils.checkParamEmpty((Object[])new Object[]{moid, name, mainType, subType, ipAddress});
            if (moid != 1L) {
                this.checkUserMoAuthority("notificationServer_createNotificationRule_operateName", 1, new long[]{moid});
            }
            String deviceStr = moid + "\t" + name + "\t" + subType + "\t" + mainType + "\t" + ipAddress;
            deviceList.add(deviceStr);
        }
        String[] deviceArray = new String[deviceList.size()];
        for (int i = 0; i < deviceList.size(); ++i) {
            deviceArray[i] = (String)deviceList.get(i);
        }
        return deviceArray;
    }

    private String[] checkEmail(RemoteNotifyRuleVo vo) {
        Set<EmailVo> emailSet = vo.getEmailSet();
        if (emailSet == null) {
            return new String[0];
        }
        ArrayList<String> emailList = new ArrayList<String>();
        for (EmailVo emailVo : emailSet) {
            String emailAddress = emailVo.getEmailAddress();
            String desc = emailVo.getDesc();
            if (!Validator.checkStringLength((String)emailAddress, (int)254) || !Validator.checkStringLength((String)desc, (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.isEmail((String)emailAddress)) continue;
            if (desc != null) {
                desc = desc.replaceAll("=", "=k");
                desc = desc.replaceAll("#", "#k");
            }
            String emailStr = emailAddress + "###" + desc;
            emailList.add(emailStr);
        }
        if (VerifyUtil.isEmpty(emailList)) {
            return new String[0];
        }
        int size = emailList.size();
        if (size > 10) {
            throw new LegoCheckedException(250L);
        }
        String[] emailStrArray = new String[size];
        for (int i = 0; i < size; ++i) {
            emailStrArray[i] = (String)emailList.get(i);
        }
        return emailStrArray;
    }

    private String[] checkPhone(RemoteNotifyRuleVo vo) {
        Set<PhoneVo> phoneSet = vo.getPhoneSet();
        if (phoneSet == null) {
            return new String[0];
        }
        ArrayList<String> phoneList = new ArrayList<String>();
        for (PhoneVo phoneVo : phoneSet) {
            String tel = phoneVo.getPhoneNumber();
            String desc = phoneVo.getDesc();
            if (!Validator.checkStringLength((String)tel, (int)32) || !Validator.checkStringLength((String)desc, (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.isPhoneInternation((String)tel)) {
                throw new LegoCheckedException(250L);
            }
            if (desc != null) {
                desc = desc.replaceAll("=", "=k");
                desc = desc.replaceAll("#", "#k");
            }
            String phoneStr = tel + "###" + desc;
            phoneList.add(phoneStr);
        }
        if (VerifyUtil.isEmpty(phoneList)) {
            return new String[0];
        }
        int size = phoneList.size();
        if (size > 10) {
            throw new LegoCheckedException(250L);
        }
        String[] phoneStrArray = new String[size];
        for (int i = 0; i < size; ++i) {
            phoneStrArray[i] = (String)phoneList.get(i);
        }
        return phoneStrArray;
    }

    private void checkParam(RemoteNotifyRuleVo vo) {
        if (VerifyUtil.isEmpty((Object)vo)) {
            throw new LegoCheckedException(1073947393L);
        }
        String ruleName = vo.getRuleName();
        Long startTime = vo.getStartTime();
        Long endTime = vo.getEndTime();
        String[] selectiveFields = vo.getSelectiveFields();
        Set<AlarmVO> alarmTypeSet = vo.getAlarmTypeSet();
        Set<DeviceVo> deviceSet = vo.getDeviceSet();
        String description = vo.getDescription();
        Integer language = vo.getLanguage();
        boolean i = true;
        int j = 2;
        if (this.checkRuleName(ruleName, selectiveFields)) {
            throw new LegoCheckedException(250L);
        }
        if (VerifyUtil.isEmpty(alarmTypeSet) || VerifyUtil.isEmpty(deviceSet) || !Validator.checkStringLength((String)description, (int)128) || language != 1 && language != 2) {
            throw new LegoCheckedException(250L);
        }
        Set<EmailVo> emailSet = vo.getEmailSet();
        Set<PhoneVo> phoneSet = vo.getPhoneSet();
        if (VerifyUtil.isEmpty(emailSet) && VerifyUtil.isEmpty(phoneSet)) {
            throw new LegoCheckedException(250L);
        }
        this.checkRuleTime(startTime, endTime);
    }

    private void checkRuleTime(Long startTime, Long endTime) {
        Validator.checkLongTime((Long)startTime);
        if (VerifyUtil.isEmpty((Object)endTime)) {
            endTime = Long.MAX_VALUE;
        } else {
            Validator.checkLongTime((Long)endTime);
        }
        if (startTime > endTime) {
            throw new LegoCheckedException(250L);
        }
        long currentTime = new Date().getTime();
        if (endTime <= currentTime) {
            throw new LegoCheckedException(1565L);
        }
    }

    private boolean checkRuleName(String ruleName, String[] selectiveFields) {
        return Validator.stringNullTrim((String)ruleName) || !Validator.checkStringLength((String)ruleName, (int)32) || !Validator.regExpCheck((String)ruleName, (String)"^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$") || !this.checkselectiveFields(selectiveFields);
    }

    @Override
    @Permission(name={"lego.event.notify.delete"})
    @Logging(name="notificationServer_delNotificationRule_operateName", rank=2)
    public BatchOperationResult deleteRemoteNotifyRule(Long[] ruleIds) {
        return this.dealRemoteNotifyRule(true, false, ruleIds);
    }

    private BatchOperationResult dealRemoteNotifyRule(boolean isDelete, boolean useStatus, Long[] ruleIds) {
        CommUtils.checkArrayEmpty((Object[])ruleIds);
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        ArrayList<BatchOperation> bathOprList = new ArrayList<BatchOperation>();
        ArrayList<RemoteNotifyRule> rulesToDelete = new ArrayList<RemoteNotifyRule>();
        for (Long ruleId : ruleIds) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(ruleId.longValue());
            RemoteNotifyRule remoteNotifyRule = service.getRuleByID(String.valueOf(ruleId));
            if (remoteNotifyRule == null) {
                tempBatch.setTargetName("");
            } else {
                tempBatch.setTargetName(remoteNotifyRule.getRuleName());
                rulesToDelete.add(remoteNotifyRule);
            }
            bathOprList.add(tempBatch);
        }
        this.checkRuleAuthority(rulesToDelete);
        BatchOperationResult batchOperationResult = isDelete ? service.deleteRules(bathOprList) : service.setSwitchStatus(useStatus, bathOprList);
        return batchOperationResult;
    }

    private void checkRuleAuthority(List<RemoteNotifyRule> rulesToDelete) {
        rulesToDelete.stream().flatMap(ruleToDel -> ruleToDel.getNotifyResItems().stream()).map(NotifyResItem::getAlarmSource).map(Long::parseLong).forEach(xva$0 -> this.checkUserAuthorityByMoIds(new long[]{xva$0}));
    }

    @Override
    @Permission(name={"lego.event.notify.start"})
    @Logging(name="notificationServer_enablelNotificationRule_operateName", rank=3)
    public BatchOperationResult enableRemoteNotifyRule(Long[] ruleIds) {
        return this.dealRemoteNotifyRule(false, true, ruleIds);
    }

    @Override
    @Permission(name={"lego.event.notify.start"})
    @Logging(name="notificationServer_disablelNotificationRule_operateName", rank=2)
    public BatchOperationResult disableRemoteNotifyRule(Long[] ruleIds) {
        return this.dealRemoteNotifyRule(false, false, ruleIds);
    }

    @Override
    @Permission(name={"lego.event.notify.scan"})
    public RemoteNotifyRuleVo getRemoteNotifyRule(String ruleId) {
        RemoteNotifyRuleVo vo = new RemoteNotifyRuleVo();
        RemoteNotifyRule remoteNotifyRulePO = this.getNotifyRule(ruleId);
        this.setVO(vo, remoteNotifyRulePO);
        return vo;
    }

    private RemoteNotifyRule getNotifyRule(String ruleId) {
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Validator.convertString2Integer((String)ruleId);
        return service.getRuleByID(ruleId);
    }

    private void setVO(RemoteNotifyRuleVo vo, RemoteNotifyRule po) {
        Set notifyResItems = po.getNotifyResItems();
        HashSet<DeviceVo> deviceSet = new HashSet<DeviceVo>();
        this.dealDeviceSet(notifyResItems, deviceSet);
        vo.setDeviceSet(deviceSet);
        Set notifyAlarmItems = po.getNotifyAlarmItems();
        HashSet<AlarmVO> alarmTypeSet = new HashSet<AlarmVO>();
        this.dealAlarmTypeSet(notifyAlarmItems, alarmTypeSet);
        vo.setAlarmTypeSet(alarmTypeSet);
        this.setFields(vo, po);
        String emailTo = po.getEmailTo();
        HashSet<EmailVo> emailVoSet = new HashSet<EmailVo>();
        if (emailTo != null) {
            this.getEmailVoSet(emailTo, emailVoSet);
        }
        vo.setEmailSet(emailVoSet);
        String smsPhone = po.getSmsPhone();
        HashSet<PhoneVo> phoneVoSet = new HashSet<PhoneVo>();
        if (smsPhone != null) {
            this.getPhoneVoSet(smsPhone, phoneVoSet);
        }
        vo.setPhoneSet(phoneVoSet);
        vo.setDescription(po.getDescription());
        vo.setIsUseEnable(po.isUseEnable());
        vo.setLanguage(po.getLanguage());
        vo.setRuleName(po.getRuleName());
        vo.setStartTime(po.getStartTime());
        long endTime = po.getEndTime();
        if (endTime == 253402271999000L) {
            endTime = -1L;
        }
        vo.setEndTime(endTime);
    }

    private void getEmailVoSet(String emailTo, Set<EmailVo> emailVoSet) {
        String[] emailList;
        for (String email : emailList = emailTo.split("===")) {
            if (VerifyUtil.isEmpty((String)email)) continue;
            String[] tmpStr = email.split("###");
            String remark = "";
            if (tmpStr.length > 1) {
                remark = tmpStr[1];
            }
            remark = remark.replaceAll("=k", "=");
            remark = remark.replaceAll("#k", "#");
            EmailVo emailVo = new EmailVo();
            emailVo.setEmailAddress(tmpStr[0]);
            emailVo.setDesc(remark);
            emailVoSet.add(emailVo);
        }
    }

    private void getPhoneVoSet(String smsPhone, Set<PhoneVo> phoneVoSet) {
        String[] phoneList;
        for (String phone : phoneList = smsPhone.split("===")) {
            if (VerifyUtil.isEmpty((String)phone)) continue;
            String[] tmpStr = phone.split("###");
            String remark = "";
            if (tmpStr.length > 1) {
                remark = tmpStr[1];
            }
            remark = remark.replaceAll("=k", "=");
            remark = remark.replaceAll("#k", "#");
            PhoneVo phoneVo = new PhoneVo();
            phoneVo.setPhoneNumber(tmpStr[0]);
            phoneVo.setDesc(remark);
            phoneVoSet.add(phoneVo);
        }
    }

    private void dealAlarmTypeSet(Set<NotifyAlarmItem> notifyAlarmItems, Set<AlarmVO> alarmTypeSet) {
        if (!VerifyUtil.isEmpty(notifyAlarmItems)) {
            for (NotifyAlarmItem item : notifyAlarmItems) {
                AlarmVO alarmVo = new AlarmVO();
                alarmVo.setId(item.getId());
                alarmVo.setAlarmId(item.getAlarmId());
                alarmVo.setSeverity(item.getAlarmLevel() + "");
                alarmVo.setAlarmName(item.getAlarmName());
                alarmVo.setAlarmType(item.getAlarmType() + "");
                alarmTypeSet.add(alarmVo);
            }
        }
    }

    private void dealDeviceSet(Set<NotifyResItem> notifyResItems, Set<DeviceVo> deviceSet) {
        if (!VerifyUtil.isEmpty(notifyResItems)) {
            for (NotifyResItem item : notifyResItems) {
                DeviceVo deviceVo = new DeviceVo();
                deviceVo.setId(item.getId());
                long moId = -1L;
                if (item.getAlarmSource() != null) {
                    moId = NumberUtil.convertToLong((Object)item.getAlarmSource());
                }
                deviceVo.setMoId(Long.valueOf(moId));
                deviceVo.setIpAddress(item.getMoIP());
                deviceVo.setMainType(item.getMoMainType());
                deviceVo.setName(item.getMoName());
                deviceVo.setSubType(item.getMoSubType());
                deviceSet.add(deviceVo);
            }
        }
    }

    private void setFields(RemoteNotifyRuleVo vo, RemoteNotifyRule po) {
        String sendContent = po.getSendContent();
        String[] fields = null;
        if (sendContent != null) {
            fields = sendContent.split(",");
        }
        if (VerifyUtil.isEmpty(fields)) {
            return;
        }
        String[] selectiveFileds = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String[] fieldValue = fields[i].split(":");
            selectiveFileds[i] = fieldValue[0];
        }
        vo.setSelectiveFields(selectiveFileds);
    }

    @Override
    @Context(name="ruleName")
    @Permission(name={"lego.event.notify.modify"})
    @Logging(name="notificationServer_modifyNotificationRule_operateName", rank=3, object="$ruleName", detail="notificationServer_modifyNotificationRule_operateDetail_1")
    public Response modifyNotifyBaseInfo(String id, RemoteNotifyRuleVo vo) {
        this.checkParamForModifyNotifyBaseInfo(vo);
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        RemoteNotifyRule rule = service.getRuleByID(id);
        CommUtils.checkObjectExists((Object[])new Object[]{rule});
        String ruleName = rule.getRuleName();
        Context.Variable.set((String)"ruleName", (Object)ruleName);
        RemoteNotifyRule remoteNotifyRule = this.voToBean(vo);
        String[] startEndTime = new String[]{remoteNotifyRule.getStartTimeStr(), remoteNotifyRule.getEndTimeStr()};
        service.modifyNotifyBaseInfo(id, remoteNotifyRule.isUseEnable(), startEndTime, remoteNotifyRule.getDescription(), remoteNotifyRule.getLanguage(), this.setSendContent(vo));
        return Response.ok().build();
    }

    private String setSendContent(RemoteNotifyRuleVo vo) {
        StringBuilder sendContent = new StringBuilder();
        Object[] selectiveFields = vo.getSelectiveFields();
        if (VerifyUtil.isEmpty((Object[])selectiveFields)) {
            throw new LegoCheckedException(1073947393L);
        }
        for (Object field : selectiveFields) {
            String value = this.getSelectiveFields((String)field);
            sendContent.append(value);
            sendContent.append(",");
        }
        String content = sendContent.toString();
        if (0 != content.length()) {
            return content.substring(0, content.length() - 1);
        }
        return content;
    }

    private String getSelectiveFields(String field) {
        return field + ":" + this.getText(SENDCONTENTMAP.get(field));
    }

    private void checkParamForModifyNotifyBaseInfo(RemoteNotifyRuleVo vo) {
        String ruleName = vo.getRuleName();
        Long startTime = vo.getStartTime();
        Long endTime = vo.getEndTime();
        String[] selectiveFields = vo.getSelectiveFields();
        String description = vo.getDescription();
        Integer language = vo.getLanguage();
        if (Validator.stringNullTrim((String)ruleName) || !Validator.checkStringLength((String)ruleName, (int)32) || !Validator.regExpCheck((String)ruleName, (String)"^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$")) {
            throw new LegoCheckedException(250L);
        }
        int i = 2;
        boolean j = true;
        if (!this.checkselectiveFields(selectiveFields) || !Validator.checkStringLength((String)description, (int)128) || language != 1 && language != 2) {
            throw new LegoCheckedException(250L);
        }
        this.checkRuleTime(startTime, endTime);
    }

    @Override
    @Context(name="ruleName")
    @Permission(name={"lego.event.notify.modify"})
    @Logging(name="notificationServer_modifyNotificationRule_operateName", rank=3, object="$ruleName", detail="notificationServer_modifyNotificationRule_operateDetail_2")
    public Response modifyNotifyObj(String id, RemoteNotifyRuleVo vo) {
        if (VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(250L);
        }
        Object remoteNotifyService = this.getBundleService("fault", "remoteNotifyRuleService");
        IRemoteNotifyRuleService service = null;
        if (remoteNotifyService instanceof IRemoteNotifyRuleService) {
            service = (IRemoteNotifyRuleService)remoteNotifyService;
        }
        int length = 32;
        String[] phoneList = new String[]{""};
        Set<PhoneVo> phoneSet = vo.getPhoneSet();
        boolean isOkPhoneNumber = false;
        if (!VerifyUtil.isEmpty(phoneSet)) {
            int i = 0;
            int size = phoneSet.size();
            if (size > 10) {
                throw new LegoCheckedException(250L);
            }
            phoneList = new String[size];
            for (PhoneVo phoneVo : phoneSet) {
                String phoneNumber = phoneVo.getPhoneNumber();
                String desc = phoneVo.getDesc();
                this.checkPhoneSet(32, phoneNumber, desc);
                desc = desc.replaceAll("=", "=k");
                desc = desc.replaceAll("#", "#k");
                phoneList[i++] = phoneNumber + "###" + desc;
                isOkPhoneNumber = true;
            }
        }
        Set<EmailVo> emailSet = vo.getEmailSet();
        String[] emailList = new String[]{""};
        boolean isOkEmailList = false;
        if (!VerifyUtil.isEmpty(emailSet)) {
            int i = 0;
            int size = emailSet.size();
            if (size > 10) {
                throw new LegoCheckedException(250L);
            }
            emailList = new String[size];
            for (EmailVo emailVo : emailSet) {
                String emailAddress = emailVo.getEmailAddress();
                String desc = emailVo.getDesc();
                this.checkEmailSet(32, emailAddress, desc);
                desc = desc.replaceAll("=", "=k");
                desc = desc.replaceAll("#", "#k");
                emailList[i++] = emailAddress + "###" + desc;
                isOkEmailList = true;
            }
        }
        if (!isOkPhoneNumber && !isOkEmailList) {
            throw new LegoCheckedException(250L);
        }
        int paramInt = 2;
        RemoteNotifyRule oldNotifyRule = this.getNotifyRule(id);
        Context.Variable.set((String)"ruleName", (Object)oldNotifyRule.getRuleName());
        service.modifyNotifyObj(id, 2, phoneList, emailList);
        return Response.ok().build();
    }

    private void checkEmailSet(int length, String emailAddress, String desc) {
        if (null != emailAddress && !Validator.checkStringLength((String)emailAddress, (int)254)) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.isEmail((String)emailAddress)) {
            throw new LegoCheckedException(250L);
        }
        if (null != desc && !Validator.checkStringLength((String)desc, (int)length)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkPhoneSet(int length, String phoneNumber, String desc) {
        if (null != phoneNumber && !Validator.checkStringLength((String)phoneNumber, (int)length)) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.isPhoneInternation((String)phoneNumber)) {
            throw new LegoCheckedException(250L);
        }
        if (null != desc && !Validator.checkStringLength((String)desc, (int)length)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void writeOptLogAndDataErrExc() {
        throw new LegoCheckedException(250L);
    }

    @Override
    @Context(name="ruleName")
    @Permission(name={"lego.event.notify.modify"})
    @Logging(name="notificationServer_modifyNotificationRule_operateName", rank=3, object="$ruleName", ward=true)
    public Response addResource(String id, Set<DeviceVo> deviceList) {
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Validator.convertString2Integer((String)id);
        if (this.checkDeviceEmpty(deviceList)) {
            throw new LegoCheckedException(250L);
        }
        RemoteNotifyRule oldNotifyRule = this.getNotifyRule(id);
        Set notifyResItems = oldNotifyRule.getNotifyResItems();
        HashSet<DeviceVo> addDeviceSet = new HashSet<DeviceVo>();
        HashSet<NotifyResItem> delDeviceSet = new HashSet<NotifyResItem>();
        this.filterDevice(notifyResItems, deviceList, addDeviceSet, delDeviceSet);
        int size = addDeviceSet.size();
        String[] deviceListStr = new String[size];
        int i = 0;
        for (DeviceVo device : addDeviceSet) {
            Long moId = device.getMoId();
            this.permissionService.checkUserMoAuthority((Object)moId);
            String name = device.getName();
            String subType = device.getSubType();
            String mainType = device.getMainType();
            String ipAddress = device.getIpAddress();
            deviceListStr[i] = moId + "\t" + name + "\t" + subType + "\t" + mainType;
            if (!VerifyUtil.isEmpty((String)ipAddress)) {
                int n = i;
                deviceListStr[n] = deviceListStr[n] + "\t" + ipAddress;
            }
            ++i;
        }
        ArrayList<BatchOperation> delResources = new ArrayList<BatchOperation>();
        for (NotifyResItem item : delDeviceSet) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetId(item.getId());
            delResources.add(batchOperation);
        }
        this.addResources(id, service, oldNotifyRule, deviceListStr);
        this.delResources(service, oldNotifyRule, delResources);
        if (this.checkDeviceList(deviceListStr, delResources)) {
            this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), null, null);
        }
        return Response.ok().build();
    }

    private void addResources(String id, IRemoteNotifyRuleService service, RemoteNotifyRule oldNotifyRule, String[] deviceListStr) {
        if (!VerifyUtil.isEmpty((Object[])deviceListStr)) {
            service.addResource(id, deviceListStr);
            this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_5", null);
        }
    }

    private void delResources(IRemoteNotifyRuleService service, RemoteNotifyRule oldNotifyRule, List<BatchOperation> delResources) {
        if (!VerifyUtil.isEmpty(delResources)) {
            service.deleteResourceItem(delResources);
            this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_6", null);
        }
    }

    private boolean checkDeviceEmpty(Set<DeviceVo> deviceList) {
        return null == deviceList || deviceList.size() <= 0;
    }

    private boolean checkDeviceList(String[] deviceListStr, List<BatchOperation> delResources) {
        return VerifyUtil.isEmpty((Object[])deviceListStr) && VerifyUtil.isEmpty(delResources);
    }

    private void filterDevice(Set<NotifyResItem> oldNotifyResItems, Set<DeviceVo> newDeviceList, Set<DeviceVo> addDeviceSet, Set<NotifyResItem> delDeviceSet) {
        ArrayList<Long> oldIds = new ArrayList<Long>();
        for (NotifyResItem item : oldNotifyResItems) {
            oldIds.add(item.getId());
        }
        ArrayList<Long> newIds = new ArrayList<Long>();
        for (DeviceVo vo : newDeviceList) {
            newIds.add(vo.getId());
            if (oldIds.contains(vo.getId())) continue;
            addDeviceSet.add(vo);
        }
        for (NotifyResItem item : oldNotifyResItems) {
            if (newIds.contains(item.getId())) continue;
            delDeviceSet.add(item);
        }
    }

    @Override
    @Context(name="ruleName")
    @Permission(name={"lego.event.notify.modify"})
    @Logging(name="notificationServer_modifyNotificationRule_operateName", rank=3, object="$ruleName", ward=true)
    public Response addAlarm(String id, Set<AlarmVO> alarmVoSet) {
        IRemoteNotifyRuleService service = (IRemoteNotifyRuleService)this.getBundleService("fault", "remoteNotifyRuleService");
        Validator.convertString2Integer((String)id);
        if (VerifyUtil.isEmpty(alarmVoSet)) {
            this.writeOptLogAndDataErrExc();
        }
        RemoteNotifyRule oldNotifyRule = this.getNotifyRule(id);
        Context.Variable.set((String)"ruleName", (Object)oldNotifyRule.getRuleName());
        Set notifyAlarmItems = oldNotifyRule.getNotifyAlarmItems();
        HashSet<AlarmVO> addAlarmSet = new HashSet<AlarmVO>();
        HashSet<NotifyAlarmItem> delAlarmSet = new HashSet<NotifyAlarmItem>();
        this.filterAlarm(notifyAlarmItems, alarmVoSet, addAlarmSet, delAlarmSet);
        Object[] alarmTypeListStr = new String[addAlarmSet.size()];
        int i = 0;
        for (AlarmVO alarmVo : addAlarmSet) {
            String alarmId = alarmVo.getAlarmId();
            String alarmName = alarmVo.getAlarmName();
            String severity = alarmVo.getSeverity();
            String alarmType = alarmVo.getAlarmType();
            int level = 0;
            try {
                level = Integer.parseInt(severity);
                Integer.parseInt(alarmType);
                if (this.isLevelNotValid(level)) {
                    this.writeOptLogAndDataErrExc();
                }
            }
            catch (NumberFormatException e) {
                this.writeOptLogAndDataErrExc();
            }
            alarmTypeListStr[i++] = level + "\t" + alarmId + "\t" + alarmName + "\t" + alarmType;
        }
        ArrayList<BatchOperation> delAlarms = new ArrayList<BatchOperation>();
        for (NotifyAlarmItem item : delAlarmSet) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetId(item.getId());
            delAlarms.add(batchOperation);
        }
        if (!VerifyUtil.isEmpty((Object[])alarmTypeListStr)) {
            service.addAlarm(id, (String[])alarmTypeListStr);
            this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_3", null);
        }
        this.delAlarmItem(service, oldNotifyRule, delAlarms);
        return Response.ok().build();
    }

    private void delAlarmItem(IRemoteNotifyRuleService service, RemoteNotifyRule oldNotifyRule, List<BatchOperation> delAlarms) {
        if (!VerifyUtil.isEmpty(delAlarms)) {
            service.deleteAlarmItem(delAlarms);
            this.writeSucOperationLog("notificationServer_modifyNotificationRule_operateName", 3, oldNotifyRule.getRuleName(), "notificationServer_modifyNotificationRule_operateDetail_4", null);
        }
    }

    private boolean isLevelNotValid(int level) {
        return level != 1 && level != 2 && level != 3 && level != 4;
    }

    private void filterAlarm(Set<NotifyAlarmItem> oldNotifyAlarmItems, Set<AlarmVO> newAlarmVoSet, Set<AlarmVO> addAlarmSet, Set<NotifyAlarmItem> delAlarmSet) {
        ArrayList<Long> newIds = new ArrayList<Long>();
        for (AlarmVO vo : newAlarmVoSet) {
            newIds.add(vo.getId());
            if (vo.getId() >= 0L) continue;
            addAlarmSet.add(vo);
        }
        for (NotifyAlarmItem item : oldNotifyAlarmItems) {
            if (newIds.contains(item.getId())) continue;
            delAlarmSet.add(item);
        }
    }

    static {
        SENDCONTENTMAP.put("severity", "lego.lab.fault.alarmLevel");
        SENDCONTENTMAP.put("alarmName", "lego.lab.fault.saveAlarm.name");
        SENDCONTENTMAP.put("alarmType", "lego.dic.warningtype");
        SENDCONTENTMAP.put("source", "lego.lab.fault.saveAlarm.alarmSource");
        SENDCONTENTMAP.put("createTime", "lego.lab.fault.createTime");
        SENDCONTENTMAP.put("clearStatus", "lego.dic.clearstatus");
        SENDCONTENTMAP.put("alarmDesc", "lego.lab.com.description");
        SENDCONTENTMAP.put("location", "lego.lab.fault.location");
    }
}

