/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.model.QueryPOPage;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.report.sdk.model.ProtectGroupStatisticInfo;
import com.huawei.ism.drm.report.sdk.service.IProtectGroupReportService;
import com.huawei.ism.drm.rest.service.platform.protection.group.AbstractProtectGroupRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.BaseAbstractProtectGroupRestService;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.service.platform.protection.group.ScheduleFormater;
import com.huawei.ism.drm.rest.service.platform.protection.group.param.ProtectGroupReplicaQueryParam;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupExcelDetailsOperator;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupExcelUtil;
import com.huawei.ism.drm.rest.service.platform.protection.util.ProtectGroupLogExcelOperator;
import com.huawei.ism.drm.rest.util.DownloadFileUtil;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.annotation.Permissions;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import com.huawei.ism.drm.web.util.FileUtil;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.Charsets;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class ProtectGroupBaseRestServiceImpl
extends AbstractProtectGroupRestService {
    private static final int QUERY_ALL_DETECTION_RESULT = -2;
    private static final Log log = LogFactory.getInstance(ProtectGroupBaseRestServiceImpl.class);

    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String protectgroups(int poType, String orderBy, String orderType, int pageSize, int startPage, String siteId) {
        if (!Validator.checkPageQueryParams((String)orderType, (int)pageSize, (int)startPage)) {
            log.error((Object)("orderType:" + orderType + ", pageSize:" + pageSize + ", startPage:" + startPage));
            throw new LegoCheckedException(1073947393L);
        }
        boolean orderByAscend = "asc".equalsIgnoreCase(orderType);
        List<QueryCondition> queryConditions = this.constructQueryCondition(poType, siteId);
        Page page = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).pagedQueryProtectGroup(startPage, pageSize, orderBy, orderByAscend, queryConditions, this.getCurrentUserId());
        JSONObject result = new JSONObject();
        if (VerifyUtil.isEmpty((Object)page) || VerifyUtil.isEmpty((Collection)page.getResult())) {
            result.put((Object)"totalCount", (Object)0);
            result.put((Object)"records", (Object)"[]");
            return result.toString();
        }
        List protectGrsours = page.getResult();
        result.put((Object)"totalCount", (Object)page.getTotalCount());
        result.put((Object)"records", (Object)this.toProtectGroupJson(protectGrsours));
        return result.toString();
    }

    private List<QueryCondition> constructQueryCondition(int poType, String siteId) {
        String filterName = this.getRequest().getParameter("filterName");
        String filterValue = this.getRequest().getParameter("filterValue");
        log.debug((Object)("poType:" + poType + ", siteId:" + siteId));
        List<QueryCondition> queryConditions = this.queryCondition(filterName, filterValue);
        if (poType != -1) {
            queryConditions.add(new QueryCondition("poType", (Object)poType));
        }
        if (!"-1".equals(siteId)) {
            this.permissionService.checkUserGrantedObject(siteId);
            queryConditions.add(new QueryCondition("productSiteId", (Object)siteId));
        }
        return queryConditions;
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String protectgroups(String protectgroupId) {
        log.debug((Object)("protectgroupId:" + protectgroupId));
        this.validateProtectGroupId(protectgroupId);
        ProtectGroup protectGroup = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupByID(protectgroupId, false);
        this.validateProtectGroup(protectGroup);
        return this.toProtectGroupJson(protectGroup);
    }

    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_modify_operateName", rank=3, object="$pg?.name", detail="protectedGroup_modify_operateDetail", parameters={"$pg?.name", "$2?.name", "$pg?.description", "$2?.description"})
    public Response updateProtectGroupBasicInfo(String protectGroupId, ProtectGroup pg) {
        if (null == protectGroupId || null == pg) {
            log.debug((Object)("protectgroupId:" + protectGroupId + ",pg:" + pg));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupValidator.updateProtectGroupBasicInfoCheck(protectGroupId, pg.getName(), pg.getDescription());
        ProtectGroup oldProtectGroup = this.getService().getProtectGroupBasicInfo(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)oldProtectGroup);
        if (oldProtectGroup == null) {
            log.error((Object)("protectgroup [id:" + protectGroupId + "] is not existed!"), 653110170615808L);
            throw new LegoCheckedException(1073947394L);
        }
        if (this.validateIsHypermetro(oldProtectGroup) || this.validateIsReplication(oldProtectGroup)) {
            throw new LegoCheckedException(1073947453L);
        }
        pg.setUuid(protectGroupId);
        long taskId = this.getService().updateProtectGroupBasicInfo(pg, Boolean.valueOf(this.isMachineToMachineReq()));
        JSONObject obj = new JSONObject();
        obj.put((Object)"taskId", (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String getProtectGroupReplicas(String protectGroupId, Integer status, Long startTime, Long endTime) {
        List<ProtectGroupReplica> replicas;
        this.validateProtectGroupId(protectGroupId);
        try {
            IReplicaService replicaService = (IReplicaService)this.getBundleService(IReplicaService.class);
            replicas = replicaService.queryProtectGroupReplicaByGroup(protectGroupId, "TIME_STAMP", false, false);
        }
        catch (Exception e) {
            log.debug((Object)("protectgroupId:" + protectGroupId + ",status:" + status));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectGroupId, false);
        this.filterReplicas(pg, replicas, status, startTime, endTime);
        replicas = this.sortReplicaByLocation(replicas);
        return this.protectGroupReplicaListToJsonStr(replicas).toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1?.protectGroupId"})
    public String pageQueryProtectGroupReplicas(ProtectGroupReplicaQueryParam queryParam) {
        List<ProtectGroupReplica> replicas;
        String protectGroupId = queryParam.getProtectGroupId();
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupByID(protectGroupId, false);
        IReplicaService replicaService = (IReplicaService)this.getBundleService(IReplicaService.class);
        Integer totalCount = 0;
        boolean isHyperCDP = false;
        Long startTime = queryParam.getStartTime();
        Long endTime = queryParam.getEndTime();
        Integer pageNum = queryParam.getStartPage();
        Integer status = queryParam.getStatus();
        Integer replicaType = queryParam.getReplicaType();
        try {
            replicas = replicaService.queryProtectGroupReplicaByGroup(protectGroupId, "TIME_STAMP", false, true);
            if (!VerifyUtil.isEmpty((Collection)replicas)) {
                replicas = this.getSiteProtectGroupReplicas(replicas, queryParam.getSiteId());
            }
            Set schedules = pg.getTemplate().getSchedules();
            for (Schedule schedule : schedules) {
                if (schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5 || !schedule.getSourceSiteId().equals(queryParam.getSiteId())) continue;
                replicas.addAll(replicaService.querySecondProtectGroupReplica(protectGroupId, schedule, pageNum, Integer.valueOf(10), startTime, endTime));
                if (schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue() || replicaType == null || replicaType != 4) continue;
                isHyperCDP = true;
                totalCount = replicaService.querySecondProtectGroupReplicaCount(protectGroupId, schedule, startTime, endTime);
            }
        }
        catch (Exception e) {
            log.error((Object)"Query replicas for protectGroup(%id) error", new Object[]{protectGroupId});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        this.filterReplicasByTypeAndDetectionStatus(replicas, replicaType, queryParam, pg);
        Integer pageSize = VerifyUtil.isEmpty((Object)queryParam.getPageSize()) || queryParam.getPageSize() <= 0 ? 10 : queryParam.getPageSize();
        if (!isHyperCDP) {
            this.filterReplicas(pg, replicas, status, startTime, endTime);
            totalCount = replicas.size();
            replicas = this.getGroupReplicasByPages(replicas, pageNum, pageSize);
        }
        return this.transferToJsonStr(replicas, totalCount);
    }

    private List<ProtectGroupReplica> sortReplicaByLocation(List<ProtectGroupReplica> replicas) {
        if (VerifyUtil.isEmpty(replicas)) {
            log.debug((Object)"replicas is empty!");
        }
        ArrayList<ProtectGroupReplica> result = new ArrayList<ProtectGroupReplica>(replicas);
        ArrayList<ProtectGroupReplica> toSortList = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : replicas) {
            if (!VerifyUtil.isEmpty((String)replica.getTimeStamp())) continue;
            toSortList.add(replica);
        }
        result.removeAll(toSortList);
        Collections.sort(toSortList, new Comparator<ProtectGroupReplica>(){

            @Override
            public int compare(ProtectGroupReplica paramT1, ProtectGroupReplica paramT2) {
                return paramT1.getProtectLocation() - paramT2.getProtectLocation();
            }
        });
        result.addAll(toSortList);
        return result;
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String getProtectGroupHistoryLogs(String protectGroupId, int startPage, int pageSize, String orderBy, String orderType) {
        this.validateProtectGroupId(protectGroupId);
        boolean isAsc = orderType != null && !orderType.equalsIgnoreCase("desc");
        Page page = this.getService().pageQueryHistoryLogFromAll(startPage, pageSize, orderBy, isAsc, protectGroupId);
        List result = page.getResult();
        long totalCount = page.getTotalCount();
        JSONObject jasonObject = new JSONObject();
        jasonObject.put((Object)"totalCount", (Object)totalCount);
        JSONArray array = new JSONArray();
        if (result instanceof List) {
            List logList = result;
            for (ProtectGroupLog groupLog : logList) {
                JSONObject obj = new JSONObject();
                try {
                    obj.put((Object)"historyLogId", (Object)groupLog.getHistoryLogId());
                    obj.put((Object)"info", (Object)groupLog.getInfo());
                    String startTime = groupLog.getStartTime();
                    obj.put((Object)"startTime", (Object)(startTime != null ? this.formatData(startTime) : "--"));
                    String endTime = groupLog.getEndTime();
                    obj.put((Object)"endTime", (Object)(endTime != null ? this.formatData(endTime) : "--"));
                    String executeTime = this.calcExecuteTime(startTime, endTime);
                    obj.put((Object)"executeTime", (Object)executeTime);
                    obj.put((Object)"result", (Object)groupLog.getResult());
                    array.add((Object)obj);
                }
                catch (Exception e) {
                    log.error((Object)"JSON operation failed.", (Throwable)e, 653110170615808L);
                }
            }
        }
        jasonObject.put((Object)"records", (Object)array);
        return jasonObject.toString();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String getProtectGroupLogDetails(String protectGroupId, int logId) {
        List result = -1 == logId ? this.getService().queryRunningHistoryLog(protectGroupId) : this.getService().queryHistoryLogDetailFromAll(logId, protectGroupId);
        JSONArray array = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)result)) {
            for (ProtectGroupLogDetail groupLogDetail : result) {
                JSONObject obj = new JSONObject();
                try {
                    this.addGroupDetailToJson(array, groupLogDetail, obj);
                }
                catch (LegoCheckedException e) {
                    log.error((Object)"JSON operation failed.", (Throwable)e, 653110170615808L);
                }
            }
        }
        return array.toString();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getAvailableProtectObject(int poType, String deviceSn) {
        Map queryParam = this.getExtParamInQueryParam();
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IResourceService resourceService = (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
        DrResource resource = resourceService.getDrResourceBySn(deviceSn);
        if (VerifyUtil.isEmpty((Object)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        if (resource instanceof DrHostGroup) {
            for (DrResource drHost : resource.getChildResources()) {
                this.permissionService.checkUserMoAuthority((Object)drHost.getDeviceSn());
            }
        } else {
            this.permissionService.checkUserMoAuthority((Object)deviceSn);
        }
        if (!this.checkDrmProtectObjectTypeParam(String.valueOf(poType))) {
            log.error((Object)"param[poType] is not number!");
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate poProvider = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        List poList = poProvider.getAvailableProtectObject(poType, deviceSn, queryParam);
        return this.protectObjectListToJsonStr(poList).toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"}, moid={"$2"})
    public String pageQueryAvailableProtectObject(int poType, String deviceSn, String orderBy, String orderType, String filterName, String filterValue) {
        IProtectObjectProviderDelegate poProvider = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deviceSn", deviceSn);
        Map paramsBack = poProvider.pretreatmentParams(poType, params);
        String string = deviceSn = VerifyUtil.isEmpty((Map)paramsBack) || VerifyUtil.isEmpty(paramsBack.get("deviceSn")) ? deviceSn : (String)paramsBack.get("deviceSn");
        if (!this.checkDrmProtectObjectTypeParam(String.valueOf(poType))) {
            log.error((Object)"Fail to get params, poType.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            log.error((Object)"Fail to get params, deviceSn.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        PageParameter pageParame = this.getPageParameter();
        Integer startPage = pageParame.getStartPage();
        Integer pageSize = pageParame.getPageSize();
        Map queryParam = this.getExtParamInQueryParam();
        queryParam.put("orderBy", orderBy);
        queryParam.put("pageSize", pageSize);
        queryParam.put("pageIndex", startPage);
        queryParam.put("orderType", orderType);
        queryParam.put("userId", this.getCurrentUserId());
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryParam.put("filterName", filterName);
            queryParam.put("filterValue", filterValue);
            queryParam.put(filterName, filterValue);
        }
        QueryPOPage page = poProvider.getAvailableProtectObjectPage(poType, deviceSn, queryParam);
        List poList = page.getPoList();
        int totalCount = page.getTotalCount();
        String records = this.protectObjectListToJsonStr(poList).toString();
        JSONObject result = new JSONObject();
        result.put((Object)"totalCount", (Object)totalCount);
        result.put((Object)"records", (Object)records);
        return result.toString();
    }

    private void validatePageQueryParams(PageParameter parameter) {
        if (!Validator.checkPageQueryParams((int)parameter.getPageSize(), (int)parameter.getStartPage())) {
            log.error((Object)"Invalid pageQuery param: pageSize=%s, startPage=%s", new Object[]{parameter.getPageSize(), parameter.getStartPage()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void addFilterToQueryMap(Map<String, Object> queryParam, String filterName, String filterValue) {
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryParam.put("filterName", filterName);
            queryParam.put("filterValue", filterValue);
            queryParam.put(filterName, filterValue);
        }
    }

    @Override
    @Permission(name={"ism.drm.12.protectgroup.auth.management"}, moid={"$this.getMoProviderSn($2)"})
    @Logging(name="protectedGroup_testAuthentication_operateName", object="$2?.name")
    public Response validateDatabaseAuthInfo(Integer poType, ProtectObject po) {
        if (VerifyUtil.isEmpty((Object)po)) {
            log.error((Object)"po is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        this.validateDbAuthInfo(poType, po);
        return Response.ok().build();
    }

    @Permission(name={"ism.drm.protectgroup.auth.add"}, moid={"$this.getMoProviderSn($1)"})
    public Response getProtectObjectStorageInfo(ProtectObject po) {
        if (VerifyUtil.isEmpty((Object)po)) {
            log.error((Object)"po is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate poProviderDelegate = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        poProviderDelegate.discoveryProtectObjectStorageInfo(po.getPoType(), po, null);
        return Response.ok().build();
    }

    @Override
    @Permissions(value={@Permission(name={"ism.drm.protectgroup.auth.add"}, uuid={"$1?.productSiteId"}), @Permission(name={"ism.drm.drp.auth.add"}, when="$2")})
    @Logging(name="protectedGroup_create_operateName", object="$1?.name")
    public Response addProtectGroup(ProtectGroup protectGroup, boolean isAutoCreateRp) {
        String groupName = protectGroup.getName();
        String pgDescription = protectGroup.getDescription();
        String pgAppType = String.valueOf(protectGroup.getPoType());
        String pgSN = protectGroup.getPoProviderSN();
        String pgSiteId = protectGroup.getProductSiteId();
        String pgDesc = HtmlStringConverter.decodeByLength((String)pgDescription);
        ArrayList<String> verifyParaList = new ArrayList<String>();
        verifyParaList.add(pgAppType);
        verifyParaList.add(pgSN);
        verifyParaList.add(pgSiteId);
        CommUtils.verifyParameterList(verifyParaList);
        Map props = protectGroup.getProps();
        CommUtils.verifyParameterMap((Map)props);
        PolicyTemplate template = protectGroup.getTemplate();
        if (this.checkProtectGroupParam(groupName, pgAppType, pgDesc, template)) {
            log.error((Object)("params are not legal!groupName:" + groupName + ", pgAppType:" + pgAppType + ", pgDesc:" + pgDesc + ", tempalte:" + template));
            throw new LegoCheckedException(1073947393L);
        }
        this.validatePolicyTemplate(template, protectGroup.getPoType());
        if (template.getType() == 25) {
            throw new LegoCheckedException(1073947453L);
        }
        IResourceService resourceService = (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
        DrResource resource = resourceService.getDrResourceBySn(pgSN);
        if (resource instanceof DrHostGroup) {
            for (DrResource drHost : resource.getChildResources()) {
                this.permissionService.checkUserMoAuthority((Object)drHost.getDeviceSn());
            }
        } else {
            this.permissionService.checkUserMoAuthority((Object)pgSN);
        }
        if (isAutoCreateRp) {
            IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName());
            planService.getSuitablePlanType(protectGroup);
        }
        template.setPtId(template.getUuid());
        ProtectGroupValidator.dealScheduleWhenCreatingProtectGroup(template);
        protectGroup.setOwnerId(this.getCurrentUserId());
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        long taskId = pgServices.createProtectGroup(protectGroup, isAutoCreateRp);
        JSONObject obj = new JSONObject();
        obj.put((Object)"taskId", (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$5"})
    public String getProtectObjcetInProtectGroupByPage(String orderBy, String orderType, int pageSize, int startPage, String protectgroupId, int poType) {
        this.validateProtectGroupId(protectgroupId);
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        String orderByField = "name";
        boolean orderByAscend = false;
        if (orderBy != null) {
            orderByField = orderBy;
        }
        if (orderType == null || orderType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            Page page = pgServices.pagedQueryProtectObjectByPg(startPage, pageSize, orderByField, orderByAscend, protectgroupId, Integer.valueOf(poType));
            long total = page.getTotalCount();
            List protectObjects = page.getResult();
            jsonObject.put((Object)"totalCount", (Object)total);
            jsonObject.put((Object)"records", this.protectObjectListToJsonStr(protectObjects));
        }
        catch (LegoCheckedException e) {
            log.error((Object)("Querying protect object by pg failed. PgId:" + protectgroupId), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return jsonObject.toString();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_addProtectedObject_operateName", rank=3, object="$pg?.name", parameters={"#join($2?.![name], ', ')", "$pg?.name"}, ward=true)
    public Response addProtectObjects(String protectgroupId, Set<ProtectObject> protectObjectSet) {
        if (VerifyUtil.isEmpty(protectObjectSet) || VerifyUtil.isEmpty((String)protectgroupId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        CommUtils.checkObjectExists((Object[])new Object[]{pg});
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.checkProviderSn(protectObjectSet, pg);
        try {
            this.addProtectObject(protectObjectSet);
            pgServices.addProtectObjects(protectgroupId, protectObjectSet);
            StringBuilder buffer = new StringBuilder();
            if (!VerifyUtil.isEmpty(protectObjectSet)) {
                for (ProtectObject protectObjectItem : protectObjectSet) {
                    if (null == protectObjectItem) continue;
                    buffer.append(protectObjectItem.getName()).append(',');
                }
            }
            log.info((Object)("Add protect objects:" + buffer));
            for (ProtectObject po : protectObjectSet) {
                this.writeSucOperationLog("protectedGroup_addProtectedObject_operateName", SysoplogLevel.NORMAL.getValue(), pg.getName(), "protectedGroup_addProtectedObject_operateDetail", new String[]{po.getName(), pg.getName()});
            }
        }
        catch (Exception le) {
            this.writeFailedOperationLogForPo("protectedGroup_addProtectedObject_operateName", SysoplogLevel.NORMAL.getValue(), le, protectObjectSet);
        }
        return Response.ok().build();
    }

    private void checkProviderSn(Collection<ProtectObject> protectObjectSet, ProtectGroup pg) {
        if (pg.getPoType() == 12) {
            for (ProtectObject po : protectObjectSet) {
                this.getMoProviderSn(po);
            }
            return;
        }
        String pgProviderSN = pg.getPoProviderSN();
        DrResource pgResource = ((IResourceService)this.getBundleService(IResourceService.class)).getDrResourceBySn(pgProviderSN);
        if (pgResource == null) {
            log.warn((Object)("Cannot find DR resource with protect group provider sn -> " + pgProviderSN), 1073947394L);
            throw new LegoCheckedException(1073947394L);
        }
        for (ProtectObject po : protectObjectSet) {
            String poProvideSn = this.getMoProviderSn(po);
            if (poProvideSn != null) continue;
            log.warn((Object)("Cannot find NE with MO UUID -> " + pgProviderSN), 1073947394L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    public String getMoProviderSn(ProtectObject po) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("uuid", po.getMoUuid());
        List moLists = ((IResourceService)this.getBundleService(IResourceService.class)).queryMoList(ManagedObject.class, query);
        if (!VerifyUtil.isEmpty((Collection)moLists)) {
            ManagedObject mo = (ManagedObject)moLists.get(0);
            po.setName(mo.getName());
            while (mo.getParentMo() != null) {
                mo = mo.getParentMo();
            }
            if (mo instanceof NetworkEntity) {
                return ((NetworkEntity)mo).getSn();
            }
        }
        log.error((Object)"Can not get the sn!");
        return "";
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_removeProtectedObject_operateName", rank=2, object="$pg?.name", parameters={"#join($2?.![name], ',')", "$pg?.name"}, ward=true)
    public Response removeProtectObjects(String protectgroupId, Set<ProtectObject> pos) {
        CommUtils.checkParamEmpty((Object[])new Object[]{protectgroupId, pos});
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        try {
            this.checkProviderSn(pos, pg);
        }
        catch (LegoCheckedException ex) {
            log.warn((Object)"Check provider sn with warning.", ex.getErrorCode());
        }
        try {
            CommUtils.checkObjectExists((Object[])new Object[]{pg});
            HashSet<ProtectObject> poSet = new HashSet<ProtectObject>();
            for (ProtectObject po : pos) {
                ProtectObject pobject = pgServices.getProtectObjectByMoUUID(protectgroupId, po.getMoUuid());
                this.checkCanBeRemoved(pobject);
                poSet.add(pobject);
                po.setName(pobject.getName());
            }
            pgServices.removeProtectObjects(protectgroupId, poSet);
            for (ProtectObject po : pos) {
                this.writeSucOperationLog("protectedGroup_removeProtectedObject_operateName", SysoplogLevel.WARNING.getValue(), pg.getName(), "protectedGroup_removeProtectedObject_operateDetail", new String[]{po.getName(), pg.getName()});
            }
        }
        catch (Exception e) {
            this.writeFailedOperationLogForPo("protectedGroup_removeProtectedObject_operateName", SysoplogLevel.WARNING.getValue(), e, pos);
        }
        return Response.ok().build();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_modifyAuthentication_operateName", rank=2, detail="protectedGroup_modifyAuthentication_operateDetail", object="$pg?.name", parameters={"#join($2?.![name], ',')", "$pg?.name"}, ward=true)
    public Response updateProtectObjectProps(String protectgroupId, List<ProtectObject> protectObjects) {
        CommUtils.checkParamEmpty((Object[])new Object[]{protectgroupId, protectObjects});
        IProtectGroupService pgServices = null;
        ProtectGroup pg = null;
        try {
            pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
            pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        }
        catch (Exception e) {
            this.writeMultiPoUpdateFailedOperationLog(protectObjects, e);
        }
        Context.Variable.set((String)"pg", pg);
        this.checkProviderSn(protectObjects, pg);
        ArrayList<ProtectObject> failedProtectObjects = new ArrayList<ProtectObject>();
        Throwable failedException = new LegoCheckedException(-1L);
        for (ProtectObject po : protectObjects) {
            try {
                pgServices.updateProtectObjectProps(protectgroupId, po.getUuid(), po.getProps());
                this.writeSucOperationLog("protectedGroup_modifyAuthentication_operateName", SysoplogLevel.WARNING.getValue(), pg.getName(), "protectedGroup_modifyAuthentication_operateDetail", new String[]{pg.getName(), po.getName()});
            }
            catch (Exception e) {
                log.error((Object)("updateProtectObjectProps error!protectgroupId:" + protectgroupId));
                failedProtectObjects.add(po);
                failedException = e;
            }
        }
        this.writeMultiPoUpdateFailedOperationLog(failedProtectObjects, (Exception)failedException);
        return Response.ok().build();
    }

    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.enable"}, uuid={"$1"})
    @Logging(name="protectedGroup_activeProtectedGroup_operateName", rank=3, object="$pg?.name")
    public Response enableProtectGroup(String protectgroupId) {
        this.validateProtectGroupId(protectgroupId);
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        pgServices.enableProtectGroup(protectgroupId);
        return Response.ok().build();
    }

    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.disable"}, uuid={"$1"})
    @Logging(name="protectedGroup_disableProtectedGroup_operateName", rank=3, object="$pg?.name")
    public Response disableProtectGroup(String protectgroupId) {
        this.validateProtectGroupId(protectgroupId);
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        pgServices.disableProtectGroup(protectgroupId);
        return Response.ok().build();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.disable"}, uuid={"$1"})
    @Logging(name="protectedGroup_stopProtectedGroup_operateName", rank=2, object="$pg?.name", detail="protectedGroup_stopProtectedGroup_operateDetail", parameters={"$pg?.name"})
    public Response stopProtectGroup(String protectgroupId, boolean isStopAirGap) {
        this.validateProtectGroupId(protectgroupId);
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        pgServices.stopProtectGroup(protectgroupId, isStopAirGap);
        return Response.ok().build();
    }

    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.refresh"}, uuid={"$1"})
    @Logging(name="protectedGroup_refreshProtectedGroup_operateName", object="$pg?.name")
    public Response refreshProtectGroup(String protectgroupId) {
        this.validateProtectGroupId(protectgroupId);
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        long taskId = pgServices.refreshProtectGroup(protectgroupId);
        JSONObject obj = new JSONObject();
        obj.put((Object)"taskId", (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.delete"}, uuid={"$1"})
    @Logging(name="protectedGroup_delete_operateName", rank=2, object="$pg?.name")
    public Response delProtectGroup(String protectgroupId) {
        this.validateProtectGroupId(protectgroupId);
        IProtectGroupService pgServices = this.getProtectGroupService();
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(protectgroupId, false);
        if (pg == null) {
            log.error((Object)("protectgroup [id:" + protectgroupId + "] is not existed!"));
            throw new LegoCheckedException(1073947394L);
        }
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        Context.Variable.set((String)"pg", (Object)pg);
        long taskId = pgServices.deleteProtectGroup(protectgroupId, Boolean.valueOf(this.isMachineToMachineReq()));
        JSONObject obj = new JSONObject();
        obj.put((Object)"taskId", (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    protected IProtectGroupService getProtectGroupService() {
        return (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getSupportProtectObjectTypes() {
        IProtectObjectProviderDelegate iProtectObjectProvider = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        log.error((Object)"interface method [getSupportProtectObjectTypes] is invoked!");
        return this.protectObjectListToJsonStr(iProtectObjectProvider.getSupportProtectObjectTypes()).toString();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String getGroupBriefInfo(String pgId) {
        Long replicaCount;
        IProtectGroupBaseService pgServices = this.getService();
        Map protectGroupDataMap = pgServices.getProtectGroupBriefInfo(pgId);
        Object propObj = protectGroupDataMap.get("props");
        JSONArray rpoJsonArray = null;
        JSONArray rtoJsonArray = null;
        ProtectGroup pg = pgServices.getProtectGroupBasicInfo(pgId, false);
        if (propObj != null) {
            Map props = (Map)propObj;
            rpoJsonArray = this.extractRPOorRTO(props, "RPO_ITEM_KEY", pg);
            rtoJsonArray = this.extractRPOorRTO(props, "RTO_ITEM_KEY", pg);
        }
        if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pg.getTemplate().getType()) && null != (replicaCount = (Long)protectGroupDataMap.get("replicaCount"))) {
            protectGroupDataMap.put("replicaCount", replicaCount - 1L);
        }
        ProtectGroup protectGroup = pgServices.getProtectGroupByID(pgId, false);
        Set schedules = protectGroup.getTemplate().getSchedules();
        Long replicaCount2 = (Long)protectGroupDataMap.get("replicaCount");
        IReplicaService replicaService = (IReplicaService)this.getBundleService(IReplicaService.class);
        for (Schedule schedule : schedules) {
            if (schedule.getScheduleMode() != 0 || schedule.getPeriodType() != 5 || schedule.getProtectedType() != ScheduleProtectedType.HYPERCDP.getValue() || pg.getPoCount() == 0) continue;
            replicaCount2 = replicaCount2 + (long)replicaService.querySecondProtectGroupReplicaCount(pgId, schedule, null, null).intValue();
        }
        ScheduleFormater.format(new ArrayList(schedules));
        protectGroupDataMap.put("template", protectGroup.getTemplate());
        protectGroupDataMap.put("replicaCount", replicaCount2);
        protectGroupDataMap.put("RPO_ITEM_KEY", rpoJsonArray);
        protectGroupDataMap.put("RTO_ITEM_KEY", rtoJsonArray);
        Iterator it = protectGroupDataMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (protectGroupDataMap.get(key) != null) continue;
            it.remove();
        }
        return JSONObject.fromObject((Object)protectGroupDataMap).toString();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String getPGStatisticInfo(String pgId, DrmEnumDefine.ReportTimeRangeE range) {
        int failCount;
        int successCount;
        ProtectGroupStatisticInfo result;
        IProtectGroupService pgService = (IProtectGroupService)this.getBundleService("DRM_Base", IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            log.error((Object)"protectgroup is null");
            throw new LegoCheckedException(1073947394L);
        }
        IProtectGroupReportService reportService = (IProtectGroupReportService)this.getBundleService("DRM_Report", IProtectGroupReportService.class.getName(), IProtectGroupReportService.class);
        if (VerifyUtil.isEmpty((Object)range)) {
            range = DrmEnumDefine.ReportTimeRangeE.LAST_24_HOURS;
        }
        if (null == (result = reportService.getProtectGroupExecutedInfo(pgId, range, this.getCurrentUserId()))) {
            successCount = 0;
            failCount = 0;
        } else {
            successCount = result.getSuccessNum();
            failCount = result.getTotalNum() - result.getSuccessNum();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"successCount", (Object)successCount);
        jsonObject.put((Object)"failCount", (Object)failCount);
        return jsonObject.toString();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$2"})
    public String getAddAvailableProtectObject(int poType, String pgId) {
        this.validateProtectGroupId(pgId);
        if (!this.checkDrmProtectObjectTypeParam(String.valueOf(poType))) {
            log.error((Object)("poType is not number. poType:" + poType));
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate poService = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        IProtectGroupService pgService = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        Map extParamInQueryParam = this.getExtParamInQueryParam();
        ProtectGroup group = pgService.getProtectGroupByID(pgId, false);
        CommUtils.checkObjectExists((Object[])new Object[]{group});
        Set polist = group.getPolist();
        if (polist == null) {
            throw new LegoCheckedException(1073947393L);
        }
        String poProviderSN = null;
        String providerSN = null;
        for (ProtectObject po : polist) {
            if (po.getPoType() == poType) {
                poProviderSN = po.getProviderSN();
                break;
            }
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                log.error((Object)("UsedStorageResourceSet is empty!. poName:" + po.getName()));
                throw new LegoCheckedException(1073947393L);
            }
            Iterator iterator = po.getUsedStorageResourceSet().iterator();
            if (!iterator.hasNext()) continue;
            providerSN = ((ProtectObjectStorageInfo)iterator.next()).getResourceProviderSN();
        }
        if (poProviderSN == null) {
            poProviderSN = providerSN;
        }
        if (poProviderSN == null) {
            log.error((Object)"poProviderSN is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        List poList = poService.getAddAvailableProtectObject(poType, poProviderSN, pgId, extParamInQueryParam);
        return this.protectObjectListToJsonStr(poList).toString();
    }

    @Permission(name={"ism.drm.protectgroup.auth.export"})
    @Logging(name="protectedGroup_exportProtectedGuop_operateName", object="=allProtectedGroup_objectName")
    public Response exportProtectGroup(int poType) {
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
        Locale locale = RequestUtil.getLocale((HttpServletRequest)super.getRequest());
        pgServices.exportProtectGroupByType(super.getCurrentUser(), poType, locale, this.isExportChecked().booleanValue());
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        return Response.ok().build();
    }

    @Context(name="name")
    @Permission(name={"ism.drm.protectgroup.auth.export"})
    @Logging(name="protectedGroup_downLoadProtectedGuop_operateName", object="$name")
    public Response downloadfile(Long taskId) {
        String fileName = null;
        try {
            CommUtils.checkParamEmpty((Object[])new Object[]{taskId});
            IBackTaskService service = (IBackTaskService)this.getBundleService("task", "backTask");
            BackTask backTask = service.readTask(taskId.longValue());
            if (null == backTask) {
                log.error((Object)"no backTask exist:%s", new Object[]{String.valueOf(taskId)});
                throw new LegoCheckedException(1073947394L);
            }
            List nameList = URLEncodedUtils.parse((CharSequence)backTask.getTaskLink(), (Charset)Charsets.UTF_8);
            for (NameValuePair pair : nameList) {
                if (!"file".equalsIgnoreCase(pair.getName())) continue;
                fileName = pair.getValue();
            }
            CommUtils.checkParamEmpty((Object[])new Object[]{fileName});
            Context.Variable.set((String)"name", fileName);
            ProtectGroupExcelUtil util = new ProtectGroupExcelUtil();
            String exportFolderPath = new File(this.getSession().getServletContext().getRealPath("")).getParentFile().getParentFile().getCanonicalPath();
            File file = new File(exportFolderPath + "/LegoRuntime/data/export/" + fileName);
            if (!file.exists() || !file.isFile()) {
                log.error((Object)"no file exist:%s", new Object[]{fileName});
                throw new LegoCheckedException(1073947394L);
            }
            String displayName = file.getName();
            int index = displayName.indexOf("-");
            if (index == 0 && displayName.startsWith("-")) {
                index = displayName.indexOf("-", 1);
            }
            if (index < 0) {
                log.error((Object)"no file exist:%s", new Object[]{fileName});
                throw new LegoCheckedException(1073947394L);
            }
            String userIdStr = displayName.substring(0, index);
            if (!NumberUtil.convertToLong((Object)userIdStr).equals(this.getCurrentUserId())) {
                log.error((Object)"file not belongs current user:%s", new Object[]{fileName});
                throw new LegoCheckedException(1073947400L);
            }
            if (!this.isExportChecked().booleanValue()) {
                return Response.ok().build();
            }
            util.downloadFile(this.getResponse(), file, "ExportProtectGroup" + displayName.substring(index));
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception le) {
            log.error((Object)"Download file error, error msg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)le)});
            throw new LegoCheckedException(0x200909L, (Throwable)le);
        }
        return Response.ok((Object)new BatchOperationResult()).build();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.export"}, uuid={"$1"})
    @Logging(name="protectedGroup_exportProtectedGroupLog_operateName", object="$pg?.name")
    public Response exportProtectGroupLog(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        BatchOperationResult result = new BatchOperationResult();
        ProtectGroup protectGroup = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        CommUtils.checkObjectExists((Object[])new Object[]{protectGroup});
        Context.Variable.set((String)"pg", (Object)protectGroup);
        if (this.validateIsHypermetro(protectGroup) || this.validateIsReplication(protectGroup)) {
            throw new LegoCheckedException(1073947453L);
        }
        int pageSize = 20001;
        Page pageQueryProtectGroupLogs = this.getService().pageQueryHistoryLogFromAll(0, pageSize, "startTime", false, protectGroupId);
        List protectGroupLogs = pageQueryProtectGroupLogs.getResult();
        CommUtils.checkObjectExists((Object[])new Object[]{protectGroupLogs});
        if (protectGroupLogs.size() > 20000) {
            throw new LegoCheckedException(1574L);
        }
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        this.exportLogHelper(protectGroupLogs, result, protectGroup);
        return Response.ok((Object)result).build();
    }

    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    @Logging(name="protectedGroup_exportProtectedGroupLogDetail_operateName", object="$pg?.name")
    public Response exportProtectGroupLogDetails(String protectGroupId, int logId) {
        this.validateProtectGroupId(protectGroupId);
        this.validateLogId(logId);
        BatchOperationResult result = new BatchOperationResult();
        List pgLogDetails = this.getService().queryHistoryLogDetailFromAll(logId, protectGroupId);
        CommUtils.checkObjectExists((Object[])new Object[]{pgLogDetails});
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        ProtectGroup pg = this.getService().getProtectGroupByID(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        this.exportDetailsHelper(pgLogDetails, result, pg.getName());
        return Response.ok((Object)result).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportDetailsHelper(List<ProtectGroupLogDetail> pgList, BatchOperationResult result, String pgName) {
        File excelFile;
        block10: {
            ProtectGroupExcelDetailsOperator details = new ProtectGroupExcelDetailsOperator((BaseAbstractProtectGroupRestService)this);
            FileOutputStream fileOutputStream = null;
            excelFile = null;
            try {
                SXSSFWorkbook wb = details.createExportExcel(pgList, result);
                excelFile = new File(FileExcelUtil.getExportCSVFilePath((HttpSession)this.getSession(), (String)pgName, pgList));
                fileOutputStream = new FileOutputStream(excelFile);
                wb.write((OutputStream)fileOutputStream);
                DownloadFileUtil.downloadFile((HttpServletResponse)this.getResponse(), (HttpServletRequest)this.getRequest(), (File)excelFile);
                if (fileOutputStream == null) break block10;
            }
            catch (LegoCheckedException e) {
                try {
                    log.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
                    throw e;
                    catch (Exception ex) {
                        log.error((Object)("Export protectGroup log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
                        throw new LegoCheckedException(1073948423L, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)e2, 90160758784000L);
                        }
                    }
                    FileUtil.deleteFile(excelFile);
                    throw throwable;
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                log.error((Object)e, 90160758784000L);
            }
        }
        FileUtil.deleteFile((File)excelFile);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportLogHelper(List<ProtectGroupLog> protectGroupLogs, BatchOperationResult result, ProtectGroup protectGroup) {
        File excelFile;
        block10: {
            ProtectGroupLogExcelOperator operator = new ProtectGroupLogExcelOperator((BaseAbstractProtectGroupRestService)this);
            FileOutputStream fileOutputStream = null;
            excelFile = null;
            try {
                SXSSFWorkbook wb = operator.createExportExcel(protectGroupLogs, result);
                excelFile = new File(FileExcelUtil.createTempDownloadPath((HttpSession)this.getSession(), (String)protectGroup.getName(), null, (String)"xlsx"));
                fileOutputStream = new FileOutputStream(excelFile);
                wb.write((OutputStream)fileOutputStream);
                DownloadFileUtil.downloadLogFile((HttpServletResponse)this.getResponse(), (HttpServletRequest)this.getRequest(), (File)excelFile);
                if (fileOutputStream == null) break block10;
            }
            catch (LegoCheckedException e) {
                try {
                    log.error((Object)"Creating exported excel failed.", (Throwable)e);
                    throw e;
                    catch (Exception ex) {
                        log.error((Object)"Export protectGroup log failed >>>>>>. msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                        throw new LegoCheckedException(1073948423L, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            log.error((Object)"Failed to close file output stream", (Throwable)e2);
                        }
                    }
                    FileUtil.deleteFile(excelFile);
                    throw throwable;
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close file output stream", (Throwable)e);
            }
        }
        FileUtil.deleteFile((File)excelFile);
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String checkProtectGroupName(String pgname) {
        boolean isNotExisted;
        if (!CommUtil.checkDrmNameParam((String)pgname)) {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject resultObject = new JSONObject();
        try {
            IProtectGroupBaseService pgServices = this.getService();
            isNotExisted = pgServices.checkGroupName(null, pgname);
        }
        catch (Exception e) {
            log.error((Object)("checkGroupName failed. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        resultObject.put((Object)"isExisted", (Object)(!isNotExisted ? 1 : 0));
        return resultObject.toString();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String pageQueryAddAvailableProtectObject(String protectGroupId, int poType, String orderBy, String orderType, String filterName, String filterValue) {
        Map queryParam = this.getExtParamInQueryParam();
        PageParameter pageParame = this.getPageParameter();
        Integer startPage = pageParame.getStartPage();
        Integer pageSize = pageParame.getPageSize();
        if (!this.checkDrmProtectObjectTypeParam(String.valueOf(poType))) {
            log.error((Object)"Fail to get params, poType.");
            throw new LegoCheckedException(1073947393L);
        }
        this.validateProtectGroupId(protectGroupId);
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        ProtectGroup pg = pgServices.getProtectGroupByID(protectGroupId, false);
        String deviceSn = pg.getPoProviderSN();
        queryParam.put("orderBy", orderBy);
        queryParam.put("pageSize", pageSize);
        queryParam.put("pageIndex", startPage);
        queryParam.put("orderType", orderType);
        queryParam.put("userId", this.getCurrentUserId());
        queryParam.put("pg", pg);
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryParam.put("filterName", filterName);
            queryParam.put("filterValue", filterValue);
        }
        IProtectObjectProviderDelegate poProvider = (IProtectObjectProviderDelegate)this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        List poList = poProvider.getAddAvailableProtectObject(poType, deviceSn, protectGroupId, queryParam);
        Map queryAllParam = this.getExtParamInQueryParam();
        queryAllParam.put("pg", pg);
        if (!VerifyUtil.isEmpty((String)filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            queryAllParam.put("filterName", filterName);
            queryAllParam.put("filterValue", filterValue);
        }
        queryAllParam.put("userId", this.getCurrentUserId());
        List poAllList = poProvider.getAddAvailableProtectObject(poType, deviceSn, protectGroupId, queryAllParam);
        int totalCount = Optional.ofNullable(poAllList).map(List::size).orElse(0);
        String records = this.protectObjectListToJsonStr(poList).toString();
        JSONObject result = new JSONObject();
        result.put((Object)"totalCount", (Object)totalCount);
        result.put((Object)"records", (Object)records);
        return result.toString();
    }

    private void writeMultiPoUpdateFailedOperationLog(List<ProtectObject> protectObjects, Exception e) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            return;
        }
        for (ProtectObject po : protectObjects) {
            this.writeFailedOperationLogNoException("protectedGroup_modifyAuthentication_operateName", SysoplogLevel.WARNING.getValue(), po.getName(), e);
        }
        if (e instanceof LegoCheckedException) {
            log.error((Object)"update po props failed.", (Throwable)e, 90160758784001L);
            throw (LegoCheckedException)((Object)e);
        }
        log.error((Object)("operation failed. msg:" + ExceptionUtil.getErrorMessage((Throwable)e)));
        throw new LegoCheckedException(-1L);
    }

    private void filterReplicasByTypeAndDetectionStatus(List<ProtectGroupReplica> replicas, Integer replicaType, ProtectGroupReplicaQueryParam queryParam, ProtectGroup protectGroup) {
        int type;
        if (!VerifyUtil.isEmpty((Object)replicaType)) {
            log.info((Object)String.format("Filter out the protection group replicas of the specified type{%s}", replicaType));
            replicas.removeIf(replica -> replica.getType() != replicaType.intValue());
        }
        if (PolicyTemplateType.isNasAirGapNetworking((int)(type = protectGroup.getTemplate().getType()))) {
            this.filterNasAirGapReplicas(replicas, queryParam, type);
        }
    }

    private void filterNasAirGapReplicas(List<ProtectGroupReplica> replicas, ProtectGroupReplicaQueryParam queryParam, int type) {
        replicas.removeIf(replica -> !replica.isStorageSnapshotReplica());
        if (type == 46 && queryParam.isShouldSearchForDataRecovery()) {
            replicas.removeIf(replica -> AntiBlackMailConstant.NOT_SUPPORT_RECOVER_DETECTION_STATUS_SET.contains(replica.getDetectionStatus()) || AntiBlackMailConstant.NOT_SUPPORT_RECOVER_STATUS_SET.contains(replica.getStatus()));
        }
        int detectionStatus = queryParam.getDetectionStatus();
        if (type == 46 && detectionStatus != -2) {
            log.debug((Object)"The pgReplicaLists: %s, detectionStatus: %s.", new Object[]{replicas, detectionStatus});
            replicas.removeIf(pgr -> pgr.getDetectionStatus() != detectionStatus);
        }
        Boolean isSearchSecureReplica = queryParam.getNeedSearchSecure();
        if (type != 45 || VerifyUtil.isEmpty((Object)isSearchSecureReplica)) {
            return;
        }
        Iterator<ProtectGroupReplica> replicaIterator = replicas.iterator();
        while (replicaIterator.hasNext()) {
            ProtectGroupReplica replica2 = replicaIterator.next();
            boolean isSecureReplica = Optional.ofNullable(replica2.getProps()).map(map -> (String)map.get("isNeedSecureSnapshot")).map(Boolean::parseBoolean).orElse(false);
            if (isSearchSecureReplica == isSecureReplica) continue;
            replicaIterator.remove();
        }
    }

    private String transferToJsonStr(List<ProtectGroupReplica> replicas, int totalCount) {
        replicas = this.sortReplicaByLocation(replicas);
        String jArray = this.protectGroupReplicaListToJsonStr(replicas).toString();
        JSONArray jsonArray = JSONArray.fromObject((Object)jArray);
        JSONObject jObj = new JSONObject();
        jObj.put((Object)"replicas", (Object)jsonArray);
        jObj.put((Object)"totalCount", (Object)totalCount);
        return jObj.toString();
    }
}

