/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.CapacityUnitUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.ism.drm.rest.service.base.LunStatisticKey;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DrmStorageUtil {
    public static String getStorageResourceStatisticByLun(List<? extends StorageResource> storageResources, int templateType) {
        if (16 != templateType) {
            JSONObject response = new JSONObject();
            response.put((Object)"totalCapacity", (Object)0.0);
            response.put((Object)"displayTotalCapacity", (Object)"--");
            response.put((Object)"details", (Object)new JSONArray().toString());
            response.put((Object)"deviceSn", (Object)"");
            return response.toString();
        }
        String deviceSn = "";
        HashMap<LunStatisticKey, Object> statistics = new HashMap<LunStatisticKey, Object>();
        for (StorageResource storageResource : storageResources) {
            Lun lun = (Lun)storageResource;
            deviceSn = lun.getDevSn();
            LunStatisticKey key = new LunStatisticKey();
            key.setTotalCapacity(Double.valueOf(UnitConvert.convert((Double)storageResource.getTotalCapacity(), (IUnitType)CapabilityUnitType.valueOf((String)storageResource.getTotalCapacityUnit()), (IUnitType)CapabilityUnitType.KB)));
            key.setTotalCapacityUnit(CapabilityUnitType.KB.name());
            key.setControllerName(lun.getControllerName());
            Object count = (Integer)statistics.get(key);
            if (null == count) {
                count = 0;
            }
            count = (Integer)count + 1;
            statistics.put(key, count);
        }
        JSONArray jsonArray = new JSONArray();
        double d = 0.0;
        Set entrySet = statistics.entrySet();
        for (Map.Entry entry : entrySet) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"count", entry.getValue());
            double capacity = UnitConvert.convert((double)((LunStatisticKey)entry.getKey()).getTotalCapacity(), (IUnitType)CapabilityUnitType.KB, (IUnitType)CapabilityUnitType.MB, (int)3);
            jsonObj.put((Object)"capacity", (Object)capacity);
            d += ((LunStatisticKey)entry.getKey()).getTotalCapacity().doubleValue();
            jsonObj.put((Object)"displayCapacity", (Object)CapacityUnitUtil.getCapacityAndUnit((Double)capacity, (CapabilityUnitType)CapabilityUnitType.MB));
            jsonObj.put((Object)"controllerId", (Object)((LunStatisticKey)entry.getKey()).getControllerName());
            jsonArray.add((Object)jsonObj);
        }
        JSONObject response = new JSONObject();
        response.put((Object)"totalCapacity", (Object)UnitConvert.convert((double)d, (IUnitType)CapabilityUnitType.KB, (IUnitType)CapabilityUnitType.MB, (int)3));
        response.put((Object)"displayTotalCapacity", (Object)CapacityUnitUtil.getCapacityAndUnit((Double)d, (CapabilityUnitType)CapabilityUnitType.KB));
        response.put((Object)"details", (Object)jsonArray.toString());
        response.put((Object)"deviceSn", (Object)deviceSn);
        return response.toString();
    }
}

