/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.dao;

import com.huawei.lego.cbb.resource.sdk.model.DevTypeRegister;
import com.huawei.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.huawei.lego.cbb.resource.sdk.model.MainDeviceType;
import com.huawei.lego.cbb.resource.sdk.model.MainDeviceTypeState;
import com.huawei.lego.cbb.resource.sdk.model.SubDeviceType;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.tree.DataElement;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import com.huawei.lego.nem.topo.sdk.model.UIElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;

public class DeviceTypeInfoDao
extends HibernateDaoSupportWrapper {
    public static final String MAINDEVICETYPENAME = "T_maindevicetype";
    public static final String SUBDEVICETYPENAME = "T_subdevicetype";
    public static final String OBJNAMEOFDEVICE = "TopoObject";
    public static final String KEY_HIDE_MAINTYPE = "hide_mainTypeDevice";
    public static final String KEY_HIDE_SPECIFIEDTYPE_MAIN = "hide_specifiedType_main";
    public static final String KEY_HIDE_SPECIFIEDTYPE_SUB = "hide_specifiedType_sub";
    private static final Log LOGGER = LogFactory.getInstance(DeviceTypeInfoDao.class);
    private static final int TOPO_TYPE_NODE = 0;
    private static final int TOPO_TYPE_GROUP = 3;

    public DeviceTypeInfoDao(SessionFactory factory) {
        this.setSessionFactory(factory);
    }

    public void addDeviceMainTypeList(List<String> mainTypes) {
        for (String devType : mainTypes) {
            MainDeviceType devTypeNode = new MainDeviceType(devType);
            this.getHibernateTemplate().save((Object)devTypeNode);
        }
        this.logger.debug((Object)"addDeviceMainTypeList:add devices main type");
    }

    public void addDevMainType(String devType) {
        this.logger.debug((Object)("addDevMainType:add device main type.devType:" + devType));
        MainDeviceType devTypeNode = new MainDeviceType(devType);
        this.getHibernateTemplate().saveOrUpdate((Object)devTypeNode);
    }

    public void addDevSubType(String devType) {
        SubDeviceType devTypeNode = new SubDeviceType(devType);
        super.getHibernateTemplate().saveOrUpdate((Object)devTypeNode);
        this.logger.debug((Object)("addDevSubType:add device sub type.devType:" + devType));
    }

    public void addDeviceSubTypeLise(List<String> subTypes) {
        for (String devType : subTypes) {
            SubDeviceType devTypeNode = new SubDeviceType(devType);
            this.getHibernateTemplate().saveOrUpdate((Object)devTypeNode);
        }
        this.logger.debug((Object)"addDeviceSubTypeLise:add devices sub type");
    }

    public void setDeviceType(Long deviceId, String mainType, String subType) {
        this.logger.debug((Object)("setDeviceType:deviceId is" + deviceId));
        try {
            TopoObject device = (TopoObject)this.getHibernateTemplate().get(TopoObject.class, (Serializable)deviceId);
            if (device != null) {
                device.setMainType(mainType);
                device.setSubType(subType);
                this.getHibernateTemplate().saveOrUpdate((Object)device);
            }
        }
        catch (DataAccessException ex) {
            this.logger.error((Object)("save device error!deviceId:" + deviceId));
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    public List<MainDeviceTypeState> getDeviceStateInfo() {
        List results = this.getHibernateTemplate().loadAll(MainDeviceType.class);
        ArrayList<MainDeviceTypeState> states = new ArrayList<MainDeviceTypeState>();
        for (MainDeviceType mainType : results) {
            String hsql = "select count(*) from  ";
            hsql = hsql + "TopoObject d where d.mainType = ";
            hsql = hsql + "'" + mainType.getName() + "'";
            Long count = (Long)this.getHibernateTemplate().find(hsql, new Object[0]).get(0);
            MainDeviceTypeState state = new MainDeviceTypeState();
            state.setMainDeviceTypeName(mainType.getName());
            state.setDeviceCount(count);
            states.add(state);
        }
        return states;
    }

    public List<TopoObject> getDevLisetByMainType(String mainType) {
        String hsql = "from TopoObject d where d.mainType = ?";
        try {
            return this.getHibernateTemplate().find(hsql, new Object[]{mainType});
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("getDevLisetByMainType:throw exception.mainType:" + mainType));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public List<TopoObject> getAllDevice() {
        String hsql = "from TopoObject";
        try {
            return this.getHibernateTemplate().find(hsql, new Object[0]);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"getAllDevice:throw exception");
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    private List<DeviceTypeRelation> getDeviceTypeRelationFromTopoObject() {
        ArrayList<DeviceTypeRelation> deviceTypeRelations = new ArrayList<DeviceTypeRelation>();
        List<TopoObject> topoObjects = this.getAllDevice();
        HashMap<String, Set> types = new HashMap<String, Set>();
        for (TopoObject topoObject : topoObjects) {
            String subType;
            String mainType = topoObject.getMainType();
            Set subtypes = types.computeIfAbsent(mainType, k -> new HashSet());
            if (subtypes.contains(subType = topoObject.getSubType())) continue;
            subtypes.add(subType);
            DeviceTypeRelation deviceTypeRelation = new DeviceTypeRelation();
            deviceTypeRelation.setParentType(topoObject.getMainType());
            deviceTypeRelation.setChildType(topoObject.getSubType());
            deviceTypeRelations.add(deviceTypeRelation);
        }
        this.logger.debug((Object)"getDeviceTypeRelationFromTopoObject:completed");
        return deviceTypeRelations;
    }

    public List<String> getDevSubTypesByMainType(String devMainType) {
        String hsql = "select r.childType from DeviceTypeRelation r where r.parentType = ?";
        try {
            return this.getHibernateTemplate().find(hsql, (Object[])new String[]{devMainType});
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("getDeviceTypeRelationFromTopoObject:throw exception.devMainType:" + devMainType));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public Long registerDeviceType(String mainDevType, String subDevType) {
        try {
            DeviceTypeRelation relation = new DeviceTypeRelation();
            relation.setParentType(mainDevType);
            relation.setChildType(subDevType);
            return (Long)this.getHibernateTemplate().save((Object)relation);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("registerDeviceType:throw exception.mainDevType:" + mainDevType));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public Long getDeviceRelationId(String mainDevType, String subDevType) {
        String hsql = "select r.id from DeviceTypeRelation r where r.parentType = ? and r.childType = ?";
        try {
            List result = this.getHibernateTemplate().find(hsql, (Object[])new String[]{mainDevType, subDevType});
            if (result == null || result.isEmpty()) {
                return null;
            }
            return (Long)result.get(0);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("getDeviceRelationId:throw exception.mainDevType:" + mainDevType));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public void registerDeviceType(String sysOid, Long relationId) {
        try {
            DevTypeRegister register = new DevTypeRegister();
            register.setSysOid(sysOid);
            register.setDevTypeRegId(relationId);
            this.getHibernateTemplate().saveOrUpdate((Object)register);
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("registerDeviceType:throw exception.sysOid:" + sysOid));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public RootDataElement getDeviceTypeTreeWithoutDev(Boolean hiddenTypeWithoutChild) {
        return this.getDeviceTypeTreeBase(null, hiddenTypeWithoutChild, false);
    }

    public RootDataElement getDeviceTypeTree(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.getDeviceTypeTreeBase(userId, hiddenTypeWithoutChild, true);
    }

    public RootDataElement getDeviceTypeTreeWithoutDev(Long userId, Boolean hiddenTypeWithoutChild) {
        this.logger.debug((Object)("getDeviceTypeTreeWithoutDev:userId is " + userId + ",hiddenTypeWithoutChild is " + hiddenTypeWithoutChild));
        return this.getDeviceTypeTreeBase(userId, hiddenTypeWithoutChild, false);
    }

    public RootDataElement getDeviceTypeTreeBaseShield(Long userId, Boolean hiddenTypeWithoutChild, Boolean showDev, Boolean isShield) {
        this.logger.debug((Object)("getDeviceTypeTreeBaseShield:hiddenTypeWithoutChild is " + hiddenTypeWithoutChild));
        RootDataElement rootData = new RootDataElement();
        Long typeId = 0L;
        try {
            ArrayList<String> shieldMainTypeList = new ArrayList<String>();
            ArrayList<String> spcTypeMainTypeList = new ArrayList<String>();
            ArrayList<String> spcTypeSubTypeList = new ArrayList<String>();
            if (isShield.booleanValue()) {
                String shieldMainType = LegoProperties.getProperty((String)KEY_HIDE_MAINTYPE, (String)"");
                String[] shieldMainTypeArray = shieldMainType.split(",");
                shieldMainTypeList.addAll(Arrays.asList(shieldMainTypeArray));
                String spcTypeMainType = LegoProperties.getProperty((String)KEY_HIDE_SPECIFIEDTYPE_MAIN, (String)"");
                spcTypeMainTypeList.addAll(Arrays.asList(spcTypeMainType.split(",")));
                String spcTypeSubType = LegoProperties.getProperty((String)KEY_HIDE_SPECIFIEDTYPE_SUB, (String)"");
                spcTypeSubTypeList.addAll(Arrays.asList(spcTypeSubType.split(",")));
            }
            List<DeviceTypeRelation> devTypeLst = this.getDeviceTypeRelationFromTopoObject();
            HashMap<String, DataElement> mainTypeNode = new HashMap<String, DataElement>();
            for (DeviceTypeRelation relation : devTypeLst) {
                typeId = typeId + 1L;
                String mainType = relation.getParentType();
                if (shieldMainTypeList.contains(mainType)) continue;
                String subType = relation.getChildType();
                if (spcTypeMainTypeList.contains(mainType) && spcTypeSubTypeList.contains(subType)) continue;
                DataElement mainTypeEle = (DataElement)mainTypeNode.get(mainType);
                if (mainTypeEle == null) {
                    mainTypeEle = this.getDataElement(rootData, typeId, mainType);
                    mainTypeNode.put(mainType, mainTypeEle);
                }
                typeId = typeId + 1L;
                DataElement subTypeEle = new DataElement();
                subTypeEle.setDisName(subType);
                subTypeEle.setEleType(NumberUtil.convertToLong((Object)3));
                subTypeEle.setId(typeId);
                subTypeEle.setEntityId(subType);
                mainTypeEle.addChildEle((UIElement)subTypeEle);
                this.addDeviceList(mainType, subType, userId, subTypeEle);
                this.processDeviceShow(hiddenTypeWithoutChild, showDev, mainTypeEle, subTypeEle);
            }
            return this.processRootData(hiddenTypeWithoutChild, mainTypeNode, rootData);
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    private DataElement getDataElement(RootDataElement rootData, Long typeId, String mainType) {
        DataElement mainTypeEle = new DataElement();
        rootData.addChildEle((UIElement)mainTypeEle);
        mainTypeEle.setDisName(mainType);
        mainTypeEle.setEleType(NumberUtil.convertToLong((Object)3));
        mainTypeEle.setId(typeId);
        mainTypeEle.setEntityId(mainType);
        return mainTypeEle;
    }

    private void processDeviceShow(boolean hiddenTypeWithoutChild, boolean showDev, DataElement mainTypeEle, DataElement subTypeEle) {
        this.logger.debug((Object)("processDeviceShow:hiddenTypeWithoutChild is" + hiddenTypeWithoutChild + ",showDev is" + showDev));
        if (hiddenTypeWithoutChild && subTypeEle.getChildUIElement().isEmpty()) {
            mainTypeEle.removeChildEleUI((UIElement)subTypeEle);
        }
        if (!showDev) {
            subTypeEle.removeChildEle();
        }
    }

    private RootDataElement processRootData(boolean hiddenTypeWithoutChild, Map<String, DataElement> mainTypeNode, RootDataElement rootData) {
        this.logger.debug((Object)("processRootData:hiddenTypeWithoutChild is " + hiddenTypeWithoutChild));
        if (hiddenTypeWithoutChild) {
            Set<Map.Entry<String, DataElement>> set = mainTypeNode.entrySet();
            for (Map.Entry<String, DataElement> temp : set) {
                DataElement mainTypeEle = temp.getValue();
                if (!mainTypeEle.getChildUIElement().isEmpty()) continue;
                rootData.removeChildEleUI((UIElement)mainTypeEle);
            }
        }
        return rootData;
    }

    public RootDataElement getDeviceTypeTreeBase(Long userId, Boolean hiddenTypeWithoutChild, Boolean showDev) {
        this.logger.debug((Object)("hiddenTypeWithoutChild is " + hiddenTypeWithoutChild));
        RootDataElement rootData = new RootDataElement();
        Long typeId = 0L;
        try {
            List<DeviceTypeRelation> devTypeLst = this.getDeviceTypeRelationFromTopoObject();
            HashMap<String, DataElement> mainTypeNode = new HashMap<String, DataElement>();
            for (DeviceTypeRelation relation : devTypeLst) {
                typeId = typeId + 1L;
                String mainType = relation.getParentType();
                DataElement mainTypeEle = (DataElement)mainTypeNode.get(mainType);
                if (mainTypeEle == null) {
                    mainTypeEle = new DataElement();
                    rootData.addChildEle((UIElement)mainTypeEle);
                    mainTypeEle.setDisName(mainType);
                    mainTypeEle.setEleType(NumberUtil.convertToLong((Object)3));
                    mainTypeEle.setEntityId(mainType);
                    mainTypeEle.setId(typeId);
                    mainTypeNode.put(mainType, mainTypeEle);
                }
                typeId = typeId + 1L;
                DataElement subTypeEle = new DataElement();
                String subType = relation.getChildType();
                subTypeEle.setDisName(subType);
                subTypeEle.setEleType(NumberUtil.convertToLong((Object)3));
                subTypeEle.setEntityId(subType);
                subTypeEle.setId(typeId);
                mainTypeEle.addChildEle((UIElement)subTypeEle);
                this.addDeviceList(mainType, subType, userId, subTypeEle);
                this.removeChildEleUI(hiddenTypeWithoutChild, subTypeEle, mainTypeEle);
                if (showDev.booleanValue()) continue;
                subTypeEle.removeChildEle();
            }
            if (hiddenTypeWithoutChild.booleanValue()) {
                this.hideTypeWithoutChild(mainTypeNode, rootData);
            }
            return rootData;
        }
        catch (DataAccessException e) {
            this.logger.error((Object)("getDeviceTypeTreeBase error!showDev:" + showDev));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    private void removeChildEleUI(Boolean hiddenTypeWithoutChild, DataElement subTypeEle, DataElement mainTypeEle) {
        this.logger.debug((Object)("removeChildEleUI:hiddenTypeWithoutChild is " + hiddenTypeWithoutChild));
        if (hiddenTypeWithoutChild.booleanValue() && subTypeEle.getChildUIElement().isEmpty()) {
            mainTypeEle.removeChildEleUI((UIElement)subTypeEle);
        }
    }

    private void hideTypeWithoutChild(Map<String, DataElement> mainTypeNode, RootDataElement rootData) {
        Set<Map.Entry<String, DataElement>> set = mainTypeNode.entrySet();
        for (Map.Entry<String, DataElement> temp : set) {
            DataElement mainTypeEle = temp.getValue();
            if (!mainTypeEle.getChildUIElement().isEmpty()) continue;
            rootData.removeChildEleUI((UIElement)mainTypeEle);
        }
    }

    protected void addDeviceList(String mainType, String subType, Long userId, DataElement parentEle) {
        this.logger.debug((Object)("addDeviceList:mainType is " + mainType + ", subType:" + subType));
        StringBuilder hSqlCount = new StringBuilder();
        hSqlCount.append("select t.moId, t.name from TopoObject t where t.mainType = ?");
        hSqlCount.append(" and t.subType = ? and t.isTopMo = true ");
        if (userId != null) {
            hSqlCount.append(" and t.moId in (select u.id.moId from UserRelMoInfo u where u.id.userIdx = ?)");
        }
        Object[] params = new Object[]{mainType, subType};
        if (null != userId) {
            params = new Object[]{mainType, subType, userId};
        }
        for (Object[] item : this.getHibernateTemplate().find(hSqlCount.toString(), params)) {
            Long moId = (Long)item[0];
            String disName = (String)item[1];
            DataElement ele = new DataElement();
            ele.setDisName(disName);
            ele.setEleType(NumberUtil.convertToLong((Object)0));
            ele.setId(moId);
            ele.setEntityId(String.valueOf(moId));
            parentEle.addChildEle((UIElement)ele);
        }
    }

    public Map<String, Set<String>> getDeviceTypeList() {
        try {
            List devTypeLst = this.getHibernateTemplate().loadAll(DeviceTypeRelation.class);
            HashMap<String, Set<String>> datas = new HashMap<String, Set<String>>();
            for (DeviceTypeRelation relation : devTypeLst) {
                String mainType = relation.getParentType();
                String subType = relation.getChildType();
                Set val = datas.computeIfAbsent(mainType, k -> new HashSet());
                val.add(subType);
            }
            return datas;
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"getDeviceTypeList:throw DataAccessException");
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public Map<String, Long> getDeviceTypeState(String mainDevType, Long userId) {
        this.logger.debug((Object)("getDeviceTypeState:mainDevType is " + mainDevType));
        List devTypeLst = this.getHibernateTemplate().loadAll(DeviceTypeRelation.class);
        HashMap<String, Long> stateData = new HashMap<String, Long>();
        for (DeviceTypeRelation relation : devTypeLst) {
            String subType = relation.getChildType();
            this.getDeviceTypeState(mainDevType, subType, userId, stateData);
        }
        return stateData;
    }

    protected void getDeviceTypeState(String mainType, String subType, Long userId, Map<String, Long> stateData) {
        this.logger.debug((Object)("protected void getDeviceTypeState:mainType is " + mainType + ",subType:" + subType));
        StringBuffer hSqlCount = new StringBuffer();
        hSqlCount.append("select count(*) from TopoObject t where t.mainType = ? and t.subType = ? ");
        if (userId != null) {
            hSqlCount.append("and t.moId in (select u.id.moId from UserRelMoInfo u where u.id.userIdx = ?)");
        }
        Object[] params = new Object[]{mainType, subType};
        if (userId != null) {
            params = new Object[]{mainType, subType, userId};
        }
        Long count = (Long)this.getHibernateTemplate().find(hSqlCount.toString(), params).listIterator().next();
        stateData.put(subType, count);
    }

    public Map<String, Map<String, Long>> getDeviceTypeState(Long userId) {
        try {
            List devTypeLst = this.getHibernateTemplate().loadAll(DeviceTypeRelation.class);
            HashMap<String, Map<String, Long>> datas = new HashMap<String, Map<String, Long>>();
            for (DeviceTypeRelation relation : devTypeLst) {
                String mainType = relation.getParentType();
                String subType = relation.getChildType();
                Map stateData = datas.computeIfAbsent(mainType, k -> new HashMap());
                this.getDeviceTypeState(mainType, subType, userId, stateData);
            }
            return datas;
        }
        catch (DataAccessException e) {
            this.logger.error((Object)"getDeviceTypeState(Long) throw DataAccessException");
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }
}

