/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.dao.impl;

import com.huawei.lego.cbb.task.dao.ITaskDAO;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class TaskDAOImpl
extends HibernateDaoSupportWrapper
implements ITaskDAO {
    private static final String KEY_HQL = "hql";
    private static final String KEY_PARAMS = "params";
    private static final String KEY_PARAMTYPES = "paramtypes";
    private static final Log LOG = LogFactory.getInstance(TaskDAOImpl.class);

    @Override
    public long addTask(Task task) {
        try {
            return (Long)super.getHibernateTemplate().save((Object)task);
        }
        catch (DataAccessException e) {
            LOG.error((Object)"Add Task Error", (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void updateTask(Task task) {
        block5: {
            try {
                Task tempTask = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)task.getTaskId());
                if (tempTask != null) {
                    try {
                        super.getHibernateTemplate().update((Object)task);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Update task error %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                        super.getHibernateTemplate().merge((Object)task);
                    }
                    break block5;
                }
                throw new LegoCheckedException(201L);
            }
            catch (DataAccessException e) {
                LOG.error((Object)e, 1L);
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
        }
    }

    @Override
    public void deleteTask(Task task) {
        try {
            Task tempTask = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)task.getTaskId());
            if (tempTask == null) {
                throw new LegoCheckedException(201L);
            }
            super.getHibernateTemplate().delete((Object)task);
        }
        catch (DataAccessException ex) {
            LOG.error((Object)ex, 1L);
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public Task readTask(long taskId) {
        Task task;
        try {
            task = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)Long.valueOf(taskId));
            if (task == null) {
                throw new LegoCheckedException(201L);
            }
        }
        catch (DataAccessException e) {
            LOG.error((Object)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return task;
    }

    @Override
    public List<Task> queryTask(Map<String, Object> condition) {
        Map<String, Object[]> map = this.getHqlByCondition(condition);
        String hql = (String)map.get(KEY_HQL)[0];
        Object[] params = map.get(KEY_PARAMS);
        if (params == null) {
            return super.getHibernateTemplate().find(hql, new Object[0]);
        }
        return super.getHibernateTemplate().find(hql, params);
    }

    @Override
    public Paging findPage(Map<String, Object> condition, int firstRowIndex, int totalRow) {
        Map<String, Object[]> map = this.getHqlByCondition(condition);
        String hql = (String)map.get(KEY_HQL)[0];
        Object[] params = map.get(KEY_PARAMS);
        Object[] paramTypes = map.get(KEY_PARAMTYPES);
        HibernateTemplate tmpTemplate = this.getHibernateTemplate();
        HibernateCallback tmpCallbask = this.getCallback(hql, paramTypes, params, firstRowIndex, totalRow);
        List task = (List)tmpTemplate.execute(tmpCallbask);
        Paging rePaging = new Paging();
        rePaging.setData(task);
        long iCount = 0L;
        iCount = null == params ? this.getCount(hql) : this.getCount(hql, params);
        rePaging.setiCount((int)iCount);
        return rePaging;
    }

    private HibernateCallback getCallback(final String hql, final Object[] paramTypes, final Object[] params, final int firstRowIndex, final int totalRow) {
        return new HibernateCallback<List<Task>>(){

            public List<Task> doInHibernate(Session session) {
                Query q = session.createQuery(hql);
                if (null != paramTypes) {
                    this.addQueryParams(paramTypes, params, q);
                }
                q.setFirstResult(firstRowIndex);
                q.setMaxResults(totalRow);
                return q.list();
            }

            private void addQueryParams(Object[] paramTypes2, Object[] params2, Query q) {
                for (int i = 0; i < paramTypes2.length; ++i) {
                    if ("String".equals(paramTypes2[i])) {
                        q.setString(i, (String)params2[i]);
                        continue;
                    }
                    if (!"Integer".equals(paramTypes2[i])) continue;
                    q.setInteger(i, ((Integer)params2[i]).intValue());
                }
            }
        };
    }

    private long getCount(String hql, Object[] params) {
        StringBuffer stringBuffer = new StringBuffer("select count(*) ");
        stringBuffer.append(hql);
        return this.getTotalCount(stringBuffer.toString(), params);
    }

    private long getTotalCount(String hql, Object[] params) {
        return (Long)super.getHibernateTemplate().find(hql, params).listIterator().next();
    }

    private Map<String, Object[]> getHqlByCondition(Map<String, Object> condition) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        ArrayList<Object> paramsList = new ArrayList<Object>();
        ArrayList<Object> paramTypeList = new ArrayList<Object>();
        StringBuilder hql = new StringBuilder("from Task t where t.taskId > 0 ");
        if (condition == null) {
            String[] arrStr = new String[]{hql.toString()};
            map.put(KEY_HQL, arrStr);
        }
        this.setOrderKeyAndVaules(condition, paramsList, paramTypeList, hql);
        String[] resultArr = new String[]{hql.toString()};
        map.put(KEY_HQL, resultArr);
        map.put(KEY_PARAMS, paramsList.toArray());
        map.put(KEY_PARAMTYPES, paramTypeList.toArray());
        return map;
    }

    private void setOrderKeyAndVaules(Map<String, Object> condition, List<Object> paramsList, List<Object> paramTypeList, StringBuilder hql) {
        if (condition == null) {
            return;
        }
        String orderKey = "";
        String oerder = "";
        for (Map.Entry<String, Object> entry : condition.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.deal1(key, hql, paramsList, paramTypeList, value);
            this.deal2(key, hql, paramsList, paramTypeList, value);
            if (!"DESC".equalsIgnoreCase(key) && !"ASC".equalsIgnoreCase(key)) continue;
            oerder = key;
            if (!CommonUtil.isValidDbColumn((String)String.valueOf(value))) {
                throw new LegoCheckedException(1073947393L);
            }
            orderKey = "order by " + value + " ";
        }
        hql.append(orderKey);
        hql.append(oerder);
    }

    private void deal1(String key, StringBuilder hql, List<Object> paramsList, List<Object> paramTypeList, Object value) {
        if ("taskName".equalsIgnoreCase(key)) {
            hql.append(" and t.taskName like ?");
            paramsList.add("%" + value.toString().trim() + "%");
            paramTypeList.add("String");
        }
        if ("bundleName".equalsIgnoreCase(key)) {
            hql.append(" and t.bundleName like ?");
            paramsList.add(value.toString().trim());
            paramTypeList.add("String");
        }
        if ("taskType".equalsIgnoreCase(key)) {
            hql.append(" and t.taskType.taskType = ?");
            paramsList.add(value);
            paramTypeList.add("String");
        }
        if ("type".equalsIgnoreCase(key)) {
            hql.append(" and t.taskType.type = ?");
            paramsList.add(value);
            paramTypeList.add("String");
        }
    }

    private void deal2(String key, StringBuilder hql, List<Object> paramsList, List<Object> paramTypeList, Object value) {
        if ("taskLevel".equalsIgnoreCase(key)) {
            hql.append(" and t.taskLevel = ?");
            paramsList.add(NumberUtil.convertToInteger((Object)value.toString()));
            paramTypeList.add("Integer");
        }
        if ("taskStatus".equalsIgnoreCase(key)) {
            hql.append(" and t.taskStatus = ?");
            paramsList.add(NumberUtil.convertToInteger((Object)value.toString()));
            paramTypeList.add("Integer");
        }
        if ("executeType".equalsIgnoreCase(key)) {
            hql.append(" and t.executeType = ?");
            paramsList.add(NumberUtil.convertToInteger((Object)value.toString()));
            paramTypeList.add("Integer");
        }
        if ("taskCategory".equalsIgnoreCase(key)) {
            hql.append(" and t.taskCategory = ?");
            paramsList.add(NumberUtil.convertToInteger((Object)value.toString()));
            paramTypeList.add("Integer");
        }
    }

    private long getCount(String hql) {
        StringBuffer stringBuffer = new StringBuffer("select count(*) ");
        stringBuffer.append(hql);
        return this.getTotalCount(stringBuffer.toString());
    }

    private long getTotalCount(String hql) {
        return (Long)super.getHibernateTemplate().find(hql, new Object[0]).listIterator().next();
    }

    @Override
    public Boolean nameIsExist(String taskName) {
        StringBuilder hql = new StringBuilder("from Task t where t.taskName = ?");
        List taskList = super.getHibernateTemplate().find(hql.toString(), new Object[]{taskName});
        if (taskList != null && !taskList.isEmpty()) {
            return true;
        }
        return false;
    }
}

