/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.sysjob;

import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskParameter;
import com.huawei.lego.cbb.task.sdk.service.ITaskService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.huawei.lego.nem.fault.sdk.service.IFaultBackupService;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StorageFactory {
    private static final Log LOGGER = LogFactory.getInstance(StorageFactory.class);
    private static final int SLEEPCOUNT = 100;
    private static final long SLEEPTIME = 1000L;
    private ISysOptLog sysOpLog = null;
    private IFaultBackupService faultBackupService = null;
    private ITaskService taskService = null;
    private TaskParameter taskParameter = null;
    private String cvsstyleValue = "1";
    private String langValue = "1";
    private String sysOptType = "log_bk";
    private String alarmType = "alarm_bk";
    private String currentAlarmType = "current_alarm_bk";
    private String fileStyle = "";
    private String lang = "";
    private String reserDate;
    private String filePath;
    private Map<String, Object> condition;

    public String getLangValue() {
        return this.langValue;
    }

    public void setLangValue(String langValue) {
        this.langValue = langValue;
    }

    public String dateStorage(String dateType) {
        String resultLink = "";
        Task task = null;
        LOGGER.info((Object)String.format(Locale.ENGLISH, "System dateStorage begin dateType is %s.", dateType), 1L);
        try {
            this.getTaskService();
            if (this.taskService != null) {
                LOGGER.info((Object)"TaskService is  not null");
                this.getCondition(dateType);
                if (dateType.equals(this.currentAlarmType)) {
                    this.fileStyle = this.cvsstyleValue;
                    this.reserDate = "0";
                    this.lang = this.langValue;
                    resultLink = this.dateStorageByType(dateType);
                    return resultLink;
                }
                List taskList = this.taskService.queryTasks(this.condition);
                if (taskList == null || taskList.isEmpty()) {
                    return "";
                }
                task = (Task)taskList.get(0);
                this.taskParameter = task.getParameter();
                if (this.taskParameter != null) {
                    this.fileStyle = this.taskParameter.getParameter1();
                    this.reserDate = this.taskParameter.getParameter2();
                    this.lang = this.taskParameter.getParameter3();
                    resultLink = this.dateStorageByType(dateType);
                }
            } else {
                LOGGER.info((Object)"TaskService is null.");
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"DateStorage fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        return resultLink;
    }

    private void getCondition(String dateType) {
        if (dateType.equals(this.sysOptType)) {
            this.filePath = "datastorage" + File.separator + "sysoptlog";
            this.condition = new HashMap<String, Object>();
            this.condition.put("taskType", this.sysOptType);
            this.sysOpLog = this.getISysOptLogService();
        } else if (dateType.equals(this.alarmType)) {
            this.condition = new HashMap<String, Object>();
            this.condition.put("taskType", this.alarmType);
            this.faultBackupService = this.getFaultBackupService();
            this.filePath = "datastorage" + File.separator + "alarm";
        } else if (dateType.equals(this.currentAlarmType)) {
            this.condition = new HashMap<String, Object>();
            this.condition.put("taskType", this.currentAlarmType);
            this.faultBackupService = this.getFaultBackupService();
            this.filePath = "datastorage" + File.separator + "currentAlarm";
        }
    }

    private void getTaskService() {
        for (int index = 0; this.taskService == null && index < 100; ++index) {
            try {
                this.taskService = (ITaskService)ServiceContext.getInstance().lookup("task/task");
                continue;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"TaskService is null,error msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                continue;
            }
            finally {
                CommonUtil.sleep((long)1000L);
            }
        }
    }

    private IFaultBackupService getFaultBackupService() {
        for (int index = 0; this.faultBackupService == null && index < 100; ++index) {
            try {
                this.faultBackupService = (IFaultBackupService)ServiceContext.getInstance().lookup("fault/faultBackupService");
                continue;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"TaskService is null,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                continue;
            }
            finally {
                CommonUtil.sleep((long)1000L);
            }
        }
        return this.faultBackupService;
    }

    private ISysOptLog getISysOptLogService() {
        for (int index = 0; this.sysOpLog == null && index < 100; ++index) {
            try {
                this.sysOpLog = (ISysOptLog)ServiceContext.getInstance().lookup("system/sysLogService");
                continue;
            }
            catch (Exception ex) {
                LOGGER.error((Object)"TaskService is null,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                continue;
            }
            finally {
                CommonUtil.sleep((long)1000L);
            }
        }
        return this.sysOpLog;
    }

    private String dateStorageByType(String dateType) {
        String resultLink = "";
        String fileTypes = this.getFileType(this.fileStyle);
        if (dateType.equals(this.sysOptType)) {
            if (this.sysOpLog != null) {
                resultLink = this.sysOpLog.transferLog(fileTypes, this.getEndTime(this.reserDate), this.getLang(this.lang), this.filePath);
            } else {
                LOGGER.info((Object)"System dateStorage ISysOptLog is null.");
            }
        } else if (dateType.equals(this.alarmType) || dateType.equals(this.currentAlarmType)) {
            if (this.faultBackupService != null) {
                resultLink = this.faultBackupService.transferAlarm(fileTypes, this.getEndTime(this.reserDate), this.getLang(this.lang), this.filePath);
            } else {
                LOGGER.info((Object)"System dateStorage IFaultBackupService is null.");
            }
        }
        return resultLink;
    }

    private long getEndTime(String resDate) {
        long endTime = -1L;
        if (resDate != null && !"".equals(resDate)) {
            int reserDate1 = NumberUtil.convertToInteger((Object)resDate);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -reserDate1);
            endTime = cal.getTime().getTime();
        }
        return endTime;
    }

    private String getFileType(String fileType) {
        String file = "1".equals(fileType) ? "csv" : "excel";
        return file;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    private String getLang(String language) {
        String langUa = "";
        langUa = "1".equals(language) ? "en" : "zh";
        return langUa;
    }
}

