/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.hibernate;

import com.huawei.lego.cbb.user.dao.IRoleDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class RoleDaoImpl
extends HibernateDaoSupportWrapper
implements IRoleDao {
    private static final Log LOGGER = LogFactory.getInstance(RoleDaoImpl.class);

    @Override
    public synchronized long addRoleInfo(RoleInfo roleInfo) {
        String hql = "select count(r.roleIdx) from RoleInfo r";
        List conutList = this.getHibernateTemplate().find(hql, new Object[0]);
        if ((Long)conutList.get(0) >= 512L) {
            LOGGER.error((Object)"role quantity is more than 512");
            throw new SpecCheckedException("role_quantity", 512L, ((Long)conutList.get(0)).longValue());
        }
        try {
            return (Long)this.getHibernateTemplate().save((Object)roleInfo);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method addRoleInfo fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public synchronized void deleteRole(long roleId) {
        try {
            RoleInfo roleInfo = this.getRoleInfRelUser(roleId, Boolean.TRUE);
            if (roleInfo != null) {
                if (null != roleInfo.getUserSet() && !roleInfo.getUserSet().isEmpty()) {
                    throw new LegoCheckedException(296L);
                }
            } else {
                String[] pama = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(206L, pama);
            }
            this.getHibernateTemplate().delete((Object)roleInfo);
        }
        catch (DataAccessException ex) {
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public synchronized RoleInfo getRoleById(long roleId, boolean isFetchOper) {
        try {
            RoleInfo roleInfo = null;
            if (isFetchOper) {
                String hql = "FROM RoleInfo u left join fetch u.operationSet where u.roleIdx = '" + roleId + "'";
                List allUserList = this.getHibernateTemplate().find(hql, new Object[0]);
                if (allUserList != null && !allUserList.isEmpty()) {
                    roleInfo = (RoleInfo)allUserList.get(0);
                }
            } else {
                roleInfo = (RoleInfo)this.getHibernateTemplate().get(RoleInfo.class, (Serializable)Long.valueOf(roleId));
            }
            if (roleInfo == null) {
                String[] pama = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(206L, pama);
            }
            return roleInfo;
        }
        catch (DataAccessException ex) {
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public synchronized RoleInfo getRoleByName(String roleName, boolean isFetchOper) {
        try {
            RoleInfo roleInfo = null;
            if (isFetchOper) {
                String hql = "FROM RoleInfo u left join fetch u.operationSet where u.roleName = ?";
                List allUserList = this.getHibernateTemplate().find(hql, new Object[]{roleName});
                if (allUserList != null && !allUserList.isEmpty()) {
                    roleInfo = (RoleInfo)allUserList.get(0);
                }
            } else {
                Set set;
                roleInfo = (RoleInfo)this.getHibernateTemplate().find("FROM RoleInfo u where u.roleName = ?", new Object[]{roleName});
                if (roleInfo != null && !VerifyUtil.isEmpty((Collection)(set = roleInfo.getOperationSet()))) {
                    set.clear();
                }
            }
            if (roleInfo == null) {
                String[] pama = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(206L, pama);
            }
            return roleInfo;
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Get role error,msg is %s . ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public RoleInfo getRoleInfRelUser(long roleId, boolean isFetchUser) {
        try {
            RoleInfo roleInfo = null;
            if (isFetchUser) {
                String hql = "FROM RoleInfo r left join fetch r.userSet where r.roleIdx = " + roleId;
                List allUserLists = this.getHibernateTemplate().find(hql, new Object[0]);
                if (allUserLists != null && !allUserLists.isEmpty()) {
                    roleInfo = (RoleInfo)allUserLists.get(0);
                }
            } else {
                roleInfo = (RoleInfo)this.getHibernateTemplate().get(RoleInfo.class, (Serializable)Long.valueOf(roleId));
            }
            if (roleInfo == null) {
                String[] pamas = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(206L, pamas);
            }
            return roleInfo;
        }
        catch (DataAccessException ex) {
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public synchronized void updataRole(RoleInfo roleInfo) {
        try {
            RoleInfo roleinfo = this.getRoleById(roleInfo.getRoleIdx(), false);
            if (roleinfo == null) {
                LOGGER.error((Object)"Method updataRole-role is null.");
                throw new LegoCheckedException(262L);
            }
            this.getHibernateTemplate().update((Object)roleInfo);
        }
        catch (DataAccessException ex) {
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public List<RoleInfo> getAllRoles(boolean isFetchOper) {
        String hql = "FROM RoleInfo";
        try {
            return this.getHibernateTemplate().find(hql, new Object[0]);
        }
        catch (DataAccessException ex) {
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public void checkRoleNameSingle(String roleName) {
        try {
            String hql = "FROM RoleInfo where roleName = ? ";
            List result = this.getHibernateTemplate().find(hql, (Object[])new String[]{roleName});
            if (!result.isEmpty()) {
                throw new LegoCheckedException(259L);
            }
        }
        catch (DataAccessException ex) {
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }
}

