/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service;

import com.huawei.lego.cbb.user.dao.IRoleDao;
import com.huawei.lego.cbb.user.dao.IUserDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.service.IUserService;
import com.huawei.lego.cbb.user.service.common.AbstractSystemInitializeUser;
import com.huawei.lego.cbb.user.service.common.ObjectConvertor;
import com.huawei.lego.cbb.user.service.userrelmo.UserRelMoService;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UserService
implements IUserService {
    private static final Log LOGGER = LogFactory.getInstance(UserService.class);
    private static final long DEFALT_ID = 1L;
    private IUserDao userDao;
    private IRoleDao roleDao;
    private ICommonDao comDao;
    private AbstractSystemInitializeUser systemInitUser;
    private UserRelMoService userRelMoService;

    @Override
    public void initSysUser() {
        UserInfo info = null;
        try {
            info = this.getUserInfoById(1L, false);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Method initSysUser fail,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        if (info == null) {
            UserInfo defaultUser = this.systemInitUser.getDefaultUserInfo();
            this.userDao.addUser(defaultUser);
        }
    }

    @Override
    public synchronized long addUserInfo(UserInfo ouserInfo) {
        UserInfo userInfo = null;
        this.userDao.checkUserLimit(true);
        try {
            userInfo = this.userDao.getUserByName(ouserInfo.getUserName(), false);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Get user by name failed, user is Exist, exception: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        if (userInfo != null) {
            throw new LegoCheckedException(263L);
        }
        long setTime = System.currentTimeMillis();
        ouserInfo.setSetTime(setTime);
        long userId = this.userDao.addUser(ouserInfo);
        ouserInfo.setId(Long.valueOf(userId));
        return userId;
    }

    @Override
    public long addUserInfo(UserInfo ouserInfo, Set<Long> roleIds, Set<Long> moIds, Set<Long> moGroupIds) {
        HashSet<RoleInfo> roleSet = null;
        if (roleIds != null) {
            roleSet = new HashSet<RoleInfo>();
            for (long roleId : roleIds) {
                RoleInfo info = null;
                try {
                    info = this.roleDao.getRoleById(roleId, false);
                }
                catch (Exception ex) {
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Role is not Exist, exception: %s.", ExceptionUtil.getErrorMessage((Throwable)ex)));
                }
                if (info == null) continue;
                roleSet.add(info);
            }
        }
        if (roleSet == null || roleSet.isEmpty()) {
            throw new LegoCheckedException(262L);
        }
        ouserInfo.setRolesSet(roleSet);
        long newUserId = this.addUserInfo(ouserInfo);
        this.userRelMoService.addUserRelMo(newUserId, moIds, moGroupIds);
        return newUserId;
    }

    @Override
    public void deleteUser(long userId) {
        this.userDao.deleteUser(userId);
        this.userRelMoService.deleteMOByUserId(userId);
    }

    @Override
    public void deleteUser(Long[] userIds) {
        if (userIds != null && userIds.length > 0) {
            Long[] longArray = userIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long itemp = longArray[i];
                this.deleteUser(itemp);
            }
        } else {
            LOGGER.info((Object)"userIds is null");
        }
    }

    @Override
    public List<UserInfo> getAllUser() {
        return this.userDao.getAllUser(false);
    }

    @Override
    public Paging getAllUser(Map<String, String> map, int start, int length) {
        Paging roPaging = new Paging();
        if (map != null) {
            String hql = this.getHqlByCondition(map);
            List<?> userList = this.comDao.findPage(hql, start, length);
            String countHql = "select count(*) from UserInfo ";
            int icount = Integer.parseInt(String.valueOf(this.comDao.getBaseHibernateTemplate().find(countHql, new Object[0]).listIterator().next()));
            roPaging.setiCount(icount);
            roPaging.setData(userList);
        }
        return roPaging;
    }

    @Override
    public UserInfo getFullUserInfoById(Long userId) {
        UserInfo userInfo = this.userDao.getUserInfoById(userId, true);
        if (userInfo != null && !userInfo.isAdmin()) {
            Set rolesSet = userInfo.getRolesSet();
            HashSet<RoleInfo> rolesSetTemp = new HashSet<RoleInfo>();
            for (RoleInfo roleInfo : rolesSet) {
                RoleInfo temp = this.roleDao.getRoleById(roleInfo.getRoleIdx(), true);
                rolesSetTemp.add(temp);
            }
            userInfo.setRolesSet(rolesSetTemp);
        }
        return userInfo;
    }

    @Override
    public UserInfo getUserInfoByName(String userName, boolean isFetchRole) {
        return this.userDao.getUserByName(userName, isFetchRole);
    }

    @Override
    public UserInfo getUserInfoById(long userId, boolean isFetchRole) {
        return this.userDao.getUserInfoById(userId, isFetchRole);
    }

    @Override
    public String getSaltByUserName(String userName) {
        UserInfo userInfo;
        String salt = "";
        try {
            userInfo = this.userDao.getUserByName(userName, false);
        }
        catch (Exception e) {
            return salt;
        }
        if (userInfo != null) {
            salt = userInfo.getUserPwdSalt();
        }
        return salt;
    }

    @Override
    public void updateUser(UserInfo userInfo, Boolean isUpdateSetTime) {
        LOGGER.debug((Object)"updateUser UserInfo.");
        UserInfo ui = this.userDao.getUserInfoById(userInfo.getId(), false);
        if (userInfo.getPasswordModel() == 0) {
            if (ui == null || isUpdateSetTime != null && isUpdateSetTime.booleanValue()) {
                long setTime = System.currentTimeMillis();
                userInfo.setSetTime(setTime);
            } else {
                userInfo.setSetTime(ui.getSetTime());
            }
        }
        this.userDao.updateUser(userInfo);
    }

    @Override
    public void updateUser(User user) {
        LOGGER.debug((Object)"updateUser user");
        UserInfo ouserInfo = this.coventUser(user);
        Set<UserAclInfo> userAclInfoSet = ObjectConvertor.getUserAclInfo(user.getUserAclSet());
        ouserInfo.setUserAcls(userAclInfoSet);
        this.updateUser(ouserInfo, false);
        Set moIds = user.getMoAuthIdsSet();
        Set moGroupIds = user.getMoGroupIdsSet();
        this.userRelMoService.deleteMOByUserId(user.getUserId());
        this.userRelMoService.addUserRelMo(ouserInfo.getId(), moIds, moGroupIds);
    }

    private UserInfo coventUser(User user) {
        UserInfo ouserInfo = ObjectConvertor.getUserInfo(user);
        Set roleIds = user.getRolesIdsSet();
        if (roleIds != null) {
            HashSet<RoleInfo> roleSet = new HashSet<RoleInfo>();
            Iterator iterator = roleIds.iterator();
            while (iterator.hasNext()) {
                long roleId = (Long)iterator.next();
                RoleInfo roleInfTemp = this.roleDao.getRoleById(roleId, false);
                if (roleInfTemp != null) {
                    roleSet.add(roleInfTemp);
                    continue;
                }
                LOGGER.warn((Object)"role not exist.");
                throw new LegoCheckedException(262L);
            }
            ouserInfo.setRolesSet(roleSet);
        }
        return ouserInfo;
    }

    private String getFile(String file) {
        String rtnFile = "sUserName".equalsIgnoreCase(file) ? "userName" : ("description".equalsIgnoreCase(file) ? "userDes" : file);
        return rtnFile;
    }

    public void setUserDao(IUserDao userDao) {
        this.userDao = userDao;
    }

    public void setRoleDao(IRoleDao roleDao) {
        this.roleDao = roleDao;
    }

    public void setSystemInitUser(AbstractSystemInitializeUser systemInitUser) {
        this.systemInitUser = systemInitUser;
    }

    public void setComDao(ICommonDao comDao) {
        this.comDao = comDao;
    }

    public void setUserRelMoService(UserRelMoService userRelMoService) {
        this.userRelMoService = userRelMoService;
    }

    private String getHqlByCondition(Map<String, String> map) {
        if (map == null) {
            return "FROM UserInfo ";
        }
        StringBuffer stringBuffer = new StringBuffer("FROM UserInfo ");
        Set<Map.Entry<String, String>> condition = map.entrySet();
        String order = "";
        String fileName = "";
        for (Map.Entry<String, String> entry : condition) {
            String key = entry.getKey();
            String filevalue = entry.getValue();
            String value = this.getFile(filevalue);
            if ("DESC".equalsIgnoreCase(key) || "ASC".equalsIgnoreCase(key)) {
                order = key;
                fileName = "order by " + value + " ";
                continue;
            }
            stringBuffer.append(" where ");
            stringBuffer.append(key);
            stringBuffer.append(" like '*");
            stringBuffer.append(value);
            stringBuffer.append("*'");
        }
        stringBuffer.append(fileName);
        stringBuffer.append(order);
        return stringBuffer.toString();
    }

    @Override
    public List<String> getAllUserAuthority() {
        List<?> list = this.comDao.findBySql("select opt_url from T_operations", new Object[0]);
        Iterator<?> it = list.iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (it.hasNext()) {
            String str;
            Object obj = it.next();
            if (obj == null || "".equals((str = (String)obj).trim())) continue;
            result.add(str);
        }
        return result;
    }

    @Override
    public RoleInfo getRoleByName(String roleName) {
        RoleInfo roleInfo = null;
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, roleName);
        List<?> allRoleList = this.comDao.findByHql("FROM RoleInfo u where u.roleName = ?", param);
        if (allRoleList != null && !allRoleList.isEmpty()) {
            roleInfo = (RoleInfo)allRoleList.get(0);
        }
        return roleInfo;
    }

    @Override
    public boolean checkUserExist(String userName) {
        UserInfo userInfo = null;
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, userName);
        List<?> allUserList = this.comDao.findByHql("FROM UserInfo u where u.userName = ?", param);
        if (allUserList != null && !allUserList.isEmpty()) {
            userInfo = (UserInfo)allUserList.get(0);
        }
        return userInfo != null;
    }

    @Override
    public void setOldUserLog(String username) {
        Object[] param = new Object[]{username};
        String sbf = "update OptLogMo t set t.isOld='true' where t.opUser=?";
        this.comDao.updateByHql(sbf, param);
    }
}

