/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.common;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserAclInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserLoginPolicyInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserSecPolicyInfo;
import com.huawei.lego.cbb.user.service.IUserService;
import com.huawei.lego.cbb.user.service.security.ISecurity;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractSystemInitializeUser {
    protected static final String DEFALT_USER_NAME_SYNC = "SyncAdmin";
    private static final String DEFALT_USER_NAME = "admin";
    private static final Log LOGGER = LogFactory.getInstance(AbstractSystemInitializeUser.class);
    private static boolean propertyInit = false;
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static final Properties PROPS = new Properties();
    protected transient IUserService userService;
    private ICommonDao commonDao;
    private transient ISecurity security;

    protected abstract String getJarFileName();

    protected abstract ClassLoader getClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void initProperty() {
        block25: {
            block24: {
                InputStream stream;
                block23: {
                    ClassLoader classLoader;
                    String jarfileName;
                    block22: {
                        if (propertyInit) break block25;
                        stream = null;
                        jarfileName = this.getJarFileName();
                        classLoader = this.getClassLoader();
                        if (jarfileName != null && classLoader != null) break block22;
                        LOGGER.error((Object)"Get SystemInitializeUser ClassLoader fail.");
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.error((Object)"Method initProperty IOException,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                        }
                        return;
                    }
                    URL url = AdapterUtils.getUrlResourceFromJar((ClassLoader)classLoader, (String)jarfileName, (String)DEFAULT_PROPERTIES);
                    if (url == null) break block23;
                    stream = url.openStream();
                    PROPS.load(stream);
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block24;
                }
                catch (IOException ex) {
                    LOGGER.error((Object)"Method initProperty IOException,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                }
                break block24;
                catch (IOException e) {
                    LOGGER.error((Object)"Read default.properties fail,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block24;
                    }
                    catch (IOException ex) {
                        LOGGER.error((Object)"Method initProperty IOException,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    }
                    break block24;
                }
                catch (Exception e2) {
                    LOGGER.error((Object)"Read default.properties fail,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e2)});
                    {
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                            catch (IOException ex) {
                                LOGGER.error((Object)"Method initProperty IOException,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.error((Object)"Method initProperty IOException,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                    }
                }
            }
            Properties sysProps = System.getProperties();
            sysProps.putAll((Map<?, ?>)PROPS);
            System.setProperties(sysProps);
            propertyInit = true;
        }
    }

    protected void initSysUser() {
        UserInfo userInfo = null;
        try {
            userInfo = this.userService.getUserInfoByName(DEFALT_USER_NAME, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"System not exist user");
        }
        if (userInfo == null) {
            this.initProperty();
            UserInfo defaultUser = this.getDefaultUserInfo();
            UserAclInfo aclInfoV4 = this.getDefaultUserAclInfoV4();
            UserAclInfo aclInfoV6 = this.getDefaultUserAclInfoV6();
            defaultUser.addTouserAcls(aclInfoV4);
            defaultUser.addTouserAcls(aclInfoV6);
            this.commonDao.saveOrUpdate(defaultUser);
        }
    }

    void initSysSyncUser() {
        UserInfo syncUserInfo = null;
        try {
            syncUserInfo = this.userService.getUserInfoByName(DEFALT_USER_NAME_SYNC, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"System not exist syncSyncUser");
        }
        if (syncUserInfo == null) {
            this.initProperty();
            UserInfo defaultUser = this.getDefaultSyncUserInfoLego();
            UserAclInfo aclInfoV4 = this.getDefaultUserAclInfoV4();
            UserAclInfo aclInfoV6 = this.getDefaultUserAclInfoV6();
            defaultUser.addTouserAcls(aclInfoV4);
            defaultUser.addTouserAcls(aclInfoV6);
            this.commonDao.saveOrUpdate(defaultUser);
        }
    }

    void initSysLoginPolicy() {
        UserSecPolicyInfo secInfo;
        UserLoginPolicyInfo info = this.security.getLoginPolicy();
        if (info == null) {
            this.initProperty();
            UserLoginPolicyInfo defaultLoginPolicy = this.getDefaultLoginPolicy();
            this.commonDao.save(defaultLoginPolicy);
        }
        if ((secInfo = this.security.getUserSecPolicy()) == null) {
            this.initProperty();
            UserSecPolicyInfo defaultSecPolicy = this.getDefaultSecPolicy();
            this.commonDao.save(defaultSecPolicy);
        }
    }

    public UserSecPolicyInfo getDefaultSecPolicy() {
        UserSecPolicyInfo info = new UserSecPolicyInfo();
        int pswLenth = this.getInt("system.sec.policy.pswLenth");
        int unseal = this.getInt("system.sec.policy.unseal");
        int usefulLife = this.getInt("system.sec.policy.usefulLife");
        String complex = this.getProperty("system.sec.policy.complex", "");
        info.setComplex(complex);
        info.setPswLenth(Integer.valueOf(pswLenth));
        info.setUnseal(Integer.valueOf(unseal));
        info.setUsefulLife(Integer.valueOf(usefulLife));
        info.setId(Long.valueOf(1L));
        return info;
    }

    public UserLoginPolicyInfo getDefaultLoginPolicy() {
        UserLoginPolicyInfo info = new UserLoginPolicyInfo();
        int lgoinInterval = this.getInt("system.login.policy.lgoinInterval");
        int lgoinCount = this.getInt("system.login.policy.lgoinCount");
        int lockTime = this.getInt("system.login.policy.lockTime");
        int unseal = 1;
        int sessionTimeOut = this.getInt("system.login.policy.sessionTimeOut");
        info.setId(Long.valueOf(1L));
        info.setLgoinCount(Integer.valueOf(lgoinCount));
        info.setLgoinInterval(Integer.valueOf(lgoinInterval));
        info.setLockTime(Integer.valueOf(lockTime));
        info.setSessionTimeOut(Integer.valueOf(sessionTimeOut));
        info.setUnseal(Integer.valueOf(unseal));
        return info;
    }

    public int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (value == null || value.length() <= 0) {
            return 0;
        }
        return NumberUtil.convertToInteger((Object)value);
    }

    public UserInfo getDefaultSyncUserInfoLego() {
        UserInfo info = new UserInfo();
        String userName = this.getProperty("sys.defalt.syncUserName", "");
        String pwd = this.getProperty("sys.defalt.syncUserPwd", "");
        info.setAdmin(true);
        info.setUserName(userName);
        info.setUserPwd(KmcInstance.protectPwdEx((String)WccEncryptor.decrypt((String)pwd)));
        info.setUserPwdHistory(info.getUserPwd());
        info.setUserPwdSalt("");
        info.setMustModiPassword(false);
        info.setPasswordModel(Integer.valueOf(0));
        info.setSessionControl(Boolean.valueOf(false));
        info.setSessionLimit(Integer.valueOf(0));
        info.setUserDes("user_syncAdmin_description_label");
        long setTime = System.currentTimeMillis();
        info.setSetTime(setTime);
        return info;
    }

    public UserAclInfo getDefaultUserAclInfoV4() {
        UserAclInfo info = new UserAclInfo();
        String startIp = this.getProperty("system.sec.acl.startip", "");
        String endIp = this.getProperty("system.sec.acl.endip", "");
        info.setEndIp(endIp);
        info.setStartIp(startIp);
        return info;
    }

    public UserAclInfo getDefaultUserAclInfoV6() {
        UserAclInfo info = new UserAclInfo();
        String startIp = this.getProperty("system.sec.acl.v6.startip", "");
        String endIp = this.getProperty("system.sec.acl.v6.endip", "");
        info.setEndIp(endIp);
        info.setStartIp(startIp);
        return info;
    }

    public String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (value == null || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public UserInfo getDefaultUserInfo() {
        return this.getDefaultUserInfoLego();
    }

    public UserInfo getDefaultUserInfoLego() {
        UserInfo info = new UserInfo();
        String userName = this.getProperty("sys.defalt.userName", "");
        String pwd = this.getProperty("sys.defalt.userPwd", "");
        info.setAdmin(true);
        info.setUserName(userName);
        info.setUserPwd(KmcInstance.protectPwdEx((String)WccEncryptor.decrypt((String)pwd)));
        info.setUserPwdHistory(info.getUserPwd());
        info.setUserPwdSalt("");
        info.setMustModiPassword(true);
        info.setPasswordModel(Integer.valueOf(0));
        info.setSessionControl(Boolean.valueOf(false));
        info.setSessionLimit(Integer.valueOf(0));
        long setTime = System.currentTimeMillis();
        info.setSetTime(setTime);
        return info;
    }

    public void setSecurity(ISecurity security) {
        this.security = security;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }
}

