/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.common;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class SessionGeneratorUtil {
    private static final Log LOGGER = LogFactory.getInstance(SessionGeneratorUtil.class);
    private static int count = 0;

    private SessionGeneratorUtil() {
    }

    public static String generateSessionId(long userId, String loginIp) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("userId=").append(userId).append(",loginIp=").append(loginIp).append(",loginTime=").append(System.currentTimeMillis()).append(SessionGeneratorUtil.getRandom());
        buffer.append(",sequnce=").append(SessionGeneratorUtil.generateSequence());
        return buffer.toString();
    }

    private static String getRandom() {
        SecureRandom random = null;
        try {
            random = SecureRandomFactory.getInstanceStrongWithDRBG();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"Securerandomfactory get instancestrongwithdrbg fail,cause no such algorithm.");
            throw new LegoCheckedException(-1L);
        }
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        StringBuilder stringBuilder = new StringBuilder("");
        for (byte abyte : bytes) {
            int vv = abyte & 0xFF;
            String hv = Integer.toHexString(vv);
            if (hv.length() == 1) {
                hv = "0" + hv;
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getUserIdFromSessionId(String sessionId) {
        if (VerifyUtil.isEmpty((String)sessionId)) {
            return "";
        }
        String[] temp = sessionId.split(",");
        String tempInfo = temp[0];
        return tempInfo.replaceAll("userId=", "");
    }

    private static int generateSequence() {
        return ++count;
    }
}

