/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.userrelmo;

import com.huawei.lego.cbb.user.dao.IUserRelMoDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserRelMo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.huawei.lego.cbb.user.service.userrelmo.IUserRelMoService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserRelMoService
implements IUserRelMoService {
    private IUserRelMoDao userRelMoDao;

    @Override
    public void addUserRelMo(long userId, Set<Long> moIds, Set<Long> moGroupIds) {
        Set<UserRelMoInfo> set = this.getUserRelMoInfo(userId, moIds, moGroupIds);
        this.userRelMoDao.addMoByUser(set);
    }

    @Override
    public void deleteMOByUserId(long userId) {
        this.userRelMoDao.deleteMOByUserId(userId);
    }

    @Override
    public void deleteUserRelMO(long userId, Set<Long> moIds, Set<Long> moGroupIds) {
        Set<UserRelMoInfo> set = this.getUserRelMoInfo(userId, moIds, moGroupIds);
        this.userRelMoDao.deleteUserRelMO(set);
    }

    @Override
    public List<UserRelMoInfo> getUserAllRelMO(long userId) {
        return this.userRelMoDao.getAllMOByUserId(userId);
    }

    public Set<UserRelMoInfo> getUserRelMoInfo(long userId, Set<Long> moIds, Set<Long> moGroupIds) {
        UserRelMo userRelMo;
        UserRelMoInfo userRelMoInfo;
        HashSet<UserRelMoInfo> set = new HashSet<UserRelMoInfo>();
        if (moIds != null) {
            for (long moId : moIds) {
                userRelMoInfo = new UserRelMoInfo();
                userRelMoInfo.setGroup(false);
                userRelMo = new UserRelMo();
                userRelMo.setMoId(Long.valueOf(moId));
                userRelMo.setUserIdx(Long.valueOf(userId));
                userRelMoInfo.setId(userRelMo);
                set.add(userRelMoInfo);
            }
        }
        if (moGroupIds != null) {
            for (long moId : moGroupIds) {
                userRelMoInfo = new UserRelMoInfo();
                userRelMoInfo.setGroup(true);
                userRelMo = new UserRelMo();
                userRelMo.setMoId(Long.valueOf(moId));
                userRelMo.setUserIdx(Long.valueOf(userId));
                userRelMoInfo.setId(userRelMo);
                set.add(userRelMoInfo);
            }
        }
        return set;
    }

    @Override
    public Boolean checkUserRight(long userId, long moId) {
        List<UserRelMoInfo> list = this.userRelMoDao.getMoByUserId(userId, moId);
        if (list == null || list.isEmpty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void deleteManageObject(Set<Long> moIds, Set<Long> moGroupIds) {
        HashSet<Long> set = new HashSet<Long>();
        if (moIds != null) {
            set.addAll(moIds);
        }
        this.userRelMoDao.deleteMos(set);
    }

    public void setUserRelMoDao(IUserRelMoDao userRelMoDao) {
        this.userRelMoDao = userRelMoDao;
    }
}

