/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.security;

import com.huawei.lego.core.sdk.util.NumberUtil;
import java.io.Serializable;
import java.util.Comparator;

public class ProtocolComparator
implements Serializable,
Comparator<String> {
    private static final long serialVersionUID = 1L;
    private static final String PROTOCOL_TLS = "TLS";
    private static final String PROTOCOL_SSL = "SSL";
    private static final String PROTOCOL_SPLITTER = "v";

    @Override
    public int compare(String protocol1, String protocol2) {
        if (!protocol1.startsWith(PROTOCOL_TLS) && !protocol1.startsWith(PROTOCOL_SSL)) {
            return -1;
        }
        String[] protocol1Array = protocol1.split(PROTOCOL_SPLITTER);
        String[] protocol2Array = protocol2.split(PROTOCOL_SPLITTER);
        String protocol1Type = protocol1Array[0];
        double protocol1Version = 1 == protocol1Array.length ? 0.0 : NumberUtil.parseDouble((Object)protocol1Array[1]);
        String protocol2Type = protocol2Array[0];
        double protocol2Version = 1 == protocol2Array.length ? 0.0 : NumberUtil.parseDouble((Object)protocol2Array[1]);
        int result = this.compareByProtocolType(protocol1Type, protocol2Type);
        if (result != 0) {
            return result;
        }
        return this.compareByProtocolVersion(protocol1Version, protocol2Version);
    }

    private int compareByProtocolType(String protocol1Type, String protocol2Type) {
        if (protocol1Type.equalsIgnoreCase(PROTOCOL_TLS) && protocol2Type.equalsIgnoreCase(PROTOCOL_SSL)) {
            return 1;
        }
        if (protocol1Type.equalsIgnoreCase(PROTOCOL_SSL) && protocol2Type.equalsIgnoreCase(PROTOCOL_TLS)) {
            return -1;
        }
        return 0;
    }

    private int compareByProtocolVersion(double protocol1Version, double protocol2Version) {
        if (protocol1Version > protocol2Version) {
            return -1;
        }
        if (protocol1Version < protocol2Version) {
            return 1;
        }
        return 0;
    }
}

