/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base;

import com.huawei.lego.core.base.confmgr.EntryProcessor;
import com.huawei.lego.core.base.service.IAnalyzer;
import com.huawei.lego.core.sdk.base.annotation.Application;
import com.huawei.lego.core.sdk.base.model.AppPriority;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.springframework.util.Assert;

@Application(name="KernelApplication", desc="this is the core application of lego system", priority=AppPriority.KERNEL)
public class KernelApplication
extends AbsApplication {
    private static final String EXTENSION_DEF_PROPERTIES = "extension-def.properties";
    private static final Log LOGGER = LogFactory.getInstance(KernelApplication.class);
    private Properties extensionPoints = new Properties();
    private List<IAnalyzer> analyzers;
    private EntryProcessor processor;

    public void setAnalyzers(List<IAnalyzer> analyzers) {
        this.analyzers = analyzers;
    }

    public void setProcessor(EntryProcessor processor) {
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(List<ICallback> callback) {
        InputStream inputStream;
        block16: {
            inputStream = null;
            try {
                ClassLoader classLoader = AdapterUtils.getClassLoader(((Object)((Object)this)).getClass());
                if (null == classLoader) break block16;
                URL url = classLoader.getResource(EXTENSION_DEF_PROPERTIES);
                if (null != url) {
                    inputStream = url.openStream();
                }
                if (null != inputStream) {
                    this.extensionPoints.load(inputStream);
                }
                for (IAnalyzer analyzer : this.analyzers) {
                    analyzer.analyze(this.extensionPoints);
                }
                this.processor.process();
                super.start(callback);
            }
            catch (IOException e) {
                try {
                    LOGGER.error((Object)("curBundle: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                }
                catch (Throwable throwable) {
                    Assert.notNull(inputStream);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)"curBundle: ", (Throwable)e2, 1L);
                        }
                    }
                    throw throwable;
                }
                Assert.notNull((Object)inputStream);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e3) {
                        LOGGER.error((Object)"curBundle: ", (Throwable)e3, 1L);
                    }
                }
            }
        }
        Assert.notNull(inputStream);
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"curBundle: ", (Throwable)e, 1L);
            }
        }
    }
}

