/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import com.huawei.lego.core.base.thread.CommonThreadPoolExecutor;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private static final Log LOGGER = LogFactory.getInstance(ThreadPool.class);
    private CommonThreadPoolExecutor executor;

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, int workQueueSize) {
        this.executor = new CommonThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(workQueueSize));
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit, int workQueueSize) {
        this.executor = new CommonThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, new LinkedBlockingQueue<Runnable>(workQueueSize));
    }

    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    public void submitTask(FutureTask<Object> task) {
        LOGGER.debug((Object)"submit a task[%s]. active count:[%s]. task count:[%s]. queue count:[%s]. pool size:[%s]", new Object[]{task, String.valueOf(this.executor.getActiveCount()), String.valueOf(this.executor.getTaskCount()), String.valueOf(this.executor.getQueue().size()), String.valueOf(this.executor.getPoolSize())});
        this.executor.execute(task);
    }

    public void submitTask(Runnable runnable) {
        LOGGER.debug((Object)"submit a task[%s]. active count:[%s]. task count:[%s]. queue count:[%s]. pool size:[%s]", new Object[]{runnable, String.valueOf(this.executor.getActiveCount()), String.valueOf(this.executor.getTaskCount()), String.valueOf(this.executor.getQueue().size()), String.valueOf(this.executor.getPoolSize())});
        this.executor.execute(runnable);
    }

    public <T> Future<T> submit(Callable<T> task) {
        LOGGER.debug((Object)"submit a task[%s]. active count:[%s]. task count:[%s]. queue count:[%s]. pool size:[%s]", new Object[]{task, String.valueOf(this.executor.getActiveCount()), String.valueOf(this.executor.getTaskCount()), String.valueOf(this.executor.getQueue().size()), String.valueOf(this.executor.getPoolSize())});
        return this.executor.submit(task);
    }

    public Future<?> submit(Runnable task) {
        LOGGER.debug((Object)"submit a task[%s]. active count:[%s]. task count:[%s]. queue count:[%s]. pool size:[%s]", new Object[]{task, String.valueOf(this.executor.getActiveCount()), String.valueOf(this.executor.getTaskCount()), String.valueOf(this.executor.getQueue().size()), String.valueOf(this.executor.getPoolSize())});
        return this.executor.submit(task);
    }

    public <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.executor.newTaskFor(runnable, value);
    }

    public <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return this.executor.newTaskFor(callable);
    }

    public int getRemainCapacity() {
        BlockingQueue<Runnable> workQueue = this.executor.getQueue();
        if (workQueue != null) {
            return workQueue.remainingCapacity();
        }
        return 0;
    }

    public BlockingQueue<Runnable> getWorkQueue() {
        return this.executor.getQueue();
    }
}

