/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.util;

import com.huawei.lego.core.base.thread.FutureResult;
import com.huawei.lego.core.base.util.Watcher;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class KeyStoreLoader
extends Watcher {
    private static final Log logger = LogFactory.getInstance(KeyStoreLoader.class);
    private static final Object LOCK = new Object();
    private static final Map<String, KeyStoreLoader> LOADERS = new ConcurrentHashMap<String, KeyStoreLoader>();
    private static long keystoreFileModifyTime = 0L;
    private String type;
    private Supplier<String> token;
    private CompletableFuture<FutureResult<KeyStore>> future = new CompletableFuture();
    private Object lock = new Object();

    public KeyStoreLoader(String type, Path file, Supplier<String> token) {
        super(file, Watcher.Kind.INIT, Watcher.Kind.CREATE, Watcher.Kind.MODIFY);
        this.type = type;
        this.token = Objects.requireNonNull(token);
        this.handle(this::handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<FutureResult<KeyStore>> getFuture(boolean isRefresh) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.future.isDone()) {
                return this.future;
            }
            if (isRefresh) {
                this.future = new CompletableFuture();
            }
            return this.future;
        }
    }

    public Optional<FutureResult<KeyStore>> get() {
        if (!this.running()) {
            this.start();
        }
        if (this.isRunningTest()) {
            logger.info((Object)"run at test mode");
            return Optional.of(new FutureResult<KeyStore>((KeyStore)null));
        }
        try {
            return Optional.ofNullable(this.getFuture(false).get());
        }
        catch (InterruptedException | ExecutionException e) {
            return Optional.of(new FutureResult(e));
        }
    }

    private void handle(Watcher.Event event) {
        if (event.isDeletedAtLast()) {
            logger.info((Object)"key store file is deleted, no need to reload keystore");
            return;
        }
        String keyStoreFile = event.getPath().toAbsolutePath().toString();
        if (VerifyUtil.isEmpty((String)keyStoreFile)) {
            logger.error((Object)"keyStoreFile is null.");
            this.getFuture(true).complete(new FutureResult(new LegoCheckedException(207L)));
            return;
        }
        File file = new File(keyStoreFile);
        if (!file.exists()) {
            logger.error((Object)"keyStore is not exist.");
            this.getFuture(true).complete(new FutureResult(new LegoCheckedException(207L)));
            return;
        }
        Path path = file.toPath();
        if (!Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
            logger.error((Object)"Not a regular file");
            this.getFuture(true).complete(new FutureResult(new LegoCheckedException(207L, "Not a regular file")));
            return;
        }
        try (FileInputStream in = new FileInputStream(file);){
            KeyStore keyStore = KeyStore.getInstance(this.type);
            String password = this.token.get();
            if (VerifyUtil.isEmpty((String)password)) {
                logger.error((Object)"password is empty.");
                this.getFuture(true).complete(new FutureResult(new LegoCheckedException(207L)));
                return;
            }
            keyStore.load(in, password.toCharArray());
            this.getFuture(true).complete(new FutureResult<KeyStore>(keyStore));
            keystoreFileModifyTime = file.lastModified();
            logger.info((Object)"Init keystore success.");
        }
        catch (Exception e) {
            logger.error((Object)"Initializing KeyStore failed,msg is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.getFuture(true).complete(new FutureResult(new LegoCheckedException(207L, (Throwable)e)));
        }
    }

    @Override
    public KeyStoreLoader handle(Consumer<Watcher.Event> handler) {
        super.handle(handler);
        return this;
    }

    @Override
    public KeyStoreLoader delay(long delayTime) {
        super.delay(delayTime);
        return this;
    }

    @Override
    public KeyStoreLoader start() {
        super.start();
        return this;
    }

    @Override
    public KeyStoreLoader stop() {
        super.stop();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String path, Supplier<KeyStoreLoader> keyStoreLoaderSupplier) {
        Object object = LOCK;
        synchronized (object) {
            KeyStoreLoader loader = LOADERS.get(path);
            if (loader == null) {
                loader = Objects.requireNonNull(keyStoreLoaderSupplier.get());
                LOADERS.put(path, loader);
            }
            return loader.get().map(FutureResult::rethrow).map(FutureResult::getData).orElseThrow(() -> new LegoCheckedException("get key store failed").log(logger));
        }
    }

    public static long getKeystoreFileModifyTime() {
        return keystoreFileModifyTime;
    }
}

