/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.nepoll;

import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.huawei.lego.cbb.resource.sdk.service.IDataExplore;
import com.huawei.lego.core.mediation.nepoll.PingPoll;
import com.huawei.lego.core.mediation.nepoll.PollPlugin;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;

class InitPollThread
implements Runnable {
    private static final long VALUE_3000L = 3000L;
    private static final Log logger = LogFactory.getInstance(InitPollThread.class);
    private IDataExplore dateExplorer;

    public InitPollThread(IDataExplore dateExplorer) {
        this.dateExplorer = dateExplorer;
    }

    @Override
    public void run() {
        try {
            CommonUtil.sleep((long)3000L);
            TopoObjectQueryCondition condition = new TopoObjectQueryCondition();
            condition.setUserId(null);
            condition.setIsManaged(Boolean.valueOf(true));
            List topoObjects = this.dateExplorer.getDataList(condition);
            for (TopoObject topoMo : topoObjects) {
                if (topoMo.getUuid().equals(PollPlugin.getInstance().getMediationApp().getLegoSystem().getUuid())) continue;
                long moId = topoMo.getMoId();
                String moIP = topoMo.getIpAddress();
                String moName = topoMo.getName();
                if (!topoMo.getSupportPing().booleanValue()) {
                    logger.error((Object)"No support ping,ip: %s,moId:%s,moName:%s.", new Object[]{moIP, moId, moName});
                    continue;
                }
                if (moIP == null) {
                    logger.error((Object)"MoIP is null, can not add a poll task while starting, moId:%s", moId);
                    continue;
                }
                String descr = topoMo.getDescription();
                if (descr != null && "manual".equals(descr)) {
                    logger.info((Object)"No need to add a poll task while starting, moId: %s, moName: %s, moIP: %s.", new Object[]{moId, moName, moIP});
                    continue;
                }
                PollPlugin.getInstance().addPingPoll(new PingPoll(moId, moIP, moName));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Get all TopoObject in PollPlugin failed.%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }
}

