/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.common;

import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.sysmonitor.sdk.model.Bundle;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.huawei.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.huawei.lego.core.system.sysmonitor.sdk.service.ISysMonitor;
import com.huawei.lego.core.system.sysmonitor.service.common.MonitorCacheThread;
import com.huawei.lego.core.system.sysmonitor.service.common.SysMonitorCache;
import com.huawei.lego.core.system.sysmonitor.service.compmoniservice.ICompMonitor;
import com.huawei.lego.core.system.sysmonitor.service.treshold.ISysmTresholdService;
import com.huawei.lego.core.system.sysmonitor.service.treshold.SysmTresholdService;
import java.util.List;
import java.util.Map;

@Service(name="sysMonitor", desc="", interfaceClass=ISysMonitor.class)
public class SysMonitorImpl
extends BaseService
implements ISysMonitor,
ILifecycle {
    private static final Log LOGGER = LogFactory.getInstance(SysMonitorImpl.class);
    private static final long serialVersionUID = 1L;
    private ICompMonitor compMonitor;
    private SysMonitorCache sysMonitorCache;
    private MonitorCacheThread monitorCacheThread;
    private ISysmTresholdService sysTresholdService;

    public void stopBundle(List<String> sBundle) {
        this.compMonitor.stopBundle(sBundle);
    }

    public void startBundle(List<String> sBundle) {
        this.compMonitor.startBundle(sBundle);
    }

    public List<Bundle> getBundles() {
        return this.compMonitor.getBundles();
    }

    public Map<?, HostServerMonitorInfo> getCurrentHostServerInfo() {
        Map<Long, HostServerMonitorInfo> temp = null;
        List<Map<Long, HostServerMonitorInfo>> hostInfoList = this.sysMonitorCache.getHostInfoList();
        if (null == hostInfoList) {
            LOGGER.info((Object)"hostInfoList is null", 1L);
            return null;
        }
        if (!hostInfoList.isEmpty()) {
            temp = hostInfoList.get(hostInfoList.size() - 1);
        }
        return temp;
    }

    public List<Map<Long, HostServerMonitorInfo>> getHistoryhostInfo() {
        return this.sysMonitorCache.getHostInfoList();
    }

    public Map<?, List<DataBaseInfo>> getDataBaseInfo() {
        List<Map<Long, List<DataBaseInfo>>> list = this.sysMonitorCache.getDataBaseList();
        if (null == list) {
            LOGGER.info((Object)"DataBaseInfo is null", 1L);
            return null;
        }
        Map<Long, List<DataBaseInfo>> current = null;
        int listSize = list.size();
        if (listSize >= 1) {
            current = this.sysMonitorCache.getDataBaseList().get(listSize - 1);
        }
        return current;
    }

    public List<Map<Long, List<DataBaseInfo>>> getHistoryDataBaseInfo() {
        List<Map<Long, List<DataBaseInfo>>> list = this.sysMonitorCache.getDataBaseList();
        return list;
    }

    public List<SysmTreshold> getSysmTreshold() {
        return this.sysTresholdService.getSysmTreshold();
    }

    public void updateSysmTreshold(List<SysmTreshold> list) {
        this.sysTresholdService.updateSysmTreshold(list);
    }

    public void setMonitorCacheThread(MonitorCacheThread monitorCacheThread) {
        this.monitorCacheThread = monitorCacheThread;
    }

    public void setSysTresholdService(SysmTresholdService sysTresholdService) {
        this.sysTresholdService = sysTresholdService;
    }

    public void setSysMonitorCache(SysMonitorCache sysMonitorCache) {
        this.sysMonitorCache = sysMonitorCache;
    }

    public ICompMonitor getCompMonitor() {
        return this.compMonitor;
    }

    public void setCompMonitor(ICompMonitor compMonitor) {
        this.compMonitor = compMonitor;
    }

    public void initialize(List<ICallback> callback) {
        if (null != this.monitorCacheThread) {
            this.monitorCacheThread.setMonitorStart(true);
            ExecutionService.submitTask(this.monitorCacheThread);
        }
        LOGGER.info((Object)"System bundle SysMonitor Modle start", 1L);
    }

    public void stop(ICallback[] callback) {
        if (null != this.monitorCacheThread) {
            this.monitorCacheThread.setMonitorStart(false);
        }
        LOGGER.info((Object)"System bundle SysMonitor Modle stop", 1L);
    }
}

