/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.compmoniservice;

import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.system.sysmonitor.sdk.model.Bundle;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class TranslateObject {
    private TranslateObject() {
    }

    public static List<Bundle> translateAppInfoToBundle(List<AppInfo> lstAppInfo) {
        ArrayList<Bundle> lstBundle = new ArrayList<Bundle>();
        if (null != lstAppInfo) {
            for (AppInfo tmpAppInfo : lstAppInfo) {
                Bundle tmpBundle = new Bundle();
                tmpBundle.setVersion(tmpAppInfo.getVersion());
                tmpBundle.setIp(tmpAppInfo.getIp());
                tmpBundle.setName(tmpAppInfo.getAppName());
                tmpBundle.setiPort(tmpAppInfo.getPort());
                try {
                    tmpBundle.setCreateTime(TranslateObject.translateCSTTime(tmpAppInfo.getCreateDate().toString()));
                }
                catch (ParseException e) {
                    throw LegoExceptionTranslator.convert((Throwable)e);
                }
                tmpBundle.setiStatus(tmpAppInfo.getStatus().getValue());
                tmpBundle.setDescription(tmpAppInfo.getDesc());
                lstBundle.add(tmpBundle);
            }
        }
        return lstBundle;
    }

    public static String translateCSTTime(String sCSTTime) throws ParseException {
        SimpleDateFormat dfFromString = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
        SimpleDateFormat dfToString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = dfFromString.parse(sCSTTime);
        return dfToString.format(date);
    }
}

