/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.template.dao;

import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.template.dao.ITemplateBaseDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.dao.DataAccessException;

public class AbstractTemplateBaseDao
extends HibernateDaoSupportWrapper
implements ITemplateBaseDao {
    private static final Log LOGGER = LogFactory.getInstance(AbstractTemplateBaseDao.class);

    @Override
    public boolean addTemplate(Protocol template, String className) {
        try {
            this.getHibernateTemplate().save(className, (Object)template);
            return true;
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method addTemplate error, templateName: %s,error:%s.", new Object[]{template.getTemplateName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public boolean updateTemplate(Protocol template, String className) {
        try {
            Protocol oldTemplate = (Protocol)this.getHibernateTemplate().get(className, (Serializable)template.getId());
            if (oldTemplate == null) {
                String[] param = new String[]{className};
                throw new LegoCheckedException(204L, param);
            }
            this.getHibernateTemplate().update(className, (Object)template);
            return true;
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method updateTemplate error, templateId: %s,templateName:%s,error:%s.", new Object[]{template.getId(), template.getTemplateName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public Protocol getTemplate(Serializable id, String className) {
        try {
            Protocol template = (Protocol)this.getHibernateTemplate().get(className, id);
            if (template == null) {
                String[] param = new String[]{className};
                throw new LegoCheckedException(204L, param);
            }
            return template;
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"getTemplate error, id: %s,error:%s.", new Object[]{id, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public List<Protocol> getAllTemplate() {
        StringBuffer queryString = new StringBuffer();
        queryString.append("from " + Protocol.class.getName());
        ArrayList<Protocol> templateList = new ArrayList<Protocol>();
        List list = this.getHibernateTemplate().find(queryString.toString(), new Object[0]);
        for (Object obj : list) {
            if (!(obj instanceof Protocol)) continue;
            templateList.add((Protocol)obj);
        }
        return templateList;
    }

    @Override
    public Long addTemplateReturnKey(Protocol template, String className) {
        try {
            return (Long)this.getHibernateTemplate().save(className, (Object)template);
        }
        catch (DataAccessException ex) {
            LOGGER.error((Object)"Method addTemplateReturnKey error, templateName: %s,error :%s.", new Object[]{template.getTemplateName(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public void deleteTemplate(long templateId, String className) {
    }

    @Override
    public List<Protocol> getTemplateList(Properties prop) {
        return new ArrayList<Protocol>();
    }
}

