/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms;

import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.jms.IFaultMsgHandler;
import java.util.HashMap;
import java.util.Map;

public class FaultMsgSubscriber
extends MessageTaskManager {
    private static final int VALUE_2 = 2;
    private static final Log LOGGER = LogFactory.getInstance(FaultMsgSubscriber.class);
    private Map<Long, IFaultMsgHandler> handlers = new HashMap<Long, IFaultMsgHandler>();

    @Override
    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters(2);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(103L);
        mrs[0].addMessageCode(105L);
        mrs[0].addMessageCode(107L);
        mrs[0].addMessageCode(5003L);
        mrs[0].addMessageCode(5019L);
        mrs[0].addMessageCode(5006L);
        mrs[1].setMessageTopic(MessageTopic.COMMAND);
        mrs[1].addMessageCode(110L);
        mrs[1].addMessageCode(109L);
        mrs[1].addMessageCode(5001L);
        mrs[1].addMessageCode(4001L);
        mrs[1].addMessageCode(4003L);
        mrs[1].addMessageCode(4002L);
        mrs[1].addMessageCode(4004L);
        mrs[1].addMessageCode(4005L);
        return mrs;
    }

    @Override
    public void onMessage(MessageUnit mu) {
        long msgType = mu.getCmdcode();
        IFaultMsgHandler handler = this.handlers.get(msgType);
        if (handler == null) {
            LOGGER.error((Object)"no IFaultMsgHandler was found, msgType: %s.", msgType);
            return;
        }
        handler.handleMsg(mu);
    }

    public void addMsgHandler(IFaultMsgHandler handler) {
        this.handlers.put(handler.getMsgType(), handler);
    }

    public void deleteMsgHandler(IFaultMsgHandler handler) {
        this.handlers.remove(handler.getMsgType());
    }

    public void setHandlers(Map<Long, IFaultMsgHandler> handlers) {
        this.handlers = handlers;
    }
}

