/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.handler;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserRelMo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgrBaseService;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.FaultApplication;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class UserMoContainer
implements ServiceStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(UserMoContainer.class);
    private static UserMoContainer sInstance = null;
    private ConcurrentHashMap<Long, Set<Long>> userMoIdCache = new ConcurrentHashMap();
    private ManagedObject legoMo = null;
    private IUserMgrBaseService userMgr = null;
    private ICommonDao commonDao;

    private UserMoContainer() {
    }

    public static synchronized UserMoContainer getInstance() {
        if (null == sInstance) {
            sInstance = new UserMoContainer();
        }
        return sInstance;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getEventTarget() instanceof IUserMgrBaseService && event.getStatus() == Status.STATUS_STARTED) {
            this.userMgr = (IUserMgrBaseService)ServiceContext.getInstance().lookup("user/usermgr");
            this.initialize(this.userMgr);
        }
    }

    public Set<Long> getMoIdList(long userId) {
        Set<Long> moIds = this.userMoIdCache.get(userId);
        if (moIds != null) {
            moIds.add(this.legoMo.getMoId());
            moIds.add(0L);
        }
        return moIds;
    }

    public void notifyAddAndModifyUser(Map<Long, Set<Long>> userInfo) {
        this.addUserMoRelation(userInfo);
        this.userMoIdCache.putAll(userInfo);
    }

    public void addUserMoRelation(Map<Long, Set<Long>> obj) {
        if (obj == null || obj.isEmpty()) {
            return;
        }
        Set<Map.Entry<Long, Set<Long>>> entrySet = obj.entrySet();
        try {
            for (Map.Entry<Long, Set<Long>> entry : entrySet) {
                Long userId;
                if (null == entry || (userId = entry.getKey()) <= 0L) continue;
                UserRelMoInfo userRelMoInfo = new UserRelMoInfo();
                userRelMoInfo.setGroup(false);
                UserRelMo userRelMo = new UserRelMo();
                userRelMo.setMoId(this.legoMo.getMoId());
                userRelMo.setUserIdx(userId);
                userRelMoInfo.setId(userRelMo);
                Set<Long> moSet = entry.getValue();
                moSet.add(this.legoMo.getMoId());
                HashSet<UserRelMoInfo> relationList = new HashSet<UserRelMoInfo>();
                relationList.add(userRelMoInfo);
                UserRelMoInfo userRelMoInfo0 = new UserRelMoInfo();
                userRelMoInfo0.setGroup(false);
                UserRelMo userRelMo0 = new UserRelMo();
                userRelMo0.setMoId(Long.valueOf(0L));
                userRelMo0.setUserIdx(userId);
                userRelMoInfo0.setId(userRelMo0);
                moSet.add(0L);
                relationList.add(userRelMoInfo0);
                this.commonDao.saveAll(relationList);
            }
        }
        catch (Exception t) {
            logger.error((Object)"receive add user message error,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)t)});
        }
    }

    public void notifyGrandUser(Map<Long, Set<Long>> userInfo) {
        Set<Map.Entry<Long, Set<Long>>> entrySet = userInfo.entrySet();
        for (Map.Entry<Long, Set<Long>> entry : entrySet) {
            Set<Long> existMoIds = this.userMoIdCache.get(entry.getKey());
            if (existMoIds == null) continue;
            existMoIds.addAll((Collection<Long>)entry.getValue());
        }
    }

    public void notifyUnGrandUser(Map<Long, Set<Long>> userInfo) {
        Set<Map.Entry<Long, Set<Long>>> entrySet = userInfo.entrySet();
        for (Map.Entry<Long, Set<Long>> entry : entrySet) {
            Set<Long> existMoIds = this.userMoIdCache.get(entry.getKey());
            if (existMoIds == null) continue;
            existMoIds.removeAll((Collection)entry.getValue());
        }
    }

    public void notifyDeleteUser(long userId) {
        this.userMoIdCache.remove(userId);
    }

    public void notifyDeleteMo(Set<Long> moIds) {
        Set<Map.Entry<Long, Set<Long>>> entrySet = this.userMoIdCache.entrySet();
        for (Map.Entry<Long, Set<Long>> entry : entrySet) {
            Set<Long> existMoIds = entry.getValue();
            if (existMoIds == null) continue;
            existMoIds.removeAll(moIds);
        }
    }

    private void initialize(IUserMgrBaseService userMgrBaseService) {
        try {
            List userList = userMgrBaseService.getAllUser();
            for (User user : userList) {
                long userId = user.getUserId();
                if (userMgrBaseService.checkUserIsAdmin(userId).booleanValue()) continue;
                List moIdList = userMgrBaseService.getUserGrandObjects(userId);
                HashSet<Long> moIds = new HashSet<Long>();
                for (Long moId : moIdList) {
                    moIds.add(moId);
                }
                this.userMoIdCache.put(userId, moIds);
            }
        }
        catch (Exception e) {
            logger.error((Object)"initialize UserMoContainer failed\uff0cerror :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public void setFaultApp(FaultApplication faultApp) {
        this.legoMo = faultApp.getLegoSystem();
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }
}

