/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher.impl;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSyncService;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSynchronize;
import com.huawei.lego.nem.fault.sync.AlarmSynchronizer;
import com.huawei.lego.nem.fault.sync.AlarmSynchronizerBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class AlarmSyncLauncher
implements IFaultLauncher {
    private static List<AlarmSynchronizerBean> alarmSynchronizerList = Collections.synchronizedList(new ArrayList());
    private static final Log LOGGER = LogFactory.getInstance(AlarmSyncLauncher.class);
    private static AlarmSynchronizer synchronizer = null;
    private IAlarmSyncService alarmSyncSrv = null;

    private static void setAlarmSynchronizer(AlarmSynchronizer alarmSynchronizer) {
        synchronizer = alarmSynchronizer;
    }

    @Override
    public void start() {
        LOGGER.info((Object)"[FaultLauncher] begin to start AlarmSyncLauncher.");
        this.alarmSyncSrv.resetSynStatus();
    }

    @Override
    public void stop() {
        alarmSynchronizerList.clear();
    }

    public static void addAlarmSynchronizer(IAlarmSynchronize service, String productName, String trapoid) {
        LOGGER.info((Object)new StringBuilder().append("add an AlarmSynchronizer: ").append(service.getClass().getName()).append(", productName: ").append(productName).append(", trapoid: ").append(trapoid), 1L);
        AlarmSynchronizerBean serviceBean = new AlarmSynchronizerBean(productName, trapoid, service);
        alarmSynchronizerList.add(serviceBean);
    }

    public static AlarmSynchronizerBean getSynchronizer(long moId) {
        for (AlarmSynchronizerBean bean : alarmSynchronizerList) {
            IAlarmSynchronize alarmSynchronize = bean.getService();
            if (alarmSynchronize.isMyNode(moId)) {
                return bean;
            }
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "Mo is not my mo,MoId: %s, ProductName: %s,trapoid:%s.", moId, bean.getProductName(), bean.getTrapoid()), 1L);
        }
        return null;
    }

    public static AlarmSynchronizer getSynchronizer() {
        return synchronizer;
    }

    public static List<AlarmSynchronizerBean> getAllSynchronizer() {
        return alarmSynchronizerList;
    }

    public void setSynchronizer(AlarmSynchronizer synchronizer) {
        AlarmSyncLauncher.setAlarmSynchronizer(synchronizer);
    }

    public void setAlarmSyncSrv(IAlarmSyncService alarmSyncSrv) {
        this.alarmSyncSrv = alarmSyncSrv;
    }
}

