/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.launcher.impl;

import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class RedundaceDataLauncher
implements IFaultLauncher,
ServiceStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(RedundaceDataLauncher.class);
    private IAlarmService alarmSrv = null;
    private IRemoteNotifyRuleService notifyRuleSrv = null;

    @Override
    public void start() {
        LOGGER.info((Object)"[FaultLauncher] begin to start RedundaceDataLauncher.", 1L);
    }

    @Override
    public void stop() {
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getEventTarget() instanceof IResourceService) {
            try {
                String ip = this.getInstallServerIp();
                this.notifyRuleSrv.updateNotifyRuleSystemIp(ip);
            }
            catch (Exception e) {
                LOGGER.error((Object)"getHostAddress error,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            try {
                IResourceService resourceService = (IResourceService)ServiceContext.getInstance().lookup("ResourceApplication/ResourceServiceImpl");
                List moIdList = resourceService.getAllMoId();
                moIdList.add(0L);
                this.alarmSrv.deleteRedundanceInfo(moIdList);
            }
            catch (Exception e) {
                LOGGER.error((Object)"delete redundancy data exception,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public void setAlarmSrv(IAlarmService alarmSrv) {
        this.alarmSrv = alarmSrv;
    }

    public void setNotifyRuleSrv(IRemoteNotifyRuleService notifyRuleSrv) {
        this.notifyRuleSrv = notifyRuleSrv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInstallServerIp() {
        String current;
        String ips = "";
        String legoinstallPaths = "/monitor/RDInstalled.xml";
        String realPath = "";
        try {
            current = new File("").getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error((Object)"get current path failed: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return ips;
        }
        realPath = this.getRealPath(legoinstallPaths, current);
        SAXReader readers = new SAXReader();
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(realPath);
            CommonUtil.setSecurityFeatures((SAXReader)readers);
            document = readers.read((InputStream)inputStream);
            ips = InetAddress.getLocalHost().getHostAddress();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "The default ip is:%s.", ips), 1L);
            if (null == document) {
                LOGGER.error((Object)"The documents is null.", 1L);
                String string = ips;
                return string;
            }
            Node nodes = document.selectSingleNode("//install/httpsip");
            if (nodes != null) {
                ips = nodes.getText();
                LOGGER.info((Object)String.format(Locale.ENGLISH, "The lego install ips is:%s.", ips), 1L);
                String string = ips;
                return string;
            }
            String string = ips;
            return string;
        }
        catch (Exception ee) {
            LOGGER.error((Object)"Get install ip fail, errors is:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ee)});
        }
        finally {
            if (null != inputStream) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ex) {
                    LOGGER.error((Object)"Close the inputstream failed, the error is:", (Throwable)ex, 1L);
                }
            }
        }
        return ips;
    }

    private String getRealPath(String legoinstallPaths, String current) {
        String legoruntimes = "/LegoRuntime";
        int lengthDiff = 0;
        String newCurrentPaths = "";
        if (current != null && (lengthDiff = current.length() - legoruntimes.length()) >= 0) {
            newCurrentPaths = current.substring(0, lengthDiff);
        }
        String realPath = newCurrentPaths + legoinstallPaths;
        return realPath;
    }
}

