/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.persistence;

import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.nem.fault.define.FaultDefineUtil;
import com.huawei.lego.nem.fault.msg.FaultMsg;
import com.huawei.lego.nem.fault.msg.FaultMsgDispatcher;
import com.huawei.lego.nem.fault.msg.FaultMsgType;
import com.huawei.lego.nem.fault.persistence.AlarmObject;
import com.huawei.lego.nem.fault.persistence.IFaultPersistence;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.RestoreInfo;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;

public class FaultDBAPI {
    private static final int VALUE_1000 = 1000;
    private static final int VALUE_1000000 = 1000000;
    private static final String NOT_GENERATE_ALARMS = "NotGenerateAlarms";
    private static final Log LOGGER = LogFactory.getInstance(FaultDBAPI.class);
    private static FaultDBAPI sInstance = null;
    private boolean lockTag = false;
    private Object syncLock = new Object();
    private Map<String, AlarmObject> alarmMap = new LinkedHashMap<String, AlarmObject>();
    private MultiMap historyMap = new MultiHashMap();
    private IFaultPersistence faultPersistence = null;

    private FaultDBAPI() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    FaultDBAPI.this.flush();
                }
                catch (Exception t) {
                    LOGGER.error((Object)("exception occured when saveAlarmAndAnnotation(), " + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static synchronized FaultDBAPI getInstanse() {
        if (sInstance == null) {
            sInstance = new FaultDBAPI();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processAlarm(Alarm alarm, FaultMsgType msgType) {
        boolean bl;
        Alarm updateAlarm;
        String entity;
        boolean existInDB;
        block10: {
            block9: {
                if (!this.isAlarmGenerate(alarm)) {
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "The alarm is not generate, the alarmId is : %s.", alarm.getAlarmId()));
                    return false;
                }
                existInDB = false;
                entity = null;
                entity = alarm.getEntity();
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm lock:%s.", System.currentTimeMillis()), 1L);
                this.lock();
                updateAlarm = null;
                AlarmObject alarmObject = this.alarmMap.get(entity);
                if (null != alarmObject) {
                    updateAlarm = alarmObject.getAlarm();
                    existInDB = alarmObject.isExistInDb();
                }
                if (null == updateAlarm && null != (updateAlarm = this.faultPersistence.getAlarm(entity))) {
                    existInDB = true;
                }
                if (null != updateAlarm) break block9;
                this.setAlarmMap(alarm, msgType, existInDB, entity);
                boolean bl2 = true;
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
                this.unLock();
                return bl2;
            }
            if (!this.isNoInsertAlarm(alarm, updateAlarm)) break block10;
            LOGGER.info((Object)String.format(Locale.ENGLISH, "AlarmAPI: alarm is not restore,no insert.entity:%s.", entity), 1L);
            boolean bl3 = false;
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
            this.unLock();
            return bl3;
        }
        try {
            this.setUpdateProp(updateAlarm, alarm);
            updateAlarm.setExtProps(alarm.getExtProps());
            alarm.setGmt(updateAlarm.getGmt());
            this.alarmMap.put(entity, new AlarmObject(existInDB, updateAlarm));
            Annotation anntation = this.createAnnotation(alarm);
            this.historyMap.put((Object)entity, (Object)new FaultMsg(msgType, alarm, anntation));
            bl = true;
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)("AlarmAPI: Exception from processAlarm: " + entity + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            catch (Throwable throwable) {
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
                this.unLock();
                throw throwable;
            }
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
            this.unLock();
            return false;
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
        this.unLock();
        return bl;
    }

    private void setAlarmMap(Alarm alarm, FaultMsgType msgType, boolean existInDB, String entity) {
        alarm.setCreateTime(alarm.getModTime());
        alarm.setCount(1);
        this.alarmMap.put(entity, new AlarmObject(existInDB, alarm));
        Annotation anntation = this.createAnnotation(alarm);
        this.historyMap.put((Object)entity, (Object)new FaultMsg(msgType, alarm, anntation));
    }

    private boolean isNoInsertAlarm(Alarm alarm, Alarm updateAlarm) {
        LOGGER.debug((Object)"enter isNoInsertAlarm");
        if (updateAlarm.getClearStatus() != 0) {
            return false;
        }
        if ("0x000803220001".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220003".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220004".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220002".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220005".equalsIgnoreCase(alarm.getAlarmId()) || "0x00080322000f".equalsIgnoreCase(alarm.getAlarmId())) {
            return true;
        }
        if ("0x3230036".equalsIgnoreCase(alarm.getAlarmId())) {
            return true;
        }
        return this.isThresholdAlarm(alarm.getAlarmId(), alarm.getDesc());
    }

    public boolean processEvent(Event event) {
        try {
            this.faultPersistence.addEvent(event);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("AlarmAPI: Exception from processEvent: " + event.getEntity() + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Alarm processRestoreAlarm(RestoreInfo restoreInfo, String lockAlias, Alarm alarm) {
        Alarm restoredAlarm;
        String entity;
        boolean existInDB;
        block13: {
            existInDB = false;
            entity = null;
            entity = restoreInfo.getRestoredEntity();
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm lock:%s.", System.currentTimeMillis()), 1L);
            this.lock();
            restoredAlarm = null;
            if (null != this.alarmMap.get(restoreInfo.getRestoredEntity())) {
                restoredAlarm = this.alarmMap.get(restoreInfo.getRestoredEntity()).getAlarm();
                existInDB = this.alarmMap.get(restoreInfo.getRestoredEntity()).isExistInDb();
            }
            if (null == restoredAlarm && null != (restoredAlarm = this.faultPersistence.getAlarm(restoreInfo.getRestoredEntity()))) {
                existInDB = true;
            }
            if (null != restoredAlarm) break block13;
            this.printDebugLog(restoreInfo);
            Alarm alarm2 = null;
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm unlock:%s.", System.currentTimeMillis()), 1L);
            this.unLock();
            return alarm2;
        }
        if (this.isSetTime(alarm, restoreInfo, restoredAlarm)) {
            restoreInfo.setTtime(restoredAlarm.getModTime());
        }
        if (restoredAlarm.getConfirmStatus() != 1) {
            this.setRestoredAlarm(alarm, restoredAlarm);
        }
        Alarm alarm3 = this.setRestoredAlarmParameter(restoreInfo, alarm, existInDB, entity, restoredAlarm);
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm unlock:%s.", System.currentTimeMillis()), 1L);
        this.unLock();
        return alarm3;
        {
            catch (LegoCheckedException e) {
                Alarm alarm4;
                block14: {
                    if (!this.checkNoInsert(alarm)) break block14;
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "No insert annotation,alarmId=%s.", alarm.getAlarmId()), 1L);
                    Alarm alarm5 = null;
                    LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm unlock:%s.", System.currentTimeMillis()), 1L);
                    this.unLock();
                    return alarm5;
                }
                try {
                    this.setRestoredAlarm(alarm, restoredAlarm);
                    this.setDetailInfo(restoreInfo, alarm);
                    alarm4 = this.resetAlarmAfterException(restoreInfo, alarm, existInDB, entity, restoredAlarm);
                }
                catch (Exception e2) {
                    try {
                        LOGGER.error((Object)("AlarmAPI: Exception from processRestoreAlarm: " + entity + ExceptionUtil.getErrorMessage((Throwable)e2)), 1L);
                    }
                    catch (Throwable throwable) {
                        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm unlock:%s.", System.currentTimeMillis()), 1L);
                        this.unLock();
                        throw throwable;
                    }
                    LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm unlock:%s.", System.currentTimeMillis()), 1L);
                    this.unLock();
                }
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessRestoreAlarm unlock:%s.", System.currentTimeMillis()), 1L);
                this.unLock();
                return alarm4;
            }
        }
        return null;
    }

    private void setDetailInfo(RestoreInfo restoreInfo, Alarm alarm) {
        Annotation anno = this.saveAnnotation(restoreInfo, alarm);
        this.historyMap.put((Object)anno.getEntity(), (Object)new FaultMsg(FaultMsgType.RESTORE_ALARM, alarm, anno, false));
        LOGGER.debug((Object)"AlarmAPI:insert history alarm success.", 1L);
    }

    private void setRestoredAlarm(Alarm alarm, Alarm restoredAlarm) {
        restoredAlarm.setConfirmStatus(alarm.getConfirmStatus());
        restoredAlarm.setConfirmTime(alarm.getConfirmTime());
        restoredAlarm.setConfirmUser(alarm.getConfirmUser());
    }

    private void printDebugLog(RestoreInfo restoreInfo) {
        LOGGER.debug((Object)new StringBuilder().append("AlarmAPI: no correspond restored alarm, entity: ").append(restoreInfo.getRestoredEntity()).append(", time: ").append(restoreInfo.getTtime()).append(", clearTime: ").append(restoreInfo.getClearTime()).append(", clearUser: ").append(restoreInfo.getClearUser()).append(", sequence: ").append(restoreInfo.getSequence()), 1L);
    }

    private Alarm setRestoredAlarmParameter(RestoreInfo restoreInfo, Alarm alarm, boolean existInDB, String entity, Alarm restoredAlarm) {
        Annotation annotation = this.processAnnotation(restoreInfo, restoredAlarm);
        restoreInfo.setTtime(annotation.getModTime());
        LOGGER.debug((Object)"AlarmAPI:update history alarm successful.", 1L);
        if (this.isSetClearAlarm(restoreInfo, restoredAlarm)) {
            LOGGER.debug((Object)"AlarmAPI:update alarm successful.", 1L);
            restoredAlarm.setClearStatus(1);
            restoredAlarm.setClearTime(restoreInfo.getClearTime());
            restoredAlarm.setClearUser(restoreInfo.getClearUser());
            alarm.setClearStatus(1);
            alarm.setClearTime(restoreInfo.getClearTime());
            alarm.setClearUser(restoreInfo.getClearUser());
            alarm.setGmt(restoredAlarm.getGmt());
            this.setAlarmParam(alarm, restoredAlarm);
            restoredAlarm.setExtProps(alarm.getExtProps());
            this.alarmMap.put(entity, new AlarmObject(existInDB, restoredAlarm));
            FaultDefineUtil.appendDefineProps(alarm, alarm.getFaultDefine());
            this.historyMap.put((Object)annotation.getEntity(), (Object)new FaultMsg(FaultMsgType.RESTORE_ALARM, alarm, annotation));
            return restoredAlarm;
        }
        this.historyMap.put((Object)annotation.getEntity(), (Object)new FaultMsg(FaultMsgType.RESTORE_ALARM, alarm, annotation, false));
        return null;
    }

    private Alarm resetAlarmAfterException(RestoreInfo restoreInfo, Alarm alarm, boolean existInDB, String entity, Alarm restoredAlarm) {
        this.extractMethod(restoreInfo, restoredAlarm);
        this.setAlarmParam(alarm, restoredAlarm);
        restoredAlarm.setExtProps(alarm.getExtProps());
        alarm.setClearStatus(1);
        alarm.setClearTime(restoreInfo.getClearTime());
        alarm.setClearUser(restoreInfo.getClearUser());
        alarm.setGmt(restoredAlarm.getGmt());
        this.alarmMap.put(entity, new AlarmObject(existInDB, restoredAlarm));
        FaultDefineUtil.appendDefineProps(alarm, alarm.getFaultDefine());
        Annotation anno = this.updateAnnotation(alarm);
        this.historyMap.put((Object)anno.getEntity(), (Object)new FaultMsg(FaultMsgType.RESTORE_ALARM, alarm, anno));
        LOGGER.debug((Object)"AlarmAPI:insert alarm successful.", 1L);
        return restoredAlarm;
    }

    private boolean isAlarmGenerate(Alarm alarm) {
        if (null == alarm) {
            LOGGER.error((Object)"alarm is null");
            return false;
        }
        LegoBaseConfig legoConfig = LegoBaseConfig.getInstance();
        legoConfig.reloadConfigProperties();
        String alarms = legoConfig.getKeyValue(NOT_GENERATE_ALARMS, "");
        List<String> alarmIds = Arrays.asList(alarms.split(","));
        return !alarmIds.contains(alarm.getAlarmId());
    }

    private boolean checkNoInsert(Alarm alarm) {
        LOGGER.debug((Object)"enter checkNoInsert");
        return this.isNoInsertRestore(alarm) || this.isThresholdAlarm(alarm.getFaultDefine().getFaultId(), alarm.getFaultDefine().getFaultDesc());
    }

    private void extractMethod(RestoreInfo restoreInfo, Alarm restoredAlarm) {
        LOGGER.debug((Object)"enter extractMethod");
        if (restoredAlarm.getModTime() <= restoreInfo.getTtime()) {
            restoredAlarm.setClearStatus(1);
            restoredAlarm.setClearTime(restoreInfo.getClearTime());
            restoredAlarm.setClearUser(restoreInfo.getClearUser());
        }
        restoredAlarm.setCount(restoredAlarm.getCount() + 1);
        if (restoredAlarm.getCreateTime() > restoreInfo.getTtime()) {
            restoredAlarm.setCreateTime(restoreInfo.getTtime());
        } else if (restoredAlarm.getModTime() < restoreInfo.getTtime()) {
            restoredAlarm.setModTime(restoreInfo.getTtime());
        }
    }

    private void setAlarmParam(Alarm alarm, Alarm restoredAlarm) {
        if (!this.isVsmAlarm(alarm)) {
            LOGGER.debug((Object)"", 1L);
        }
        if (!this.isThresholdAlarm(alarm.getFaultDefine().getFaultId(), alarm.getFaultDefine().getFaultDesc())) {
            return;
        }
        if (null != alarm.getDesc() && !"".equals(alarm.getDesc())) {
            restoredAlarm.setDesc(alarm.getDesc());
        }
    }

    private boolean isNoInsertRestore(Alarm alarm) {
        LOGGER.debug((Object)"enter isNoInsertRestore");
        if ("0x000803220001".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220003".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220004".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220002".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220005".equalsIgnoreCase(alarm.getAlarmId()) || "0x00080322000f".equalsIgnoreCase(alarm.getAlarmId())) {
            return true;
        }
        return this.isVsmAlarm(alarm);
    }

    private boolean isSetTime(Alarm alarm, RestoreInfo restoreInfo, Alarm restoredAlarm) {
        LOGGER.debug((Object)"enter isSetTime");
        if (restoredAlarm.getModTime() >= restoreInfo.getTtime()) {
            return false;
        }
        if ("0x000803220001".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220003".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220004".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220002".equalsIgnoreCase(alarm.getAlarmId()) || "0x000803220005".equalsIgnoreCase(alarm.getAlarmId()) || "0x00080322000f".equalsIgnoreCase(alarm.getAlarmId())) {
            return true;
        }
        if (this.isThresholdAlarm(alarm.getFaultDefine().getFaultId(), alarm.getFaultDefine().getFaultDesc())) {
            return true;
        }
        return this.isVsmAlarm(alarm);
    }

    private boolean isThresholdAlarm(String alarmId, String alarmDesc) {
        LOGGER.debug((Object)"enter isThresholdAlarm");
        if (!"".equals(alarmId)) {
            return false;
        }
        return "perf.threshold.alarm.desc".equals(alarmDesc) || "perf.threshold.alarm.max.desc".equals(alarmDesc) || "perf.threshold.alarm.min.desc".equals(alarmDesc) || "perf.threshold.alarm.reset.max.desc".equals(alarmDesc) || "perf.threshold.alarm.reset.min.desc".equals(alarmDesc);
    }

    private boolean isSetClearAlarm(RestoreInfo restoreInfo, Alarm restoredAlarm) {
        LOGGER.debug((Object)"enter isSetClearAlarm");
        if (restoredAlarm.getClearStatus() == 1) {
            return false;
        }
        if (restoredAlarm.getModTime() == restoreInfo.getTtime()) {
            return true;
        }
        return restoreInfo.getSequence() > 0L && restoreInfo.getSequence() == restoredAlarm.getSequence();
    }

    private boolean isVsmAlarm(Alarm alarm) {
        LOGGER.debug((Object)"enter isVsmAlarm");
        String matchAlarm = alarm.getFaultDefine().getMatchAlarm();
        if (null != matchAlarm && "true".equalsIgnoreCase(matchAlarm)) {
            return true;
        }
        return null != alarm.getRelateId() && !"".equals(alarm.getRelateId());
    }

    private Annotation processAnnotation(RestoreInfo restoreInfo, Alarm restoredAlarm) {
        LOGGER.debug((Object)"enter processAnnotation");
        Alarm alarm = new Alarm();
        alarm.setClearStatus(1);
        alarm.setClearTime(restoreInfo.getClearTime());
        alarm.setClearUser(restoreInfo.getClearUser());
        alarm.setEntity(restoreInfo.getRestoredEntity());
        alarm.setSequence(restoreInfo.getSequence());
        alarm.setModTime(restoreInfo.getTtime());
        alarm.setConfirmStatus(restoredAlarm.getConfirmStatus());
        alarm.setConfirmTime(restoredAlarm.getConfirmTime());
        alarm.setConfirmUser(restoredAlarm.getConfirmUser());
        return this.updateAnnotation(alarm);
    }

    public boolean clearAlarmAndAnnotation(Alarm alarm) {
        boolean result = false;
        String entity = null;
        try {
            entity = alarm.getEntity();
            this.alarmMap.put(entity, new AlarmObject(true, alarm));
            Annotation annotation = this.updateAnnotation(alarm);
            this.historyMap.put((Object)annotation.getEntity(), (Object)new FaultMsg(FaultMsgType.MANUCLEAR_ALARM, alarm, annotation));
            result = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("AlarmAPI: Exception from clearAlarmAndAnnotation: " + entity + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return result;
    }

    public boolean confirmAlarmAndAnnotation(Alarm alarm) {
        boolean result = false;
        String entity = null;
        try {
            entity = alarm.getEntity();
            this.alarmMap.put(entity, new AlarmObject(true, alarm));
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "AlarmAPI: confirmAlarmAndAnnotation entity: %s.", entity), 1L);
            Annotation annotation = this.getAnnotation(alarm);
            if (annotation == null) {
                LOGGER.error((Object)("AlarmAPI: get Annotation return null, entity: " + alarm.getEntity()));
                throw new LegoCheckedException(201L);
            }
            annotation.setConfirmStatus(alarm.getConfirmStatus());
            annotation.setConfirmUser(alarm.getConfirmUser());
            annotation.setConfirmTime(alarm.getConfirmTime());
            if (alarm.getConfirmStatus() == 1) {
                this.historyMap.put((Object)annotation.getEntity(), (Object)new FaultMsg(FaultMsgType.CONFIRM_ALARM, alarm, annotation));
            } else {
                this.historyMap.put((Object)annotation.getEntity(), (Object)new FaultMsg(FaultMsgType.UNCONFIRM_ALARM, alarm, annotation));
            }
            result = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("AlarmAPI: Exception from confirmAlarmAndAnnotation:" + entity + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return result;
    }

    private void setUpdateProp(Alarm updateAlarm, Alarm alarm) {
        LOGGER.debug((Object)"enter setUpdateProp");
        updateAlarm.setSeverity(alarm.getSeverity());
        updateAlarm.setMoId(alarm.getMoId());
        this.setAlarmExtendProp(updateAlarm, alarm);
        IAlarmService service = (IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class);
        int oldCount = service.getAlarmDetailsCount(alarm.getEntity());
        updateAlarm.setCount(++oldCount);
        updateAlarm.setIsFilterForThirdDevice(alarm.getIsFilterForThirdDevice());
        if (updateAlarm.getCreateTime() > alarm.getModTime()) {
            updateAlarm.setCreateTime(alarm.getModTime());
        }
        updateAlarm.setModTime(alarm.getModTime());
        updateAlarm.setSourceId(alarm.getSourceId());
        updateAlarm.setSourceType(alarm.getSourceType());
    }

    private void setAlarmExtendProp(Alarm updateAlarm, Alarm alarm) {
        LOGGER.debug((Object)"enter setAlarmExtendProp");
        updateAlarm.setMoName(alarm.getMoName());
        updateAlarm.setSequence(alarm.getSequence());
        updateAlarm.setMoIP(alarm.getMoIP());
        updateAlarm.setMoMainType(alarm.getMoMainType());
        updateAlarm.setMoSubType(alarm.getMoSubType());
        updateAlarm.setAdvice(alarm.getAdvice());
        updateAlarm.setParams(alarm.getParams());
        updateAlarm.setLocation(alarm.getLocation());
        updateAlarm.setProductName(alarm.getProductName());
        updateAlarm.setDesc(alarm.getDesc());
        updateAlarm.setParams(alarm.getParams());
        if (alarm.getClearStatus() == 1) {
            updateAlarm.setClearStatus(FaultEnum.ClearState.CLEARED.getValue());
            updateAlarm.setClearTime(alarm.getClearTime());
            updateAlarm.setClearUser("system");
        } else {
            updateAlarm.setClearStatus(FaultEnum.ClearState.UNCLEARED.getValue());
            updateAlarm.setClearTime(0L);
            updateAlarm.setClearUser("");
        }
        updateAlarm.setConfirmStatus(alarm.getConfirmStatus());
        updateAlarm.setConfirmTime(alarm.getConfirmTime());
        updateAlarm.setConfirmUser(alarm.getConfirmUser());
    }

    private Annotation createAnnotation(Alarm alarm) {
        LOGGER.debug((Object)"enter createAnnotation");
        String entity = alarm.getEntity();
        Annotation history = new Annotation();
        history.setEntity(entity);
        history.setModTime(alarm.getModTime());
        history.setSequence(alarm.getSequence());
        history.setClearStatus(alarm.getClearStatus());
        history.setClearTime(alarm.getClearTime());
        history.setClearUser(alarm.getClearUser());
        history.setConfirmStatus(alarm.getConfirmStatus());
        history.setConfirmTime(alarm.getConfirmTime());
        history.setConfirmUser(alarm.getConfirmUser());
        return history;
    }

    private Annotation updateAnnotation(Alarm alarm) {
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "AlarmAPI: updateAnnotation entity: %s.", alarm.getEntity()), 1L);
        Annotation annotation = this.getAnnotation(alarm);
        if (annotation == null) {
            LOGGER.error((Object)("AlarmAPI: get Annotation return null, entity: " + alarm.getEntity()));
            throw new LegoCheckedException(201L);
        }
        if (annotation.getClearStatus() == 1) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "AlarmAPI: annotation is cleared, entity: %s.", alarm.getEntity()), 1L);
            return annotation;
        }
        annotation.setClearStatus(FaultEnum.ClearState.CLEARED.getValue());
        annotation.setClearUser(alarm.getClearUser());
        annotation.setClearTime(alarm.getClearTime());
        if (annotation.getConfirmStatus() != 1) {
            annotation.setConfirmStatus(alarm.getConfirmStatus());
            annotation.setConfirmTime(alarm.getConfirmTime());
            annotation.setConfirmUser(alarm.getConfirmUser());
        }
        return annotation;
    }

    private Annotation saveAnnotation(RestoreInfo restoreInfo, Alarm alarm) {
        LOGGER.debug((Object)"enter saveAnnotation");
        Annotation annotation = new Annotation();
        annotation.setClearStatus(FaultEnum.ClearState.CLEARED.getValue());
        annotation.setClearUser(restoreInfo.getClearUser());
        annotation.setClearTime(restoreInfo.getClearTime());
        annotation.setEntity(restoreInfo.getRestoredEntity());
        annotation.setModTime(restoreInfo.getTtime());
        annotation.setSequence(restoreInfo.getSequence());
        annotation.setConfirmStatus(alarm.getConfirmStatus());
        annotation.setConfirmTime(alarm.getConfirmTime());
        annotation.setConfirmUser(alarm.getConfirmUser());
        return annotation;
    }

    private Annotation getAnnotation(Alarm alarm) {
        long sequence;
        Annotation annotation = null;
        Object object = this.historyMap.get((Object)alarm.getEntity());
        if (object instanceof List) {
            List valuelist = (List)object;
            for (int i = valuelist.size() - 1; i >= 0; --i) {
                annotation = ((FaultMsg)valuelist.get(i)).getAnnotation();
                if (!this.isExistAnnotation(alarm, annotation)) continue;
                return annotation;
            }
        } else if (object instanceof FaultMsg && this.isExistAnnotation(alarm, annotation = ((FaultMsg)object).getAnnotation())) {
            return annotation;
        }
        annotation = -1L != (sequence = alarm.getSequence()) ? this.faultPersistence.getAnnotationBySN(alarm.getEntity(), sequence) : this.faultPersistence.getAnnotationByTime(alarm.getEntity(), alarm.getModTime());
        object = this.historyMap.get((Object)alarm.getEntity());
        if (object instanceof List) {
            List valuelist = (List)object;
            int i = valuelist.size() - 1;
            if (i >= 0) {
                annotation = ((FaultMsg)valuelist.get(i)).getAnnotation();
                return annotation;
            }
        } else {
            if (object instanceof FaultMsg) {
                annotation = ((FaultMsg)object).getAnnotation();
                return annotation;
            }
            annotation = this.faultPersistence.getTheLastAnnotation(alarm.getEntity());
        }
        this.extractNullThrow(alarm, annotation);
        return annotation;
    }

    private void extractNullThrow(Alarm alarm, Annotation annotation) {
        LOGGER.debug((Object)"enter extractNullThrow");
        if (null == annotation) {
            throw new LegoCheckedException("AlarmAPI: get Annotation return null, entity: " + alarm.getEntity());
        }
    }

    private boolean isExistAnnotation(Alarm alarm, Annotation annotation) {
        LOGGER.debug((Object)"enter isExistAnnotation");
        long sequence = alarm.getSequence();
        if (-1L != sequence && annotation.getSequence() == sequence) {
            return true;
        }
        return -1L == sequence && annotation.getModTime() == alarm.getModTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        long startTime = System.currentTimeMillis();
        block8: while (true) {
            try {
                Object object;
                do {
                    object = this.syncLock;
                    synchronized (object) {
                        if (!this.lockTag) {
                            this.lockTag = true;
                            break block8;
                        }
                    }
                    CommonUtil.sleep((long)100L);
                } while (System.currentTimeMillis() - startTime <= 120000L);
                LOGGER.debug((Object)"get lock exceed 2 minutes.", 1L);
                object = this.syncLock;
                synchronized (object) {
                    this.lockTag = true;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("get lock fail" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLock() {
        Object object = this.syncLock;
        synchronized (object) {
            this.lockTag = false;
        }
    }

    public void flush() {
        this.flushLego();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLego() {
        if (this.alarmMap.size() > 1000000 || this.historyMap.size() >= 1000000) {
            this.alarmMap.clear();
            this.historyMap.clear();
            return;
        }
        if (this.alarmMap.isEmpty() && this.historyMap.isEmpty()) {
            return;
        }
        try {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "Flush lock:%s.", System.currentTimeMillis()), 1L);
            this.lock();
            Collection historys = this.historyMap.values();
            this.faultPersistence.saveOrUpdateAlarms(this.alarmMap.values(), historys);
            for (Object history : historys) {
                if (history instanceof List) {
                    List msgList = (List)history;
                    this.dealList(msgList);
                    continue;
                }
                if (!(history instanceof FaultMsg)) continue;
                FaultMsg faultMsg = (FaultMsg)history;
                this.dealFaultMsg(faultMsg);
            }
            this.alarmMap.clear();
        }
        catch (Exception t) {
            try {
                LOGGER.error((Object)("flush error." + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
                this.alarmMap.clear();
            }
            catch (Throwable throwable) {
                this.alarmMap.clear();
                this.historyMap.clear();
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "Flush unlock:%s.", System.currentTimeMillis()), 1L);
                this.unLock();
                throw throwable;
            }
            this.historyMap.clear();
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "Flush unlock:%s.", System.currentTimeMillis()), 1L);
            this.unLock();
        }
        this.historyMap.clear();
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Flush unlock:%s.", System.currentTimeMillis()), 1L);
        this.unLock();
    }

    private void dealList(List<FaultMsg> msgList) {
        LOGGER.debug((Object)"enter dealList");
        for (FaultMsg faultMsg : msgList) {
            if (!faultMsg.isNeedNotify()) continue;
            Alarm tmpAlarm = this.getAlarmFast(faultMsg.getAlarm().getEntity());
            if (null != tmpAlarm && !"".equals(tmpAlarm.getLocation())) {
                faultMsg.getAlarm().setLocation(tmpAlarm.getLocation());
            }
            FaultMsgDispatcher.getInstance().notity(faultMsg);
        }
    }

    private void dealFaultMsg(FaultMsg faultMsg) {
        LOGGER.debug((Object)"enter dealFaultMsg");
        if (faultMsg.isNeedNotify()) {
            Alarm tmpAlarm = this.getAlarmFast(faultMsg.getAlarm().getEntity());
            if (null != tmpAlarm && !"".equals(tmpAlarm.getLocation())) {
                faultMsg.getAlarm().setLocation(tmpAlarm.getLocation());
                this.logLocation(faultMsg, tmpAlarm);
            }
            FaultMsgDispatcher.getInstance().notity(faultMsg);
        }
    }

    private void logLocation(FaultMsg faultMsg, Alarm tmpAlarm) {
        int length;
        if (null != faultMsg.getAlarm() && null != faultMsg.getAlarm().getLocation() && (length = faultMsg.getAlarm().getLocation().split("\\.alarm").length) > 1) {
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "Alarm location length is:%s.old location is:.new location is:%s.", length, tmpAlarm.getLocation()), 1L);
        }
    }

    public Alarm getAlarmFast(String entity) {
        AlarmObject alarmObject = this.alarmMap.get(entity);
        if (null != alarmObject) {
            return alarmObject.getAlarm();
        }
        return this.faultPersistence.getAlarm(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearAlertAndHistory(Alarm alarm, long aaid) {
        Annotation annotation;
        String entity;
        boolean result;
        block5: {
            result = false;
            entity = null;
            LOGGER.debug((Object)"start get faultDBAPI lock", 1L);
            this.lock();
            annotation = this.faultPersistence.getAnnotation(aaid);
            entity = alarm.getEntity();
            this.alarmMap.put(entity, new AlarmObject(true, alarm));
            if (annotation.getClearStatus() != 1) break block5;
            LOGGER.info((Object)String.format(Locale.ENGLISH, "ExtendAlertAPI: alertDetail is cleared, entity: %s.", alarm.getEntity()), 1L);
            boolean bl = true;
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
            this.unLock();
            return bl;
        }
        try {
            annotation.setClearStatus(FaultEnum.ClearState.CLEARED.getValue());
            annotation.setClearUser(alarm.getClearUser());
            annotation.setClearTime(alarm.getClearTime());
            this.historyMap.put((Object)annotation.getEntity(), (Object)new FaultMsg(FaultMsgType.MANUCLEAR_ALARM, alarm, annotation));
            result = true;
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)("ExtendAlertAPI: Exception from clearAlertAndHistory: " + entity + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            catch (Throwable throwable) {
                LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
                this.unLock();
                throw throwable;
            }
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
            this.unLock();
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "ProcessAlarm unlock:%s.", System.currentTimeMillis()), 1L);
        this.unLock();
        return result;
    }

    public Alarm getAlarmFromCache(String entity) {
        AlarmObject alarmObject = this.alarmMap.get(entity);
        if (null != alarmObject) {
            return alarmObject.getAlarm();
        }
        return null;
    }

    public void setFaultPersistence(IFaultPersistence faultPersistence) {
        this.faultPersistence = faultPersistence;
    }
}

