/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.filter;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.decorator.FaultDecoratorMgr;
import com.huawei.lego.nem.fault.define.FaultDefineUtil;
import com.huawei.lego.nem.fault.launcher.impl.TrapReceiverLauncher;
import com.huawei.lego.nem.fault.msg.FaultMsgCenter;
import com.huawei.lego.nem.fault.msg.FaultMsgType;
import com.huawei.lego.nem.fault.persistence.IFaultPersistence;
import com.huawei.lego.nem.fault.sdk.decorator.IFaultDecorator;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.AlarmPDU;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.model.LegoEvent;
import com.huawei.lego.nem.fault.sdk.model.SnmpTrapPDU;
import com.huawei.lego.nem.fault.sdk.service.IPDUFilter;
import com.huawei.lego.nem.fault.sdk.service.ITrapService;
import com.huawei.lego.nem.fault.shield.AlarmShielder;
import com.huawei.lego.nem.fault.util.FaultUtil;
import org.snmp4j.CommandResponderEvent;

public class SnmpFaultFilter
implements IPDUFilter {
    private static final int VALUE_2000 = 2000;
    private Log logger = LogFactory.getInstance(SnmpFaultFilter.class);
    private IFaultPersistence faultPersistence = null;

    public void doFilter(AlarmPDU alarmPdu) {
        try {
            CommandResponderEvent snmpEvent = (CommandResponderEvent)alarmPdu.getPduObj();
            SnmpTrapPDU snmppdu = FaultUtil.convertSnmpPDU(snmpEvent);
            String agentIP = snmppdu.getRemoteHost();
            String trapoid = snmppdu.getTrapoid();
            ITrapService trapSrv = TrapReceiverLauncher.getTrapService(agentIP, trapoid);
            if (null == trapSrv) {
                this.logger.info((Object)("no ITrapService was found, the alarm trap from: " + agentIP + ", trapoid: " + trapoid), 1L);
                return;
            }
            boolean isDuplicated = trapSrv.isTrapDuplacated(snmppdu);
            if (isDuplicated) {
                this.logger.info((Object)("recv a duplicated trappdu, host: " + agentIP + ", trapoid: " + trapoid), 1L);
                return;
            }
            LegoEvent legoEvent = trapSrv.parseEvent(snmppdu);
            if (null == legoEvent) {
                CommonUtil.sleep((long)2000L);
                legoEvent = trapSrv.parseEvent(snmppdu);
                if (null == legoEvent) {
                    this.logger.info((Object)("parseFault return null, host: " + agentIP + ", trapoid: " + trapoid), 1L);
                    return;
                }
            }
            this.initFaultDefine(trapoid, trapSrv, legoEvent);
        }
        catch (Exception ex) {
            this.logger.error((Object)("exception happened when filter snmp event:" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
    }

    private void initFaultDefine(String trapoid, ITrapService trapSrv, LegoEvent legoEvent) {
        FaultDefine faultDefine = null;
        if (null == legoEvent.getFaultDefine()) {
            faultDefine = TrapReceiverLauncher.getFaultDefine(trapSrv, legoEvent);
            if (null == faultDefine) {
                this.logger.info((Object)("no FaultDefine exist in Database, faultId: " + legoEvent.getEventId() + ", trapoid: " + trapoid), 1L);
                return;
            }
            legoEvent.setFaultDefine(faultDefine);
        } else {
            faultDefine = legoEvent.getFaultDefine();
        }
        int trapType = legoEvent.getTrapType();
        if (-1 == trapType) {
            this.logger.info((Object)"createNewAlert:product no set trapType.", 1L);
            trapType = legoEvent.getFaultDefine().getTrapType();
            legoEvent.setTrapType(trapType);
        }
        this.extractComplexity(legoEvent, faultDefine, trapType);
    }

    private void extractComplexity(LegoEvent legoEvent, FaultDefine faultDefine, int trapType) {
        if (trapType == 0) {
            this.processEvent(legoEvent, faultDefine);
        } else if (trapType == 2) {
            this.processRestore(legoEvent, faultDefine);
        } else {
            IFaultDecorator decorator;
            Alarm alarm = FaultUtil.legoEvenToAlarm(legoEvent);
            if (null != alarm) {
                FaultDefineUtil.appendDefineProps(alarm, faultDefine);
                if (AlarmShielder.getInstance().isFilterAlarm(alarm)) {
                    alarm.setIsFilterForThirdDevice("1");
                }
            }
            if (null != (decorator = FaultDecoratorMgr.getInstance().getDecorator(alarm))) {
                alarm = decorator.decorateAlarm(alarm);
            }
            LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
            FaultMsgCenter.sendMessage(FaultMsgType.ALARM, legoAlarm);
        }
    }

    private void processEvent(LegoEvent legoEvent, FaultDefine faultDefine) {
        Event event = FaultUtil.legoEventToEvent(legoEvent);
        if (event != null) {
            FaultDefineUtil.appendDefineProps(event, faultDefine);
            IFaultDecorator decorator = FaultDecoratorMgr.getInstance().getDecorator(event);
            if (null != decorator) {
                event = decorator.decorateEvent(event);
            }
            this.faultPersistence.addEvent(event);
        }
    }

    private void processRestore(LegoEvent legoEvent, FaultDefine faultDefine) {
        IFaultDecorator decorator;
        Alarm alarm = FaultUtil.legoEvenToAlarm(legoEvent);
        if (null != alarm) {
            FaultDefineUtil.appendDefineProps(alarm, faultDefine);
        }
        if (null != (decorator = FaultDecoratorMgr.getInstance().getDecorator(alarm))) {
            alarm = decorator.decorateAlarm(alarm);
        }
        LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
        FaultMsgCenter.sendRestoreMessage(FaultMsgType.RESTORE_ALARM, legoAlarm);
    }

    public FaultEnum.PDUType getPduType() {
        return FaultEnum.PDUType.SNMP;
    }

    public void setFaultPersistence(IFaultPersistence faultPersistence) {
        this.faultPersistence = faultPersistence;
    }
}

