/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.recv;

import com.huawei.lego.com.south.snmp.api.LegoLogFactoryForSnmp4j;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.launcher.IFaultLauncher;
import com.huawei.lego.nem.fault.trap.recv.TrapMsgListener;
import com.huawei.lego.nem.fault.trap.recv.TrapMsgResponder;
import com.huawei.lego.nem.fault.util.FaultUtil;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class TrapMsgLauncher
implements IFaultLauncher {
    private static final int VALUE_3 = 3;
    private static final String KEY_IS_TRAP = "isTrapReceiveEnable";
    private static int receiveMsgTaskNum = 3;
    private static Log logger = LogFactory.getInstance(TrapMsgLauncher.class);

    @Override
    public void start() {
        logger.info((Object)"[FaultLauncher] begin to start TrapMsgLauncher.", 1L);
        String isTrapStr = LegoProperties.getProperty((String)KEY_IS_TRAP, (String)Boolean.FALSE.toString());
        if (isTrapStr.equals(Boolean.FALSE.toString())) {
            logger.warn((Object)"The snmp trap receiver is forbidden!", 1L);
            return;
        }
        LegoLogFactoryForSnmp4j.init();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
        int trapport = LegoProperties.getTrapListenPort();
        try {
            if (0 == trapport) {
                logger.warn((Object)"The snmp trap port is not config!", 1L);
                return;
            }
            SNMP4JSettings.setExtensibilityEnabled((boolean)true);
            String ipLocal = new LegoMoGenerator().getIpForTrap();
            if (VerifyUtil.isEmpty((String)ipLocal)) {
                logger.error((Object)"start trap failed, get listen ip failed.");
                throw new LegoCheckedException(1073947393L);
            }
            logger.info((Object)("start trap listener on " + ipLocal));
            StringBuilder port = new StringBuilder("/").append(trapport);
            String snmpAddress = "udp:" + ipLocal + port.toString();
            Address listenAddress = GenericAddress.parse((String)snmpAddress);
            Object transport = null;
            transport = listenAddress instanceof UdpAddress ? new DefaultUdpTransportMapping((UdpAddress)listenAddress) : new DefaultTcpTransportMapping((TcpAddress)listenAddress);
            ThreadPool threadPool = ThreadPool.create((String)"Trap Receiver Pool start....", (int)receiveMsgTaskNum);
            MultiThreadedMessageDispatcher dispatcher = new MultiThreadedMessageDispatcher((WorkerPool)threadPool, (MessageDispatcher)new MessageDispatcherImpl());
            Snmp snmpTrapListener = TrapMsgListener.createSnmpTrapListener((MessageDispatcher)dispatcher, (TransportMapping)transport);
            snmpTrapListener.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
            snmpTrapListener.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
            snmpTrapListener.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3());
            SecurityProtocols.getInstance().addDefaultProtocols();
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            snmpTrapListener.addCommandResponder((CommandResponder)TrapMsgResponder.getInstance());
            snmpTrapListener.listen();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"start snmp trap receiver failed.", (long)1536L, null, (Log)logger);
        }
        logger.info((Object)("start snmp trap receiver at port: " + trapport), 1L);
    }

    @Override
    public void stop() {
        try {
            logger.info((Object)("stop snmp trap receiver at port: " + FaultUtil.getTrapPort()), 1L);
            if (null != TrapMsgListener.getSnmpTrapListener()) {
                TrapMsgListener.getSnmpTrapListener().close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("failed to stop snmp trap receiver." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }
}

