/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.util.snmp;

import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SnmpV2cUtil {
    private static final String ADDR_SPLIT = "/";
    private static final String WHITE_PEER_ADDR_SPLIT = ",";
    private static Map<String, String> keyMap = new ConcurrentHashMap<String, String>();
    private static Map<String, List<String>> v2params = new ConcurrentHashMap<String, List<String>>();
    private static Log logger = LogFactory.getInstance(SnmpV2cUtil.class);

    public static synchronized void addParam(SnmpPara param, String uuid) {
        if (param == null) {
            logger.error((Object)"Error adding, param is null", 1L);
            return;
        }
        if (param.getPeerAddress() != null && !param.getPeerAddress().equals("") && param.getReadComm() != null) {
            keyMap.put(uuid, param.getReadComm());
            String[] ips = param.getPeerAddress().split(WHITE_PEER_ADDR_SPLIT);
            v2params.put(uuid, Arrays.asList(ips));
            logger.info((Object)("v2 param add succ, uuid:" + uuid), 1L);
            return;
        }
        logger.error((Object)("Error to add param, pa:" + param.getPeerAddress()), 1L);
    }

    public static synchronized void removeParam(String uuid) {
        if (uuid == null) {
            logger.error((Object)"Error removing, uuid is null", 1L);
            return;
        }
        keyMap.remove(uuid);
        v2params.remove(uuid);
    }

    public static synchronized void removeParam(SnmpPara param) {
        if (param == null) {
            logger.error((Object)"Error removing, Param is null", 1L);
            return;
        }
        if (param.getPeerAddress() != null) {
            v2params.remove(param.getPeerAddress());
        }
    }

    public static synchronized boolean validate(String peerAddress, String sn) {
        if (peerAddress == null || sn == null) {
            logger.error((Object)("Error validate, peerAddress:" + peerAddress + ",sn:" + sn), 1L);
            return false;
        }
        String ip = SnmpV2cUtil.formatPeerAddress(peerAddress);
        Set<Map.Entry<String, String>> set = keyMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (!entry.getValue().equals(sn) || !v2params.get(entry.getKey()).contains(ip)) continue;
            return true;
        }
        return false;
    }

    private static String formatPeerAddress(String peerAddress) {
        String ip = peerAddress;
        if (ip.contains(ADDR_SPLIT)) {
            ip = ip.substring(0, ip.indexOf(ADDR_SPLIT));
        }
        return ip;
    }
}

