/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.util.snmp;

import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;
import com.huawei.lego.com.south.snmp.util.SnmpUtil;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public final class Snmpv3Util {
    private static final int VALUE_2 = 2;
    private static final int VALUE_16 = 16;
    private static IAlarmService alarmService;
    private static IFaultGenerateService genrateAlarmService;
    private static Log logger;

    private Snmpv3Util() {
    }

    public static void addUSMUserEntry(Snmp snmpapi, SnmpV3Param v3Param) {
        if (null == snmpapi || null == v3Param) {
            logger.error((Object)"addUSMUserEntry failed,the input param is null", 1L);
            throw new LegoCheckedException(1792L);
        }
        try {
            String userName = v3Param.getUserName();
            if (userName != null) {
                byte[] engineId = v3Param.getEngineId().getBytes("ISO-8859-1");
                OID authGenericOID = SnmpUtil.getAuthProtocol((SnmpEnum.AuthProtocol)v3Param.getAuthProtocol());
                OID privacyProtocolOID = SnmpUtil.getPrivProtocol((SnmpEnum.PrivProtocol)v3Param.getPrivProtocol());
                UsmUser usmUser = new UsmUser(new OctetString(userName), authGenericOID, new OctetString(null == v3Param.getAuthPwd() ? "" : v3Param.getAuthPwd()), privacyProtocolOID, new OctetString(null == v3Param.getPrivPwd() ? "" : v3Param.getPrivPwd()));
                if (null == engineId) {
                    logger.info((Object)"the engineId is null", 1L);
                    snmpapi.getUSM().getUserTable().addUser(new UsmUserEntry(new OctetString(userName), usmUser));
                } else {
                    logger.info((Object)("the engineId is " + Arrays.toString(engineId)), 1L);
                    snmpapi.getUSM().addUser(new OctetString(userName), new OctetString(engineId), usmUser);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("addUSMUserEntry failed,the snmv3param:" + v3Param + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public static void removeUSMUserEntry(Snmp snmpapi, SnmpV3Param v3Param) {
        try {
            byte[] engineId = v3Param.getEngineId().getBytes("ISO-8859-1");
            snmpapi.getUSM().removeAllUsers(new OctetString(v3Param.getUserName()), new OctetString(engineId));
        }
        catch (Exception e) {
            logger.error((Object)("removeUserFromSnmp4j failed,the snmv3param:" + v3Param + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String discoveryEngineId(SnmpV3Param snmpV3Param) {
        if (null == snmpV3Param.getIpAddress() || "".equals(snmpV3Param.getIpAddress()) || snmpV3Param.getPort() == 0) {
            return null;
        }
        String engineID = "";
        byte[] authoritativeengineID = null;
        Snmp snmp = null;
        try {
            snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            snmp.listen();
            snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
            snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
            snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3());
            Address outlistenAddress = GenericAddress.parse((String)(snmpV3Param.getIpAddress() + "/" + snmpV3Param.getPort()));
            authoritativeengineID = snmp.discoverAuthoritativeEngineID(outlistenAddress, 5000L);
            if (authoritativeengineID != null) {
                engineID = new String(authoritativeengineID, "ISO-8859-1");
            }
        }
        catch (Exception e) {
            String alarmId = "0x00080322000d";
            Snmpv3Util.generateAlarm(snmpV3Param, alarmId);
            logger.error((Object)("get enginedId failture." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            if (null != snmp) {
                try {
                    snmp.close();
                }
                catch (IOException e) {
                    logger.error((Object)("get enginedId failture." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                }
            }
        }
        return engineID;
    }

    private static void generateAlarm(SnmpV3Param snmpV3Param, String alarmId) {
        String resouceIp = snmpV3Param.getIpAddress();
        String[] alarmParam = null;
        alarmParam = new String[]{String.valueOf(resouceIp), String.valueOf(snmpV3Param.getPort())};
        LegoAlarm alarm = new LegoAlarm();
        alarm.setAlarmId(alarmId);
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmParam(alarmParam);
        alarm.setEntity(alarmId + resouceIp);
        alarm.setSourceId(snmpV3Param.getDiscoveredDeviceUuid());
        alarm.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        try {
            IFaultGenerateService alarmService1 = Snmpv3Util.getGenrateAlarmService();
            alarmService1.generateLegoAlarm(alarm);
        }
        catch (Exception e) {
            logger.error((Object)("alarmService generate LegoRestoreAlarm error." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    public static String convertEnginID(String engineID) {
        if (engineID.startsWith("0x") || engineID.startsWith("0X")) {
            return new String(Snmpv3Util.getHexValue(engineID), Charset.defaultCharset());
        }
        return engineID;
    }

    private static byte[] getHexValue(String value) {
        byte[] hexVal = new byte[value.length() / 2 - 1];
        String ss = null;
        String str = null;
        ss = value.substring(2);
        for (int i = 0; i < ss.length(); i += 2) {
            byte temp;
            str = ss.substring(i, i + 2);
            try {
                temp = (byte)Integer.parseInt(str, 16);
            }
            catch (NumberFormatException e) {
                logger.error((Object)"getHexValue Exception", (Throwable)e, 1L);
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
            hexVal[i / 2] = temp;
        }
        return hexVal;
    }

    public static IAlarmService getAlarmService() {
        try {
            if (null == alarmService) {
                alarmService = (IAlarmService)ServiceContext.getInstance().lookup("fault/alarmService");
            }
        }
        catch (Exception e) {
            logger.error((Object)("get AlarmService failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return alarmService;
    }

    public static IFaultGenerateService getGenrateAlarmService() {
        try {
            if (null == genrateAlarmService) {
                genrateAlarmService = (IFaultGenerateService)ServiceContext.getInstance().lookup("fault/faultGenerateService");
            }
        }
        catch (Exception e) {
            logger.error((Object)("get FaultGenerateService failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return genrateAlarmService;
    }

    static {
        logger = LogFactory.getInstance(Snmpv3Util.class);
    }
}

