/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.job.airgapjob;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.airgapjob.BasicTaskInfo;
import com.huawei.ism.drm.base.job.airgapjob.DisableTask;
import com.huawei.ism.drm.base.job.airgapjob.DisableTime;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.ResourceLockUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.LinkTypeEnum;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.model.StoragePortOperateLog;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class AirGapLinkProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AirGapLinkProcessor.class);
    private static final String AIRGAP_CORE_THREADS = "AIRGAP.ENABLE.PORT.CORES";
    private static final long CORE_POOL_SIZE = LegoBaseConfig.getInstance().getNumberWithMaxValue("AIRGAP.ENABLE.PORT.CORES", 10L, 64L);
    private static final int MAXIMUM_POOL_SIZE = 30;
    private static final int THREAD_QUEUE_SIZE = 512;
    private static final int KEEP_ALIVE = 2;
    private static final ExecutorService EXEC_TASK = new ThreadPoolExecutor((int)CORE_POOL_SIZE, 30, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(512));
    private static final ScheduledThreadPoolExecutor SCHEDULER_TASK = new ScheduledThreadPoolExecutor(1);
    private static final ConcurrentHashMap<String, BasicTaskInfo> AIRGAP_PORT_WAIT_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<String>> AIRGAP_PORT_TASK_MAP = new ConcurrentHashMap();
    private static AirGapLinkProcessor instance = null;
    private static final String AG_LINK_PORT_NAME = "ag_link_port_name";
    private static final String ENABLE_PORTS_FAILED_DESCRIPTION = "ism.business.job.airgap.enablePort.failed.description";
    private static final int AUTO_TASK_EXEC_PERIOD = 30;
    private static final long INIT_TIME_WINDOW_VALUE = -1L;
    private static final long CLOSE_DELAY_MINUTES = LegoBaseConfig.getInstance().getNumber("AIRGAP_PORT_DELAY_MINUTES", 10L) * 60L * 1000L;
    private static final long OPERATE_LOG_STORAGE_MILLIS = LegoBaseConfig.getInstance().getNumber("AIRGAP_PORT_OPERATE_LOG_STORE_DAYS", 7L) * 24L * 60L * 60L * 1000L;

    private AirGapLinkProcessor() {
        this.execDisableLink();
    }

    public static synchronized AirGapLinkProcessor getInstance() {
        if (instance == null) {
            instance = new AirGapLinkProcessor();
        }
        return instance;
    }

    private void execDisableLink() {
        DisableTask disableTask = DisableTask.getInstance(this);
        SCHEDULER_TASK.scheduleAtFixedRate(disableTask, 0L, 30L, TimeUnit.SECONDS);
    }

    private synchronized void setTaskInfo(EnablePortTask enablePortTask) {
        if ("1".equals(enablePortTask.getTaskId())) {
            LOGGER.info((Object)"Switchover task: %s, no need add", new Object[]{enablePortTask.getTaskId()});
            return;
        }
        List linkPorts = enablePortTask.getPortList();
        if (CollectionUtils.isEmpty((Collection)linkPorts)) {
            LOGGER.error((Object)"LinkPorts is null.");
            return;
        }
        for (StorageLinkPort linkPort : linkPorts) {
            String taskKey = AirGapLinkProcessor.getTaskKey(linkPort.getPortId(), linkPort.getExecTypeEnum());
            List taskList = AIRGAP_PORT_TASK_MAP.computeIfAbsent(taskKey, list -> new ArrayList());
            LOGGER.info((Object)"Add task info, portName: %s, taskKey: %s taskId: %s", new Object[]{linkPort.getPortName(), taskKey, enablePortTask.getTaskId()});
            taskList.add(enablePortTask.getTaskId());
        }
        ProtectGroup pg = enablePortTask.getProtectGroup();
        if (pg == null) {
            LOGGER.info((Object)"Not find ProtectGroup return.");
            return;
        }
        AirGapLinkPortUtil.updateTimeWindowWithPg(pg, true);
    }

    public void addEnablePortsToProcessor(EnablePortTask enablePortTask) {
        if (VerifyUtil.isEmpty((Object)enablePortTask)) {
            LOGGER.error((Object)"EnablePortTask is null.");
            return;
        }
        this.setTaskInfo(enablePortTask);
        if (this.checkPortStatus(enablePortTask)) {
            LOGGER.info((Object)"Task: %s all enabled, return.", new Object[]{enablePortTask.getTaskId()});
            return;
        }
        String lockResId = this.getPortIdLockKey(enablePortTask.getDevSn(), enablePortTask.getRemoteDevSn());
        String lockPortKey = ResourceLockUtil.lockRes(lockResId, AG_LINK_PORT_NAME, 360000L);
        try {
            EXEC_TASK.execute(() -> this.runEnablePorts(enablePortTask, lockPortKey));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Run enable ports failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            ResourceLockUtil.unlockRes(lockPortKey);
        }
    }

    private void runEnablePorts(EnablePortTask enablePortTask, String lockPortKey) {
        try {
            if (this.checkPortStatus(enablePortTask)) {
                LOGGER.info((Object)"Task: %s all enabled, no need to operate.", new Object[]{enablePortTask.getTaskId()});
                return;
            }
            LOGGER.info((Object)"Begin to enable task: %s", new Object[]{enablePortTask.getTaskId()});
            this.execEnablePorts(enablePortTask);
        }
        finally {
            ResourceLockUtil.unlockRes(lockPortKey);
        }
    }

    public synchronized void updateDisableTimeMap(StorageLinkPort linkPort) {
        DisableTime oldDisableTime;
        if (VerifyUtil.isEmpty((Object)linkPort)) {
            LOGGER.error((Object)"Get linkPort is null.");
            return;
        }
        this.consumeTask(linkPort);
        DrmEnumDefine.ExecTypeEnum execTypeEnum = linkPort.getExecTypeEnum();
        long curTime = System.currentTimeMillis();
        long execDisTime = curTime + CLOSE_DELAY_MINUTES;
        DisableTime disableTimeObj = new DisableTime();
        disableTimeObj.setExecTypeEnum(execTypeEnum);
        disableTimeObj.setTimeWindowEndTime(-1L);
        disableTimeObj.setDisableTime(execDisTime);
        BasicTaskInfo basicTaskInfo = AIRGAP_PORT_WAIT_MAP.get(linkPort.getPortId());
        if (VerifyUtil.isEmpty((Object)basicTaskInfo) || VerifyUtil.isEmpty((Object)basicTaskInfo.getDisableTimeInfo())) {
            LOGGER.info((Object)"Not find basicTaskInfo by portId: %s, new add.", new Object[]{linkPort.getPortId()});
            basicTaskInfo = new BasicTaskInfo();
            basicTaskInfo.setDisableTimeInfo(disableTimeObj);
            basicTaskInfo.setLinkPortInfo(linkPort);
            AIRGAP_PORT_WAIT_MAP.put(linkPort.getPortId(), basicTaskInfo);
            oldDisableTime = disableTimeObj;
        } else {
            oldDisableTime = AIRGAP_PORT_WAIT_MAP.get(linkPort.getPortId()).getDisableTimeInfo();
        }
        List<ResourceTimeWindowRange> rangeList = this.getTimeRangesByLinkPort(linkPort);
        if (CollectionUtils.isEmpty(rangeList)) {
            DisableTime time = new DisableTime();
            time.setDisableTime(execDisTime);
            time.setExecTypeEnum(execTypeEnum);
            time.setTimeWindowEndTime(-1L);
            if (oldDisableTime.isInitValue().booleanValue() || execDisTime > oldDisableTime.getDisableTime()) {
                oldDisableTime.setIsInitValue(false);
                basicTaskInfo.setDisableTimeInfo(time);
                basicTaskInfo.setLinkPortInfo(linkPort);
                AIRGAP_PORT_WAIT_MAP.put(linkPort.getPortId(), basicTaskInfo);
            }
            return;
        }
        if (disableTimeObj.getExecTypeEnum() == DrmEnumDefine.ExecTypeEnum.AUTO) {
            this.doSetDisableTimeByTimeWindow(linkPort.getPortId(), disableTimeObj, rangeList);
        }
        if (oldDisableTime.isInitValue().booleanValue() || disableTimeObj.getDisableTime() > oldDisableTime.getDisableTime()) {
            disableTimeObj.setIsInitValue(false);
            basicTaskInfo.setDisableTimeInfo(disableTimeObj);
            basicTaskInfo.setLinkPortInfo(linkPort);
            AIRGAP_PORT_WAIT_MAP.put(linkPort.getPortId(), basicTaskInfo);
        }
    }

    public synchronized void consumeTask(StorageLinkPort linkPort) {
        String taskKey = AirGapLinkProcessor.getTaskKey(linkPort.getPortId(), linkPort.getExecTypeEnum());
        LOGGER.info((Object)"Begin to consume taskKey: %s, taskId: %s", new Object[]{taskKey, linkPort.getTaskId()});
        List<String> taskList = AIRGAP_PORT_TASK_MAP.get(taskKey);
        if (!CollectionUtils.isEmpty(taskList)) {
            taskList.remove(linkPort.getTaskId());
        }
    }

    public synchronized void preSetBeforeRemoveStorage(List<String> devSns) {
        if (CollectionUtils.isEmpty(devSns)) {
            LOGGER.info((Object)"Not find devSns");
            return;
        }
        ArrayList linkPorts = new ArrayList();
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        devSns.forEach(devSn -> {
            List portsInDb = resourceService.getResourceLinkPorts(devSn);
            linkPorts.addAll(portsInDb);
        });
        HashSet<String> portIds = new HashSet<String>();
        for (StorageLinkPort linkPort : linkPorts) {
            this.deletePortRelation(portIds, linkPort);
        }
        this.doEnableAndDisableIsolation(devSns);
    }

    private void deletePortRelation(Set<String> portIds, StorageLinkPort linkPort) {
        String portId = linkPort.getPortId();
        if (portIds.contains(portId)) {
            return;
        }
        if (VerifyUtil.isEmpty((String)portId)) {
            return;
        }
        portIds.add(portId);
        LOGGER.info((Object)"Begin to remove task info, port: %s", new Object[]{linkPort.toString()});
        if (AIRGAP_PORT_WAIT_MAP.containsKey(portId)) {
            LOGGER.info((Object)"Remove port, portId: %s, portName: %s", new Object[]{portId, linkPort.getPortName()});
            AIRGAP_PORT_WAIT_MAP.remove(portId);
        }
        String keyManual = AirGapLinkProcessor.getTaskKey(linkPort.getPortId(), DrmEnumDefine.ExecTypeEnum.MANUAL);
        String keyAuto = AirGapLinkProcessor.getTaskKey(linkPort.getPortId(), DrmEnumDefine.ExecTypeEnum.AUTO);
        if (AIRGAP_PORT_TASK_MAP.containsKey(keyManual)) {
            LOGGER.info((Object)"Remove manual task: %s", new Object[]{keyManual});
            AIRGAP_PORT_TASK_MAP.remove(keyManual);
        }
        if (AIRGAP_PORT_TASK_MAP.containsKey(keyAuto)) {
            LOGGER.info((Object)"Remove auto task: %s", new Object[]{keyAuto});
            AIRGAP_PORT_TASK_MAP.remove(keyAuto);
        }
        String devSn = linkPort.getDevSn();
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        if (!linkPort.getOperationalStatus().booleanValue()) {
            LOGGER.info((Object)"Need to enable port, portName: %s", new Object[]{linkPort.getPortName()});
            EXEC_TASK.execute(() -> mgr.enableStoragePort(devSn, linkPort));
        }
    }

    private void doEnableAndDisableIsolation(List<String> devSnList) {
        HashSet<String> isolatedWwns = new HashSet<String>();
        List<RemoteLinkDevice> allRemoteDevices = this.getRemoteLinkDevices(devSnList);
        for (RemoteLinkDevice remoteDevice : allRemoteDevices) {
            this.disableAlarmIsolation(isolatedWwns, remoteDevice);
        }
    }

    private void disableAlarmIsolation(Set<String> remoteWwnSet, RemoteLinkDevice remoteDevice) {
        String remoteWwn = remoteDevice.getRemoteWwn();
        if (remoteWwnSet.contains(remoteWwn)) {
            LOGGER.info((Object)"RemoteWwn: %s has executed", new Object[]{remoteWwn});
            return;
        }
        String devSn = remoteDevice.getLocalDevSn();
        remoteDevice.setNetIsolation(0);
        LOGGER.info((Object)"Begin to disable alarm isolation, remote name: %s", new Object[]{remoteDevice.getRemoteName()});
        try {
            IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
            mgr.isolateAlarm(devSn, remoteDevice);
            remoteWwnSet.add(remoteWwn);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Get exception when isolateAlarm, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private List<RemoteLinkDevice> getRemoteLinkDevices(List<String> devSnList) {
        ArrayList<RemoteLinkDevice> allDevices = new ArrayList<RemoteLinkDevice>();
        for (String devSn : devSnList) {
            ArrayList remoteDevices;
            try {
                IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
                remoteDevices = mgr.getStorageRemoteDevice(devSn);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Exception when get remote info.");
                remoteDevices = new ArrayList();
            }
            allDevices.addAll(remoteDevices);
        }
        return allDevices;
    }

    private void registerPortMap(StorageLinkPort linkPort) {
        if (linkPort.getSwitchover().booleanValue()) {
            LOGGER.info((Object)"Time window switch on, no need register to map, portId: %s", new Object[]{linkPort.getPortId()});
            return;
        }
        DisableTime time = new DisableTime();
        long curTime = System.currentTimeMillis();
        long execDisTime = curTime + CLOSE_DELAY_MINUTES;
        time.setDisableTime(execDisTime);
        time.setIsInitValue(true);
        time.setTimeWindowEndTime(-1L);
        LOGGER.info((Object)"Register to disable portName: %s.", new Object[]{linkPort.getPortName()});
        AIRGAP_PORT_WAIT_MAP.put(linkPort.getPortId(), this.getBasicTaskInfo(linkPort, time));
    }

    private BasicTaskInfo getBasicTaskInfo(StorageLinkPort linkPort, DisableTime time) {
        BasicTaskInfo basicTaskInfo = new BasicTaskInfo();
        basicTaskInfo.setDisableTimeInfo(time);
        basicTaskInfo.setLinkPortInfo(linkPort);
        return basicTaskInfo;
    }

    public void filterAndDisablePortsWithoutTask(List<StorageLinkPort> linkPorts) {
        List<StorageLinkPort> needDisablePorts = new ArrayList<StorageLinkPort>();
        if (!AIRGAP_PORT_WAIT_MAP.isEmpty()) {
            this.setNeedToDisablePorts(linkPorts, needDisablePorts);
        } else {
            LOGGER.info((Object)"No wait disable port task, choose all.");
            needDisablePorts = linkPorts;
        }
        if (CollectionUtils.isEmpty(needDisablePorts)) {
            LOGGER.info((Object)"Not find ports to disable, return.");
            return;
        }
        List<StorageLinkPort> disablePorts = this.getNeedDisablePortByTask(needDisablePorts);
        this.doDisablePort(disablePorts);
    }

    private List<StorageLinkPort> getNeedDisablePortByTask(List<StorageLinkPort> needDisablePorts) {
        ArrayList<StorageLinkPort> disablePorts = new ArrayList<StorageLinkPort>();
        for (StorageLinkPort linkPort : needDisablePorts) {
            String keyManual = AirGapLinkProcessor.getTaskKey(linkPort.getPortId(), DrmEnumDefine.ExecTypeEnum.MANUAL);
            String keyAuto = AirGapLinkProcessor.getTaskKey(linkPort.getPortId(), DrmEnumDefine.ExecTypeEnum.AUTO);
            List<String> manualTasks = AIRGAP_PORT_TASK_MAP.get(keyManual);
            List<String> autoTasks = AIRGAP_PORT_TASK_MAP.get(keyAuto);
            if (!CollectionUtils.isEmpty(manualTasks) || !CollectionUtils.isEmpty(autoTasks)) continue;
            LOGGER.info((Object)"PortName: %s without any task, can disable.", new Object[]{linkPort.getPortName()});
            disablePorts.add(linkPort);
        }
        return disablePorts;
    }

    private void setNeedToDisablePorts(List<StorageLinkPort> linkPorts, List<StorageLinkPort> needDisablePorts) {
        for (StorageLinkPort linkPort : linkPorts) {
            String tmpPortId = linkPort.getPortId();
            if (AIRGAP_PORT_WAIT_MAP.containsKey(tmpPortId)) {
                LOGGER.debug((Object)"PortId: %s is in AIRGAP_PORT_WAIT_MAP, continue", new Object[]{tmpPortId});
                continue;
            }
            LOGGER.info((Object)"PortId: %s, portName: %s is need to disable for switch secure mode.", new Object[]{linkPort.getPortId(), linkPort.getPortName()});
            needDisablePorts.add(linkPort);
        }
    }

    public List<StorageLinkPort> getNeedToDisableLinkPorts() {
        ArrayList<StorageLinkPort> resList = new ArrayList<StorageLinkPort>();
        for (Map.Entry<String, BasicTaskInfo> entry : AIRGAP_PORT_WAIT_MAP.entrySet()) {
            this.doCheckAndUpdate(entry.getKey(), entry.getValue(), resList);
        }
        return resList;
    }

    private void doCheckAndUpdate(String portId, BasicTaskInfo basicTaskInfo, List<StorageLinkPort> resList) {
        List<ResourceTimeWindowRange> rangeList = this.getTimeRangesByLinkPort(basicTaskInfo.getLinkPortInfo());
        this.doSetDisableTimeByTimeWindow(portId, basicTaskInfo.getDisableTimeInfo(), rangeList);
        this.computePortDisableTime(portId, basicTaskInfo, resList);
    }

    private void computePortDisableTime(String portId, BasicTaskInfo basicTaskInfo, List<StorageLinkPort> resList) {
        long endTime;
        long curTime = System.currentTimeMillis();
        StorageLinkPort linkPort = basicTaskInfo.getLinkPortInfo();
        DisableTime disableTime = basicTaskInfo.getDisableTimeInfo();
        String keyManual = AirGapLinkProcessor.getTaskKey(linkPort.getPortId(), DrmEnumDefine.ExecTypeEnum.MANUAL);
        String keyAuto = AirGapLinkProcessor.getTaskKey(linkPort.getPortId(), DrmEnumDefine.ExecTypeEnum.AUTO);
        List<String> manualTasks = AIRGAP_PORT_TASK_MAP.get(keyManual);
        List<String> autoTasks = AIRGAP_PORT_TASK_MAP.get(keyAuto);
        LOGGER.debug((Object)"Now portId: %s, manualTasks: %s, autoTasks: %s", new Object[]{portId, manualTasks, autoTasks});
        if (disableTime.getTimeWindowEndTime() != -1L && curTime >= disableTime.getTimeWindowEndTime() && CollectionUtils.isEmpty(manualTasks)) {
            resList.add(linkPort);
            LOGGER.info((Object)"Add link portId: %s to disable list by time window end", new Object[]{portId});
            AIRGAP_PORT_WAIT_MAP.remove(portId);
            return;
        }
        if (CollectionUtils.isEmpty(manualTasks) && CollectionUtils.isEmpty(autoTasks) && curTime >= (endTime = disableTime.getDisableTime().longValue())) {
            resList.add(linkPort);
            LOGGER.info((Object)"Add link portId: %s to disable list by no task.", new Object[]{portId});
            AIRGAP_PORT_WAIT_MAP.remove(portId);
        }
    }

    private void doSetDisableTimeByTimeWindow(String portId, DisableTime disableTime, List<ResourceTimeWindowRange> rangeList) {
        if (CollectionUtils.isEmpty(rangeList)) {
            LOGGER.info((Object)"Not find any range, return. PortId: %s", new Object[]{portId});
            return;
        }
        rangeList.sort(Comparator.comparing(ResourceTimeWindowRange::getStartTime));
        long time = disableTime.getDisableTime();
        LOGGER.info((Object)"Set time: %s, it`s rangeList: %s", new Object[]{time, rangeList});
        Optional<ResourceTimeWindowRange> rangeOpt = rangeList.stream().filter(range -> time >= range.getStartTime().getTime() && time <= range.getEndTime().getTime()).findAny();
        if (rangeOpt.isPresent()) {
            disableTime.setDisableTime(time);
            disableTime.setTimeWindowEndTime(rangeOpt.get().getEndTime().getTime());
            LOGGER.debug((Object)"In time range, portId: %s and %s", new Object[]{portId, disableTime.toString()});
            return;
        }
        if (rangeList.get(0).getStartTime().getTime() > time) {
            long curTime = System.currentTimeMillis();
            disableTime.setDisableTime(curTime);
            disableTime.setTimeWindowEndTime(curTime);
            LOGGER.debug((Object)"Before time range, portId: %s and %s", new Object[]{portId, disableTime.toString()});
        } else if (rangeList.get(rangeList.size() - 1).getEndTime().getTime() < time) {
            disableTime.setDisableTime(rangeList.get(rangeList.size() - 1).getEndTime().getTime());
            disableTime.setTimeWindowEndTime(rangeList.get(rangeList.size() - 1).getEndTime().getTime());
            LOGGER.debug((Object)"After time range, portId: %s and %s", new Object[]{portId, disableTime.toString()});
        } else {
            ResourceTimeWindowRange lastRange = this.getLastRange(time, rangeList);
            disableTime.setDisableTime(lastRange.getEndTime().getTime());
            disableTime.setTimeWindowEndTime(lastRange.getEndTime().getTime());
            LOGGER.debug((Object)"Middle of the time ranges, portId: %s and %s", new Object[]{portId, disableTime.toString()});
        }
        this.setExtendTime(disableTime, time);
    }

    private void setExtendTime(DisableTime disableTime, long time) {
        long newDisableTime;
        if (disableTime.getExecTypeEnum() == DrmEnumDefine.ExecTypeEnum.MANUAL && time != (newDisableTime = disableTime.getDisableTime().longValue())) {
            long endTime = time - CLOSE_DELAY_MINUTES;
            long updateTime = endTime <= disableTime.getTimeWindowEndTime() ? disableTime.getTimeWindowEndTime() : endTime;
            LOGGER.info((Object)"Manual type set disable time result: %s", new Object[]{String.valueOf(updateTime)});
            disableTime.setDisableTime(updateTime);
        }
        LOGGER.debug((Object)disableTime.toString());
    }

    private ResourceTimeWindowRange getLastRange(long time, List<ResourceTimeWindowRange> rangeList) {
        List filterList = rangeList.stream().filter(range -> range.getEndTime().getTime() < time).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterList)) {
            LOGGER.error((Object)"Error get. please check! time: %s, rangeList: %s", new Object[]{String.valueOf(time), rangeList});
            throw new LegoCheckedException(1073947394L);
        }
        filterList.sort(Comparator.comparing(ResourceTimeWindowRange::getStartTime));
        return (ResourceTimeWindowRange)filterList.get(filterList.size() - 1);
    }

    private static String getTaskKey(String portId, DrmEnumDefine.ExecTypeEnum execTypeEnum) {
        return portId + "_" + execTypeEnum.getType();
    }

    private boolean checkPortStatus(EnablePortTask enablePortTask) {
        List portsInStorage;
        String devSn = enablePortTask.getDevSn();
        String srcDevSn = enablePortTask.getRemoteDevSn();
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        try {
            portsInStorage = mgr.getStorageLinkPortsByRemoteSn(devSn, srcDevSn);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Get port in storage failed. skip.");
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)portsInStorage)) {
            LOGGER.info((Object)"Not find any port by devSn: %s and srcDevSn", new Object[]{devSn, srcDevSn});
            return true;
        }
        boolean isSuccess = true;
        for (StorageLinkPort portInStorage : portsInStorage) {
            if ("1".equals(enablePortTask.getTaskId())) {
                if (portInStorage.getOperationalStatus().booleanValue()) continue;
                return false;
            }
            boolean isNeedEnable = this.checkAndUpdatePortInDb(portInStorage);
            if (isNeedEnable) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    private boolean checkAndUpdatePortInDb(StorageLinkPort portInStorage) {
        StorageLinkPort linkPortInDb = (StorageLinkPort)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(StorageLinkPort.class, (Serializable)((Object)portInStorage.getPortId()));
        if (VerifyUtil.isEmpty((Object)linkPortInDb)) {
            LOGGER.error((Object)"Find linkPortInDb failed. portId: %s", new Object[]{portInStorage.getPortId()});
            return false;
        }
        if (!portInStorage.getEnable().booleanValue() || !portInStorage.getOperationalStatus().booleanValue()) {
            if (linkPortInDb.getEnable().booleanValue() || linkPortInDb.getOperationalStatus().booleanValue()) {
                linkPortInDb.setEnable(portInStorage.getEnable());
                linkPortInDb.setOperationalStatus(portInStorage.getOperationalStatus());
                LOGGER.error((Object)"linkPortInDb portName: %s not match storage. change to false.", new Object[]{linkPortInDb.getPortName()});
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)linkPortInDb);
            }
            return false;
        }
        if (!linkPortInDb.getEnable().booleanValue() || !linkPortInDb.getOperationalStatus().booleanValue()) {
            linkPortInDb.setEnable(portInStorage.getEnable());
            linkPortInDb.setOperationalStatus(portInStorage.getOperationalStatus());
            LOGGER.error((Object)"LinkPort in Db portName: %s not match storage. Change to true.", new Object[]{linkPortInDb.getPortName()});
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)linkPortInDb);
        }
        return true;
    }

    private void execEnablePorts(EnablePortTask enablePortTask) {
        block5: {
            String devSn = enablePortTask.getDevSn();
            String srcDevSn = enablePortTask.getRemoteDevSn();
            List linkPorts = enablePortTask.getPortList();
            HashSet<StorageLinkPort> waitEnablePortSet = new HashSet<StorageLinkPort>(linkPorts);
            IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
            HashSet<StorageLinkPort> enabledSet = new HashSet<StorageLinkPort>();
            try {
                long curTime;
                List portsInStorage = mgr.getStorageLinkPortsByRemoteSn(devSn, srcDevSn);
                if (CollectionUtils.isEmpty((Collection)portsInStorage)) {
                    LOGGER.error((Object)"Not find port in storage!!");
                    return;
                }
                for (StorageLinkPort linkPort : waitEnablePortSet) {
                    this.doEnablePort(devSn, linkPort, portsInStorage, mgr);
                }
                long startTime = System.currentTimeMillis();
                do {
                    CommUtil.pauseThread((long)30000L);
                    List nowPortsInStorage = mgr.getStorageLinkPortsByRemoteSn(devSn, srcDevSn);
                    this.refreshResult(enabledSet, waitEnablePortSet, nowPortsInStorage);
                    if (waitEnablePortSet.size() != enabledSet.size()) continue;
                    LOGGER.info((Object)"All ports enabled, break.");
                    break block5;
                } while ((curTime = System.currentTimeMillis()) - startTime < 360000L);
                Set<String> enabledPortIds = enabledSet.stream().map(StorageLinkPort::getPortId).collect(Collectors.toSet());
                this.handleFailedPorts(devSn, mgr, waitEnablePortSet, enabledPortIds);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exec enablePortTask: %s failed, devSn: %s, errorMsg: %s", new Object[]{enablePortTask.getTaskId(), devSn, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    private void handleFailedPorts(String devSn, IStoragePortLinksManager mgr, Set<StorageLinkPort> waitEnableSet, Set<String> enabledPortIds) {
        Set<String> portIds = AirGapLinkPortUtil.getSwitchMaintainPortIds();
        for (StorageLinkPort linkPort : waitEnableSet) {
            if (!CollectionUtils.isEmpty(enabledPortIds) && enabledPortIds.contains(linkPort.getPortId())) continue;
            if (portIds.contains(linkPort.getPortId())) {
                LOGGER.info((Object)"PortName: %s in time window is manuel, continue.", new Object[]{linkPort.getPortName()});
                continue;
            }
            if (!linkPort.getOperationalStatus().booleanValue()) {
                LOGGER.info((Object)"PortName: %s is already disabled, continue.", new Object[]{linkPort.getPortName()});
                continue;
            }
            LOGGER.error((Object)"PortName: %s wait max time, record and disable.", new Object[]{linkPort.getPortName()});
            linkPort.setEnable(Boolean.valueOf(false));
            linkPort.setOperationalStatus(Boolean.valueOf(false));
            linkPort.setExecTypeEnum(DrmEnumDefine.ExecTypeEnum.AUTO);
            linkPort.setScheduleModeType(DrmEnumDefine.ExecTypeEnum.AUTO);
            linkPort.setTime(System.currentTimeMillis());
            mgr.disableStoragePort(devSn, linkPort);
            this.saveOperateLog(linkPort, -1, ENABLE_PORTS_FAILED_DESCRIPTION);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)linkPort);
        }
    }

    private void refreshResult(Set<StorageLinkPort> enabledSet, Set<StorageLinkPort> portSet, List<StorageLinkPort> nowPortsInStorage) {
        portSet.forEach(linkPort -> {
            if (this.checkAndSave((StorageLinkPort)linkPort, nowPortsInStorage)) {
                enabledSet.add((StorageLinkPort)linkPort);
            }
        });
    }

    private boolean checkAndSave(StorageLinkPort linkPort, List<StorageLinkPort> nowPortsInStorage) {
        Optional<StorageLinkPort> opt = nowPortsInStorage.stream().filter(portInStorage -> portInStorage.getPortId().equals(linkPort.getPortId())).findAny();
        if (!opt.isPresent()) {
            LOGGER.info((Object)"PortName: %s not find, wait.", new Object[]{linkPort.getPortName()});
            return false;
        }
        StorageLinkPort portInStorage2 = opt.get();
        if (!portInStorage2.getOperationalStatus().booleanValue() || !portInStorage2.getEnable().booleanValue()) {
            if (!linkPort.getOperationalStatus().equals(portInStorage2.getOperationalStatus())) {
                this.saveOrUpdateLinkPortInfo(linkPort, portInStorage2);
            }
            LOGGER.info((Object)"PortName: %s not enable, wait.", new Object[]{linkPort.getPortName()});
            return false;
        }
        linkPort.setEnable(Boolean.valueOf(true));
        linkPort.setOperationalStatus(Boolean.valueOf(true));
        linkPort.setPortName(portInStorage2.getPortName());
        linkPort.setTime(System.currentTimeMillis());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)linkPort);
        LOGGER.info((Object)"PortName: %s is all enabled, return.", new Object[]{linkPort.getPortName()});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnablePort(String devSn, StorageLinkPort linkPort, List<StorageLinkPort> portsInStorage, IStoragePortLinksManager mgr) {
        Optional<StorageLinkPort> opt = portsInStorage.stream().filter(inStoragePort -> inStoragePort.getPortId().equals(linkPort.getPortId())).findAny();
        if (!opt.isPresent()) {
            LOGGER.error((Object)"Not find port By portId: %s", new Object[]{linkPort.getPortId()});
            return;
        }
        StorageLinkPort portInStorage = opt.get();
        if (portInStorage.getOperationalStatus().booleanValue()) {
            LOGGER.info((Object)"PortName: %s status is enable, return.", new Object[]{portInStorage.getPortName()});
            return;
        }
        LOGGER.info((Object)"------Start to enable port: %s----------", new Object[]{portInStorage.getPortName()});
        String lockPort = ResourceLockUtil.lockRes(this.getPortIdLockKey(linkPort.getPortId(), linkPort.getDevSn()), AG_LINK_PORT_NAME, 360000L);
        try {
            mgr.enableStoragePort(devSn, portInStorage);
        }
        finally {
            ResourceLockUtil.unlockRes(lockPort);
        }
        linkPort.setPortName(portInStorage.getPortName());
        this.registerPortMap(linkPort);
        linkPort.setOperationalStatus(Boolean.valueOf(true));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)linkPort);
        this.saveOperateLog(linkPort, 1, "");
    }

    public void doDisablePort(List<StorageLinkPort> linkPorts) {
        LOGGER.debug((Object)"Begin to delete port list: %s", new Object[]{linkPorts});
        for (StorageLinkPort linkPort : linkPorts) {
            EXEC_TASK.execute(() -> this.runDisablePorts(linkPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDisablePorts(StorageLinkPort linkPort) {
        if (VerifyUtil.isEmpty((Object)linkPort)) {
            LOGGER.error((Object)"Not find linkPort by portName: %s", new Object[]{linkPort.getPortName()});
            return;
        }
        LOGGER.info((Object)"------Start to disable port: %s----------", new Object[]{linkPort.getPortName()});
        String lockPort = ResourceLockUtil.lockRes(this.getPortIdLockKey(linkPort.getPortId(), linkPort.getDevSn()), AG_LINK_PORT_NAME);
        LOGGER.info((Object)"Get lock success, lockPort: %s", new Object[]{lockPort});
        String devSn = linkPort.getDevSn();
        try {
            this.doDisablePort(linkPort, devSn);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Disable storage portName: %s failed, devSn: %s, errorMsg: %s", new Object[]{linkPort.getPortName(), devSn, e.getMessage()});
            this.sendDisablePortAlarm(linkPort);
        }
        finally {
            ResourceLockUtil.unlockRes(lockPort);
        }
    }

    private void doDisablePort(StorageLinkPort linkPort, String devSn) {
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        StorageLinkPort portInStorage = mgr.getStoragePortByPortIdAndType(devSn, linkPort.getPortId(), linkPort.getLinkTypeEnum());
        if (portInStorage != null && !portInStorage.getOperationalStatus().booleanValue()) {
            LOGGER.info((Object)"PortName: %s already disabled, return.", new Object[]{linkPort.getPortName()});
            portInStorage.setEnable(Boolean.valueOf(false));
            this.saveOrUpdateLinkPortInfo(linkPort, portInStorage);
            return;
        }
        this.isolateAlarmBeforeDisable(linkPort, mgr);
        mgr.disableStoragePort(devSn, portInStorage);
        this.updateDisablePortStatus(linkPort);
        int index = 0;
        do {
            CommUtil.pauseThread((long)5000L);
            StorageLinkPort newPortInStorage = mgr.getStoragePortByPortIdAndType(devSn, linkPort.getPortId(), linkPort.getLinkTypeEnum());
            if (newPortInStorage == null) {
                LOGGER.error((Object)"Not find port in storage by portName: %s", new Object[]{linkPort.getPortName()});
                continue;
            }
            this.saveOrUpdateLinkPortInfo(linkPort, newPortInStorage);
            if (!newPortInStorage.getOperationalStatus().booleanValue()) {
                LOGGER.info((Object)"Disable port success. portName: %s", new Object[]{newPortInStorage.getPortName()});
                this.saveOperateLog(linkPort, -1, "");
                this.cleanLastPortAlarm(linkPort);
                return;
            }
            ++index;
        } while (index < 3);
        LOGGER.error((Object)"Disable port failed. portName: %s", new Object[]{linkPort.getPortName()});
        this.sendDisablePortAlarm(linkPort);
    }

    private void updateDisablePortStatus(StorageLinkPort linkPort) {
        linkPort.setEnable(Boolean.valueOf(false));
        linkPort.setOperationalStatus(Boolean.valueOf(false));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)linkPort);
    }

    private void isolateAlarmBeforeDisable(StorageLinkPort linkPort, IStoragePortLinksManager mgr) {
        String portId = linkPort.getPortId();
        String devSn = linkPort.getDevSn();
        AirGapLinkPortUtil util = AirGapLinkPortUtil.getInstance();
        List<RemoteLinkDevice> remotes = util.getIsolateRemoteDevice(devSn, portId);
        if (CollectionUtils.isEmpty(remotes)) {
            return;
        }
        for (RemoteLinkDevice remote : remotes) {
            try {
                LOGGER.info((Object)"Begin to isolate remote device: %s, remoteWWn: %s", new Object[]{remote.getEsn(), remote.getRemoteWwn()});
                remote.setNetIsolation(1);
                mgr.isolateAlarm(devSn, remote);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Remote esn: %s link error, can not isolate alarm", new Object[]{remote.getEsn()});
                continue;
            }
            util.updateIsolateAlarmFlag(devSn, remote.getRemoteWwn(), false);
        }
    }

    private void cleanLastPortAlarm(StorageLinkPort linkPort) {
        DrResource drResource = this.getDrResource(linkPort);
        String[] params = new String[]{drResource.getIpAddress(), linkPort.getPortName()};
        AlarmReporter.restoreAlarm(52625511L, params);
    }

    private String[] getStrings(StorageLinkPort linkPort) {
        DrResource drResource = this.getDrResource(linkPort);
        String portType = linkPort.getLinkTypeEnum() == LinkTypeEnum.LIF ? "Logical Ports" : "FC Network";
        return new String[]{drResource.getIpAddress(), linkPort.getPortName(), portType};
    }

    private DrResource getDrResource(StorageLinkPort linkPort) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        return resourceService.getDrResourceBySn(linkPort.getDevSn());
    }

    private void sendDisablePortAlarm(StorageLinkPort linkPort) {
        String[] params = this.getStrings(linkPort);
        FaultEnum.AlarmSeverity severity = FaultEnum.AlarmSeverity.getSeverity((int)3);
        AlarmReporter.sendAlarm(52625511L, "", "", severity, params);
        LOGGER.info((Object)"Send portName: %s alarm success.", new Object[]{linkPort.getPortName()});
    }

    private void saveOrUpdateLinkPortInfo(StorageLinkPort oldLink, StorageLinkPort linkPortInStorage) {
        oldLink.setPortName(linkPortInStorage.getPortName());
        oldLink.setEnable(linkPortInStorage.getEnable());
        oldLink.setOperationalStatus(linkPortInStorage.getOperationalStatus());
        oldLink.setRunningStatus(linkPortInStorage.getRunningStatus());
        oldLink.setTime(System.currentTimeMillis());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldLink);
    }

    private void saveOperateLog(StorageLinkPort linkPort, int portDisableMode, String description) {
        StoragePortOperateLog portLog = new StoragePortOperateLog();
        portLog.setOperateMode(portDisableMode);
        portLog.setPortId(linkPort.getPortId());
        portLog.setPortName(linkPort.getPortName());
        portLog.setOperator(linkPort.getOperator());
        portLog.setDevSn(linkPort.getDevSn());
        portLog.setOperateType(linkPort.getOperateType());
        portLog.setExecutionMode(linkPort.getScheduleModeType().getType());
        portLog.setTime(System.currentTimeMillis());
        if (!VerifyUtil.isEmpty((String)description)) {
            portLog.setDescription(description);
        }
        LOGGER.info((Object)portLog.toString());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)portLog);
    }

    private List<ResourceTimeWindowRange> getTimeRangesByLinkPort(StorageLinkPort linkPort) {
        AirGapLinkPortUtil linkPortUtil = AirGapLinkPortUtil.getInstance();
        return linkPortUtil.getTimeRangesByPgPortIds(linkPort.getPgWorkPorts(), linkPort.getDevSn());
    }

    private synchronized String getPortIdLockKey(String portId, String devSn) {
        return portId + "_" + devSn;
    }

    public void cleanOperateLog() {
        LocalDateTime now = LocalDateTime.now();
        if (now.getHour() != 0 || now.getMinute() != 0) {
            return;
        }
        if (now.getSecond() >= 30) {
            return;
        }
        long curTime = System.currentTimeMillis();
        List logList = CommonDAOLocator.getBaseDao().find("from StoragePortOperateLog where time < ?", new Object[]{curTime - OPERATE_LOG_STORAGE_MILLIS});
        if (CollectionUtils.isEmpty((Collection)logList)) {
            LOGGER.info((Object)"Not find matched logs. curTime: %s", new Object[]{now.toString()});
            return;
        }
        List logIds = logList.stream().map(StoragePortOperateLog::getId).collect(Collectors.toList());
        LOGGER.info((Object)"Begin to delete logs. logIds: %s", new Object[]{logIds.toString()});
        for (StoragePortOperateLog log : logList) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)log);
        }
    }

    public void disablePortsAfterSystemStarted() {
        List<StorageLinkPort> portsInStorage = AirGapLinkPortUtil.getPortsInSecurityTimeWindow();
        if (VerifyUtil.isEmpty(portsInStorage)) {
            LOGGER.info((Object)"No ports need to disable while system rebooting.");
            return;
        }
        portsInStorage.forEach(storageLinkPort -> {
            storageLinkPort.setOperateType(4);
            storageLinkPort.setOperator("System");
            storageLinkPort.setExecTypeEnum(DrmEnumDefine.ExecTypeEnum.MANUAL);
            storageLinkPort.setScheduleModeType(DrmEnumDefine.ExecTypeEnum.MANUAL);
        });
        this.doDisablePort(portsInStorage);
    }
}

