/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.nodeagent.util.PropUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AddressUtils {
    private static final Log LOGGER = LogFactory.getInstance(AddressUtils.class);
    private static final List<String> DOMAIN_BLOCK = ImmutableList.of((Object)"csdr.", (Object)"csha.", (Object)"vha.", (Object)"ark.");
    private static final Set<String> NODE_IPS = Collections.unmodifiableSet(AddressUtils.getNodeIps());

    public static void checkInnerNetworkDetection(String ipOrDomain) {
        if (StringUtils.isBlank((CharSequence)ipOrDomain)) {
            LOGGER.error((Object)"The ip or address is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean isIp = AddressUtil.isIpAddress((String)ipOrDomain);
        if (isIp && AddressUtils.checkLoopBackOrLocalAddress(ipOrDomain)) {
            LOGGER.error((Object)"The ip is loopBack address or local address.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean isDomain = CommUtil.checkDrmDomainParam((String)ipOrDomain);
        if (isDomain && AddressUtils.checkDomain(ipOrDomain)) {
            LOGGER.error((Object)"The ip or address is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!isIp && !isDomain) {
            LOGGER.error((Object)"The ip or address is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        String installServerIp = new LegoMoGenerator().getInstallServerIp();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{installServerIp}) && installServerIp.equals(ipOrDomain)) {
            LOGGER.error((Object)"The ip or address cannot be the eReplication service address.");
            throw new LegoCheckedException(1073947393L);
        }
        if (NODE_IPS.contains(ipOrDomain)) {
            LOGGER.error((Object)"The ip or address cannot be the eReplication service address.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static boolean checkLoopBackOrLocalAddress(String ipOrDomain) {
        try {
            InetAddress inetAddress = InetAddress.getByName(ipOrDomain);
            return inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.error((Object)"The ip can't convert to inetAddress.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static boolean checkDomain(String domain) {
        for (String str : DOMAIN_BLOCK) {
            if (!domain.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getNodeIps() {
        Path path = Paths.get(PathUtil.getInstallPath(), "NodeAgent/conf/nodeAgent.properties");
        Properties nodeAgentProperties = PropUtil.loadProperties((Path)path);
        HashSet<String> nodeIps = new HashSet<String>();
        ImmutableList nodeNames = ImmutableList.of((Object)"node_1", (Object)"node_2", (Object)"node_3", (Object)"node_4");
        for (String nodeName : nodeNames) {
            String node = nodeAgentProperties.getProperty(nodeName);
            if (VerifyUtil.isEmpty((String)node) || node.indexOf(";") == 0) continue;
            nodeIps.add(node.split(";")[0]);
        }
        return nodeIps;
    }
}

