/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.airgapjob.AirGapLinkProcessor;
import com.huawei.ism.drm.base.util.PgSyncRate;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.SwitchoverEnum;
import com.huawei.ism.drm.protection.checker.manager.RateConfigServiceManager;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IRateConfigService;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.EnablePortTask;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class AirGapLinkPortUtil {
    private static final Log LOGGER = LogFactory.getInstance(AirGapLinkPortUtil.class);
    private static final ConcurrentHashMap<String, PgSyncRate> PG_MODIFY_RATE_RECORD = new ConcurrentHashMap();
    private static AirGapLinkPortUtil instance;

    public static synchronized AirGapLinkPortUtil getInstance() {
        if (instance == null) {
            instance = new AirGapLinkPortUtil();
        }
        return instance;
    }

    public boolean isHasPortEnable(Set<StorageLinkPort> waitEnablePorts, Set<String> failedPortNames) {
        HashSet<String> enablePortNameSet;
        block5: {
            long curTime;
            enablePortNameSet = new HashSet<String>();
            long startTime = System.currentTimeMillis();
            do {
                if (!this.pauseThread(10000L)) {
                    LOGGER.warn((Object)"Another thread interrupts the current task while waiting to open the port");
                    return false;
                }
                for (StorageLinkPort linkPort2 : waitEnablePorts) {
                    StorageLinkPort linkPortInDb = (StorageLinkPort)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(StorageLinkPort.class, (Serializable)((Object)linkPort2.getPortId()));
                    if (VerifyUtil.isEmpty((Object)linkPortInDb)) {
                        LOGGER.error((Object)"Error to get port in db by Name: %s. please check.", new Object[]{linkPort2.getPortName()});
                        continue;
                    }
                    LOGGER.debug((Object)"Get portName: %s of DB enable result: %s", new Object[]{linkPortInDb.getPortName(), linkPortInDb.getEnable()});
                    if (!linkPortInDb.getEnable().booleanValue() || !linkPortInDb.getOperationalStatus().booleanValue()) continue;
                    enablePortNameSet.add(linkPortInDb.getPortName());
                }
                if (enablePortNameSet.size() <= 0) continue;
                LOGGER.debug((Object)"Has port is enable.");
                break block5;
            } while ((curTime = System.currentTimeMillis()) - startTime < 360000L);
            LOGGER.error((Object)"Get enable failed by max wait time.");
        }
        waitEnablePorts.forEach(linkPort -> {
            if (!enablePortNameSet.contains(linkPort.getPortName())) {
                failedPortNames.add(linkPort.getPortName());
            }
        });
        if (!this.pauseThread(5000L)) {
            LOGGER.warn((Object)"Another thread interrupts the current task while waiting to open the port");
            return false;
        }
        return enablePortNameSet.size() > 0;
    }

    public List<ResourceTimeWindowRange> getTimeRangesByPgPortIds(List<String> portIds, String devSn) {
        if (CollectionUtils.isEmpty(portIds)) {
            LOGGER.error((Object)"Error: portIds list is null. Please check!!!!");
            return Collections.emptyList();
        }
        List timeWindows = this.getResourceService().getResourceTimeWindow(devSn);
        HashSet timeWindowSet = new HashSet();
        for (String portId : portIds) {
            List tmpTimeWindows = timeWindows.stream().filter(timeWindow -> !VerifyUtil.isEmpty((String)timeWindow.getPortId())).filter(timeWindow -> timeWindow.getPortId().contains(portId)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tmpTimeWindows)) continue;
            timeWindowSet.addAll(tmpTimeWindows);
        }
        if (CollectionUtils.isEmpty(timeWindowSet)) {
            return Collections.emptyList();
        }
        HashSet rangeSet = new HashSet();
        timeWindowSet.forEach(timeWindow -> {
            Set tmp = timeWindow.getTimeWindowRanges();
            rangeSet.addAll(tmp);
        });
        Long[][] intervals = new Long[rangeSet.size()][2];
        int index = 0;
        for (ResourceTimeWindowRange range : rangeSet) {
            Long[] tmp = new Long[]{range.getStartTime().getTime(), range.getEndTime().getTime()};
            intervals[index] = tmp;
            ++index;
        }
        return this.getResourceTimeWindowRanges(intervals);
    }

    private List<ResourceTimeWindowRange> getResourceTimeWindowRanges(Long[][] intervals) {
        Long[][] res;
        ArrayList<ResourceTimeWindowRange> resultList = new ArrayList<ResourceTimeWindowRange>();
        for (Long[] array : res = AirGapLinkPortUtil.mergeArray(intervals)) {
            ResourceTimeWindowRange range = new ResourceTimeWindowRange();
            Date newStartDate = new Date();
            Date newEndDate = new Date();
            newStartDate.setTime(array[0]);
            newEndDate.setTime(array[1]);
            range.setStartTime(newStartDate);
            range.setEndTime(newEndDate);
            resultList.add(range);
        }
        return resultList;
    }

    private boolean pauseThread(long millis) {
        try {
            CommUtil.interruptiblePauseThread((long)millis);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private static Long[][] mergeArray(Long[][] intervals) {
        if (intervals.length == 0) {
            return new Long[0][2];
        }
        Arrays.sort(intervals, Comparator.comparingLong(interval -> interval[0]));
        ArrayList<Long[]> merged = new ArrayList<Long[]>();
        for (Long[] interval2 : intervals) {
            long left = interval2[0];
            long right = interval2[1];
            if (merged.size() == 0 || ((Long[])merged.get(merged.size() - 1))[1] < left) {
                merged.add(new Long[]{left, right});
                continue;
            }
            ((Long[])merged.get((int)(merged.size() - 1)))[1] = Math.max(((Long[])merged.get(merged.size() - 1))[1], right);
        }
        return (Long[][])merged.toArray((T[])new Long[0][0]);
    }

    private IResourceService getResourceService() {
        IResourceService resourceService = null;
        Object drmBase = ServiceLocator.getBundleService((String)"DRM_Base", (String)IResourceService.class.getName());
        if (drmBase instanceof IResourceService) {
            resourceService = (IResourceService)drmBase;
        }
        return resourceService;
    }

    public static String getPortNames(Set<String> failedPortNames) {
        if (failedPortNames.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : failedPortNames) {
            sb.append(name).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static List<StorageLinkPort> getAirGapPortList(ProtectGroup protectGroup) {
        String providerDevSn = protectGroup.getPoProviderSN();
        ProtectGroupReplica replica = protectGroup.getAnyoneReplicationReplica();
        String srcDevSn = replica.getProductArray();
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(providerDevSn);
        try {
            return mgr.getStorageLinkPortsByRemoteSn(providerDevSn, srcDevSn);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Get ports in storage exception, pgName: %s", new Object[]{protectGroup.getName()});
            return Collections.emptyList();
        }
    }

    public static Map<String, List<StorageLinkPort>> getHyperMetroAirGapPortsMap(ProtectGroup protectGroup) {
        String providerDevSn = protectGroup.getPoProviderSN();
        List replicas = protectGroup.listAllReplicatonRepica();
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(providerDevSn);
        HashMap<String, List<StorageLinkPort>> res = new HashMap<String, List<StorageLinkPort>>(16);
        replicas.forEach(replica -> {
            String srcDevSn = replica.getProductArray();
            try {
                res.put(srcDevSn, mgr.getStorageLinkPortsByRemoteSn(providerDevSn, srcDevSn));
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Get main|slave chain ports in storage exception, pgName: %s, e: %s", new Object[]{protectGroup.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
                throw e;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Get main|slave chain ports in storage exception, pgName: %s, e: %s", new Object[]{protectGroup.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1073948475L);
            }
        });
        return res;
    }

    public static List<ResourceTimeWindow> getAirGapTimeWindowByPg(ProtectGroup protectGroup) {
        String providerDevSn = protectGroup.getPoProviderSN();
        ProtectGroupReplica replica = protectGroup.getAnyoneReplicationReplica();
        String productDevSn = replica.getProductArray();
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(providerDevSn);
        List remoteDevices = mgr.getStorageRemoteDeviceByRemoteSn(providerDevSn, productDevSn);
        ArrayList<ResourceTimeWindow> timeWindows = new ArrayList<ResourceTimeWindow>();
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            List<ResourceTimeWindow> tmp = AirGapLinkPortUtil.getTimeWindows(providerDevSn, remoteDevice.getRemoteWwn());
            timeWindows.addAll(tmp);
        }
        return timeWindows;
    }

    private static List<ResourceTimeWindow> getTimeWindows(String devSn, String remoteWwn) {
        List timeWindows = CommonDAOLocator.getBaseDao().find("from ResourceTimeWindow where resourceId=? and remoteWwn=?", new Object[]{devSn, remoteWwn});
        return AirGapLinkPortUtil.transferTimeWindows(timeWindows);
    }

    public static List<StorageLinkPort> getAirGapPortListByTimeWindow(ResourceTimeWindow timeWindow) {
        if (VerifyUtil.isEmpty((Object)timeWindow)) {
            LOGGER.error((Object)"timeWindow is null");
            return Collections.emptyList();
        }
        String localDevSn = timeWindow.getResourceId();
        String srcDevSn = timeWindow.getEsn();
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(localDevSn);
        return mgr.getStorageLinkPortsByRemoteSn(localDevSn, srcDevSn);
    }

    public void consumeFailedAirGapTask(EnablePortTask task, int executionMode) {
        if (VerifyUtil.isEmpty((Object)task)) {
            LOGGER.info((Object)"Task is null: executionMode=%s", new Object[]{String.valueOf(executionMode)});
            return;
        }
        ProtectGroup pg = task.getProtectGroup();
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            LOGGER.info((Object)"Task is not Air Gap task.");
            return;
        }
        if (VerifyUtil.isEmpty((Object)task)) {
            LOGGER.info((Object)"Task is null.");
            return;
        }
        LOGGER.info((Object)"Begin to consume failed task, taskId: %s, pgName: %s", new Object[]{task.getTaskId(), pg.getName()});
        DrmEnumDefine.ExecTypeEnum execTypeEnum = AirGapLinkPortUtil.getExecTypeEnum(pg, executionMode);
        List linkPorts = task.getPortList();
        String taskId = task.getTaskId();
        AirGapLinkProcessor linkProcessor = AirGapLinkProcessor.getInstance();
        for (StorageLinkPort linkPort : linkPorts) {
            linkPort.setTaskId(taskId);
            linkPort.setExecTypeEnum(execTypeEnum);
            linkPort.setScheduleModeType(executionMode == 1 ? DrmEnumDefine.ExecTypeEnum.MANUAL : DrmEnumDefine.ExecTypeEnum.AUTO);
            linkProcessor.consumeTask(linkPort);
        }
        AirGapLinkPortUtil.updateTimeWindowWithPg(pg, false);
    }

    public static void updateTimeWindowWithPg(ProtectGroup pg, boolean isAdd) {
        List<ResourceTimeWindow> timeWindows = AirGapLinkPortUtil.getAirGapTimeWindowByPg(pg);
        for (ResourceTimeWindow window : timeWindows) {
            AirGapLinkPortUtil.updatePgId(pg, window, isAdd);
        }
    }

    public static DrmEnumDefine.ExecTypeEnum getExecTypeEnum(ProtectGroup pg, int execMode) {
        if (pg.isInExecutionPreferred(Integer.valueOf(execMode))) {
            return DrmEnumDefine.ExecTypeEnum.MANUAL;
        }
        return execMode == 1 ? DrmEnumDefine.ExecTypeEnum.MANUAL : DrmEnumDefine.ExecTypeEnum.AUTO;
    }

    private static void updatePgId(ProtectGroup pg, ResourceTimeWindow timeWindow, boolean isAdd) {
        String curPgId = pg.getUuid();
        String idsStr = timeWindow.getAssociatedPgIds();
        HashSet<String> pgIdSet = new HashSet<String>();
        if (!VerifyUtil.isEmpty((String)idsStr)) {
            String[] split = idsStr.split(",", -1);
            Arrays.stream(split).filter(str -> !VerifyUtil.isEmpty((String)str)).forEach(str -> pgIdSet.add(str.trim()));
        }
        if (isAdd) {
            pgIdSet.add(curPgId);
        } else {
            pgIdSet.remove(curPgId);
        }
        String tmpStr = ((Object)pgIdSet).toString();
        String pgIgStr = tmpStr.substring(1, tmpStr.length() - 1);
        timeWindow.setAssociatedPgIds(pgIgStr);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)timeWindow);
        LOGGER.info((Object)"update windowId: %s, pgId: %s with: %s", new Object[]{timeWindow.getWindowId(), curPgId, isAdd});
    }

    public void updateIsolateAlarmFlag(String devSn, String remoteWwn, boolean isNeed) {
        List<ResourceTimeWindow> timeWindows = AirGapLinkPortUtil.getTimeWindows(devSn, remoteWwn);
        Optional opt = timeWindows.stream().findAny();
        if (!opt.isPresent()) {
            LOGGER.error((Object)"Not find timeWindows, return. devSn: %s, remoteWwn: %s", new Object[]{devSn, remoteWwn});
            return;
        }
        if (timeWindows.size() > 1) {
            LOGGER.error((Object)"Error find timeWindow, devSn: %s, remoteWwn: %s", new Object[]{devSn, remoteWwn});
            return;
        }
        ResourceTimeWindow timeWindow = (ResourceTimeWindow)opt.get();
        timeWindow.setNeedIsolateAlarm(Boolean.valueOf(isNeed));
        timeWindow.setTime(System.currentTimeMillis());
        LOGGER.info((Object)"Update isolate alarm flag, timeWindow: %s", new Object[]{timeWindow.toString()});
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)timeWindow);
    }

    public List<RemoteLinkDevice> getIsolateRemoteDevice(String devSn, String portId) {
        List windows = CommonDAOLocator.getBaseDao().find("from ResourceTimeWindow where resourceId=?", new Object[]{devSn});
        List<String> waitIsolateWwns = this.getRemoteWwns(portId, AirGapLinkPortUtil.transferTimeWindows(windows));
        if (CollectionUtils.isEmpty(waitIsolateWwns)) {
            LOGGER.error((Object)"Not find any wwn.");
            return Collections.emptyList();
        }
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        List remoteDevices = mgr.getStorageRemoteDevice(devSn);
        ArrayList<RemoteLinkDevice> isolateRemotes = new ArrayList<RemoteLinkDevice>();
        for (RemoteLinkDevice remoteLinkDevice : remoteDevices) {
            if (!waitIsolateWwns.contains(remoteLinkDevice.getRemoteWwn())) continue;
            isolateRemotes.add(remoteLinkDevice);
        }
        return isolateRemotes;
    }

    private List<String> getRemoteWwns(String portId, List<ResourceTimeWindow> timeWindows) {
        ArrayList<String> remoteWwns = new ArrayList<String>();
        for (ResourceTimeWindow timeWindow : timeWindows) {
            List<String> portIds;
            String portIdInTimeWindow = timeWindow.getPortId();
            if (VerifyUtil.isEmpty((String)portIdInTimeWindow) || !(portIds = Arrays.asList(portIdInTimeWindow.split(","))).contains(portId) || !timeWindow.getNeedIsolateAlarm().booleanValue()) continue;
            remoteWwns.add(timeWindow.getRemoteWwn());
        }
        return remoteWwns;
    }

    public static synchronized void runAirGapSyncRateAtOnce(ProtectGroup pg) {
        if (!PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
            return;
        }
        PolicyTemplate policyTemplate = pg.getTemplate();
        List<ProtectGroupSyncRatePolicy> pgSyncRatePolicies = ProtectGroupUtil.convertToSyncRatePolicy(policyTemplate);
        if (CollectionUtils.isEmpty(pgSyncRatePolicies)) {
            LOGGER.info((Object)"Not set policy, use default. pgName: %s", new Object[]{pg.getName()});
            return;
        }
        int rateLevel = ProtectGroupUtil.getRateLevel(pgSyncRatePolicies);
        String pgId = pg.getUuid();
        long curHourTime = AirGapLinkPortUtil.getCurHourTime();
        if (PG_MODIFY_RATE_RECORD.containsKey(pgId)) {
            PgSyncRate syncRate = PG_MODIFY_RATE_RECORD.get(pgId);
            long time = syncRate.getCurHourTime();
            int tmpLevel = syncRate.getRateLevel();
            if (time == curHourTime && tmpLevel == rateLevel) {
                LOGGER.debug((Object)"pg: %S modified sync rate in time: %s, return", new Object[]{pgId, String.valueOf(curHourTime)});
                return;
            }
        }
        DmEnumDefine.SpeedLevelE speedLevel = DmEnumDefine.SpeedLevelE.valueOf((Integer)rateLevel);
        String type = Integer.toString(pg.getTemplate().getType());
        IRateConfigService service = RateConfigServiceManager.getInstance().getReplicaConfigService(type);
        if (service == null) {
            LOGGER.error((Object)"Not find service by type: %s", new Object[]{type});
            return;
        }
        try {
            LOGGER.info((Object)"Begin to modify rate, rateLevel: %s, pgName: %s", new Object[]{rateLevel, pg.getName()});
            service.modifyRate(speedLevel, pg, DrmEnumDefine.ProtectLocation.A_B.getValue());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Get exception when modify rate, msg: %s", new Object[]{e.getMessage()});
            return;
        }
        PgSyncRate rate = new PgSyncRate();
        rate.setPgId(pgId);
        rate.setCurHourTime(curHourTime);
        rate.setRateLevel(rateLevel);
        PG_MODIFY_RATE_RECORD.put(pg.getUuid(), rate);
    }

    private static long getCurHourTime() {
        Date curDate = new Date();
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(curDate);
        calStart.set(12, 0);
        calStart.set(13, 0);
        calStart.set(14, 0);
        return calStart.getTime().getTime();
    }

    public static Set<String> getSwitchMaintainPortIds() {
        List result = CommonDAOLocator.getBaseDao().find("from ResourceTimeWindow", new Object[0]);
        List<ResourceTimeWindow> timeWindows = AirGapLinkPortUtil.transferTimeWindows(result);
        List<String> tmpPortIds = timeWindows.stream().filter(timeWindow -> timeWindow.getSwitchoverEnum() == SwitchoverEnum.MAINTENANCE).map(ResourceTimeWindow::getPortId).collect(Collectors.toList());
        return AirGapLinkPortUtil.getPorts(tmpPortIds);
    }

    public static Set<String> getProtectGroupWorkPorts() {
        List result = CommonDAOLocator.getBaseDao().find("from ResourceTimeWindow", new Object[0]);
        List<ResourceTimeWindow> timeWindows = AirGapLinkPortUtil.transferTimeWindows(result);
        List<String> tmpPortIds = timeWindows.stream().filter(timeWindow -> !VerifyUtil.isEmpty((String)timeWindow.getAssociatedPgIds())).map(ResourceTimeWindow::getPortId).collect(Collectors.toList());
        return AirGapLinkPortUtil.getPorts(tmpPortIds);
    }

    private static Set<String> getPorts(List<String> tmpPortIds) {
        HashSet<String> portIds = new HashSet<String>();
        for (String tmpPortId : tmpPortIds) {
            if (VerifyUtil.isEmpty((String)tmpPortId)) continue;
            String[] split = tmpPortId.split(",", -1);
            Arrays.stream(split).filter(str -> !VerifyUtil.isEmpty((String)str)).forEach(str -> portIds.add(str.trim()));
        }
        return portIds;
    }

    private static List<ResourceTimeWindow> transferTimeWindows(List<?> timeWindows) {
        HashSet<ResourceTimeWindow> windows = new HashSet<ResourceTimeWindow>();
        for (Object obj : timeWindows) {
            if (!(obj instanceof ResourceTimeWindow)) continue;
            ResourceTimeWindow timeWindow = (ResourceTimeWindow)obj;
            windows.add(timeWindow);
        }
        return new ArrayList<ResourceTimeWindow>(windows);
    }

    public static List<StorageLinkPort> getPortsInSecurityTimeWindow() {
        List result = CommonDAOLocator.getBaseDao().find("from ResourceTimeWindow", new Object[0]);
        List<ResourceTimeWindow> timeWindows = AirGapLinkPortUtil.transferTimeWindows(result);
        List<String> tmpPortIds = timeWindows.stream().filter(timeWindow -> timeWindow.getSwitchoverEnum() == SwitchoverEnum.SECURITY).map(ResourceTimeWindow::getPortId).collect(Collectors.toList());
        Set<String> portIds = AirGapLinkPortUtil.getPorts(tmpPortIds);
        return AirGapLinkPortUtil.getPortsInDb(portIds);
    }

    public static List<StorageLinkPort> getPortsInDb(Collection<String> portIds) {
        SessionFactory sessionFactory;
        Session session;
        String sql;
        List<Object> portsInDb;
        block6: {
            portsInDb = new ArrayList<StorageLinkPort>();
            sql = "FROM StorageLinkPort WHERE portId IN (:portIds)";
            session = null;
            sessionFactory = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory();
            if (!VerifyUtil.isEmpty((Object)sessionFactory)) break block6;
            LOGGER.error((Object)"Session factory is null.");
            ArrayList<StorageLinkPort> arrayList = portsInDb;
            HibernateUtil.closeSession((Session)session);
            return arrayList;
        }
        try {
            session = sessionFactory.openSession();
            Query query = session.createQuery(sql);
            query.setParameterList("portIds", portIds);
            portsInDb = query.list();
            if (VerifyUtil.isEmpty(portsInDb)) {
                LOGGER.error((Object)"Ports info not found in database, portsIds: %s.", new Object[]{portIds});
            }
        }
        catch (HibernateException e) {
            try {
                LOGGER.error((Object)"Query ports info in database failed. portsIds: %s. error msg:%s.", new Object[]{portIds, ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return portsInDb;
    }
}

