/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;

public class ResourceLockUtil {
    private static final Log LOGGER = LogFactory.getInstance(ResourceLockUtil.class);
    private static final HashSet<String> RESOURCE_LOCK_SET = new HashSet();
    private static final String RES_LUN = "res_lun_";
    private static final String RES_PAIR = "res_pair_";
    private static final long MAX_WAIT_TIME_ONE_HOUR = 3600000L;

    public static String lockLun(String lunWwn) {
        return ResourceLockUtil.lockRes(lunWwn, RES_LUN);
    }

    public static String lockPair(String pairId) {
        return ResourceLockUtil.lockRes(pairId, RES_PAIR);
    }

    public static String lockRes(String resId, String resType) {
        String lockId = resType + resId;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"lock resource id: %s", new Object[]{lockId});
        }
        ResourceLockUtil.waitAndLockRes(lockId, 3600000L);
        LOGGER.debug((Object)"lock resource completed.");
        return lockId;
    }

    public static String lockRes(String resId, String resType, long timeout) {
        String lockId = resType + resId;
        ResourceLockUtil.waitAndLockRes(lockId, timeout);
        return lockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitAndLockRes(String lockId, long timeout) {
        block9: {
            long startTime = System.currentTimeMillis();
            try {
                long balance;
                do {
                    HashSet<String> hashSet = RESOURCE_LOCK_SET;
                    synchronized (hashSet) {
                        if (ResourceLockUtil.getResLock(lockId)) {
                            break block9;
                        }
                        RESOURCE_LOCK_SET.wait(timeout);
                    }
                    balance = System.currentTimeMillis() - startTime;
                } while (System.currentTimeMillis() - startTime <= timeout);
                LOGGER.error((Object)"Locking resource time out: lockId=%s, startTime=%s, balance=%s", new Object[]{lockId, startTime, balance});
                throw new LegoCheckedException(1073947433L);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Locking resource interrupted out: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw e;
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Locking resource interrupted out: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Locking resource interrupted", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unexpected error occurred: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Unexpected error");
            }
        }
    }

    private static boolean getResLock(String lockId) {
        if (!RESOURCE_LOCK_SET.contains(lockId)) {
            RESOURCE_LOCK_SET.add(lockId);
            LOGGER.debug((Object)"locking resource succeed: %s", new Object[]{lockId});
            return true;
        }
        return false;
    }

    public static boolean isLockExisted(String lockId) {
        if (RESOURCE_LOCK_SET.contains(lockId)) {
            LOGGER.debug((Object)"resource lock exists: %s", new Object[]{lockId});
            return true;
        }
        LOGGER.debug((Object)"resource lock don't exist: %s", new Object[]{lockId});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockRes(String lockId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"unlock resource id: %s, existed: %s", new Object[]{lockId, RESOURCE_LOCK_SET.contains(lockId)});
        }
        HashSet<String> hashSet = RESOURCE_LOCK_SET;
        synchronized (hashSet) {
            if (RESOURCE_LOCK_SET.contains(lockId)) {
                RESOURCE_LOCK_SET.remove(lockId);
                RESOURCE_LOCK_SET.notifyAll();
                LOGGER.debug((Object)"unlocking resource succeed: %s", new Object[]{lockId});
            }
        }
        LOGGER.debug((Object)"unlocking resource completed");
    }
}

