/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util.concurrent;

import com.huawei.ism.drm.base.util.concurrent.ThreadPoolConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPoolFactory {
    private static final Map<String, ThreadPoolExecutor> THREAD_POOL_EXECUTOR_MAP = new HashMap<String, ThreadPoolExecutor>();

    private ThreadPoolFactory() {
    }

    public static synchronized ThreadPoolExecutor getThreadPool(ThreadPoolConfig config) {
        if (!THREAD_POOL_EXECUTOR_MAP.containsKey(config.getName())) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(config.getCorePoolSize(), config.getMaximumPoolSize(), config.getKeepAliveTime(), TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
            threadPoolExecutor.allowCoreThreadTimeOut(config.isAllowCoreThreadTimeOut());
            THREAD_POOL_EXECUTOR_MAP.put(config.getName(), threadPoolExecutor);
            return threadPoolExecutor;
        }
        return THREAD_POOL_EXECUTOR_MAP.get(config.getName());
    }
}

