/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert;

import com.huawei.ism.cbb.util.UrlUtil;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.lego.comm.keystore.KeystoreUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.nodeagent.util.PropUtil;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public enum CertUriResolver {
    SERVER("Server"){

        @Override
        public CertificateSummary resolve(String uri) {
            return this.resolve(uri, new String[0]);
        }
    }
    ,
    DEPEND("Depend"){

        @Override
        public CertificateSummary resolve(String uri) {
            return this.resolve(uri, "service:dependServiceName", "cert:dependCertName", "format:dependCertFormat", "use:dependType");
        }
    };

    private static final Log LOGGER;
    private static final int NODE_NUMS = 4;
    private static final String KEY_STORE = "keyStore";
    private static final String KEY_STORE_TYPE = "JKS";
    private static final String KEY_STORE_ALIAS_NAME = "bcmrootca";
    private static final String KEY_STORE_PATH = "Runtime/LegoRuntime/certs/bcm.keystore";
    private static final int IP_AND_REGION_LENGTH = 2;
    private String name;

    private CertUriResolver(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static CertUriResolver get(String name) {
        for (CertUriResolver type : CertUriResolver.values()) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static List<CertificateSummary> resolve(List<String> items) {
        CertUriResolver.handleArbCertRegion(items);
        CertUriResolver.handleSfsCertRegion(items);
        return items.stream().map(CertUriResolver::parse).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public abstract CertificateSummary resolve(String var1);

    private static void handleArbCertRegion(List<String> items) {
        Map<String, Set<String>> certRegionMap = CertUriResolver.getArbCertRegionId();
        for (Map.Entry<String, Set<String>> entry : certRegionMap.entrySet()) {
            Optional<String> certUrl = items.stream().filter(e -> e.contains((CharSequence)entry.getKey())).findFirst();
            if (!certUrl.isPresent()) continue;
            String certUrlS = certUrl.get();
            items.remove(certUrlS);
            for (String regionId : entry.getValue()) {
                String url = certUrlS.replaceAll(entry.getKey(), regionId);
                items.add(url);
            }
        }
    }

    private static void handleSfsCertRegion(List<String> items) {
        String sfsCertUrl = "";
        for (String item : items) {
            if (!item.contains("sfsCertRegionId")) continue;
            sfsCertUrl = item;
            break;
        }
        if (VerifyUtil.isEmpty((String)sfsCertUrl)) {
            LOGGER.warn((Object)"Not find sfs cert url.");
            return;
        }
        items.remove(sfsCertUrl);
        Set<String> sfsCertRegionIds = CertUriResolver.getSfsCertRegionId();
        for (String sfsCertRegionId : sfsCertRegionIds) {
            String tempSfsCertUrl = sfsCertUrl;
            items.add(tempSfsCertUrl.replaceAll("sfsCertRegionId", sfsCertRegionId));
        }
    }

    public static Map<String, Set<String>> getArbCertRegionId() {
        HashMap<String, Set<String>> certRegionMap = new HashMap<String, Set<String>>();
        Set arbRegionIdList = LegoBaseConfig.getArbConfig().getArbRegionIdList();
        certRegionMap.put("arbCertRegionId", arbRegionIdList);
        return certRegionMap;
    }

    public static Set<String> getSfsCertRegionId() {
        HashSet<String> certRegionSet = new HashSet<String>();
        Path path = Paths.get(PathUtil.getInstallPath(), "NodeAgent/conf/nodeAgent.properties");
        Properties properties = PropUtil.loadProperties((Path)path);
        for (int i = 1; i <= 4; ++i) {
            if (VerifyUtil.isEmpty((String)properties.getProperty("node_" + i))) continue;
            String[] ipAndRegion = properties.getProperty("node_" + i).split(";");
            if (ipAndRegion.length < 2 || VerifyUtil.isEmpty((String)ipAndRegion[1])) {
                LOGGER.warn((Object)"Region in node.properties not find.");
                continue;
            }
            String region = ipAndRegion[1];
            certRegionSet.add(region);
        }
        return certRegionSet;
    }

    public static CertificateSummary parse(String uri) {
        return Optional.ofNullable(UrlUtil.parse((String)uri)).map(url -> CertUriResolver.get(url.getProtocol())).map(resolver -> resolver.resolve(uri)).orElse(null);
    }

    private static String getDescriptionFromConfig(String item) {
        String zh = LegoBaseConfig.getInstance().getKeyValue("cert." + item + ".description.zh", "");
        String en = LegoBaseConfig.getInstance().getKeyValue("cert." + item + ".description.en", "");
        Log logger = LogFactory.getInstance(CertUriResolver.class);
        logger.info((Object)"Certificate description: %s.", new Object[]{item});
        if (VerifyUtil.isEmpty((String)zh) || VerifyUtil.isEmpty((String)en)) {
            logger.error((Object)"The certificate description is empty, zh: %s, en: %s.", new Object[]{zh, en});
            return "";
        }
        return zh + "##" + en;
    }

    protected CertificateSummary resolve(String uri, String ... aliases) {
        Log logger = LogFactory.getInstance(CertUriResolver.class);
        URL url = UrlUtil.parse((String)uri);
        if (url == null || !this.name.equalsIgnoreCase(url.getProtocol())) {
            logger.error((Object)"The certificate url is null.");
            return null;
        }
        if (url.getPath() == null) {
            logger.error((Object)"The certificate path is null.");
            return null;
        }
        String certName = url.getPath().replaceAll("^/", "").replaceAll("/", "-");
        String[] certNameStr = certName.split("-");
        if (certNameStr.length < 2) {
            logger.error((Object)"The format of certificate name is incorrect.");
            return null;
        }
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            return null;
        }
        String[] items = userInfo.split(":");
        if (items.length != 2) {
            return null;
        }
        String use = items[0];
        String category = items[1];
        String type = url.getProtocol();
        String certFormat = url.getHost();
        Map<String, Object> data = this.getUrlDate(url, logger, aliases);
        int keySize = url.getPort() >= 0 ? url.getPort() : 2048;
        CertificateSummary summary = (CertificateSummary)JSONObject.toBean((JSONObject)JSONObject.fromObject(data), CertificateSummary.class);
        summary.setType(type);
        summary.setUse(use);
        summary.setCertName(certName);
        summary.setCertFormat(certFormat);
        summary.setDescription(CertUriResolver.getDescriptionFromConfig(certNameStr[1]));
        summary.setKeySize(keySize);
        summary.setCategory(category);
        summary.setCertType((String)data.getOrDefault("certType", "common"));
        summary.setPriority(Integer.valueOf((String)data.getOrDefault("priority", "1")));
        if (CertUriResolver.SERVER.name.equalsIgnoreCase(type)) {
            this.setServerCertInfo(summary, logger);
        }
        logger.info((Object)"resolve summary succeed.");
        return summary;
    }

    private void setServerCertInfo(CertificateSummary summary, Log logger) {
        Certificate bcmRootCaCert;
        String bcmKeyStorePath = PathUtil.getInstallPath() + KEY_STORE_PATH;
        String keystorePwd = LegoBaseConfig.getInstance().getKeyValue(KEY_STORE);
        try {
            KeyStore bcmKeyStore = KeystoreUtil.loadKeyStore((String)bcmKeyStorePath, (String)KEY_STORE_TYPE, (String)WccEncryptor.encrypt((String)keystorePwd));
            bcmRootCaCert = bcmKeyStore.getCertificate(KEY_STORE_ALIAS_NAME);
        }
        catch (Exception e) {
            logger.error((Object)"Open bcm.keystore fail, msg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return;
        }
        if (bcmRootCaCert == null) {
            logger.error((Object)"Bcmrootca certificate not exist.");
            return;
        }
        if (!(bcmRootCaCert instanceof X509Certificate)) {
            logger.error((Object)"Certificate format is not X.509.");
            return;
        }
        X509Certificate bcmRootCaX509Cert = (X509Certificate)bcmRootCaCert;
        SimpleDateFormat dateFormat = new SimpleDateFormat(":yyyy-MM-dd HH:mm:ss");
        if (bcmRootCaX509Cert.getSubjectDN() != null) {
            summary.setSubjectName(bcmRootCaX509Cert.getSubjectDN().getName());
        }
        if (bcmRootCaX509Cert.getNotBefore() != null) {
            summary.setNotBefore(dateFormat.format(bcmRootCaX509Cert.getNotBefore()));
        }
        if (bcmRootCaX509Cert.getNotAfter() != null) {
            summary.setNotAfter(dateFormat.format(bcmRootCaX509Cert.getNotAfter()));
        }
    }

    private Map<String, Object> getUrlDate(URL url, Log logger, String[] aliases) {
        HashMap<String, Object> data;
        try {
            data = new HashMap<String, Object>(Optional.ofNullable(UrlUtil.query((String)url.getQuery(), (char[])new char[]{'-'})).orElse(Collections.emptyMap()));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"resolve cert info, catch UnsupportedEncodingException,error:%s. ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return new HashMap<String, Object>();
        }
        for (String alias : aliases) {
            int index = alias.indexOf(58);
            String k = alias.substring(0, index);
            String v = alias.substring(index + 1);
            data.put(v, data.remove(k));
        }
        return data;
    }

    static {
        LOGGER = LogFactory.getInstance(CertUriResolver.class);
    }
}

