/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert;

import com.huawei.ism.drm.cert.SystemCertificateService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateResolver {
    private static final Log logger = LogFactory.getInstance(CertificateResolver.class);

    public X509Certificate resolveX509Certificate(String component) {
        X509Certificate cert;
        CertificateFactory certificateFactory;
        Path path = SystemCertificateService.getComponentCertificatePath();
        if (path == null) {
            logger.error((Object)"Cert path is null.");
            return null;
        }
        File file = path.resolve(component + ".cert").toFile();
        if (!file.exists()) {
            logger.error((Object)"File is not exist, cert: %s ", new Object[]{component});
            return null;
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            logger.error((Object)"Initialize certificate factory failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return null;
        }
        try (FileInputStream content = new FileInputStream(file);){
            cert = (X509Certificate)certificateFactory.generateCertificate(content);
        }
        catch (IOException e) {
            logger.error((Object)"Not find cert file for component: %s, error: %s.", new Object[]{component, ExceptionUtil.getErrorMessage((Throwable)e)});
            return null;
        }
        catch (CertificateException e) {
            logger.error((Object)"Load certificate for component: %s, error: %s.", new Object[]{component, ExceptionUtil.getErrorMessage((Throwable)e)});
            return null;
        }
        return cert;
    }
}

