/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.component;

import com.huawei.ism.drm.cert.CertUriResolver;
import com.huawei.ism.drm.cert.component.AbstractCertificateService;
import com.huawei.ism.drm.cert.sdk.model.CertificateOperateStatus;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.IComplexCertificateService;
import com.huawei.ism.drm.cert.task.CertificateNotifyTask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Constants;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import org.springframework.util.ObjectUtils;

public class ComplexCertificateService
extends AbstractCertificateService
implements IComplexCertificateService {
    private static final Log logger = LogFactory.getInstance(ComplexCertificateService.class);
    private CertificateSummary summary;

    public ComplexCertificateService(String certificate) {
        this.summary = CertUriResolver.parse(certificate);
    }

    public void initialize(List<CertificateSummary> summaries) {
        this.summary.getChildren().addAll(summaries);
    }

    public void initialize() {
        try {
            this.getSystemCertificateService().getCertificateHandler(this.summary).fulfil(this.summary);
        }
        catch (Exception e) {
            logger.error((Object)"Initialize ComplexCertificateService error,error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L);
        }
    }

    public List<CertificateSummary> getCertificateSummaries() {
        return Collections.singletonList(this.summary);
    }

    public CertificateOperateStatus submitCertificateUpdateTask(BlockingQueue queue, CertificateSummary certificateSummary, CertificateUpdateParam param, boolean independent, boolean onlyRegisterable) {
        Map<Integer, Map<CertificateUpdateParam, CertificateSummary>> certificateUpdatePriorityMap = this.getCertNameAndAllCertUpdateTask(certificateSummary, param);
        ArrayList<Integer> priorityList = new ArrayList<Integer>(certificateUpdatePriorityMap.keySet());
        Collections.sort(priorityList);
        for (Integer i : priorityList) {
            Map map = certificateUpdatePriorityMap.getOrDefault(i, new HashMap());
            for (Map.Entry entry : map.entrySet()) {
                CertificateOperateStatus status = ((CertificateSummary)entry.getValue()).submitCertificateUpdateTask(queue, (CertificateUpdateParam)entry.getKey(), false, false);
                if (!status.failure()) continue;
                queue.add(new CertificateNotifyTask(this.getSystemCertificateService(), certificateSummary.getCertName(), param.getTaskId()));
                return status;
            }
        }
        queue.add(new CertificateNotifyTask(this.getSystemCertificateService(), certificateSummary.getCertName(), param.getTaskId()));
        return CertificateOperateStatus.success();
    }

    private Map<Integer, Map<CertificateUpdateParam, CertificateSummary>> getCertNameAndAllCertUpdateTask(CertificateSummary certificateSummary, CertificateUpdateParam param) {
        Map priorityList;
        CertificateUpdateParam childCertificateUpdateParam;
        HashMap<Integer, Map<CertificateUpdateParam, CertificateSummary>> certificateUpdatePriorityMap = new HashMap<Integer, Map<CertificateUpdateParam, CertificateSummary>>();
        JSONObject json = JSONObject.fromObject((Object)param);
        if (!ObjectUtils.isEmpty((Object)param.getCert())) {
            for (CertificateSummary child : certificateSummary.getChildren().stream().filter(e -> Constants.CertType.COMMON.getType().equalsIgnoreCase(e.getCertType())).collect(Collectors.toList())) {
                childCertificateUpdateParam = (CertificateUpdateParam)JSONObject.toBean((JSONObject)json, CertificateUpdateParam.class);
                childCertificateUpdateParam.getCert().setCertName(child.getCertName());
                childCertificateUpdateParam.setSmCerts(new ArrayList());
                childCertificateUpdateParam.setSmCas(new ArrayList());
                priorityList = certificateUpdatePriorityMap.getOrDefault(child.getPriority(), new LinkedHashMap());
                priorityList.put(childCertificateUpdateParam, child);
                certificateUpdatePriorityMap.put(child.getPriority(), priorityList);
            }
        }
        if (!ObjectUtils.isEmpty((Object)param.getSmCerts())) {
            for (CertificateSummary child : certificateSummary.getChildren().stream().filter(e -> Constants.CertType.SIGNATURE.getType().equalsIgnoreCase(e.getCertType())).collect(Collectors.toList())) {
                childCertificateUpdateParam = (CertificateUpdateParam)JSONObject.toBean((JSONObject)json, CertificateUpdateParam.class);
                childCertificateUpdateParam.setCert(null);
                childCertificateUpdateParam.setCrl(null);
                childCertificateUpdateParam.getSmCerts().forEach(smCert -> smCert.setCertName(child.getCertName()));
                priorityList = certificateUpdatePriorityMap.getOrDefault(child.getPriority(), new LinkedHashMap());
                priorityList.put(childCertificateUpdateParam, child);
                certificateUpdatePriorityMap.put(child.getPriority(), priorityList);
            }
        }
        return certificateUpdatePriorityMap;
    }
}

