/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.ObjectConvert;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.PropsUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.mo.ProtectObjectBo;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanListener;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanQueryServiceImpl;
import com.huawei.ism.drm.drp.util.RecoveryPlanQueryUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

abstract class AbstractRecoveryPlanBaseService
extends RecoveryPlanQueryServiceImpl {
    private static final Log logger = LogFactory.getInstance(AbstractRecoveryPlanBaseService.class);
    private static final String PDB = "PDB";
    private IProtectGroupBaseService protectGroupService;
    private List<IRecoveryPlanListener> listeners = new ArrayList<IRecoveryPlanListener>();

    AbstractRecoveryPlanBaseService() {
    }

    public void addListener(IRecoveryPlanListener listener, Map<?, ?> properties) {
        this.listeners.add(listener);
    }

    public IProtectGroupBaseService getProtectGroupService() {
        return this.protectGroupService;
    }

    public void setProtectGroupService(IProtectGroupBaseService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public RecoveryPlan getRecoveryPlan(String recoveryPlanId) {
        return this.getRecoveryPlan(recoveryPlanId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryPlan getRecoveryPlan(String recoveryPlanId, boolean isQueryRp, boolean isQueryPoRep) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter recoveryPlanId is null.");
            return null;
        }
        RecoveryPlan recoveryPlan = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHql = "from RecoveryPlan rp where rp.planId=:planId";
            Query query = session.createQuery(queryHql);
            query.setParameter("planId", (Object)recoveryPlanId);
            List recoveryPlans = query.list();
            if (recoveryPlans != null && !recoveryPlans.isEmpty()) {
                recoveryPlan = (RecoveryPlan)recoveryPlans.get(0);
                Set protectGroups = recoveryPlan.getProtectGroups();
                if (!VerifyUtil.isEmpty((Collection)protectGroups) && isQueryPoRep) {
                    this.loadPoReplica(protectGroups);
                }
                this.getRecoverySetting(recoveryPlan, session);
                if (isQueryRp) {
                    Set<RecoveryProcessDefinition> processes = this.getRecoveryProcesses(session, recoveryPlan, null);
                    recoveryPlan.setRecoveryProcesses(processes);
                }
            }
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryPlan;
    }

    public RecoveryPlan getRecoveryPlan(String recoveryPlanId, boolean isQueryRp) {
        return this.getRecoveryPlan(recoveryPlanId, isQueryRp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, String>> getRecoveryPlansInfo(List<String> planIdList) {
        HashMap<String, Map<String, String>> planProgressMap = new HashMap<String, Map<String, String>>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySql = "select rp.planid, rp.planstatus, rp.planprogress from ti_recoveryPlan rp where rp.planid in (:planIds)";
            List<List<String>> queryParams = DBOperationUtil.createBatchQueryParameters(planIdList, 10);
            for (List<String> param : queryParams) {
                NativeQuery query = session.createSQLQuery(querySql);
                query.setParameterList("planIds", param);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) continue;
                for (Object object : results) {
                    Object[] values;
                    if (!(object instanceof Object[]) || (values = (Object[])object).length != 3) continue;
                    HashMap<String, String> infos = new HashMap<String, String>();
                    String planId = String.valueOf(values[0]);
                    String planStatus = String.valueOf(values[1]);
                    String planProgress = String.valueOf(values[2]);
                    infos.put("planProgress", planProgress);
                    infos.put("planStatus", planStatus);
                    planProgressMap.put(planId, infos);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting plan progress failed. Ids:%s,error is %s.", new Object[]{planIdList.toString(), ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return planProgressMap;
    }

    public RecoveryPlan getRecoveryPlanWithProcess(String recoveryPlanId) {
        return this.getRecoveryPlan(recoveryPlanId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedRecoveryPlanByName(String planName, Integer type) {
        if (VerifyUtil.isEmpty((String)planName)) {
            logger.error((Object)"The parameter planName is null.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExist = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySql = "select PLANID from ti_recoveryplan where PLANNAME=:planName and PLANUSE=:planuse";
            NativeQuery query = session.createSQLQuery(querySql);
            query.setParameter("planName", (Object)planName);
            query.setParameter("planuse", (Object)type);
            List recoveryPlans = query.list();
            if (recoveryPlans != null && !recoveryPlans.isEmpty()) {
                isExist = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Checking whether the recovery plan existed failed. Name:%s,error is %s.", new Object[]{planName, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedRecoveryPlanByName(String planName, String planId, Integer planUse) {
        if (VerifyUtil.isEmpty((String)planName) || VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"Invalid parameter. PlanName:%s,planId:%s.", new Object[]{planName, planId});
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExist = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySql = "select PLANID from ti_recoveryplan where PLANNAME=:planName and PLANUSE=:planUse and PLANID!=:planId";
            NativeQuery query = session.createSQLQuery(querySql);
            query.setParameter("planName", (Object)planName);
            query.setParameter("planUse", (Object)planUse);
            query.setParameter("planId", (Object)planId);
            List recoveryPlans = query.list();
            if (recoveryPlans != null && !recoveryPlans.isEmpty()) {
                isExist = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Checking whether the recovery plan existed failed. Name:%s,error is %s.", new Object[]{planName, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExist;
    }

    public RecoveryLog getRecoveryLog(String recoveryLogId) {
        if (VerifyUtil.isEmpty((String)recoveryLogId)) {
            logger.error((Object)"The parameter recoveryLogId is null.");
            return null;
        }
        RecoveryLog recoveryLog = null;
        try {
            RecoveryLog obj = (RecoveryLog)this.getBaseDao().getHibernateTemplate().get(RecoveryLog.class, (Serializable)((Object)recoveryLogId));
            if (obj != null) {
                recoveryLog = obj;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery log failed. Id:%s,error is %s.", new Object[]{recoveryLogId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return recoveryLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryLog getRecoveryLog(String recoveryPlanId, String queryHql) {
        RecoveryLog recoveryLog = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(queryHql);
            query.setParameter("planId", (Object)recoveryPlanId);
            List recoveryLogs = query.list();
            if (recoveryLogs != null && !recoveryLogs.isEmpty()) {
                recoveryLog = (RecoveryLog)recoveryLogs.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery logs failed. Id:%s,error is %s.", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryLog;
    }

    public RecoveryProcessorDetail getRecoveryProcessorDetail(String detailId) {
        if (VerifyUtil.isEmpty((String)detailId)) {
            logger.error((Object)"The parameter detailId is null.");
            return null;
        }
        RecoveryProcessorDetail detail = null;
        try {
            RecoveryProcessorDetail obj = (RecoveryProcessorDetail)this.getBaseDao().getHibernateTemplate().get(RecoveryProcessorDetail.class, (Serializable)((Object)detailId));
            if (obj != null) {
                detail = obj;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery process detail failed. Id:%s,error is %s.", new Object[]{detailId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return detail;
    }

    public RecoveryProcessorDetail getRecoveryProcessorDetail(String planId, String detailId) {
        String disasterSiteId;
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)detailId)) {
            logger.error((Object)"The parameter planId or detailId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(planId, false, true);
        if (recoveryPlan == null) {
            logger.error((Object)"Recovery plan does not exist. PlanId:%s.", new Object[]{planId});
            throw new LegoCheckedException(201L);
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
        if (this.isNeedQueryFromDisaster(productSiteId, disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID"))) {
            Site remoteSite = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(disasterSiteId);
            RestClient client = SiteUtil.initClient(remoteSite);
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("planId", planId);
            request.put("detailId", detailId);
            RecoveryProcessorDetail result = (RecoveryProcessorDetail)client.postSerializableObj(request, "/ws/recoveryplans/getRecoveryProcessorDetail", RecoveryProcessorDetail.class);
            return result;
        }
        return this.getRecoveryProcessorDetail(detailId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryLog getLatestRecoveryLog(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter (recoveryPlanId) is null.");
            return null;
        }
        String queryHql = "from RecoveryLog rl where rl.planId=:planId and (rl.endTime=null or rl.logStatus=4) order by rl.startTime desc";
        RecoveryLog recoveryLog = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(queryHql);
            query.setParameter("planId", (Object)recoveryPlanId);
            List recoveryLogs = query.list();
            if (recoveryLogs != null && !recoveryLogs.isEmpty()) {
                recoveryLog = (RecoveryLog)recoveryLogs.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery logs failed. Id:%s,error is %s.", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryLog;
    }

    public RecoveryLog getLatestHistoryRecoveryLog(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter recoveryPlanId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = this.isRecoveryPlanExisted(recoveryPlanId);
        if (!isExisted) {
            logger.error((Object)"Recovery plan does not exist. logId:%s.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        String queryHql = "from RecoveryLog rl where rl.planId=:planId and rl.endTime!=null order by rl.startTime desc";
        return this.getRecoveryLog(recoveryPlanId, queryHql);
    }

    public Page pageQueryRecoveryPlan(int pageNum, int pageSize, String orderBy, boolean isAsc, int planType, Map<String, Object> extFilterMap, Long userId) {
        if (extFilterMap == null) {
            logger.debug((Object)"prop is null");
            extFilterMap = new HashMap<String, Object>();
        }
        if (!RecoveryPlan.checkPlanType((int)planType)) {
            logger.error((Object)"planType: %s is invalid.", new Object[]{String.valueOf(planType)});
            throw new LegoCheckedException(1073947393L);
        }
        extFilterMap.put("PLANUSE", planType);
        List<RecoveryPlan> list = this.getRecoveryPlans(orderBy, isAsc, extFilterMap);
        list = this.foreignKeyQueryFilter(userId, list, extFilterMap);
        Page page = Page.createPage((int)pageNum, (int)pageSize, (List)((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(userId, list));
        this.fillRecoveryPlan(page.getResult());
        if (!VerifyUtil.isEmpty((Collection)page.getResult())) {
            Iterator planIterator = page.getResult().iterator();
            while (planIterator.hasNext()) {
                RecoveryPlan recoveryPlan = (RecoveryPlan)planIterator.next();
                if (!VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) continue;
                logger.error((Object)("no protectGroups for plan:" + recoveryPlan.getPlanId() + " name:" + recoveryPlan.getName()));
                planIterator.remove();
            }
        }
        return page;
    }

    public Page pageQueryRecoveryLog(String planId, int pageNum, int pageSize, String orderBy, boolean isAsc) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"The parameter is invalid. PlanId:%s.", new Object[]{planId});
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = this.isRecoveryPlanExisted(planId);
        if (!isExisted) {
            logger.error((Object)"Recovery plan does not exist. PlanId:%s.", new Object[]{planId});
            throw new LegoCheckedException(201L);
        }
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition1 = new QueryCondition("planId", (Object)planId);
        QueryCondition queryCondition2 = new QueryCondition("endTime", (Object)"null", 2);
        queryConditions.add(queryCondition1);
        queryConditions.add(queryCondition2);
        List criterionList = this.getBaseDao().translatePropsToCriterions(queryConditions);
        return this.getBaseDao().pagedQuery(RecoveryLog.class, pageNum, pageSize, criterionList, orderBy, isAsc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsedHostGroupByRp(String hostGroupId) {
        boolean result = false;
        Session session = null;
        try {
            Object obj;
            session = this.getHibernateSession();
            String querySql = "select count(1) from ti_recoverysetting where NAME=:name and VALUE=:value";
            NativeQuery query = session.createSQLQuery(querySql);
            query.setParameter("name", (Object)"PG_DISASTER_HOST");
            query.setParameter("value", (Object)hostGroupId);
            List resultTmp = query.list();
            if (resultTmp != null && !resultTmp.isEmpty() && (obj = resultTmp.get(0)) instanceof BigInteger) {
                BigInteger bi = (BigInteger)obj;
                result = bi.compareTo(BigInteger.ONE) == 0;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting RecoverySetting failed. Id:%s,error is %s.", new Object[]{hostGroupId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return result;
    }

    public List<ProtectGroup> getAvailableProtectGroups(long userId, DrmEnumDefine.RecoveryPlanTypeE planType) {
        List<ProtectGroup> allProtectGroups = this.getAllProtectGroups(userId);
        if (allProtectGroups == null || allProtectGroups.isEmpty()) {
            logger.info((Object)"allProtectGroups is null: %s", new Object[]{String.valueOf(userId)});
            return new ArrayList<ProtectGroup>();
        }
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        List localSites = siteService.getAllLocalSites();
        ArrayList<ProtectGroup> availableProtectGroups = new ArrayList<ProtectGroup>();
        List<RecoveryPlan> recoveryPlans = this.queryRecoveryPlans(userId, false);
        Iterator<RecoveryPlan> iterator = recoveryPlans.iterator();
        while (iterator.hasNext()) {
            RecoveryPlan recoveryPlan = iterator.next();
            if (!Integer.valueOf(RecoveryPlanUse.INTERNAL_USE.getValue()).equals(recoveryPlan.getUse())) continue;
            iterator.remove();
        }
        for (ProtectGroup pp : allProtectGroups) {
            boolean isValid = this.isAvailableProtectGroup(pp, localSites, recoveryPlans, planType);
            if (!isValid) continue;
            availableProtectGroups.add(pp);
        }
        return availableProtectGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryProcessor getRecoveryProcessor(String procId) {
        if (procId == null) {
            logger.error((Object)"The procId is null.");
            return null;
        }
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHql = "from RecoveryProcessor rProcessor where rProcessor.procId=:procId";
            Query query = session.createQuery(queryHql);
            query.setParameter("procId", (Object)procId);
            List results = query.list();
            if (results != null && !results.isEmpty()) {
                if (results.size() == 1) {
                    RecoveryProcessor processor = new RecoveryProcessor();
                    RecoveryProcessor tempProcessor = (RecoveryProcessor)results.get(0);
                    processor.setProcId(tempProcessor.getProcId());
                    tempProcessor.updateProcessName();
                    processor.setProcName(tempProcessor.getProcName());
                    processor.setPlanId(tempProcessor.getPlanId());
                    processor.setProcType(tempProcessor.getProcType());
                    RecoveryProcessor recoveryProcessor = processor;
                    return recoveryProcessor;
                }
                logger.error((Object)"The db data has problem. ProcId:%s.", new Object[]{procId});
            }
        }
        catch (Exception e) {
            logger.error((Object)"Querying the recovery processor failed. procId:%s,error is %s.", new Object[]{procId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return null;
    }

    public DrmEnumDefine.RecoveryPlanTypeE getSuitablePlanType(ProtectGroup protectGroup) {
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(protectGroup);
        if (provider == null) {
            throw new LegoCheckedException(1073947395L);
        }
        if (provider.isSuitableProtectGroup(DrmEnumDefine.RecoveryPlanTypeE.LOCAL, protectGroup)) {
            return DrmEnumDefine.RecoveryPlanTypeE.LOCAL;
        }
        if (provider.isSuitableProtectGroup(DrmEnumDefine.RecoveryPlanTypeE.REMOTE, protectGroup)) {
            return DrmEnumDefine.RecoveryPlanTypeE.REMOTE;
        }
        throw new LegoCheckedException(1073948748L);
    }

    public Page pageQueryProtectObjectInRP(String planId, int pageNum, int pageSize, String orderBy, boolean isAsc) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.debug((Object)"planId is null");
            return null;
        }
        RecoveryPlan plan = this.queryRecoveryPlan(planId, true, false);
        if (plan == null) {
            throw new LegoCheckedException(201L);
        }
        ArrayList<ProtectObjectBo> protectObjectBos = new ArrayList<ProtectObjectBo>();
        Set settings = RecoveryUtil.getRecoverySettingsByItemKey((String)planId, (String)"PG_DISASTER_HOST", (Set)plan.getRecoverySettings());
        IProtectGroupBaseService pgService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        Set protectGroups = plan.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            String hostOrGroupId = this.getHostOrGroupId(planId, settings, protectGroup);
            IProtectObjectBaseProvider provider = pgService.getProtectObjectProvider((Object)protectGroup.getPoType());
            ArrayList<ProtectObject> protectObjList = new ArrayList<ProtectObject>(protectGroup.getPolist());
            this.resetProtectObjectProperties(protectObjList, protectGroup, plan);
            provider.refreshProtectObjectProperties(protectObjList);
            ArrayList<String> uuidList = new ArrayList<String>();
            for (ProtectObject protectObj : protectObjList) {
                uuidList.add(protectObj.getMoUuid());
            }
            Map<String, String> nameMap = RecoveryServiceUtil.getAllMoNameMap(uuidList);
            for (ProtectObject protectObj : protectObjList) {
                ProtectObjectBo protectObjectBo = this.convertToProtectObjectBo(protectObj, protectGroup.getName(), hostOrGroupId);
                protectObjectBos.add(protectObjectBo);
                String moName = nameMap.get(protectObj.getMoUuid());
                if (VerifyUtil.isEmpty((String)moName) || "--".equals(moName)) continue;
                protectObjectBo.setName(moName);
            }
        }
        protectObjectBos.sort((Comparator<ProtectObjectBo>)new CommonComparator(orderBy, isAsc));
        return Page.createPage((int)pageNum, (int)pageSize, protectObjectBos);
    }

    private String getHostOrGroupId(String planId, Set<RecoverySetting> settings, ProtectGroup protectGroup) {
        Set hostOrGroupSettings = RecoveryUtil.getRecoverySettingsByOwnerId((String)planId, (String)protectGroup.getUuid(), settings);
        String hostOrGroupId = "--";
        Iterator recvoerySettingIterator = hostOrGroupSettings.iterator();
        if (recvoerySettingIterator.hasNext()) {
            hostOrGroupId = ((RecoverySetting)recvoerySettingIterator.next()).getValue();
        }
        return hostOrGroupId;
    }

    private void resetProtectObjectProperties(List<ProtectObject> protectObjects, ProtectGroup protectGroup, RecoveryPlan plan) {
        for (ProtectObject protectObj : protectObjects) {
            protectObj.setProtectGroup(protectGroup);
            Set poSettings = RecoveryUtil.getRecoverySettingsByOwnerId((String)plan.getPlanId(), (String)protectObj.getUuid(), (Set)plan.getRecoverySettings());
            HashMap<String, String> poSettingMap = new HashMap<String, String>();
            for (RecoverySetting setting : poSettings) {
                poSettingMap.put(setting.getName(), setting.getValue());
            }
            if (protectObj.getProps() == null) {
                protectObj.setProps(new HashMap());
            }
            this.dealPdbOfChange(protectObj, poSettingMap);
            protectObj.getProps().putAll(poSettingMap);
        }
    }

    private void dealPdbOfChange(ProtectObject protectObj, Map<String, String> poSettingMap) {
        if (!"1".equals(protectObj.getProps().get("IS_CDB"))) {
            return;
        }
        String protectObjPdbStr = (String)protectObj.getProps().get(PDB);
        if (VerifyUtil.isEmpty((String)protectObjPdbStr)) {
            return;
        }
        JSONArray protectPdbArray = JSONArray.fromObject((Object)protectObjPdbStr);
        String recoverySettingPdbStr = poSettingMap.get(PDB);
        if (VerifyUtil.isEmpty((String)recoverySettingPdbStr)) {
            return;
        }
        JSONArray recSettingArray = JSONArray.fromObject((Object)recoverySettingPdbStr);
        JSONArray jsonArray = new JSONArray();
        for (Object protectPdbObj : protectPdbArray) {
            JSONObject poJson = JSONObject.fromObject(protectPdbObj);
            String conId = String.valueOf(poJson.get("conID"));
            String pdbName = String.valueOf(poJson.get("pdbName"));
            if ("CDB$ROOT".equals(pdbName) || "PDB$SEED".equals(pdbName)) continue;
            for (Object recSetting : recSettingArray) {
                JSONObject recJson = JSONObject.fromObject(recSetting);
                if (!conId.equals(String.valueOf(recJson.get("conID")))) continue;
                poJson.put((Object)"isStart", (Object)String.valueOf(recJson.get("isStart")));
            }
            jsonArray.add((Object)poJson);
        }
        poSettingMap.remove(PDB);
        poSettingMap.put(PDB, jsonArray.toString());
    }

    protected abstract List<RecoveryPlan> foreignKeyQueryFilter(Long var1, List<RecoveryPlan> var2, Map<String, Object> var3);

    protected void hwStackFilter(Map<String, Object> filterMap, List<RecoveryPlan> resRps, List<ProtectGroup> protectGroups, Map<String, String> planIdPgIdMap) {
        String regionId = MapUtils.getString(filterMap, (Object)"regionId");
        String azId = MapUtils.getString(filterMap, (Object)"azId");
        String projectId = MapUtils.getString(filterMap, (Object)"projectId");
        String instProtectType = MapUtils.getString(filterMap, (Object)"instProtectType");
        if (!VerifyUtil.isEmptyAll((Object[])new Object[]{regionId, azId, projectId, instProtectType})) {
            Map<String, Map<String, String>> pgPropsMap = PropsUtil.queryPropMaps(PropsUtil.PropModel.PROTECTGROUP, null);
            Iterator<RecoveryPlan> iterator = resRps.iterator();
            while (iterator.hasNext()) {
                RecoveryPlan rp = iterator.next();
                String pgId = planIdPgIdMap.get(rp.getPlanId());
                ProtectGroup pg = Optional.of(protectGroups.stream().filter(protectGroup -> protectGroup.getUuid().equals(pgId)).findAny()).get().orElse(null);
                if (VerifyUtil.isEmpty((Object)pg)) {
                    logger.error((Object)"plan bind pg is null. planId:%s.", new Object[]{rp.getPlanId()});
                    continue;
                }
                if (VerifyUtil.isEmpty((Object)pg.getTemplate())) {
                    logger.error((Object)"pg template is null. pgName:%s.", new Object[]{pg.getName()});
                    continue;
                }
                if (!PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(pg.getTemplate().getType())) continue;
                Map<String, String> propMap = pgPropsMap.get(pg.getUuid());
                if (propMap == null) {
                    propMap = new HashMap<String, String>();
                }
                this.hwStackFilter(iterator, propMap, regionId, azId, projectId, instProtectType);
            }
        }
    }

    private void hwStackFilter(Iterator<RecoveryPlan> iterator, Map<String, String> propMap, String regionId, String azId, String projectId, String instProtectType) {
        if (!VerifyUtil.isEmpty((String)regionId) && !regionId.equals(AbstractRecoveryPlanBaseService.getIdFromOpenstackUuid(propMap.get("regionId")))) {
            iterator.remove();
        } else if (!VerifyUtil.isEmpty((String)azId) && !azId.equals(AbstractRecoveryPlanBaseService.getIdFromOpenstackUuid(propMap.get("zoneName")))) {
            iterator.remove();
        } else if (!VerifyUtil.isEmpty((String)projectId) && !projectId.equals(AbstractRecoveryPlanBaseService.getIdFromOpenstackUuid(propMap.get("projectId")))) {
            iterator.remove();
        } else if (!VerifyUtil.isEmpty((String)instProtectType)) {
            ServiceInstaceEnumDefine.ServiceInstanceTypeE filterValue = ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)instProtectType);
            ServiceInstaceEnumDefine.ServiceInstanceTypeE pgValue = ServiceInstaceEnumDefine.ServiceInstanceTypeE.getTypeFromValue((String)propMap.get("serviceInstanceType"));
            if (!VerifyUtil.isEmpty((Object)filterValue) && !filterValue.equals((Object)pgValue)) {
                iterator.remove();
            }
        }
    }

    public static String getIdFromOpenstackUuid(String uuid) {
        if (VerifyUtil.isEmpty((String)uuid)) {
            return null;
        }
        if (uuid.contains(":")) {
            uuid = uuid.split(":")[1];
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getPlanIdPgIdMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSql = "select PLANID,PGID from ti_drp_r_pg";
            NativeQuery query = session.createSQLQuery(strSql);
            List results = query.list();
            for (Object object : results) {
                Object[] values;
                if (!(object instanceof Object[]) || (values = (Object[])object).length != 2) continue;
                map.put(CommUtil.convertToString((Object)values[0]), CommUtil.convertToString((Object)values[1]));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting ti_drp_r_pg failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return map;
    }

    protected boolean isConditionFilter(Object condition, Object tgt) {
        if (condition == null) {
            return true;
        }
        return condition.equals(tgt);
    }

    protected boolean isTimeRange(String startTime, String endTime, Long createTimeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long startTimeStamp = startTime == null ? Long.MIN_VALUE : sdf.parse(startTime, new ParsePosition(0)).getTime();
        long endTimeStamp = endTime == null ? Long.MAX_VALUE : sdf.parse(endTime, new ParsePosition(0)).getTime();
        return createTimeStamp >= startTimeStamp && createTimeStamp <= endTimeStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ProtectGroup> getAllProtectGroups(long userId) {
        List<Object> allProtectGrops = new ArrayList();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySql = "select pg.PGID, pg.UUID as pguuid, pg.PRODUCTSITEID, st.siteName, pg.PGNAME, pg.POTYPE, pt.TYPE, pt.SUBTYPE, pg.ISPRIMARY, pg.STATUS, pt.UUID as ptuuid, pt.NAME, pt.DESCRIPTION, pg.PGPROVIDERSN from ti_protectgroup pg, ti_site st, ti_policytemplate pt where pg.PTID = pt.PTID and pg.PRODUCTSITEID = st.siteId";
            NativeQuery query = session.createSQLQuery(querySql);
            List result = query.list();
            if (!VerifyUtil.isEmpty((Collection)result)) {
                allProtectGrops = RecoveryPlanQueryUtil.constructProtectGroups(result);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting all protect groups failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        List protectGroups = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(Long.valueOf(userId), allProtectGrops);
        this.buildProtectGroupProps(protectGroups);
        return protectGroups;
    }

    private void buildProtectGroupProps(List<ProtectGroup> protectGroups) {
        List pgIds = protectGroups.stream().map(DRMObject::getUuid).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(pgIds)) {
            return;
        }
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        List result = HibernateUtil.execute(() -> {
            String hsql = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID in(:ids)";
            NativeQuery query = session.createSQLQuery(hsql);
            query.setParameterList("ids", (Collection)pgIds);
            return query.list();
        }, session);
        for (ProtectGroup protectGroup : protectGroups) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (Object object : result) {
                String pgId;
                Object[] values;
                if (!(object instanceof Object[]) || (values = (Object[])object).length != 3 || !StringUtils.equals((CharSequence)(pgId = CommUtil.convertToString((Object)values[0])), (CharSequence)protectGroup.getUuid())) continue;
                String propName = CommUtil.convertToString((Object)values[1]);
                String propValue = CommUtil.convertToString((Object)values[2]);
                props.put(propName, propValue);
            }
            protectGroup.setProps(props);
        }
    }

    private boolean isAvailableProtectGroup(ProtectGroup protectGroup, List<Site> localSites, List<RecoveryPlan> recoveryPlans, DrmEnumDefine.RecoveryPlanTypeE planType) {
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.equals((Object)planType) && !RecoveryServiceUtil.isContainSite(localSites, protectGroup.getProductSiteId())) {
            return false;
        }
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(protectGroup);
        if (provider == null) {
            logger.debug((Object)"provider is null");
            return false;
        }
        boolean isSuitableProtectGroup = provider.isSuitableProtectGroup(planType, protectGroup);
        if (!isSuitableProtectGroup) {
            return false;
        }
        boolean isPlanIncludedPg = this.isUsedProtectGroup(recoveryPlans, protectGroup);
        return !isPlanIncludedPg && !protectGroup.isInvalid();
    }

    private boolean isUsedProtectGroup(List<RecoveryPlan> recoveryPlans, ProtectGroup protectGroup) {
        if (recoveryPlans == null || recoveryPlans.isEmpty()) {
            logger.debug((Object)"recoveryPlans is null");
            return false;
        }
        for (RecoveryPlan recoveryPlan : recoveryPlans) {
            Set usedProtectGroups = recoveryPlan.getProtectGroups();
            for (ProtectGroup usedProtectGroup : usedProtectGroups) {
                if (!usedProtectGroup.getUuid().equals(protectGroup.getUuid())) continue;
                return true;
            }
        }
        return false;
    }

    private ProtectObjectBo convertToProtectObjectBo(ProtectObject protectObject, String pgName, String standbyHostIp) {
        ProtectObjectBo protectObjectBo = new ProtectObjectBo();
        ObjectConvert.convert((Object)protectObject, (Object)protectObjectBo);
        logger.debug((Object)"pgName is:%s.", new Object[]{pgName});
        protectObjectBo.setPgName(pgName);
        protectObjectBo.setStandbyHostIp(standbyHostIp);
        return protectObjectBo;
    }

    private void getRecoverySetting(RecoveryPlan recoveryPlan, Session session) {
        if (recoveryPlan == null || session == null) {
            logger.debug((Object)"param is null");
            return;
        }
        String queryHql = "from RecoverySetting rs where rs.recoveryPlan.planId=:planId";
        Query query = session.createQuery(queryHql);
        query.setParameter("planId", (Object)recoveryPlan.getPlanId());
        List recoverySettings = query.list();
        HashSet<RecoverySetting> settings = new HashSet<RecoverySetting>();
        if (recoverySettings != null && !recoverySettings.isEmpty()) {
            for (Object obj : recoverySettings) {
                settings.add((RecoverySetting)obj);
            }
        }
        recoveryPlan.setRecoverySettings(settings);
    }

    private void loadPoReplica(Set<ProtectGroup> protectGroups) {
        for (ProtectGroup pg : protectGroups) {
            Set replicaList = pg.getReplicaList();
            if (VerifyUtil.isEmpty((Collection)replicaList)) continue;
            for (ProtectGroupReplica pgReplica : replicaList) {
                Hibernate.initialize((Object)pgReplica.getReplicas());
            }
        }
    }

    protected abstract void fillRecoveryPlan(List<RecoveryPlan> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getBackRunningRecoveryTaskNum() {
        int count = 0;
        Session session = null;
        try {
            Object obj;
            session = this.getHibernateSession();
            String split = ",";
            StringBuffer querySql = new StringBuffer();
            querySql.append("select count(*) from ti_recoveryplan where PLANSTATUS in (");
            querySql.append(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_RUNNING.getValue()).append(split);
            querySql.append(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING.getValue()).append(split);
            querySql.append(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING.getValue()).append(split);
            querySql.append(DrmEnumDefine.RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING.getValue()).append(split);
            querySql.append(DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_RUNNING.getValue()).append(split);
            querySql.append(DrmEnumDefine.RecoveryPlanStatusE.ROLLBACK_RUNNING.getValue());
            querySql.append(')');
            NativeQuery query = session.createSQLQuery(querySql.toString());
            List recoveryPlans = query.list();
            if (recoveryPlans != null && !recoveryPlans.isEmpty() && (obj = recoveryPlans.get(0)) instanceof BigInteger) {
                count = ((BigInteger)obj).intValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Checking back recovery task count failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return count;
    }

    private boolean isNeedQueryFromDisaster(String productSiteId, String disasterSiteId) {
        if (VerifyUtil.isEmpty((String)productSiteId) || VerifyUtil.isEmpty((String)disasterSiteId)) {
            logger.debug((Object)"param is null");
            return false;
        }
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Site disasterSite = siteService.getSiteById(disasterSiteId);
        Site productSite = siteService.getSiteById(productSiteId);
        List localSites = siteService.getAllLocalSites();
        return localSites.contains(productSite) && !localSites.contains(disasterSite);
    }

    public void notifyListener(MessageEvent event) {
        this.listeners.forEach(listener -> listener.notify(event));
    }
}

