/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.PropsUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.service.impl.AbstractRecoveryPlanService;
import com.huawei.ism.drm.drp.util.RecoveryPlanQueryUtil;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public abstract class RecoveryPlanQueryServiceImpl
extends AbstractRecoveryPlanService {
    private static final Log logger = LogFactory.getInstance(RecoveryPlanQueryServiceImpl.class);
    private static final String QUERY_PLAN_SQL = "select rp.planid, rp.uuid, rp.planname, rp.plandesc, rp.planstatus, rp.planprogress, rp.plantype, rp.LASTTESTSTATUS, rp.PROCESSSTATUS, rp.PLANUSE,rp.CREATETIME,rp.OBJECTTYPE from ti_recoveryplan rp ";
    private static final List<String> RECOVERYPLAN_COLUME = new ArrayList<String>();

    public Map<String, Object> getDrillingStatisticsInfo(String recoveryPlanId) {
        RecoveryPlan recoveryPlan = this.queryRecoveryPlanWithoutAssociatedData(recoveryPlanId);
        if (recoveryPlan == null) {
            logger.error((Object)"Recovery plan does not exist. planId:%s.", new Object[]{recoveryPlanId, 90160758784001L});
            throw new LegoCheckedException(201L);
        }
        long lastReprotectEndTime = this.filterLastReprotectEndTime(recoveryPlanId);
        int successCount = 0;
        int failCount = 0;
        List<RecoveryLog> drillingHistLogs = this.getHistoryLogsByPlanId(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, null, null, null);
        if (!VerifyUtil.isEmpty(drillingHistLogs)) {
            for (RecoveryLog drillingLog : drillingHistLogs) {
                long startTime = Long.parseLong(drillingLog.getStartTime());
                if (lastReprotectEndTime >= startTime) continue;
                if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == drillingLog.getLogStatus()) {
                    ++successCount;
                    continue;
                }
                if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != drillingLog.getLogStatus() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != drillingLog.getLogStatus()) continue;
                ++failCount;
            }
        }
        HashMap<String, Object> statisticsInfo = new HashMap<String, Object>();
        statisticsInfo.put("failCount", failCount);
        statisticsInfo.put("successCount", successCount);
        statisticsInfo.put("totalCount", failCount + successCount);
        return statisticsInfo;
    }

    public List<RecoveryProcessorDetail> getRecoveryProcessorDetailsByPlanId(String recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE executeType) {
        if (recoveryPlanId == null || executeType == null) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(recoveryPlanId, false, true);
        if (recoveryPlan == null) {
            logger.error((Object)"Recovery plan does not exist. PlanId:%s.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        return this.getRecoveryProcessorDetailsByExecType(recoveryPlan, executeType);
    }

    public List<RecoveryLog> getHistoryReocveryLogsByPlanId(String recoveryPlanId) {
        if (recoveryPlanId == null) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = this.isRecoveryPlanExisted(recoveryPlanId);
        if (!isExisted) {
            logger.error((Object)"Recovery plan does not exist. PlanId:%s.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        return this.getHistoryLogsByPlanId(recoveryPlanId, null, null, null, null);
    }

    public List<RecoveryLog> getHistoryRecoveryLogsByPlanIdAndTypeAndResult(DrmEnumDefine.ReportTimeRangeE timeRange, String recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, DrmEnumDefine.RecoveryPlanExecuteResultE status, String proSiteId, String recoverySiteId) {
        if (recoveryPlanId == null) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return this.getHistoryLogsByPlanId(recoveryPlanId, type, status, proSiteId, recoverySiteId);
    }

    public List<RecoveryProcessorDetail> getRecoveryProcessorDetailsByLogId(String recoveryPlanId, String recoveryLogId) {
        if (recoveryLogId == null) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(recoveryPlanId, false, true);
        if (recoveryPlan == null) {
            logger.error((Object)"Recovery plan does not exist. logId:%s.", new Object[]{recoveryLogId});
            throw new LegoCheckedException(201L);
        }
        return this.getRecoveryProcessorDetailsByLogId(recoveryPlan, recoveryLogId);
    }

    private List<RecoveryProcessorDetail> getRecoveryProcessorDetailsByLogId(RecoveryPlan recoveryPlan, String recoveryLogId) {
        if (recoveryPlan == null || recoveryLogId == null) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryLog recoveryLog = this.queryRecoveryLog(recoveryLogId);
        if (recoveryLog == null) {
            logger.error((Object)"RecoveryLog is null.");
            throw new LegoCheckedException(201L);
        }
        List<RecoveryProcessorDetail> details = this.queryDetailsByLogId(recoveryLogId);
        details = this.extendUnRunningProcessDetail(recoveryPlan, details, recoveryLog.getLogType());
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryPlan queryRecoveryPlan(String planId, boolean isQueryPo, boolean firstPgOnly) {
        RecoveryPlan recoveryPlan = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            NativeQuery query = session.createSQLQuery("select rp.planid, rp.uuid, rp.planname, rp.plandesc, rp.planstatus, rp.planprogress, rp.plantype, rp.LASTTESTSTATUS, rp.PROCESSSTATUS, rp.PLANUSE,rp.CREATETIME,rp.OBJECTTYPE from ti_recoveryplan rp  where rp.planid=:planId");
            query.setParameter("planId", (Object)planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlan = RecoveryPlanQueryUtil.constructRecoveryPlans(results).get(0);
                Map<String, String> globalSettings = this.getRecoveryGlobalSettings(planId);
                recoveryPlan.setGlobalSettings(globalSettings);
                Set<RecoverySetting> recoverySettings = this.getRecoverySettingsBy(planId);
                recoveryPlan.setRecoverySettings(recoverySettings);
                for (RecoverySetting setting : recoverySettings) {
                    setting.setRecoveryPlan(recoveryPlan);
                }
                Set<ProtectGroup> protectGroups = this.getProtectGroupsByPlanId(planId, session, isQueryPo, firstPgOnly);
                recoveryPlan.setProtectGroups(protectGroups);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Querying recovery plan failed. Id:%s,error :%s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page pageQueryRecoveryLog(int pageNum, int pageSize, Long userId) {
        List<Object> recoveryLogs = new ArrayList();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySql = "select rl.LOGID, rl.LOGSTATUS, rl.LOGTYPE, rl.LOGNAME, rl.OPERATOR, rl.STARTTIME, rl.ENDTIME, rl.ISSYNCHRONIZED, rl.PRODUCTIONSITEID, rl.RECOVERYSITEID, rl.PLANID from TI_RECOVERYPLAN rp inner join TI_RECOVERYLOG rl on rl.PLANID=rp.PLANID  where rp.PLANSTATUS<>:rpStatus and rl.STARTTIME=(select MAX(STARTTIME) from TI_RECOVERYLOG  where PLANID=rp.PLANID) order by rl.STARTTIME desc ";
            NativeQuery query = session.createSQLQuery(querySql);
            query.setParameter("rpStatus", (Object)DrmEnumDefine.RecoveryPlanStatusE.INVALID.getValue());
            List list = query.list();
            if (!VerifyUtil.isEmpty((Collection)list)) {
                recoveryLogs = RecoveryPlanQueryUtil.constructRecoveryLogs(list);
            }
        }
        catch (Exception e) {
            logger.error((Object)"pageQueryRecoveryLog failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        ArrayList filterLogs = new ArrayList(recoveryLogs);
        if (!VerifyUtil.isEmpty(recoveryLogs)) {
            for (RecoveryLog recoveryLog : recoveryLogs) {
                try {
                    ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).checkUserGrantedObject(userId, recoveryLog.getPlanId());
                }
                catch (Exception e) {
                    filterLogs.remove(recoveryLog);
                }
            }
        }
        return Page.createPage((int)pageNum, (int)pageSize, filterLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RecoveryPlan> queryRecoveryPlans(long userId, boolean isQueryPo) {
        List<Object> recoveryPlans = new ArrayList();
        Session session = null;
        try {
            session = this.getHibernateSession();
            NativeQuery query = session.createSQLQuery(QUERY_PLAN_SQL);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlans = RecoveryPlanQueryUtil.constructRecoveryPlans(results);
                for (RecoveryPlan recoveryPlan : recoveryPlans) {
                    Map<String, String> globalSettings = this.getRecoveryGlobalSettings(recoveryPlan.getPlanId());
                    recoveryPlan.setGlobalSettings(globalSettings);
                    Set<RecoverySetting> recoverySettings = this.getRecoverySettingsBy(recoveryPlan.getPlanId());
                    recoveryPlan.setRecoverySettings(recoverySettings);
                    for (RecoverySetting setting : recoverySettings) {
                        setting.setRecoveryPlan(recoveryPlan);
                    }
                    Set<ProtectGroup> protectGroups = this.getProtectGroupsByPlanId(recoveryPlan.getPlanId(), session, isQueryPo, false);
                    recoveryPlan.setProtectGroups(protectGroups);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Querying recovery plans failed. Id:%s,isQueryPo:%s,error :%s", new Object[]{userId, isQueryPo, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        if (!VerifyUtil.isEmpty(recoveryPlans)) {
            recoveryPlans = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(Long.valueOf(userId), recoveryPlans);
        }
        return recoveryPlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<RecoverySetting> getRecoverySettingsBy(String planId) {
        Set<RecoverySetting> settings = new HashSet<RecoverySetting>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSql = "select settingid, planid, disastersiteid, ownerid, name, value from ti_recoverysetting where planid=:planid";
            NativeQuery query = session.createSQLQuery(strSql);
            query.setParameter("planid", (Object)planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                settings = RecoveryPlanQueryUtil.constructRecoverySettings(results);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Getting recovery settings failed. Id:" + planId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getRecoveryGlobalSettings(String planId) {
        Map<String, String> settings = new HashMap<String, String>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSQL = "select planid, propname, propvalue from ti_rp_globalsettings where planid=:planid";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setParameter("planid", (Object)planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                settings = RecoveryPlanQueryUtil.constructRecoveryGlobalSettings(results);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Getting recovery global settings failed. Id:" + planId), (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryPlan queryRecoveryPlanWithoutAssociatedData(String planId) {
        RecoveryPlan recoveryPlan = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            NativeQuery query = session.createSQLQuery("select rp.planid, rp.uuid, rp.planname, rp.plandesc, rp.planstatus, rp.planprogress, rp.plantype, rp.LASTTESTSTATUS, rp.PROCESSSTATUS, rp.PLANUSE,rp.CREATETIME,rp.OBJECTTYPE from ti_recoveryplan rp  where rp.planid=:planId");
            query.setParameter("planId", (Object)planId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlan = RecoveryPlanQueryUtil.constructRecoveryPlans(results).get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Querying recovery plan failed. Id:%s,error is %s.", new Object[]{planId, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryPlan;
    }

    public String getLatestRecoveryLogIdBy(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.");
            return null;
        }
        String queryHql = "select rl.LOGID from ti_recoverylog rl where rl.PLANID = ? order by rl.STARTTIME desc";
        List recoveryLogs = this.getBaseDao().executeNativeSql(queryHql, new Object[]{recoveryPlanId});
        String logId = "";
        if (recoveryLogs != null && !recoveryLogs.isEmpty()) {
            logId = (String)recoveryLogs.get(0);
        } else {
            logger.error((Object)"The logId is null,recoveryPlanId :%s. ", new Object[]{recoveryPlanId});
        }
        return logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RecoveryPlan> getRecoveryPlans(String orderBy, boolean isAsc, Map<String, Object> extFilterMap) {
        List<RecoveryPlan> recoveryPlans = new ArrayList<RecoveryPlan>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            StringBuilder strSqlBuilder = new StringBuilder();
            strSqlBuilder.append(QUERY_PLAN_SQL);
            List<QueryCondition> conditions = this.getRecoveryPlanCondition(extFilterMap);
            if (!VerifyUtil.isEmpty(extFilterMap)) {
                strSqlBuilder.append("where ");
                strSqlBuilder.append(RecoveryPlanQueryUtil.constructRpPageQuerySql(conditions, RECOVERYPLAN_COLUME));
            }
            if ("name".equalsIgnoreCase(orderBy)) {
                strSqlBuilder.append(" order by planname ");
            } else if ("planstatus".equalsIgnoreCase(orderBy)) {
                strSqlBuilder.append(" order by planstatus ");
            }
            strSqlBuilder.append(isAsc ? "asc" : "desc");
            NativeQuery query = session.createSQLQuery(strSqlBuilder.toString());
            this.setQuery(conditions, (Query)query);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                recoveryPlans = RecoveryPlanQueryUtil.constructRecoveryPlans(results);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery plans failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryPlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RecoveryProcessorDetail> getDetailsByLogId(String recoveryLogId) {
        if (recoveryLogId == null) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<RecoveryProcessorDetail> details = new ArrayList();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHql = "from RecoveryProcessorDetail rpd where rpd.parentDetailId=null and rpd.logId=:logId order by rpd.startTime asc";
            Query query = session.createQuery(queryHql);
            query.setParameter("logId", (Object)recoveryLogId);
            details = query.list();
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery process details failed. Id:%s,error is %s.", new Object[]{recoveryLogId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return details;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RecoveryProcessorDetail> queryDetailsByLogId(String recoveryLogId) {
        if (recoveryLogId == null) {
            logger.error((Object)"The parameter is null.");
            throw new LegoCheckedException(1073947393L);
        }
        List<RecoveryProcessorDetail> details = new ArrayList<RecoveryProcessorDetail>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String strSQL = "select DETAILID,STARTTIME,ENDTIME,PROCESSNAME,PROCESSNAMEPARAMS,PROCESSDETAIL,PROCESSDETAILPARAMS,PROCESSSTATUS,PROCID,LOGID,RELATEDDETAILID,PREVIOUSPROCID,NEXTPROCID,ISSKIPPED from ti_recoveryprocessordetail where logId=:logId";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setParameter("logId", (Object)recoveryLogId);
            List results = query.list();
            if (!VerifyUtil.isEmpty((Collection)results)) {
                Set<RecoveryProcessorDetail> allDetails = RecoveryPlanQueryUtil.constructRecoveryProcessorDetails(results);
                details = RecoveryPlanQueryUtil.groupRecoveryLogDetails(allDetails);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery process details failed. Id:%s,error is %s.", new Object[]{recoveryLogId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return details;
    }

    private List<QueryCondition> getRecoveryPlanCondition(Map<String, Object> extFilterMap) {
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        for (Map.Entry<String, Object> extFilter : extFilterMap.entrySet()) {
            String key = extFilter.getKey();
            Object val = extFilter.getValue();
            if (RECOVERYPLAN_COLUME.stream().anyMatch(col -> col.equalsIgnoreCase(key))) {
                conditions.add(new QueryCondition(key, val));
            }
            if (!"name".equals(key)) continue;
            conditions.add(new QueryCondition(key, val));
        }
        return conditions;
    }

    private List<RecoveryProcessorDetail> extendUnRunningProcessDetail(RecoveryPlan recoveryPlan, List<RecoveryProcessorDetail> details, int procType) {
        Set<RecoveryProcessDefinition> processes = this.getRecoveryProcessesWithSql(recoveryPlan.getPlanId(), procType);
        logger.info((Object)"recoveryPlan is: %s", new Object[]{recoveryPlan.getPlanId()});
        RecoveryProcessDefinition rpDefinition = null;
        Iterator<RecoveryProcessDefinition> iterator = processes.iterator();
        rpDefinition = iterator.hasNext() ? iterator.next() : RecoveryServiceUtil.getInitRecoveryProcessDefinition(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType));
        Set processors = rpDefinition.getRecoveryProcessors();
        List<RecoveryProcessor> sortedProcesses = RecoveryServiceUtil.sortRecoveryProcessors(processors);
        if (VerifyUtil.isEmpty(details)) {
            return this.generateSortedProcessorDetails(sortedProcesses);
        }
        return this.getSortedProcessorDetails(details, sortedProcesses);
    }

    private List<RecoveryProcessorDetail> generateSortedProcessorDetails(List<RecoveryProcessor> sortedProcesses) {
        ArrayList<RecoveryProcessorDetail> newDetails = new ArrayList<RecoveryProcessorDetail>();
        for (RecoveryProcessor processor : sortedProcesses) {
            if (!processor.getIsEnabled().booleanValue()) continue;
            RecoveryProcessorDetail newDetail = this.createRecoveryProcessorDetail(processor);
            newDetails.add(newDetail);
            if (VerifyUtil.isEmpty((Collection)processor.getChildProc()) || !(processor instanceof IInitialChildProcessor)) continue;
            List<RecoveryProcessorDetail> childDetails = RecoveryServiceUtil.sortRecoveryProcessors(processor.getChildProc()).stream().map(subRecoveryProcessor -> this.createRecoveryProcessorDetail((RecoveryProcessor)subRecoveryProcessor)).collect(Collectors.toList());
            childDetails.forEach(subDetail -> subDetail.setParentDetailId(newDetail.getDetailId()));
            newDetail.setChildDetails(childDetails);
        }
        return newDetails;
    }

    private List<RecoveryProcessorDetail> getSortedProcessorDetails(List<RecoveryProcessorDetail> details, List<RecoveryProcessor> sortedProcesses) {
        List<RecoveryProcessorDetail> sortedDetails = RecoveryServiceUtil.sortRecoveryProcessorDetails(details);
        this.setChildDetails(sortedProcesses, sortedDetails);
        if (VerifyUtil.isEmpty(sortedDetails)) {
            return sortedDetails;
        }
        RecoveryProcessorDetail lastDetail = sortedDetails.get(sortedDetails.size() - 1);
        if (VerifyUtil.isEmpty((String)lastDetail.getNextProcId())) {
            logger.debug((Object)"lastDetail.getNextProcId() is null");
            return sortedDetails;
        }
        RecoveryProcessor matchedProcessor = null;
        for (RecoveryProcessor processor : sortedProcesses) {
            if (!processor.getProcId().equals(lastDetail.getNextProcId())) continue;
            matchedProcessor = processor;
        }
        while (matchedProcessor != null) {
            if (matchedProcessor.getIsEnabled().booleanValue()) {
                RecoveryProcessorDetail newDetail = this.createRecoveryProcessorDetail(matchedProcessor);
                sortedDetails.add(newDetail);
            }
            matchedProcessor = matchedProcessor.getNextProcessor();
        }
        return sortedDetails;
    }

    private void setChildDetails(List<RecoveryProcessor> sortedProcesses, List<RecoveryProcessorDetail> sortedDetails) {
        if (VerifyUtil.isEmpty(sortedProcesses) || VerifyUtil.isEmpty(sortedDetails)) {
            return;
        }
        for (RecoveryProcessorDetail detail : sortedDetails) {
            for (RecoveryProcessor processor : sortedProcesses) {
                if (!(processor instanceof IInitialChildProcessor) || detail.getProcId() == null || !detail.getProcId().equals(processor.getProcId())) continue;
                List<RecoveryProcessorDetail> newChilds = this.getSortedProcessorDetails(detail.getChildDetails(), RecoveryServiceUtil.sortRecoveryProcessors(processor.getChildProc()));
                newChilds.forEach(child -> child.setParentDetailId(detail.getDetailId()));
                detail.setChildDetails(newChilds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RecoveryProcessDefinition> getRecoveryProcessesWithSql(String recoveryPlanId, int procType) {
        Set<RecoveryProcessDefinition> processes;
        Session session = null;
        try {
            session = this.getHibernateSession();
            processes = this.getRecoveryProcessesWithSql(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType), session);
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery process failed. PlanId:%s,error is %s.", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e)});
            processes = new HashSet<RecoveryProcessDefinition>();
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return processes;
    }

    private Set<RecoveryProcessDefinition> getRecoveryProcessesWithSql(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, Session session) {
        List results;
        HashSet<RecoveryProcessDefinition> processes = new HashSet<RecoveryProcessDefinition>();
        if (planId == null || session == null) {
            return processes;
        }
        String querySql = "select PROCESSID,PROCTYPE,APPTYPE,PROTECTIONTYPE,PLANID,DISASTERSITEID from ti_recoveryprocessdefinition where PLANID=:planId";
        if (null != type) {
            querySql = querySql + " and PROCTYPE=:procType";
        }
        NativeQuery query = session.createSQLQuery(querySql);
        query.setParameter("planId", (Object)planId);
        if (type != null) {
            query.setInteger("procType", type.getValue());
        }
        if (VerifyUtil.isEmpty((Collection)(results = query.list()))) {
            return processes;
        }
        RecoveryPlan recoveryPlan = this.queryRecoveryPlan(planId);
        Set<RecoveryProcessDefinition> recoveryProcesses = this.constructRecoveryProcessDefinitions(results);
        for (RecoveryProcessDefinition rpDefinition : recoveryProcesses) {
            Set<RecoveryProcessor> recoveryProcessors = this.getRecoveryProcessorsWithSql(rpDefinition.getProcessId(), type, session);
            for (RecoveryProcessor processor : recoveryProcessors) {
                processor.resetEnableStatus(recoveryPlan, type);
            }
            rpDefinition.setRecoveryProcessors(recoveryProcessors);
            processes.add(rpDefinition);
        }
        return processes;
    }

    private RecoveryPlan queryRecoveryPlan(String planId) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId, false, false);
        if (recoveryPlan == null) {
            logger.error((Object)"pgIterator hasNext failed.PlanId:%s", new Object[]{planId});
            throw new LegoCheckedException(201L);
        }
        return recoveryPlan;
    }

    private Set<RecoveryProcessor> getRecoveryProcessorsWithSql(String processId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, Session session) {
        List results;
        Set<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (processId == null || session == null) {
            return processors;
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append("select discriminator,PROCID,PROCNAME,PROCTYPE,PROCSTATUS,STARTTIME,ENDTIME,ISENABLE,");
        querySql.append("ISEDITABLE,ISPRESET,PROCESSID,PARENTPROCID,PREPROCID,NEXTPROCID,NEXTCASCADEPROCID,PLANID ");
        querySql.append("from ti_recoveryprocessor where PROCESSID=:processId");
        if (type != null) {
            querySql.append(" and PROCTYPE=:procType");
        }
        NativeQuery query = session.createSQLQuery(querySql.toString());
        query.setParameter("processId", (Object)processId);
        if (type != null) {
            query.setParameter("procType", (Object)type.getValue());
        }
        if ((results = query.list()) != null && !results.isEmpty()) {
            Set<RecoveryProcessor> recoveryProcessors = RecoveryPlanQueryUtil.constructRecoveryProcessors(results);
            processors = this.groupRecoveryProcessors(recoveryProcessors);
        }
        return processors;
    }

    private Set<RecoveryProcessor> groupRecoveryProcessors(Set<RecoveryProcessor> recoveryProcessors) {
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (VerifyUtil.isEmpty(recoveryProcessors)) {
            logger.debug((Object)"recoveryProcessors is null");
            return processors;
        }
        HashMap<String, RecoveryProcessor> processorsMap = new HashMap<String, RecoveryProcessor>();
        HashMap groupProcessors = new HashMap();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            processorsMap.put(recoveryProcessor.getProcId(), recoveryProcessor);
            HashSet subProcessors = (HashSet)groupProcessors.get(recoveryProcessor.getProcId());
            if (subProcessors == null) {
                subProcessors = new HashSet();
                groupProcessors.put(recoveryProcessor.getProcId(), subProcessors);
            }
            recoveryProcessor.setChildProc((Set)subProcessors);
            if (VerifyUtil.isEmpty((String)recoveryProcessor.getParentProcId())) {
                processors.add(recoveryProcessor);
                continue;
            }
            HashSet<RecoveryProcessor> parentSubProcessors = (HashSet<RecoveryProcessor>)groupProcessors.get(recoveryProcessor.getParentProcId());
            if (parentSubProcessors == null) {
                parentSubProcessors = new HashSet<RecoveryProcessor>();
                groupProcessors.put(recoveryProcessor.getParentProcId(), parentSubProcessors);
            }
            parentSubProcessors.add(recoveryProcessor);
        }
        this.resetRecoveryProcessors(processors, processorsMap);
        return processors;
    }

    private void resetRecoveryProcessors(Set<RecoveryProcessor> processors, Map<String, RecoveryProcessor> rpProcessorsMap) {
        if (VerifyUtil.isEmpty(processors)) {
            logger.debug((Object)"processors is null.");
            return;
        }
        for (RecoveryProcessor processor : processors) {
            processor.setParentProc(rpProcessorsMap.get(processor.getParentProcId()));
            processor.setPreviousProcessor(rpProcessorsMap.get(processor.getPreProcId()));
            processor.setNextProcessor(rpProcessorsMap.get(processor.getNextProcId()));
            processor.setNextCascadeProcessor(rpProcessorsMap.get(processor.getNextCascadeProcId()));
            if (VerifyUtil.isEmpty((Collection)processor.getChildProc())) continue;
            this.resetRecoveryProcessors(processor.getChildProc(), rpProcessorsMap);
        }
    }

    private List<RecoveryProcessorDetail> getRecoveryProcessorDetailsByExecType(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE executeType) {
        List<RecoveryProcessorDetail> details = new ArrayList<RecoveryProcessorDetail>();
        String recoveryPlanId = recoveryPlan.getPlanId();
        RecoveryLog recoveryLog = this.getLatestRecoveryLog(recoveryPlanId);
        if (recoveryLog != null && recoveryLog.getLogType() == executeType.getValue()) {
            details = this.getRecoveryProcessorDetailsByLogId(recoveryPlan, recoveryLog.getLogId());
        }
        return this.extendUnRunningProcessDetail(recoveryPlan, details, executeType.getValue());
    }

    private RecoveryProcessorDetail createRecoveryProcessorDetail(RecoveryProcessor process) {
        process.updateProcessName();
        RecoveryProcessorDetail newDetail = new RecoveryProcessorDetail();
        newDetail.setDetailId(UUIDGenerator.getUUID());
        newDetail.setProcessName(process.getProcName());
        newDetail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        newDetail.setProcId(process.getProcId());
        return newDetail;
    }

    private List<String> getProtectGroupIdsByPlanId(String planId, Session session) {
        ArrayList<String> protectGroupIds = new ArrayList<String>();
        String strSql = "select PGID from ti_drp_r_pg where PLANID=:planId";
        NativeQuery query = session.createSQLQuery(strSql);
        query.setParameter("planId", (Object)planId);
        List results = query.list();
        logger.info((Object)"planId: %s", new Object[]{planId});
        if (!VerifyUtil.isEmpty((Collection)results)) {
            results.forEach(id -> protectGroupIds.add(String.valueOf(id)));
        } else {
            logger.error((Object)"can not find protectgroup for planID:%s.", new Object[]{planId});
        }
        return protectGroupIds;
    }

    protected Set<ProtectGroup> getProtectGroupsByPlanId(String planId, Session session, boolean isQueryPos, boolean firstPgOnly) {
        HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
        List<String> protectGroupIds = this.getProtectGroupIdsByPlanId(planId, session);
        String querySql = "select pg.PGID, pg.UUID as PGUUID, pg.PRODUCTSITEID, st.siteName, pg.PGNAME, pg.POTYPE, pt.TYPE, pt.SUBTYPE, pg.ISPRIMARY, pg.STATUS, pt.UUID as PTUUID, pt.NAME, pt.DESCRIPTION, pg.PGPROVIDERSN from ti_protectgroup pg, ti_site st, ti_policytemplate pt where pg.PTID = pt.PTID and pg.PRODUCTSITEID = st.siteId and pg.PGID=:pgId";
        NativeQuery query = session.createSQLQuery(querySql);
        for (String protectGroupId : protectGroupIds) {
            query.setParameter("pgId", (Object)protectGroupId);
            List results = query.list();
            if (VerifyUtil.isEmpty((Collection)results)) {
                logger.info((Object)"results: %s", new Object[]{protectGroupId});
                continue;
            }
            List<ProtectGroup> pgs = RecoveryPlanQueryUtil.constructProtectGroups(results);
            for (ProtectGroup protectGroup : pgs) {
                Set<ProtectGroupReplica> pgReplicas = this.getProtectGroupReplicas(protectGroup.getUuid(), session);
                protectGroup.setReplicaList(pgReplicas);
                protectGroup.setProps(PropsUtil.queryPropMapById(PropsUtil.PropModel.PROTECTGROUP, protectGroup.getUuid()));
                if (isQueryPos) {
                    Set<ProtectObject> protectObjects = this.getProtectObjects(protectGroup.getUuid(), session);
                    protectGroup.setPolist(protectObjects);
                }
                protectGroups.add(protectGroup);
            }
            if (!firstPgOnly) continue;
            break;
        }
        return protectGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RecoveryLog> getHistoryLogsByPlanId(String recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, DrmEnumDefine.RecoveryPlanExecuteResultE status, String productionSiteId, String recoverySiteId) {
        ArrayList<RecoveryLog> recoveryLogs = new ArrayList();
        StringBuffer queryHql = RecoveryPlanQueryUtil.getHistoryLogQueryString(recoveryPlanId, type, status, productionSiteId, recoverySiteId);
        Session session = null;
        try {
            session = this.getHibernateSession();
            Query query = session.createQuery(queryHql.toString());
            if (recoveryPlanId != null) {
                query.setParameter("planId", (Object)recoveryPlanId);
            }
            if (type != null) {
                query.setParameter("logType", (Object)type.getValue());
            }
            if (status != null) {
                query.setParameter("logStatus", (Object)status.getValue());
            }
            if (productionSiteId != null) {
                query.setParameter("productionSiteId", (Object)productionSiteId);
            }
            if (recoverySiteId != null) {
                query.setParameter("recoverySiteId", (Object)recoverySiteId);
            }
            recoveryLogs = query.list();
        }
        catch (Exception e) {
            logger.error((Object)"Getting recovery logs failed. Id:%s,error is %s.", new Object[]{recoveryPlanId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoveryLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryLog queryRecoveryLog(String logId) {
        Session session;
        RecoveryLog recoveryLog;
        block6: {
            List results;
            block5: {
                recoveryLog = null;
                session = null;
                String querySql = "select LOGID,LOGSTATUS,LOGTYPE,LOGNAME,OPERATOR,STARTTIME,ENDTIME,ISSYNCHRONIZED,PRODUCTIONSITEID,RECOVERYSITEID,PLANID from ti_recoverylog where LOGID=:logId";
                session = this.getHibernateSession();
                NativeQuery query = session.createSQLQuery(querySql);
                query.setParameter("logId", (Object)logId);
                results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) break block5;
                RecoveryLog recoveryLog2 = null;
                DBOperationUtil.closeSession(session);
                return recoveryLog2;
            }
            try {
                Iterator<RecoveryLog> iterator = RecoveryPlanQueryUtil.constructRecoveryLogs(results).iterator();
                if (!iterator.hasNext()) break block6;
                recoveryLog = iterator.next();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"Querying recovery log failed. Id:%s,error iss %s.", new Object[]{logId, ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return recoveryLog;
    }

    private long filterLastReprotectEndTime(String recoveryPlanId) {
        List<RecoveryLog> reprotectHistLogs = this.getHistoryLogsByPlanId(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT, null, null, null);
        long lastReprotectEndTime = 0L;
        if (VerifyUtil.isEmpty(reprotectHistLogs)) {
            logger.info((Object)"reprotectHistLogs is null:%s", new Object[]{recoveryPlanId});
            return lastReprotectEndTime;
        }
        for (RecoveryLog reprotectLog : reprotectHistLogs) {
            long endTime;
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != reprotectLog.getLogStatus() || lastReprotectEndTime >= (endTime = Long.parseLong(reprotectLog.getEndTime()))) continue;
            lastReprotectEndTime = endTime;
        }
        return lastReprotectEndTime;
    }

    private void setQuery(List<QueryCondition> conditions, Query query) {
        for (QueryCondition condition : conditions) {
            if (condition.getPropName().equalsIgnoreCase("name")) {
                String filterValue = ((String)condition.getPropValue()).replaceAll("_", "\\\\_");
                filterValue = filterValue.replaceAll("%", "\\\\%");
                query.setParameter(condition.getPropName(), (Object)("%" + filterValue + "%"));
                continue;
            }
            if (condition.getPropName().equalsIgnoreCase("planstatus")) {
                int planStatus = Integer.parseInt(String.valueOf(condition.getPropValue()));
                query.setParameter(condition.getPropName(), (Object)planStatus);
                continue;
            }
            if (condition.getPropName().equalsIgnoreCase("planuse")) {
                int planType = Integer.parseInt(String.valueOf(condition.getPropValue()));
                query.setParameter(condition.getPropName(), (Object)planType);
                continue;
            }
            if (!condition.getPropName().equalsIgnoreCase("objectType")) continue;
            query.setParameter(condition.getPropName(), (Object)ServiceInstaceEnumDefine.ObjectType.getObjectType((String)String.valueOf(condition.getPropValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ProtectGroup> getProtectGroupsByPlanId(String planId, boolean isQueryPos) {
        HashSet<ProtectGroup> protectGroups = new HashSet();
        Session session = null;
        try {
            session = this.getHibernateSession();
            protectGroups = this.getProtectGroupsByPlanId(planId, session, isQueryPos, false);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"getProtectGroupsByPlanId failed.", (long)-1L, (String[])new String[0], (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return protectGroups;
    }

    static {
        RECOVERYPLAN_COLUME.add("planid");
        RECOVERYPLAN_COLUME.add("uuid");
        RECOVERYPLAN_COLUME.add("planname");
        RECOVERYPLAN_COLUME.add("plandesc");
        RECOVERYPLAN_COLUME.add("planstatus");
        RECOVERYPLAN_COLUME.add("planprogress");
        RECOVERYPLAN_COLUME.add("plantype");
        RECOVERYPLAN_COLUME.add("lastteststatus");
        RECOVERYPLAN_COLUME.add("processstatus");
        RECOVERYPLAN_COLUME.add("planuse");
        RECOVERYPLAN_COLUME.add("objectType");
    }
}

