/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.util;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.service.impl.RecoveryProcessorDetailComparator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RecoveryPlanQueryUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryPlanQueryUtil.class);

    private RecoveryPlanQueryUtil() {
    }

    public static String constructRpPageQuerySql(List<QueryCondition> conditions, List<String> recoveryPlanColume) {
        if (VerifyUtil.isEmpty(conditions)) {
            return "";
        }
        StringBuilder strSqlBuilder = new StringBuilder();
        int count = 0;
        for (QueryCondition condition : conditions) {
            if (condition.getPropName().equalsIgnoreCase("name")) {
                strSqlBuilder.append("planname ilike :").append(condition.getPropName());
            } else if ("objectType".equals(condition.getPropName()) && ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue().equals(condition.getPropValue())) {
                strSqlBuilder.append(" ( ");
                strSqlBuilder.append(condition.getPropName()).append("= :").append(condition.getPropName());
                strSqlBuilder.append(" or ");
                strSqlBuilder.append(condition.getPropName()).append(" is null ");
                strSqlBuilder.append(" ) ");
            } else {
                if (!recoveryPlanColume.stream().anyMatch(col -> col.equalsIgnoreCase(condition.getPropName()))) continue;
                strSqlBuilder.append(condition.getPropName()).append("= :").append(condition.getPropName());
            }
            if (++count >= conditions.size()) continue;
            strSqlBuilder.append(" and ");
        }
        return strSqlBuilder.toString();
    }

    public static List<ProtectGroup> constructProtectGroups(List<?> result) {
        ArrayList<ProtectGroup> protectGroups = new ArrayList<ProtectGroup>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || (values = (Object[])object).length != 14) continue;
            ProtectGroup protectGroup = new ProtectGroup();
            protectGroup.setUuid(CommUtil.convertToString((Object)values[1]));
            protectGroup.setProductSiteId(CommUtil.convertToString((Object)values[2]));
            protectGroup.setProductSiteName(CommUtil.convertToString((Object)values[3]));
            protectGroup.setName(CommUtil.convertToString((Object)values[4]));
            protectGroup.setPoType(CommUtil.convertToInteger((Object)values[5]).intValue());
            protectGroup.setPoProviderSN(CommUtil.convertToString((Object)values[13]));
            PolicyTemplate template = new PolicyTemplate();
            Integer templateType = CommUtil.convertToInteger((Object)values[6]);
            Integer templateSubType = CommUtil.convertToInteger((Object)values[7]);
            template.setType(templateType.intValue());
            template.setSubType((0 >= templateSubType ? templateType : templateSubType).intValue());
            template.setUuid(String.valueOf(values[10]));
            template.setName(String.valueOf(values[11]));
            template.setDescription(String.valueOf(values[12]));
            protectGroup.setTemplate(template);
            protectGroup.setPrimary(CommUtil.convertToBoolean((Object)values[8]).booleanValue());
            protectGroup.setStatus(NumberUtil.convertToInteger((Object)String.valueOf(values[9])).intValue());
            protectGroups.add(protectGroup);
            logger.info((Object)"protectGroup is: %s", new Object[]{protectGroup.getName()});
        }
        return protectGroups;
    }

    public static StringBuffer getHistoryLogQueryString(String recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, DrmEnumDefine.RecoveryPlanExecuteResultE status, String productionSiteId, String recoverySiteId) {
        StringBuffer queryHql = new StringBuffer();
        queryHql.append("from RecoveryLog rl where rl.endTime!=null ");
        if (recoveryPlanId != null) {
            queryHql.append("and rl.planId=:planId ");
        }
        if (type != null) {
            queryHql.append("and rl.logType=:logType ");
        }
        if (status != null) {
            queryHql.append("and rl.logStatus<>:logStatus ");
        }
        if (productionSiteId != null) {
            queryHql.append("and rl.productionSiteId=:productionSiteId ");
        }
        if (recoverySiteId != null) {
            queryHql.append("and rl.recoverySiteId=:recoverySiteId ");
        }
        queryHql.append("order by rl.endTime desc");
        return queryHql;
    }

    public static List<RecoveryLog> constructRecoveryLogs(List<?> results) {
        ArrayList<RecoveryLog> recoveryLogs = new ArrayList<RecoveryLog>();
        for (Object object : results) {
            if (!(object instanceof Object[])) continue;
            Object[] values = (Object[])object;
            if (values.length != 11) {
                logger.info((Object)"param is error: %s.", new Object[]{String.valueOf(values.length)});
                continue;
            }
            RecoveryLog recoveryLog = new RecoveryLog();
            recoveryLog.setLogId(CommUtil.convertToString((Object)values[0]));
            recoveryLog.setLogStatus(CommUtil.convertToInteger((Object)values[1]).intValue());
            recoveryLog.setLogType(CommUtil.convertToInteger((Object)values[2]).intValue());
            recoveryLog.setLogName(CommUtil.convertToString((Object)values[3]));
            recoveryLog.setOperator(CommUtil.convertToString((Object)values[4]));
            recoveryLog.setStartTime(CommUtil.convertToString((Object)values[5]));
            recoveryLog.setEndTime(CommUtil.convertToString((Object)values[6]));
            recoveryLog.setIsSynchronized(CommUtil.convertToBoolean((Object)values[7]));
            recoveryLog.setProductionSiteId(CommUtil.convertToString((Object)values[8]));
            recoveryLog.setRecoverySiteId(CommUtil.convertToString((Object)values[9]));
            recoveryLog.setPlanId(CommUtil.convertToString((Object)values[10]));
            recoveryLogs.add(recoveryLog);
        }
        return recoveryLogs;
    }

    public static List<RecoveryProcessorDetail> groupRecoveryLogDetails(Set<RecoveryProcessorDetail> allDetails) {
        ArrayList<RecoveryProcessorDetail> details = new ArrayList<RecoveryProcessorDetail>();
        if (VerifyUtil.isEmpty(allDetails)) {
            return details;
        }
        HashMap groupDetails = new HashMap();
        for (RecoveryProcessorDetail rpDetail : allDetails) {
            ArrayList subDetails = (ArrayList)groupDetails.get(rpDetail.getDetailId());
            if (subDetails == null) {
                subDetails = new ArrayList();
                groupDetails.put(rpDetail.getDetailId(), subDetails);
            }
            rpDetail.setChildDetails((List)subDetails);
            if (VerifyUtil.isEmpty((String)rpDetail.getParentDetailId())) {
                details.add(rpDetail);
                continue;
            }
            ArrayList<RecoveryProcessorDetail> parentSubDetails = (ArrayList<RecoveryProcessorDetail>)groupDetails.get(rpDetail.getParentDetailId());
            if (parentSubDetails == null) {
                parentSubDetails = new ArrayList<RecoveryProcessorDetail>();
                groupDetails.put(rpDetail.getParentDetailId(), parentSubDetails);
            }
            parentSubDetails.add(rpDetail);
        }
        RecoveryPlanQueryUtil.sortRecoveryLogDetails(details, new RecoveryProcessorDetailComparator());
        return details;
    }

    private static void sortRecoveryLogDetails(List<RecoveryProcessorDetail> details, RecoveryProcessorDetailComparator comparator) {
        if (VerifyUtil.isEmpty(details)) {
            logger.debug((Object)"details is null");
            return;
        }
        details.sort(comparator);
        for (RecoveryProcessorDetail detail : details) {
            if (VerifyUtil.isEmpty((Collection)detail.getChildDetails())) continue;
            RecoveryPlanQueryUtil.sortRecoveryLogDetails(detail.getChildDetails(), comparator);
        }
    }

    public static Set<RecoveryProcessor> constructRecoveryProcessors(List<?> results) {
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        for (Object object : results) {
            if (!(object instanceof Object[])) continue;
            Object[] values = (Object[])object;
            if (values.length != 16) {
                logger.info((Object)"param is error: %s.", new Object[]{String.valueOf(values.length)});
                continue;
            }
            String discriminator = CommUtil.convertToString((Object)values[0]);
            String className = CommUtil.convertToString((Object)values[2]);
            RecoveryProcessor processor = RecoveryPlanQueryUtil.createRecoveryProcessor(className, discriminator);
            processor.setProcId(CommUtil.convertToString((Object)values[1]));
            processor.setProcName(CommUtil.convertToString((Object)values[2]));
            processor.setProcType(CommUtil.convertToInteger((Object)values[3]).intValue());
            processor.setProcStatus(CommUtil.convertToInteger((Object)values[4]).intValue());
            processor.setStartTime(CommUtil.convertToString((Object)values[5]));
            processor.setEndTime(CommUtil.convertToString((Object)values[6]));
            processor.setIsEnabled(CommUtil.convertToBoolean((Object)values[7]));
            processor.setIsEditable(CommUtil.convertToBoolean((Object)values[8]));
            processor.setIsPreset(CommUtil.convertToBoolean((Object)values[9]));
            processor.setProcessId(CommUtil.convertToString((Object)values[10]));
            processor.setParentProcId(CommUtil.convertToString((Object)values[11]));
            processor.setPreProcId(CommUtil.convertToString((Object)values[12]));
            processor.setNextProcId(CommUtil.convertToString((Object)values[13]));
            processor.setNextCascadeProcId(CommUtil.convertToString((Object)values[14]));
            processor.setPlanId(CommUtil.convertToString((Object)values[15]));
            processors.add(processor);
        }
        return processors;
    }

    private static RecoveryProcessor createRecoveryProcessor(String className, String discriminator) {
        RecoveryProcessor processor = null;
        try {
            ClassLoader clsLoader = DrmObjectSerializableUtil.getGlobalClassLoader();
            if (!VerifyUtil.isEmpty((String)className)) {
                processor = (RecoveryProcessor)Class.forName(className, true, clsLoader).newInstance();
            } else {
                logger.warn((Object)"The className is null. discriminator:%s,", new Object[]{discriminator});
            }
        }
        catch (Exception e) {
            processor = new RecoveryProcessor();
        }
        return processor;
    }

    public static Set<RecoveryProcessorDetail> constructRecoveryProcessorDetails(List<?> results) {
        HashSet<RecoveryProcessorDetail> logDetails = new HashSet<RecoveryProcessorDetail>();
        for (Object object : results) {
            if (!(object instanceof Object[])) continue;
            Object[] values = (Object[])object;
            if (values.length != 14) {
                logger.info((Object)"param is error: %s", new Object[]{String.valueOf(values.length)});
                continue;
            }
            RecoveryProcessorDetail logDetail = new RecoveryProcessorDetail();
            logDetail.setDetailId(CommUtil.convertToString((Object)values[0]));
            logDetail.setStartTime(CommUtil.convertToString((Object)values[1]));
            logDetail.setEndTime(CommUtil.convertToString((Object)values[2]));
            logDetail.setProcessName(CommUtil.convertToString((Object)values[3]));
            logDetail.setProcessNameParams(CommUtil.convertToString((Object)values[4]));
            logDetail.setProcessDetail(CommUtil.convertToString((Object)values[5]));
            logDetail.setProcessDetailParams(CommUtil.convertToString((Object)values[6]));
            logDetail.setProcessStatus(CommUtil.convertToInteger((Object)values[7]).intValue());
            logDetail.setProcId(CommUtil.convertToString((Object)values[8]));
            logDetail.setLogId(CommUtil.convertToString((Object)values[9]));
            logDetail.setParentDetailId(CommUtil.convertToString((Object)values[10]));
            logDetail.setPreviousProcId(CommUtil.convertToString((Object)values[11]));
            logDetail.setNextProcId(CommUtil.convertToString((Object)values[12]));
            logDetail.setIsSkipped(CommUtil.convertToBoolean((Object)values[13]));
            logDetails.add(logDetail);
        }
        return logDetails;
    }

    public static List<RecoveryPlan> constructRecoveryPlans(List<?> result) {
        ArrayList<RecoveryPlan> recoveryPlans = new ArrayList<RecoveryPlan>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || (values = (Object[])object).length != 12) continue;
            RecoveryPlan recoveryPlan = new RecoveryPlan();
            recoveryPlan.setPlanId(CommUtil.convertToString((Object)values[0]));
            recoveryPlan.setUuid(CommUtil.convertToString((Object)values[1]));
            recoveryPlan.setName(CommUtil.convertToString((Object)values[2]));
            recoveryPlan.setDescription(CommUtil.convertToString((Object)values[3]));
            recoveryPlan.setPlanStatus(CommUtil.convertToInteger((Object)values[4]).intValue());
            recoveryPlan.setPlanProgress(CommUtil.convertToInteger((Object)values[5]).intValue());
            recoveryPlan.setPlanType(CommUtil.convertToInteger((Object)values[6]).intValue());
            recoveryPlan.setLastTestStatus(CommUtil.convertToInteger((Object)values[7]).intValue());
            recoveryPlan.setProcessStatus(CommUtil.convertToInteger((Object)values[8]).intValue());
            recoveryPlan.setUse(CommUtil.convertToInteger((Object)values[9]));
            recoveryPlan.setCreateTime(CommUtil.convertToLong((Object)values[10]));
            recoveryPlan.setObjectType(CommUtil.convertToString((Object)values[11]));
            recoveryPlans.add(recoveryPlan);
            logger.info((Object)"recoveryPlan is: %s", new Object[]{recoveryPlan.getName()});
        }
        return recoveryPlans;
    }

    public static Set<RecoverySetting> constructRecoverySettings(List<?> result) {
        HashSet<RecoverySetting> recoverySettings = new HashSet<RecoverySetting>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || (values = (Object[])object).length != 6) continue;
            RecoverySetting recoverySetting = new RecoverySetting();
            recoverySetting.setSettingId(CommUtil.convertToString((Object)values[0]));
            recoverySetting.setPlanId(CommUtil.convertToString((Object)values[1]));
            recoverySetting.setDisasterSiteId(CommUtil.convertToString((Object)values[2]));
            recoverySetting.setOwnerId(CommUtil.convertToString((Object)values[3]));
            recoverySetting.setName(CommUtil.convertToString((Object)values[4]));
            recoverySetting.setValue(CommUtil.convertToString((Object)values[5]));
            recoverySettings.add(recoverySetting);
            logger.info((Object)"recoverySetting is: %s", new Object[]{recoverySetting.getName()});
        }
        return recoverySettings;
    }

    public static Map<String, String> constructRecoveryGlobalSettings(List<?> result) {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (Object object : result) {
            if (!(object instanceof Object[])) continue;
            Object[] values = (Object[])object;
            if (values.length != 3) {
                logger.info((Object)"param is error: %s", new Object[]{String.valueOf(values.length)});
                continue;
            }
            String propName = CommUtil.convertToString((Object)values[1]);
            String propValue = CommUtil.convertToString((Object)values[2]);
            settings.put(propName, propValue);
        }
        return settings;
    }
}

