/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.storage.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public final class RecoveryServiceUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryServiceUtil.class);
    private static final int LOG_DETAIL_LIMIT = 64;

    private RecoveryServiceUtil() {
    }

    public static void checkOperationPrivilegeBySite(RecoveryPlan recoveryPlan) {
        boolean isLocalRecoverySite;
        Set<String> disasterSiteIds;
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"Context is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"recoveryPlan: %s.", new Object[]{recoveryPlan.getPlanId(), 1073947393L});
            throw new LegoCheckedException(1073947393L);
        }
        String productSiteId = ((ProtectGroup)iterator.next()).getProductSiteId();
        Site productSite = siteService.getSiteById(productSiteId);
        List localSites = siteService.getAllLocalSites();
        if (localSites.contains(productSite) && !VerifyUtil.isEmpty(disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan)) && 1 == disasterSiteIds.size() && !(isLocalRecoverySite = RecoveryServiceUtil.isExistLocalRecoverySite(disasterSiteIds))) {
            logger.error((Object)"RecoverySite is not local.");
            throw new LegoCheckedException(1073948711L);
        }
    }

    public static void checkReprotectOperationPrivilege(RecoveryPlan recoveryPlan) {
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            logger.debug((Object)"Param provider is null.");
            return;
        }
        provider.checkIfAllowReprotect(recoveryPlan);
    }

    public static void checkRecoveryOperationPrivilegeBySite(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        RecoveryServiceUtil.checkOperationPrivilegeBySite(recoveryPlan);
        String curDisasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (VerifyUtil.isEmpty((String)curDisasterSiteId)) {
            logger.debug((Object)"Param curDisasterSiteId is null,planName: %s.", new Object[]{recoveryPlan.getName()});
            return;
        }
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Site curDisasterSite = siteService.getSiteById(curDisasterSiteId);
        if (curDisasterSite == null) {
            logger.debug((Object)"Param curDisasterSite is null.");
            return;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() == recoveryPlan.getPlanStatus() && (procType == null || DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == procType.getValue())) {
            return;
        }
        if (curDisasterSite.getSiteType() != 0) {
            throw new LegoCheckedException(1073948730L);
        }
    }

    public static void checkRecoveryOperationPrivilegeBySite(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String newDisasterSiteId) {
        RecoveryServiceUtil.checkOperationPrivilegeBySite(recoveryPlan);
        logger.debug((Object)"Param recoveryPlan is: %s.", new Object[]{recoveryPlan.getName()});
        if (VerifyUtil.isEmpty((String)newDisasterSiteId)) {
            logger.warn((Object)"Disaster site id empty.");
            return;
        }
        Site recoverySite = RecoveryServiceUtil.getRecoverySite(newDisasterSiteId);
        if (recoverySite.getSiteType() != 0) {
            throw new LegoCheckedException(1073948730L);
        }
    }

    public static List<RecoveryProcessorDetail> sortRecoveryProcessorDetails(List<RecoveryProcessorDetail> details) {
        ArrayList<RecoveryProcessorDetail> sortedDetails = new ArrayList<RecoveryProcessorDetail>();
        if (VerifyUtil.isEmpty(details)) {
            logger.debug((Object)"Parma details is null.");
            return sortedDetails;
        }
        boolean isContainsEndProcessor = details.stream().anyMatch(detail -> detail.getProcessName().contains("EndRecoveryProcessor") || detail.getProcessName().contains("ism.drm.planedmotion.end.process.name"));
        RecoveryProcessorDetail firstDetail = RecoveryServiceUtil.getFirstRecoveryProcessorDetail(details, isContainsEndProcessor);
        if (firstDetail == null) {
            return details;
        }
        sortedDetails.add(firstDetail);
        while (firstDetail != null && !VerifyUtil.isEmpty((String)firstDetail.getNextProcId())) {
            String nextProcId = firstDetail.getNextProcId();
            firstDetail = null;
            for (RecoveryProcessorDetail detail2 : details) {
                if (!VerifyUtil.isEmpty((String)detail2.getParentDetailId()) && !isContainsEndProcessor || !detail2.getProcId().equals(nextProcId)) continue;
                firstDetail = detail2;
                RecoveryServiceUtil.limitLogDetailSize(firstDetail);
                sortedDetails.add(firstDetail);
            }
        }
        if (sortedDetails.size() != details.size()) {
            return details;
        }
        return sortedDetails;
    }

    private static void limitLogDetailSize(RecoveryProcessorDetail detail) {
        if (VerifyUtil.isEmpty((Object)detail) || VerifyUtil.isEmpty((Collection)detail.getChildDetails()) || detail.getChildDetails().size() < 64) {
            logger.debug((Object)"The log detail size is less than the threshold(%s).", new Object[]{String.valueOf(64)});
            return;
        }
        detail.setChildDetails(detail.getChildDetails().stream().sorted(Comparator.comparingInt(RecoveryProcessorDetail::getProcessStatus).reversed()).limit(64L).collect(Collectors.toList()));
    }

    public static List<RecoveryProcessor> sortRecoveryProcessors(Set<RecoveryProcessor> processors, boolean isSortable) {
        ArrayList<RecoveryProcessor> processorList = new ArrayList<RecoveryProcessor>();
        RecoveryProcessor startRecoveryProcessor = null;
        for (RecoveryProcessor processor : processors) {
            if (processor.getPreviousProcessor() != null) continue;
            startRecoveryProcessor = processor;
            break;
        }
        if (startRecoveryProcessor != null) {
            do {
                processorList.add(startRecoveryProcessor);
            } while (null != (startRecoveryProcessor = startRecoveryProcessor.getNextProcessor()));
        }
        if (processorList.size() != processors.size()) {
            if (isSortable) {
                List processorNames = processors.stream().map(RecoveryProcessor::getName).collect(Collectors.toList());
                processorList.removeIf(e -> !processorNames.contains(e.getName()));
            } else {
                processorList.clear();
                processorList.addAll(processors);
            }
        }
        return processorList;
    }

    public static List<RecoveryProcessor> sortRecoveryProcessors(Set<RecoveryProcessor> processors) {
        return RecoveryServiceUtil.sortRecoveryProcessors(processors, false);
    }

    public static DrmEnumDefine.AppType getAppType(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(recoveryPlan.getObjectType())) {
            return DrmEnumDefine.AppType.NAS;
        }
        Set pgs = recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"ProtectGroup is null.");
            throw new LegoCheckedException(1073947393L);
        }
        int poType = ((ProtectGroup)iterator.next()).getPoType();
        DrmEnumDefine.AppType appType = DrmEnumDefine.AppType.getType((int)poType);
        return appType;
    }

    public static String getProductSiteId(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"Param recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Set pgs = recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"ProtectGroup is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return ((ProtectGroup)iterator.next()).getProductSiteId();
    }

    public static Set<String> getDisasterSiteIds(RecoveryPlan recoveryPlan) {
        HashSet<String> disasterSites = new HashSet<String>();
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            Set gpReplicas = protectGroup.getReplicaList();
            for (ProtectGroupReplica gpReplica : gpReplicas) {
                disasterSites.add(gpReplica.getRecoverySite());
            }
        }
        logger.info((Object)"Param recoveryPlan name is:%s.", new Object[]{recoveryPlan.getName()});
        return disasterSites;
    }

    public static Set<String> getDisasterSiteIds(ProtectGroup protectGroup) {
        HashSet<String> disasterSites = new HashSet<String>();
        Set gpReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica gpReplica : gpReplicas) {
            disasterSites.add(gpReplica.getRecoverySite());
        }
        logger.info((Object)"The protectGroup name is:%s.", new Object[]{protectGroup.getName()});
        return disasterSites;
    }

    public static boolean isExistLocalRecoverySite(Set<String> disasterSiteIds) {
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        List localSites = siteService.getAllLocalSites();
        boolean isLoacalDisasterSite = false;
        for (String disasterSiteId : disasterSiteIds) {
            logger.info((Object)"The disasterSiteId is:%s", new Object[]{disasterSiteId});
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (disasterSite == null || !localSites.contains(disasterSite)) continue;
            isLoacalDisasterSite = true;
            break;
        }
        return isLoacalDisasterSite;
    }

    public static IRecoveryProcessBaseProvider getRecoveryProcessProvider(RecoveryPlan recoveryPlan) {
        Set pgs = recoveryPlan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            logger.error((Object)"There is no protect group. planId:%s.", new Object[]{recoveryPlan.getPlanId(), 90160758784001L});
            return null;
        }
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"Iterator is null. planId:%s.", new Object[]{recoveryPlan.getPlanId(), 90160758784001L});
            return null;
        }
        return RecoveryServiceUtil.getRecoveryProcessProvider((ProtectGroup)iterator.next());
    }

    public static IRecoveryProcessBaseProvider getRecoveryProcessProvider(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"Protect group is null.");
            return null;
        }
        int poType = protectGroup.getPoType();
        DrmEnumDefine.AppType appType = DrmEnumDefine.AppType.getType((int)poType);
        if (appType == null) {
            logger.error((Object)"There is no matched AppType. poType:%s.", new Object[]{poType, 90160758784001L});
            return null;
        }
        IRecoveryProcessBaseProvider procProvider = RecoveryProcessorMgr.getInstance().getRecoveryProcessProvider(appType.name());
        if (procProvider == null) {
            logger.error((Object)"The recovery process provider is null. appType:%s.", new Object[]{appType.name(), 90160758784001L});
        }
        return procProvider;
    }

    public static RecoveryProcessDefinition getInitRecoveryProcessDefinition(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procyType) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"The recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"Iterator is null,planId: %s.", new Object[]{recoveryPlan.getPlanId()});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, procyType, protectGroup);
        return rpDefinition;
    }

    public static RecoveryProcessDefinition getInitRecoveryProcessDefinition(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procyType, int protectionType) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"The recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"Group is null,planId: %s.", new Object[]{recoveryPlan.getPlanId()});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            logger.error((Object)"Failed to get recovery provider, planId: %s.", new Object[]{recoveryPlan.getPlanId()});
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        try {
            ProtectGroup pg = (ProtectGroup)ProtectGroup.class.cast(protectGroup.clone());
            pg.getTemplate().setType(protectionType);
            return provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, procyType, pg);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Failed to clone a pg, planId: %s.", new Object[]{recoveryPlan.getPlanId()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static Set<RecoveryProcessDefinition> getInitRecoveryProcessDefinitions(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"Param recoveryPlan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"Iterator is null, recoveryPlan id is %s.", new Object[]{recoveryPlan.getPlanId(), 1073947393L});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup firstProtectGroup = (ProtectGroup)iterator.next();
        DrmEnumDefine.AppType appType = DrmEnumDefine.AppType.getType((int)firstProtectGroup.getPoType());
        if (appType == null) {
            logger.error((Object)"There is no matched AppType. poType:%s.", new Object[]{firstProtectGroup.getPoType(), 90160758784001L});
            throw new LegoCheckedException(-1L);
        }
        Set processes = provider.getRecoveryProcesses(recoveryPlan, appType, firstProtectGroup);
        return processes;
    }

    public static void updateProgressRatio(List<? extends RecoveryProcessor> processors) {
        List<RecoveryProcessor> newProcessors = RecoveryServiceUtil.filterEnabledProcessors(processors);
        if (newProcessors.isEmpty()) {
            logger.debug((Object)"The newProcessors is null.");
            return;
        }
        int totalProgressRatio = 100;
        RecoveryProcessor proc = newProcessors.get(0);
        if (proc.getParentProc() != null && !(proc.getParentProc() instanceof IInitialChildProcessor)) {
            totalProgressRatio = proc.getParentProc().getProgressRatio();
        }
        int avgProgressRatio = totalProgressRatio / newProcessors.size();
        int index = 0;
        int countProgressRatio = 0;
        for (RecoveryProcessor recoveryProcessor : newProcessors) {
            if (++index == newProcessors.size()) {
                recoveryProcessor.setProgressRatio(totalProgressRatio - countProgressRatio);
                continue;
            }
            countProgressRatio += avgProgressRatio;
            recoveryProcessor.setProgressRatio(avgProgressRatio);
        }
    }

    public static boolean isContainSite(List<Site> sites, String siteId) {
        if (VerifyUtil.isEmpty(sites) || VerifyUtil.isEmpty((String)siteId)) {
            logger.debug((Object)"Params is null.");
            return false;
        }
        for (Site site : sites) {
            if (!site.getSiteId().equals(siteId)) continue;
            return true;
        }
        return false;
    }

    public static List<? extends IProcessor> sortAndUpdateProcessorRation(Set<RecoveryProcessor> processors) {
        return RecoveryServiceUtil.sortAndUpdateProcessorRation(processors, false);
    }

    public static List<? extends IProcessor> sortAndUpdateProcessorRation(Set<RecoveryProcessor> processors, boolean isSortable) {
        List<RecoveryProcessor> newProcessors = RecoveryServiceUtil.sortRecoveryProcessors(processors, isSortable);
        RecoveryServiceUtil.updateProgressRatio(newProcessors);
        return newProcessors;
    }

    public static void resetRecoverySetting(Set<RecoverySetting> oldSettings, RecoverySetting newSetting) {
        if (VerifyUtil.isEmpty(oldSettings)) {
            logger.debug((Object)"Param oldSettings is null.");
            oldSettings.add(newSetting);
        }
        boolean isExistedSetting = false;
        for (RecoverySetting oldSetting : oldSettings) {
            if (!oldSetting.getOwnerId().equals(newSetting.getOwnerId()) || !oldSetting.getName().equals(newSetting.getName())) continue;
            oldSetting.setValue(newSetting.getValue());
            if (!VerifyUtil.isEmpty((String)newSetting.getDisasterSiteId())) {
                oldSetting.setDisasterSiteId(newSetting.getDisasterSiteId());
            }
            isExistedSetting = true;
            break;
        }
        if (!isExistedSetting) {
            oldSettings.add(newSetting);
        }
    }

    public static List<RecoverySetting> filterAddedRecoverySettings(Set<RecoverySetting> oldSettings, Set<RecoverySetting> newSettings) {
        ArrayList<RecoverySetting> addedRecoverySettings = new ArrayList<RecoverySetting>();
        if (VerifyUtil.isEmpty(newSettings)) {
            logger.debug((Object)"The newSettings is null.");
            return addedRecoverySettings;
        }
        for (RecoverySetting newSetting : newSettings) {
            boolean isExistedSetting = false;
            for (RecoverySetting oldSetting : oldSettings) {
                if (!oldSetting.getOwnerId().equals(newSetting.getOwnerId()) || !oldSetting.getName().equals(newSetting.getName())) continue;
                isExistedSetting = true;
                break;
            }
            if (isExistedSetting) continue;
            addedRecoverySettings.add(newSetting);
        }
        return addedRecoverySettings;
    }

    public static String getDisasterHostSN(RecoveryPlan recoveryPlan) {
        String hostOrGroupId = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        if (VerifyUtil.isEmpty((String)hostOrGroupId)) {
            Set settings = RecoveryUtil.getRecoverySettingsByItemKey((String)recoveryPlan.getPlanId(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
            if (VerifyUtil.isEmpty((Collection)settings)) {
                return hostOrGroupId;
            }
            Iterator iterator = settings.iterator();
            if (iterator.hasNext()) {
                hostOrGroupId = ((RecoverySetting)iterator.next()).getValue();
            }
        }
        logger.info((Object)"The hostOrGroupId is: %s.", new Object[]{hostOrGroupId});
        return hostOrGroupId;
    }

    public static Site getRecoverySite(String recoverySiteId) {
        if (VerifyUtil.isEmpty((String)recoverySiteId)) {
            logger.error((Object)"RecoverySiteId is null.");
            throw new LegoCheckedException(201L);
        }
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Site recoverySite = siteService.getSiteById(recoverySiteId);
        if (recoverySite == null) {
            logger.info((Object)"The recoverySiteId is: %s.", new Object[]{recoverySiteId});
            throw new LegoCheckedException(201L);
        }
        return recoverySite;
    }

    public static void setProtectGroupsInvalidByPlan(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        try {
            RecoveryProcessorMgr processMgr = RecoveryProcessorMgr.getInstance();
            IRecoveryProcessBaseHandler recoveryProcessHandler = processMgr.getRecoveryProcessHandler();
            String productSiteId = RecoveryServiceUtil.getProductSiteId(plan);
            Site productSite = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(productSiteId);
            boolean operationResult = recoveryProcessHandler.setProtectGroupsInvalid(productSite, plan.getProtectGroups(), type);
            if (!operationResult) {
                logger.error((Object)"Setting protect group invalid failed. planId:%s.", new Object[]{plan.getPlanId()});
            }
        }
        catch (Exception e) {
            logger.error((Object)"Setting protect group invalid failed. planId:%s,error :%s.", new Object[]{plan.getPlanId(), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private static List<RecoveryProcessor> filterEnabledProcessors(List<? extends RecoveryProcessor> processors) {
        ArrayList<RecoveryProcessor> newProcessors = new ArrayList<RecoveryProcessor>();
        if (processors == null || processors.isEmpty()) {
            logger.debug((Object)"Param processors is null.");
            return newProcessors;
        }
        for (RecoveryProcessor recoveryProcessor : processors) {
            if (recoveryProcessor == null || !recoveryProcessor.getIsEnabled().booleanValue()) continue;
            RecoveryServiceUtil.filterEnabledProcessor(recoveryProcessor, newProcessors);
        }
        return newProcessors;
    }

    private static void filterEnabledProcessor(RecoveryProcessor processor, List<RecoveryProcessor> newProcessors) {
        if (processor instanceof IInitialChildProcessor) {
            for (RecoveryProcessor childProcessor : RecoveryServiceUtil.sortRecoveryProcessors(processor.getChildProc())) {
                if (childProcessor == null || !childProcessor.getIsEnabled().booleanValue()) continue;
                RecoveryServiceUtil.filterEnabledProcessor(childProcessor, newProcessors);
            }
        } else {
            if (processor.getNextCascadeProcessor() == null) {
                newProcessors.add(processor);
                return;
            }
            RecoveryProcessor tempProcessor = processor;
            do {
                if (!tempProcessor.getIsEnabled().booleanValue()) continue;
                newProcessors.add(tempProcessor);
            } while (null != (tempProcessor = tempProcessor.getNextCascadeProcessor()));
        }
    }

    private static RecoveryProcessorDetail getFirstRecoveryProcessorDetail(List<RecoveryProcessorDetail> details, boolean isContainsEndProcessor) {
        RecoveryProcessorDetail firstDetail = null;
        for (RecoveryProcessorDetail detail : details) {
            if (!VerifyUtil.isEmpty((String)detail.getParentDetailId()) && !isContainsEndProcessor || !VerifyUtil.isEmpty((String)detail.getPreviousProcId()) || VerifyUtil.isEmpty((String)detail.getNextProcId())) continue;
            firstDetail = detail;
            break;
        }
        return firstDetail;
    }

    public static RecoveryProcessor getLastRecoveryProcessor(Set<RecoveryProcessor> processors) {
        RecoveryProcessor lastProcessor = null;
        for (RecoveryProcessor processor : processors) {
            if (processor.getNextProcessor() != null) continue;
            lastProcessor = processor;
            break;
        }
        return lastProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getAllMoNameMap(List<String> uuidList) {
        Session session;
        HashMap<String, String> nameMap;
        block7: {
            nameMap = new HashMap<String, String>();
            session = null;
            try {
                NativeQuery query;
                List results;
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                StringBuilder querSql = new StringBuilder();
                querSql.append("select UUID,NAME from T_managedobject");
                if (!VerifyUtil.isEmpty(uuidList)) {
                    querSql.append(" where UUID in (");
                    for (int index = 0; index < uuidList.size(); ++index) {
                        String uuid = uuidList.get(index);
                        querSql.append("'").append(StringEscapeUtil.escapeSql((String)uuid)).append("'");
                        if (index >= uuidList.size() - 1) continue;
                        querSql.append(",");
                    }
                    querSql.append(")");
                }
                if (VerifyUtil.isEmpty((Collection)(results = (query = session.createSQLQuery(querSql.toString())).list()))) break block7;
                for (Object object : results) {
                    Object[] values;
                    if (!(object instanceof Object[]) || (values = (Object[])object).length < 2) continue;
                    String uuid = String.valueOf(values[0]);
                    String name = String.valueOf(values[1]);
                    nameMap.put(uuid, name);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"Failed to query queryReplicaProps!,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return nameMap;
    }

    public static boolean checkRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)planId) || com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(settings)) {
            return false;
        }
        for (RecoverySetting setting : settings) {
            RecoveryPlan plan = setting.getRecoveryPlan();
            if (plan != null && plan.getPlanId() != null && plan.getPlanId().equals(planId)) continue;
            return false;
        }
        return true;
    }

    public static List<Site> getRemoteSites(ProtectGroup protectGroup) {
        ArrayList<Site> remoteSites = new ArrayList<Site>();
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Set<String> disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(protectGroup);
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (disasterSite == null || disasterSite.getSiteType() == 0) continue;
            remoteSites.add(disasterSite);
            return remoteSites;
        }
        String productSiteId = protectGroup.getProductSiteId();
        logger.debug((Object)"productSiteId=%s.", new Object[]{productSiteId});
        Site productSite = siteService.getSiteById(productSiteId);
        if (productSite != null && productSite.getSiteType() != 0) {
            remoteSites.add(productSite);
            return remoteSites;
        }
        return remoteSites;
    }

    public static List<Site> getRemoteSites(RecoveryPlan recoveryPlan) {
        ArrayList<Site> remoteSites = new ArrayList<Site>();
        ISiteBaseService siteService = (ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class);
        Set<String> disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan);
        for (String disasterSiteId : disasterSiteIds) {
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (disasterSite == null || disasterSite.getSiteType() == 0) continue;
            remoteSites.add(disasterSite);
            return remoteSites;
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
        logger.debug((Object)"productSiteId= %s.", new Object[]{productSiteId});
        Site productSite = siteService.getSiteById(productSiteId);
        if (productSite != null && productSite.getSiteType() != 0) {
            remoteSites.add(productSite);
            return remoteSites;
        }
        return remoteSites;
    }
}

