/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.license;

import com.huawei.ism.cbb.base.util.BusinessUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.license.sdk.IDRVMPlatinicInter;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractLicenseControl
extends DrmBaseService
implements ILicenseBaseControl {
    private static final Log logger = LogFactory.getInstance(AbstractLicenseControl.class);
    protected ILicenseInter licenseService = null;
    private IDRVMPlatinicInter vmPlatinicService = null;
    private ISoftwareInfoService softInfoService = null;

    public void isEnableCreateProtectGroup(int ptType) {
        logger.debug((Object)"ptType->%s", (long)ptType);
    }

    public void isEnableRecoveryPlan(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.debug((Object)"The pg is null.");
            return;
        }
        logger.debug((Object)"pgid->%s", new Object[]{protectGroup.getUuid()});
        this.checkEnablePgCount(protectGroup);
    }

    public boolean isLicenseLegal() {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        return !VerifyUtil.isEmpty((Object)licenseBo) || !this.licenseService.isLicenseProbationTimeout();
    }

    private boolean isVmPg(ProtectGroup protectGroup) {
        logger.debug((Object)"enter isVmPg");
        return protectGroup.getPoType() == 10 || protectGroup.getPoType() == 12;
    }

    private boolean checkDRVMPlatinic(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)this.vmPlatinicService) || !this.vmPlatinicService.isDRVMPlatinic(protectGroup)) {
            return false;
        }
        logger.debug((Object)"Protect group(%s) is DRVMPlatinic", new Object[]{protectGroup.getName()});
        return true;
    }

    public void checkEnablePgTopo(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"Pg is null");
            return;
        }
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        if ("UltraVR".equals(softInfo.getProductModel())) {
            logger.debug((Object)"Enable pg(%s) topo, softInfo is VR.", new Object[]{protectGroup.getName()});
            return;
        }
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (VerifyUtil.isEmpty((Object)licenseBo)) {
            logger.debug((Object)"Enable pg(%s) topo, licenseBo is null.", new Object[]{protectGroup.getName()});
            if (this.licenseService.isLicenseProbationTimeout() && !this.checkDRVMPlatinic(protectGroup)) {
                logger.error((Object)"Pg(%s) is not DRVMPlatinic, and has no license.", new Object[]{protectGroup.getName()});
                throw new LegoCheckedException(1073947430L);
            }
        } else if (this.isVmPg(protectGroup)) {
            logger.debug((Object)"Pg(%s) is vm.", new Object[]{protectGroup.getName()});
            if (!(this.isHaveLicenseResItem("LSTQDPMP") || this.isHaveCloudLicenseRes() || this.checkDRVMPlatinic(protectGroup))) {
                logger.error((Object)"Pg(%s) is not DRVMPlatinic, and also no license", new Object[]{protectGroup.getName()});
                throw new LegoCheckedException(1073947430L);
            }
        } else if (!this.isHaveLicenseResItem("LSTQDPMN")) {
            logger.error((Object)"Pg(%s) is host type, and has no license.", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947430L);
        }
    }

    public void checkHasOneLic(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            logger.error((Object)"pg is null");
            return;
        }
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        if ("UltraVR".equals(softInfo.getProductModel())) {
            logger.debug((Object)"softInfo.getProductModel() is VR,pgName:%s", new Object[]{protectGroup.getName()});
            return;
        }
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (VerifyUtil.isEmpty((Object)licenseBo)) {
            logger.debug((Object)"licenseBo is null,pgName:%s.", new Object[]{protectGroup.getName()});
            if (this.licenseService.isLicenseProbationTimeout() && !this.checkDRVMPlatinic(protectGroup)) {
                logger.error((Object)"Pg(%s) is not DRVMPlatinic, and has no license", new Object[]{protectGroup.getName()});
                throw new LegoCheckedException(1073947430L);
            }
        }
    }

    public void checkEnablePgCount(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"The pg is null.");
            return;
        }
        if (protectGroup.getPoType() == 17) {
            logger.info((Object)"The sfs protectGroup no need check licenss.");
            return;
        }
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        if ("UltraVR".equals(softInfo.getProductModel())) {
            logger.debug((Object)"softInfo.getProductModel() is VR,pgName:%s", new Object[]{protectGroup.getName()});
            return;
        }
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (VerifyUtil.isEmpty((Object)licenseBo)) {
            logger.debug((Object)"licenseBo is null,pgName:%s.", new Object[]{protectGroup.getName()});
            if (this.licenseService.isLicenseProbationTimeout() && !this.checkDRVMPlatinic(protectGroup)) {
                logger.debug((Object)"License probation is timeout,check DRVMPlatinic,pgName:%s", new Object[]{protectGroup.getName()});
                throw new LegoCheckedException(1073947430L);
            }
        } else if (this.isVmPg(protectGroup)) {
            logger.debug((Object)"Pg(%s) is vm", new Object[]{protectGroup.getName()});
            if (!this.checkDRVMPlatinic(protectGroup)) {
                logger.debug((Object)"Check DRVMPlatinic,pgName:%s", new Object[]{protectGroup.getName()});
                int templateType = protectGroup.getTemplate().getType();
                String licResType = this.covertTemplateTypeToLicType(templateType);
                this.checkLicenseEnableWithCount(licResType, 0);
            }
        } else if (protectGroup.getPoType() == 22) {
            this.checkLicenseEnableWithCount("BOMVOLDRSSWTB", 0);
        } else {
            logger.debug((Object)"Pg(%s) is host", new Object[]{protectGroup.getName()});
            this.checkLicenseEnableWithCount("LSTQDPMN", 0);
        }
    }

    private String covertTemplateTypeToLicType(int templateType) {
        String typeLicStr;
        switch (templateType) {
            case 25: {
                typeLicStr = "LSTQCSHA";
                break;
            }
            case 29: {
                typeLicStr = "LSTQVHA";
                break;
            }
            case 21: 
            case 22: {
                typeLicStr = "LSTQCSDR";
                break;
            }
            default: {
                typeLicStr = "LSTQDPMP";
            }
        }
        return typeLicStr;
    }

    public boolean isHaveLicenseResItem(String type) {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (VerifyUtil.isEmpty((Object)licenseBo)) {
            return false;
        }
        ResourceItemBo resItem = this.getResControlBean(licenseBo, type);
        return !VerifyUtil.isEmpty((Object)resItem);
    }

    public boolean isEnableVisTopo() {
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        if ("UltraVR".equals(softInfo.getProductModel())) {
            return true;
        }
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo ? (this.vmPlatinicService == null || !this.vmPlatinicService.isDRVMPlatinic()) && this.licenseService.isLicenseProbationTimeout() : !this.isStandardLicense(licenseBo)) {
            throw new LegoCheckedException(1073947430L);
        }
        return true;
    }

    private boolean isLicenseNoNumControl() {
        SoftwareInfo softInfo = this.softInfoService.getSoftwareInfo();
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        return licenseBo == null && !this.licenseService.isLicenseProbationTimeout() || "UltraVR".equals(softInfo.getProductModel());
    }

    public void checkLicenseEnable(String type, int count) {
        logger.info((Object)"checkLicenseEnable: licenseType:%s, count:%s", new Object[]{type, count});
        if (this.licenseService.isBasicVersion()) {
            logger.error((Object)"checkLicenseEnable: License is basic version.");
            if (!BusinessUtil.isUltraVR()) {
                throw new LegoCheckedException(1073947430L);
            }
            return;
        }
        this.checkLicenseEnableWithCount(type, count);
    }

    public void checkLicenseEnableWithCount(String type, int count) {
        if (this.isLicenseNoNumControl()) {
            logger.debug((Object)"not check License Enable.");
            return;
        }
        if (!this.isLicenseEnable(type, count)) {
            logger.error((Object)"license is not enough.");
            throw new LegoCheckedException(1073947451L);
        }
    }

    private boolean isLicenseEnable(String type, int count) {
        if ("LSTQVHA_CSDR".equals(type)) {
            if (!this.checkLicenseNumber("LSTQCSDR", count)) {
                return false;
            }
            return this.checkLicenseNumber("LSTQVHA", count);
        }
        if ("LSTQCSHA_CSDR".equals(type)) {
            if (!this.checkLicenseNumber("LSTQCSDR", count)) {
                return false;
            }
            return this.checkLicenseNumber("LSTQCSHA", count);
        }
        return this.checkLicenseNumber(type, count);
    }

    private boolean checkLicenseNumber(String type, int count) {
        ResourceItemBo resItem = this.countResConsumeNum(type);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)resItem)) {
            return false;
        }
        if (0L != resItem.getErrorCode()) {
            throw new LegoCheckedException(resItem.getErrorCode(), resItem.getParameters());
        }
        int licenseCount = NumberUtil.parseInteger((Object)resItem.getItemValue(), (Integer)Integer.MAX_VALUE);
        int useCount = NumberUtil.parseInteger((Object)resItem.getConsumeNum());
        logger.info((Object)"License number check.Type : %s ,count: %s, consumeNum : %s,licenseCount: %s", new Object[]{type, count, useCount, licenseCount});
        if (count + useCount > licenseCount) {
            logger.error((Object)"license: %s is not enough.", new Object[]{type});
            return false;
        }
        return true;
    }

    private ResourceItemBo countResConsumeNum(String type) {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)licenseBo)) {
            return null;
        }
        ResourceItemBo resItem = this.getResControlBean(licenseBo, type);
        if (this.isCloudType(type) && !this.isHaveCloudLicenseRes(licenseBo)) {
            resItem = this.getResControlBean(licenseBo, "LSTQDPMP");
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)resItem)) {
            resItem = new ResourceItemBo();
            resItem.setItemName(type);
            resItem.setItemValue("0");
        }
        ArrayList<ResourceItemBo> resList = new ArrayList<ResourceItemBo>();
        resList.add(resItem);
        this.licenseService.countResUseNum(resList);
        return resItem;
    }

    public boolean isHaveCloudLicenseRes() {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        return this.isHaveCloudLicenseRes(licenseBo);
    }

    private boolean isHaveCloudLicenseRes(LicenseInfoBo licenseBo) {
        return this.getResControlBean(licenseBo, "LSTQCSHA") != null || this.getResControlBean(licenseBo, "LSTQCSDR") != null || this.getResControlBean(licenseBo, "LSTQVHA") != null;
    }

    private boolean isCloudType(String type) {
        return "LSTQCSHA".equals(type) || "LSTQCSDR".equals(type) || "LSTQVHA".equals(type);
    }

    public void checkLicenseOutOfControlAlarm() {
        logger.debug((Object)"enter checkLicenseOutOfControlAlarm");
        this.checkLicenseOutOfControlAlarm(false);
    }

    public void checkLicenseOutOfControlAlarm(boolean isClear) {
        try {
            LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
            if (licenseBo == null) {
                return;
            }
            if (!this.isLicenseEnable("LSTQDPMN", 0) || !this.isLicenseEnable("LSTQDPMP", 0)) {
                ResourceItemBo hostItem = this.countResConsumeNum("LSTQDPMN");
                ResourceItemBo vmItem = this.countResConsumeNum("LSTQDPMP");
                this.generateLicenseAlarm(hostItem, vmItem);
            } else if (isClear) {
                logger.debug((Object)"Clear alarm , alarm id :%s", 52625439L);
                AlarmReporter.restoreAlarm(52625439L, "");
            }
            if (!(this.isLicenseEnable("LSTQVHA", 0) && this.isLicenseEnable("LSTQCSHA", 0) && this.isLicenseEnable("LSTQCSDR", 0) && this.isLicenseEnable("LSTQARK", 0))) {
                ResourceItemBo vhaItem = this.countResConsumeNum("LSTQVHA");
                ResourceItemBo cshaItem = this.countResConsumeNum("LSTQCSHA");
                ResourceItemBo csdrItem = this.countResConsumeNum("LSTQCSDR");
                ResourceItemBo csrItem = this.countResConsumeNum("LSTQARK");
                this.generateLicenseCloudAlarm(vhaItem, cshaItem, csdrItem, csrItem);
            } else if (isClear) {
                logger.debug((Object)"Clear alarm , alarm id :%s", 52625480L);
                AlarmReporter.restoreAlarm(52625480L, "");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Check license alarm fail,error Is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public void checkLicenseRestoreAlarm() {
        try {
            if (this.isLicenseEnable("LSTQDPMN", 0) && this.isLicenseEnable("LSTQDPMP", 0)) {
                AlarmReporter.restoreAlarm(52625439L, "");
            }
            if (this.isLicenseEnable("LSTQVHA", 0) && this.isLicenseEnable("LSTQCSHA", 0) && this.isLicenseEnable("LSTQCSDR", 0) && this.isLicenseEnable("LSTQARK", 0)) {
                AlarmReporter.restoreAlarm(52625480L, "");
            }
        }
        catch (Exception e) {
            logger.error((Object)"restore license alarm fail\uff0cerror is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160758787071L});
        }
    }

    private void generateLicenseCloudAlarm(ResourceItemBo vhaItem, ResourceItemBo cshaItem, ResourceItemBo csdrItem, ResourceItemBo csrItem) {
        if (vhaItem == null || cshaItem == null || csdrItem == null || csrItem == null) {
            logger.debug((Object)"vhaItem or cshaItem or csdrItem or csrItem is null.", 90160758787071L);
            return;
        }
        String[] alramParams = new String[]{vhaItem.getConsumeNum(), cshaItem.getConsumeNum(), csdrItem.getConsumeNum(), vhaItem.getItemValue(), cshaItem.getItemValue(), csdrItem.getItemValue(), csrItem.getConsumeNum(), csrItem.getItemValue()};
        AlarmReporter.sendLicenseAlarmForParamsNoRepeat(52625480L, null, FaultEnum.AlarmResourceType.UNDEFINED.getValue(), FaultEnum.AlarmSeverity.CRITICAL, alramParams);
    }

    private void generateLicenseAlarm(ResourceItemBo hostItem, ResourceItemBo vmItem) {
        if (null == hostItem || null == vmItem) {
            logger.debug((Object)"hostItem or vmItem is null.", 90160758787071L);
            return;
        }
        String[] alramParams = new String[]{hostItem.getConsumeNum(), vmItem.getConsumeNum(), hostItem.getItemValue(), vmItem.getItemValue()};
        AlarmReporter.sendLicenseAlarmForParamsNoRepeat(52625439L, null, FaultEnum.AlarmResourceType.UNDEFINED.getValue(), FaultEnum.AlarmSeverity.CRITICAL, alramParams);
    }

    private boolean isStandardLicense(LicenseInfoBo licenseBo) {
        FeatureBo fitem;
        List resourceItemBoList;
        if (licenseBo.getFeaBolst() != null && !licenseBo.getFeaBolst().isEmpty() && (resourceItemBoList = (fitem = (FeatureBo)licenseBo.getFeaBolst().get(0)).getReslst()) != null && !resourceItemBoList.isEmpty()) {
            logger.debug((Object)"this is StandardLicense");
            return true;
        }
        return false;
    }

    protected ResourceItemBo getResControlBean(LicenseInfoBo licenseBo, String resName) {
        List fitems = licenseBo.getFeaBolst();
        if (fitems == null) {
            logger.error((Object)"fea bo list is empty");
            return null;
        }
        try {
            for (FeatureBo fitem : fitems) {
                List resList = fitem.getReslst();
                if (resList == null || resList.isEmpty()) continue;
                for (ResourceItemBo item : resList) {
                    if (!resName.equals(item.getItemName())) continue;
                    return item;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"get ResourceItemBo fail,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160758787071L});
        }
        return null;
    }

    public void onBindDRVMPlatinic(IDRVMPlatinicInter service, Map<?, ?> properties) {
        this.vmPlatinicService = service;
        logger.info((Object)"onBindDRVMPlatinic->%s", new Object[]{this.vmPlatinicService});
    }

    public void onUnbindDRVMPlatinic(IDRVMPlatinicInter service, Map<?, ?> properties) {
        this.vmPlatinicService = null;
        logger.info((Object)"onUnbindDRVMPlatinic->%s", new Object[]{service});
    }

    public ILicenseInter getLicenseService() {
        return this.licenseService;
    }

    public void setLicenseService(ILicenseInter licenseService) {
        this.licenseService = licenseService;
    }

    public ISoftwareInfoService getSoftInfoService() {
        return this.softInfoService;
    }

    public void setSoftInfoService(ISoftwareInfoService softInfoService) {
        this.softInfoService = softInfoService;
    }
}

