/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.scheduler;

import com.huawei.ism.drm.base.util.ResourceUtil;
import com.huawei.ism.drm.protection.checker.job.ProtectionCheckerJob;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Date;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class ProtectionCheckerScheduler {
    private static final Log logger = LogFactory.getInstance(ProtectionCheckerScheduler.class);
    private Scheduler quartzScheduler;

    public ProtectionCheckerScheduler() {
        this.initializeScheduler();
        this.scheduleProtectionCheckerJob();
    }

    private void initializeScheduler() {
        try {
            this.quartzScheduler = StdSchedulerFactory.getDefaultScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)"start quartz failed,error :%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private void scheduleProtectionCheckerJob() {
        String protectionCheckInterval = ResourceUtil.getValue("protection.check.interval", "5");
        int interval = 300000;
        try {
            interval = Integer.parseInt(protectionCheckInterval) * 60 * 1000;
        }
        catch (Exception e) {
            logger.error((Object)"Parsing protection check interval failed. Str:%s,error :%s.", new Object[]{protectionCheckInterval, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        SimpleTriggerImpl protectionCheckTrigger = new SimpleTriggerImpl("ProtectionCheckTrigger", null, new Date(), null, -1, (long)interval);
        try {
            JobDetailImpl protectionCheckJobDetail = new JobDetailImpl("JOB_ProtectionChecker", "JOB_GROUP_ProtectionChecker", ProtectionCheckerJob.class);
            protectionCheckJobDetail.setDurability(true);
            this.quartzScheduler.scheduleJob((JobDetail)protectionCheckJobDetail, (Trigger)protectionCheckTrigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Schedule protection check job failed,error :%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }
}

